set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4005977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '0431304',
      1,
      NULL,
      NULL,
      '40013',
      1,
      ' 3- 1-1993',
      10,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.882244,
      NULL,
      3.905318,
      0,
      8,
      NULL,
      NULL,
      1,
      1.631968,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.719793,
      5,
      1,
      1.539131,
      NULL,
      NULL,
      4,
      7,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      6,
      7,
      2,
      8,
      5,
      6,
      6,
      1,
      0,
      1,
      0.920937,
      3,
      3,
      1.545444,
      0.011758,
      1.012453,
      9,
      3,
      0,
      1.859793,
      7,
      7,
      0.047133,
      NULL,
      NULL,
      NULL,
      NULL,
      2.348246,
      NULL,
      0,
      1,
      1,
      NULL,
      5,
      NULL,
      144.622980,
      12146.217837,
      3,
      NULL,
      NULL,
      NULL,
      0.841945,
      3,
      148.738528,
      23,
      1.780858,
      0.547025,
      200,
      22,
      0,
      1.959544,
      NULL,
      NULL,
      1,
      1.733372,
      198.791053,
      116,
      0,
      2.232280,
      NULL,
      239,
      3,
      7.746696,
      22.018899,
      NULL,
      1,
      0,
      175.030614,
      207,
      0.742073,
      2.514135,
      179,
      53,
      3.123361,
      NULL,
      135.808507,
      494.466225,
      0,
      3.465184,
      17.695717,
      424,
      2,
      4.249457,
      NULL,
      917,
      1.790798,
      NULL,
      147.175758,
      606,
      0,
      NULL,
      120,
      24.180952,
      3.683009,
      7,
      14,
      NULL,
      1.527183,
      2,
      93,
      68.243910,
      3.343503,
      7,
      195,
      NULL,
      NULL,
      2.133179,
      150.627045,
      44.440525,
      3,
      5.341655,
      185.990223,
      105.915013,
      3,
      5,
      139,
      116.390327,
      3.638055,
      7.042547,
      NULL,
      51.365008,
      2.350586,
      1.715135,
      237,
      192.296498,
      3,
      4.144814,
      19.826704,
      128,
      3,
      2.858053,
      237.640063,
      98.137867,
      2.802110,
      1,
      104.331315,
      213.714716,
      NULL,
      5.811059,
      202.566215,
      100,
      2,
      5.346885,
      NULL,
      43,
      NULL,
      0,
      116.931676,
      NULL,
      2.820692,
      2,
      NULL,
      6,
      NULL,
      4.602575,
      200,
      36.897871,
      0.876640,
      0.253921,
      NULL,
      58,
      3,
      NULL,
      545,
      286.639909,
      1,
      0.923662,
      466.773744,
      NULL,
      3.205686,
      3.347025,
      484.005064,
      NULL,
      3,
      5.267962,
      443.247786,
      NULL,
      0.202994,
      2,
      463.184122,
      41,
      0,
      1,
      NULL,
      96.239939,
      0,
      NULL,
      357.727404,
      121.440788,
      0.172757,
      0,
      603,
      536.094257,
      1,
      5.614125,
      221,
      121.392999,
      NULL,
      0.050723,
      NULL,
      136.164785,
      3.501057,
      2.014647,
      518,
      NULL,
      2,
      2.181559,
      164.802761,
      46,
      1.510437,
      6.806148,
      432.496600,
      31,
      0,
      3.028108,
      57,
      NULL,
      1,
      1.166955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '24103',
      '',
      '',
      NULL,
      '',
      '',
      0.682421,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      0,
      NULL,
      3.297972,
      2545,
      0,
      NULL,
      1.439531,
      NULL,
      1,
      NULL,
      0.667702,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.374295,
      NULL,
      1,
      NULL,
      ' 2-21-1998',
      NULL,
      2.309687,
      14.449293,
      NULL,
      12.029232,
      NULL,
      1,
      NULL,
      14,
      NULL,
      8.901663,
      23,
      3,
      NULL,
      3.421266,
      NULL,
      0,
      3.544620,
      19,
      NULL,
      4,
      12,
      9.899900,
      0,
      0,
      11,
      17.061405,
      NULL,
      12.841789,
      16.999499,
      2.216490,
      NULL,
      NULL,
      NULL,
      8,
      14,
      8,
      14.143972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      4,
      23.322846,
      NULL,
      28,
      23,
      8.633533,
      3.404251,
      17.390715,
      39,
      18,
      18,
      31.395349,
      42,
      16,
      NULL,
      3,
      NULL,
      0,
      28.634229,
      1,
      14,
      NULL,
      6.422641,
      22.082598,
      30,
      21.932237,
      4,
      12.606042,
      61.590269,
      42,
      52,
      2.022133,
      17.668219,
      24,
      7,
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76.433402,
      117.086641,
      95,
      6.334593,
      6.199601,
      114.362602,
      132.593063,
      5,
      138,
      87.237976,
      13,
      126,
      NULL,
      118,
      156.380674,
      38.294128,
      34,
      NULL,
      1.157450,
      138,
      12.030846,
      83.046346,
      144.605831,
      10.506759,
      125.510615,
      57,
      66,
      21,
      101,
      91,
      26,
      29.247064,
      NULL,
      NULL,
      45.315230,
      170.298253,
      178,
      28,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.639266,
      2.455101,
      0,
      4,
      2.511252,
      NULL,
      1.561353,
      2.885979,
      5.269251,
      5.241054,
      1,
      7.579083,
      7.445617,
      0,
      NULL,
      2.210132,
      1,
      9,
      NULL,
      5,
      5,
      8.257038,
      NULL,
      7.996982,
      NULL,
      2.788694,
      4,
      3,
      3,
      7,
      7,
      NULL,
      6,
      3,
      5,
      0,
      1,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.116797,
      1.104661,
      1.865016,
      3.597507,
      0,
      3,
      1.979135,
      2,
      1,
      0.199112,
      3.024565,
      4.381174,
      6.095749,
      NULL,
      7,
      2,
      3.003587,
      NULL,
      4.868196,
      4,
      3,
      2,
      NULL,
      2.970505,
      2,
      3,
      5,
      3.177516,
      3,
      2.305225,
      NULL,
      NULL,
      2.280061,
      6.523530,
      4,
      4.539141,
      6,
      1.219951,
      4.285627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.855506,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.806786,
      2,
      1,
      0,
      NULL,
      3.387296,
      0.451888,
      0.094806,
      3,
      3.930853,
      NULL,
      3.357332,
      NULL,
      1,
      1,
      3.240910,
      0,
      3,
      NULL,
      2.508485,
      0.353357,
      0.477790,
      1.506804,
      NULL,
      1.086611,
      2.943684,
      0,
      1,
      NULL,
      0.791407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.202558,
      2.376799,
      2,
      2,
      0,
      0.579820,
      NULL,
      1.441544,
      2,
      NULL,
      3.186814,
      0.982121,
      2,
      3,
      2,
      NULL,
      2.320587,
      2.935641,
      3.924550,
      0.538759,
      3,
      3.540651,
      3.814126,
      1,
      NULL,
      NULL,
      0.932041,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3.682179,
      2.478922,
      3.212429,
      0.522880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612873,
      0.482716,
      0.746166,
      3,
      1,
      0,
      2.264814,
      0,
      3,
      2.748764,
      NULL,
      1.692360,
      1.493623,
      0,
      1.888375,
      2.605913,
      NULL,
      2,
      NULL,
      3.982357,
      NULL,
      5.005922,
      1.274008,
      1.206334,
      0,
      1,
      NULL,
      NULL,
      0,
      2.067626,
      1,
      3,
      0.626187,
      2.905609,
      3,
      1.680165,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.398396,
      NULL,
      3,
      5,
      5,
      1,
      NULL,
      0,
      3.590183,
      1.606523,
      5.407345,
      4,
      0.779139,
      7.118893,
      0.284503,
      6,
      3.983147,
      0.308698,
      6,
      8,
      0.284642,
      4,
      4,
      6.737594,
      6,
      NULL,
      4.497209,
      1.705631,
      1,
      NULL,
      6.455807,
      7.752967,
      7,
      NULL,
      NULL,
      10,
      9.510375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765944,
      1.316703,
      0.036783,
      3.014756,
      NULL,
      2,
      NULL,
      4.525230,
      3,
      1.523561,
      5,
      NULL,
      1,
      3.196692,
      7.720453,
      4,
      3,
      4.827894,
      3,
      1.360432,
      3.183349,
      NULL,
      2.519365,
      5,
      6,
      5,
      3,
      0.366209,
      0.331224,
      8,
      3,
      7.333513,
      2,
      NULL,
      1,
      9.407020,
      8.751082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735462,
      NULL,
      1,
      5,
      3,
      4.423156,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.956301,
      6,
      7,
      6.380461,
      6,
      7.976076,
      6,
      7.241194,
      3,
      3,
      5.527125,
      6,
      3,
      1.397417,
      2,
      NULL,
      7,
      NULL,
      1.103302,
      2.360730,
      4,
      NULL,
      0,
      2,
      0.392838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439502,
      1,
      1.934738,
      1,
      1,
      2,
      1.081204,
      0,
      3.420586,
      0.706859,
      0,
      NULL,
      3.933205,
      2.898136,
      NULL,
      4,
      5,
      3,
      3.121202,
      1,
      5.010387,
      1.997343,
      3,
      1.506127,
      NULL,
      0.679707,
      NULL,
      3.285665,
      5,
      1.355229,
      5.571728,
      3,
      4.656991,
      3,
      5.736642,
      3.503258,
      5,
      1,
      3.162099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329629,
      1,
      0,
      0.069205,
      1,
      0,
      1,
      1,
      0.780760,
      0.789044,
      1.073771,
      1,
      NULL,
      0,
      0,
      NULL,
      1.688722,
      1,
      0,
      0,
      0,
      0,
      1,
      1.091642,
      1,
      1.542382,
      0,
      0.216282,
      0.997193,
      0,
      1,
      1.532511,
      1.109799,
      1.660593,
      1.968284,
      0.080930,
      1,
      0.598409,
      0.011669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027935,
      NULL,
      NULL,
      1,
      0.774070,
      1.950418,
      1,
      1.869049,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0.837110,
      NULL,
      1.726526,
      1,
      NULL,
      0.472865,
      NULL,
      1,
      1,
      1,
      0.954130,
      0.500903,
      1,
      0,
      0.868223,
      1.996179,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310050,
      NULL,
      1,
      NULL,
      NULL,
      1.285239,
      0.421007,
      1.750537,
      NULL,
      0,
      0,
      0.358395,
      NULL,
      NULL,
      0,
      NULL,
      4.277115,
      3,
      1.319394,
      5.197645,
      NULL,
      NULL,
      5.809867,
      NULL,
      9.049810,
      1.949041,
      NULL,
      3.230504,
      2.244720,
      4.460760,
      NULL,
      3,
      1.419330,
      0,
      5.981058,
      3.027564,
      4,
      5.839369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.309250,
      1.171165,
      0.307322,
      0.291271,
      1.081921,
      0.551549,
      1.977366,
      1,
      0,
      NULL,
      0.536262,
      0,
      0,
      0.901434,
      0,
      1,
      0,
      0.096215,
      1.339225,
      1.949265,
      NULL,
      0,
      1,
      1.835763,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.893955,
      NULL,
      0,
      0,
      1,
      0.835385,
      0.968614,
      1.852494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210000,
      3.751247,
      1,
      5.420884,
      6,
      9.230752,
      3.058140,
      1,
      6,
      1.993745,
      NULL,
      7.237761,
      3.014894,
      NULL,
      0,
      9,
      7.672717,
      9,
      NULL,
      7.834884,
      2,
      0.439224,
      2.934401,
      NULL,
      3,
      6,
      5,
      NULL,
      NULL,
      5,
      5,
      2,
      7,
      4.375739,
      NULL,
      NULL,
      4,
      2.730288,
      6.769243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4.189550,
      1,
      3.771181,
      5,
      1,
      4.120484,
      3,
      1.895681,
      2.035103,
      2,
      3,
      7,
      4,
      0.375261,
      5,
      3.645843,
      6.672364,
      7.961906,
      NULL,
      0.873791,
      0.077969,
      6,
      5,
      3.091826,
      0,
      3.467012,
      0.817141,
      0.662424,
      NULL,
      9,
      3,
      8,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.367365,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1.754369,
      0.870116,
      0.750655,
      0,
      1.958403,
      0.717571,
      NULL,
      1,
      0,
      0,
      0.408426,
      NULL,
      0.738362,
      0,
      NULL,
      1.302059,
      1,
      0.311763,
      NULL,
      1,
      1,
      0.048364,
      NULL,
      0,
      1,
      1.891047,
      1.922046,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.835511,
      NULL,
      0.706235,
      0,
      0,
      NULL,
      0,
      0.275981,
      0,
      2.490674,
      1.261712,
      4.604886,
      4,
      2.127095,
      5.914374,
      5,
      1.926763,
      1,
      0.881628,
      4.563682,
      0,
      0.603723,
      NULL,
      NULL,
      0,
      1.683097,
      0.514419,
      1,
      0.353956,
      0.594697,
      0.603473,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      2,
      5,
      1,
      4,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      1,
      4,
      1,
      0,
      3,
      NULL,
      2,
      4,
      3,
      3,
      5,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3,
      5,
      4,
      1,
      2,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-1994',
      ' 4-17-1993',
      ' 2- 6-1978',
      ' 8- 8-1979',
      ' 3-12-1992',
      ' 8- 5-1990',
      '10- 7-1997',
      ' 5-13-1982',
      NULL,
      ' 5-21-1990',
      NULL,
      ' 2-16-1989',
      ' 5-10-1987',
      NULL,
      NULL,
      NULL,
      ' 5- 9-1988',
      ' 2- 9-1984',
      ' 8-29-1975',
      ' 6-21-1991',
      ' 4- 0-2001',
      ' 9- 9-1987',
      ' 6-27-1995',
      '10-28-1994',
      NULL,
      ' 6- 8-1990',
      ' 6-11-1984',
      ' 9-13-2000',
      ' 2-23-1994',
      ' 7- 0-1977',
      ' 0-20-2000',
      ' 4-23-1976',
      ' 8- 7-1997',
      '10- 9-1990',
      ' 3-13-1985',
      ' 1-15-2002',
      ' 5-19-2001',
      ' 2-26-1991',
      NULL,
      NULL,
      ' 9-16-1984',
      NULL,
      ' 8-20-2002',
      ' 2-24-1992',
      ' 5-25-1980',
      '11-28-1980',
      ' 9- 5-1992',
      ' 2-24-2003',
      ' 9- 1-2000',
      '11- 2-1991',
      ' 3-17-1987',
      ' 1-29-1987',
      ' 8-13-1995',
      ' 8-24-1999',
      ' 8-11-1974',
      NULL,
      ' 4-16-1993',
      ' 6-19-1981',
      ' 7-24-1986',
      ' 7-12-2001',
      NULL,
      ' 6- 4-1999',
      NULL,
      ' 3-17-1985',
      ' 3-25-1975',
      ' 8-21-1986',
      ' 1-26-1985',
      ' 6- 5-1991',
      '11-22-1976',
      ' 2-22-2003',
      ' 0-16-2000',
      ' 2-11-1994',
      ' 2-24-2000',
      ' 6- 3-1976',
      ' 1-26-1999',
      NULL,
      ' 0- 7-1983',
      ' 3-21-2003',
      ' 6-27-1998',
      '11-27-1988',
      ' 8-25-1986',
      NULL,
      ' 0-21-1994',
      ' 5- 7-1985',
      ' 3- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


