set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '0243400',
      0,
      3,
      0,
      '01122',
      3,
      ' 9- 5-1990',
      40.405099,
      NULL,
      0,
      0,
      0.646029,
      0,
      0,
      2.535684,
      1.532999,
      2,
      1.644435,
      1.990621,
      1,
      NULL,
      NULL,
      NULL,
      0.778760,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.954075,
      NULL,
      7.983898,
      5,
      NULL,
      NULL,
      9,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1,
      3,
      NULL,
      0,
      0.512220,
      1.399572,
      3,
      8,
      18,
      NULL,
      3,
      1,
      0,
      7,
      3,
      3,
      2,
      0,
      1,
      9,
      ' 3-28-1989',
      16,
      NULL,
      5,
      2,
      4,
      2,
      2,
      2,
      3,
      368.372938,
      93.701741,
      3.216002,
      1.767728,
      NULL,
      NULL,
      1,
      0.579038,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      3.784172,
      0,
      141.276902,
      NULL,
      2,
      2,
      1408.257108,
      1283,
      1.154980,
      3,
      NULL,
      6,
      0.978107,
      NULL,
      90,
      3.766999,
      0,
      1,
      628,
      41.349013,
      1,
      1.840761,
      253,
      7,
      NULL,
      1,
      75,
      0,
      3.943555,
      3.876422,
      88,
      36.148882,
      0.525942,
      7.282015,
      608,
      76,
      0.276457,
      0,
      NULL,
      1656,
      0,
      3.026869,
      178.986404,
      92.632068,
      2,
      0,
      568.833019,
      1828.887897,
      2.260186,
      NULL,
      456.444617,
      2158,
      NULL,
      NULL,
      31.681833,
      44,
      0.712726,
      0.624538,
      494.220433,
      5.090890,
      2.610739,
      2.145059,
      756,
      NULL,
      1,
      1.302689,
      143.685393,
      9,
      2.979561,
      2,
      395,
      4.623275,
      NULL,
      0.906746,
      NULL,
      53.631012,
      1.713472,
      3,
      185.307613,
      2,
      3,
      1,
      268,
      2.708704,
      3.280879,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '33224',
      NULL,
      '',
      '',
      '',
      1.926038,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      5.869402,
      NULL,
      1,
      NULL,
      1.477134,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.199657,
      NULL,
      1.260905,
      NULL,
      0,
      NULL,
      1.283774,
      NULL,
      NULL,
      NULL,
      ' 0-29-1988',
      2.719076,
      2.754352,
      17,
      1,
      15.588061,
      NULL,
      2,
      NULL,
      3.017416,
      5,
      0.588740,
      2.327654,
      NULL,
      8.897830,
      NULL,
      11.463850,
      8,
      7,
      7.390205,
      NULL,
      0.215024,
      2.487898,
      8.503571,
      10,
      13.067651,
      7,
      14,
      NULL,
      6,
      1,
      10.095168,
      7.208390,
      0.215604,
      0.030176,
      14.968977,
      4,
      2.803707,
      3.571168,
      5.294636,
      0,
      1.099381,
      2.433011,
      10,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0,
      5,
      25.745434,
      14.003992,
      NULL,
      27.267813,
      7,
      NULL,
      36,
      3,
      0,
      31.784070,
      14.363824,
      4,
      27,
      NULL,
      3.763153,
      13,
      9.002045,
      NULL,
      NULL,
      29,
      22,
      2.940233,
      16,
      11.679680,
      34.842766,
      4,
      8.136908,
      4.437210,
      5,
      4,
      0.424748,
      NULL,
      7,
      4.587884,
      NULL,
      2.723183,
      2,
      26,
      0.814207,
      45,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85.885057,
      103,
      65.466338,
      69,
      81,
      NULL,
      79.457136,
      18.634315,
      178.615820,
      171,
      158.584365,
      27,
      114,
      25,
      177.193355,
      46,
      136,
      100.488869,
      14.362281,
      132.063250,
      55.111938,
      172.104845,
      120.974197,
      NULL,
      NULL,
      32,
      NULL,
      42.768475,
      NULL,
      55,
      13.145771,
      109.552412,
      96,
      NULL,
      35,
      72,
      130.262324,
      48.893615,
      47.366970,
      24,
      119.008992,
      157,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883940,
      1,
      NULL,
      1.868687,
      NULL,
      0,
      0,
      2.939283,
      7,
      1.568862,
      6,
      4,
      0,
      NULL,
      6.757323,
      3.252024,
      2,
      2.221949,
      NULL,
      0,
      NULL,
      NULL,
      6.084714,
      7,
      5,
      0.761233,
      5.900602,
      2.914679,
      5,
      NULL,
      6,
      3.696746,
      3.997689,
      0,
      1.310552,
      5,
      8,
      NULL,
      NULL,
      2,
      6.222117,
      0,
      3.351443,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.115631,
      0.710143,
      1.489690,
      5.948687,
      0,
      2,
      1.942230,
      6,
      2,
      6.985591,
      1,
      1.018456,
      4,
      5.529176,
      5.761725,
      0.927493,
      0.886611,
      NULL,
      0.306048,
      3.411632,
      5,
      0,
      NULL,
      0,
      8,
      7,
      NULL,
      9.200421,
      0,
      1,
      5,
      5,
      9,
      NULL,
      9,
      7.500734,
      4,
      6.954781,
      2,
      1,
      11,
      2.457908,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492655,
      5,
      3.625157,
      NULL,
      3,
      0,
      0.936462,
      1,
      NULL,
      1.239898,
      2,
      0.828677,
      2.789084,
      3.482780,
      4.202012,
      7.449050,
      NULL,
      0.216194,
      1.221828,
      2.614972,
      NULL,
      3.687032,
      0.008387,
      0.627871,
      2,
      2.438382,
      NULL,
      4,
      2.551906,
      1.097851,
      5,
      3.241309,
      1,
      1,
      2.595831,
      4,
      0.254176,
      1.687180,
      3.476936,
      0,
      2.636551,
      NULL,
      0.156974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380338,
      0.872897,
      0,
      0,
      NULL,
      2.433666,
      1.396901,
      3,
      5.391964,
      0,
      3,
      NULL,
      NULL,
      3,
      0.016881,
      1.321322,
      0,
      0.128334,
      NULL,
      2,
      2.067430,
      1,
      1.904138,
      4.255375,
      NULL,
      3,
      1,
      NULL,
      4.397904,
      0,
      5,
      5,
      1,
      1,
      NULL,
      5.535358,
      4.453795,
      0,
      0.303874,
      NULL,
      1.311842,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.510197,
      1,
      0.603073,
      0.044570,
      0,
      1.152261,
      0,
      0,
      NULL,
      0.731749,
      1,
      1,
      1,
      0.540550,
      0,
      1,
      1,
      1,
      0.763673,
      NULL,
      0,
      NULL,
      0.350096,
      1.034626,
      1,
      NULL,
      0,
      1.227326,
      1,
      0.314442,
      1,
      NULL,
      NULL,
      0.475788,
      0.283319,
      1.426949,
      0,
      1,
      1.496525,
      1.708430,
      0.726853,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271178,
      1.069654,
      4,
      3.311832,
      0.070283,
      2,
      1,
      6,
      9.048903,
      7.089225,
      1.613107,
      1.064216,
      2.859302,
      4.201714,
      9,
      4.452139,
      2.735996,
      6.328530,
      5.691686,
      3.009053,
      9,
      1,
      5,
      7.605316,
      6.621645,
      3.762064,
      8,
      3,
      NULL,
      5.744151,
      5.695506,
      0,
      3,
      6,
      1,
      7,
      7.296273,
      NULL,
      7.958887,
      7.086193,
      7,
      9.388964,
      1.326859,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.426529,
      5.453969,
      2.655380,
      NULL,
      3.116083,
      1.882124,
      5,
      NULL,
      7.977230,
      NULL,
      NULL,
      0.848198,
      4,
      NULL,
      5,
      8,
      NULL,
      8.197768,
      6,
      6.943122,
      9.193534,
      4.426735,
      3.957259,
      3.706198,
      2,
      9,
      0,
      2.818691,
      8,
      1,
      NULL,
      8.418453,
      NULL,
      2,
      8.030834,
      4.699146,
      NULL,
      7.410244,
      NULL,
      2,
      NULL,
      2.332772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.744380,
      0,
      2.349026,
      3,
      3.136778,
      2.037270,
      5.156711,
      1.870628,
      3,
      3,
      1.852776,
      5.478786,
      4,
      2.551151,
      3.690695,
      3.887688,
      1.373622,
      5,
      2,
      5.031246,
      1,
      5.481812,
      2.434730,
      3.198516,
      1,
      5,
      4,
      NULL,
      1,
      2,
      2,
      2.746544,
      NULL,
      5.544267,
      NULL,
      1.034003,
      0,
      NULL,
      NULL,
      0,
      5.391821,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.309400,
      1.649121,
      0.716468,
      5.705233,
      NULL,
      5,
      0,
      1,
      NULL,
      2.388917,
      NULL,
      0.415761,
      3,
      1.591753,
      NULL,
      2,
      4,
      0,
      4,
      3,
      NULL,
      1.245630,
      1,
      0,
      3,
      1.895447,
      0,
      3.882008,
      NULL,
      0.729375,
      NULL,
      5,
      1,
      2.976582,
      2,
      0.881250,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      NULL,
      1.294676,
      1.684810,
      1.007395,
      NULL,
      1,
      1.937798,
      0.215232,
      1.704816,
      4,
      5.742251,
      4,
      0.687060,
      2.346357,
      1.824295,
      5,
      NULL,
      3.665857,
      NULL,
      0,
      NULL,
      0,
      1.191271,
      5,
      NULL,
      4.778629,
      NULL,
      1.401229,
      1.612646,
      1.147628,
      NULL,
      3.803705,
      1.206701,
      2.787250,
      3.410738,
      0.720471,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811852,
      1,
      0.097245,
      1,
      1.512295,
      0.481198,
      0,
      1,
      NULL,
      NULL,
      1,
      1.304264,
      0.989821,
      1.975713,
      NULL,
      1.040480,
      NULL,
      1.708564,
      0.549844,
      1,
      1,
      NULL,
      0,
      1,
      1.760131,
      1,
      1.091621,
      1.416446,
      0.640381,
      1.747166,
      0.529361,
      1,
      NULL,
      NULL,
      1.514356,
      0.286434,
      1,
      1.573767,
      0.841692,
      NULL,
      1,
      NULL,
      0,
      1.194777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.668775,
      6.379969,
      2.571428,
      2,
      NULL,
      NULL,
      NULL,
      3.433462,
      2,
      0.107010,
      4,
      1,
      1,
      2,
      6,
      4.915219,
      0,
      NULL,
      3.161414,
      4,
      3.679476,
      NULL,
      5,
      2,
      2,
      2.667028,
      1.878367,
      NULL,
      1,
      1,
      NULL,
      2,
      3.609760,
      3,
      NULL,
      4.433876,
      7.719749,
      0.383353,
      NULL,
      0,
      2.132858,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.903161,
      NULL,
      0.355761,
      NULL,
      2,
      1,
      NULL,
      0.122250,
      0,
      4,
      5,
      0.961370,
      2,
      2,
      NULL,
      5,
      1,
      3.199533,
      1.555488,
      2,
      3,
      2,
      0.428612,
      1.661071,
      2.709888,
      3,
      5.881290,
      5,
      2,
      4.503245,
      5.606540,
      1,
      NULL,
      NULL,
      1.436857,
      5,
      3.664868,
      5,
      1,
      1.685903,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520605,
      0,
      NULL,
      NULL,
      3,
      4.563739,
      0.670029,
      5,
      NULL,
      2.050626,
      3.075611,
      2.024144,
      4,
      5,
      7,
      2,
      3.486797,
      1,
      9,
      NULL,
      NULL,
      1,
      7.440847,
      7,
      1.251020,
      3,
      4,
      7.351748,
      9,
      NULL,
      NULL,
      3,
      7.734171,
      4.953058,
      5.093137,
      4.765812,
      5,
      0,
      7,
      5,
      NULL,
      2.586286,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      NULL,
      2.061658,
      0.206269,
      3.667608,
      1.493869,
      NULL,
      NULL,
      0.242679,
      7.846493,
      3,
      NULL,
      4.505635,
      9,
      0,
      2,
      4.983770,
      8,
      7.634482,
      9,
      6,
      1.466072,
      0,
      8.176604,
      8.664711,
      9,
      0.778283,
      9.239771,
      1.981863,
      4.051959,
      5.452389,
      3.139568,
      3,
      9,
      7.665907,
      3.276800,
      5.939411,
      NULL,
      9.240657,
      1.257085,
      9,
      NULL,
      8.455582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005794,
      NULL,
      0,
      1.752600,
      1.280926,
      0,
      1,
      0.976498,
      NULL,
      0,
      0.115254,
      0,
      0,
      1.196609,
      NULL,
      0,
      0.866691,
      0.042514,
      NULL,
      NULL,
      1.757947,
      0.447964,
      0,
      NULL,
      1,
      0.816728,
      1,
      1.482678,
      NULL,
      NULL,
      0.762914,
      1.916197,
      0,
      NULL,
      0,
      1.252473,
      1.302917,
      0.367574,
      0.025868,
      0.768402,
      NULL,
      1,
      1.947023,
      0.348838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      4,
      0.301249,
      3,
      1,
      1,
      3,
      1.764707,
      2.976953,
      NULL,
      2.082041,
      3,
      3.995689,
      3.472588,
      3,
      2,
      NULL,
      0.993491,
      3.596803,
      NULL,
      2,
      2.508087,
      0,
      4.247178,
      3,
      3.484451,
      5.710882,
      2.537573,
      0.131901,
      0.299150,
      2.296463,
      5,
      5,
      1.956360,
      NULL,
      3,
      2.415107,
      1.745954,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      1,
      3,
      2,
      1,
      2,
      5,
      1,
      1,
      4,
      3,
      0,
      0,
      4,
      NULL,
      2,
      1,
      3,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      3,
      0,
      0,
      2,
      2,
      NULL,
      3,
      1,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 8-2002',
      ' 4-19-1980',
      NULL,
      ' 8-16-1987',
      ' 4- 4-1993',
      ' 1-11-1996',
      ' 9-12-1977',
      ' 0-18-1979',
      ' 5-22-1998',
      ' 1-18-1987',
      '11-20-1980',
      ' 3-26-1985',
      ' 1-11-1983',
      ' 4-23-1982',
      ' 9-16-1985',
      '10-10-1975',
      ' 2- 0-1994',
      '11- 7-1980',
      ' 6-22-1992',
      ' 5- 3-1999',
      ' 2- 1-1985',
      ' 6-17-1990',
      '10-19-1996',
      ' 2-18-1974',
      ' 8-11-1987',
      ' 3-13-1989',
      NULL,
      ' 4-29-1975',
      NULL,
      ' 5-13-1985',
      ' 1- 1-1997',
      NULL,
      '11-28-1987',
      NULL,
      ' 0- 3-1989',
      NULL,
      ' 8-21-1988',
      ' 3-27-1994',
      NULL,
      ' 4-24-2000',
      NULL,
      NULL,
      ' 3-26-1992',
      ' 2- 6-1994',
      ' 3-23-1980',
      ' 8-12-1998',
      ' 5-13-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1985',
      ' 4- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314485);
commit;
end;
/


