set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6516689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '4304133',
      1,
      3.357067,
      NULL,
      NULL,
      0.656436,
      ' 4-24-2003',
      39.580837,
      NULL,
      1,
      0,
      1.232177,
      1,
      1,
      1.101270,
      1.037305,
      0.615076,
      0.658383,
      0,
      0,
      9,
      NULL,
      NULL,
      3,
      NULL,
      1,
      13.768993,
      NULL,
      4.089383,
      2.772277,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      4,
      12.195556,
      2,
      3.981359,
      4,
      0,
      1.812455,
      0.340753,
      1.301371,
      3,
      0,
      NULL,
      0.372010,
      0.778568,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.442138,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.688893,
      3,
      1,
      0,
      12.389312,
      2,
      57.904560,
      93,
      33,
      2,
      0,
      165,
      586,
      NULL,
      5,
      179,
      1058,
      2,
      9,
      13.500990,
      736.691330,
      2,
      NULL,
      136.499105,
      40.035500,
      3.286516,
      NULL,
      NULL,
      73.153136,
      2,
      1,
      207.695043,
      259.518434,
      1,
      0,
      53,
      11.320922,
      NULL,
      NULL,
      31.600518,
      9.359900,
      0.942817,
      3.868535,
      171.838884,
      NULL,
      3.753739,
      NULL,
      NULL,
      25.393467,
      2,
      2,
      64,
      NULL,
      1,
      0,
      95.975747,
      NULL,
      0,
      1.010626,
      218,
      NULL,
      1,
      NULL,
      169,
      11.883004,
      NULL,
      2.480236,
      NULL,
      NULL,
      0.905736,
      0,
      NULL,
      82,
      3,
      3,
      472,
      NULL,
      0.932608,
      2,
      580.242931,
      606.623044,
      0.663998,
      1,
      NULL,
      156,
      NULL,
      1,
      NULL,
      68.368460,
      0.125582,
      NULL,
      29.332249,
      1,
      NULL,
      2,
      NULL,
      8.786621,
      1.211597,
      NULL,
      812,
      9,
      3,
      6,
      356.182471,
      NULL,
      NULL,
      1,
      304.811438,
      16,
      NULL,
      4,
      860,
      67,
      2.567861,
      NULL,
      NULL,
      0,
      3,
      3,
      283,
      5.840508,
      NULL,
      2.727162,
      423,
      25,
      2.945119,
      1.633220,
      508,
      10.862124,
      1,
      1.300329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      '40244',
      '',
      '',
      '',
      '',
      1.097260,
      '',
      '',
      NULL,
      1.687378,
      '',
      NULL,
      '',
      0,
      1,
      NULL,
      3,
      584,
      1,
      NULL,
      0.332383,
      NULL,
      15,
      85.581489,
      NULL,
      NULL,
      3,
      27.237139,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      15.567365,
      15.005000,
      2.379305,
      11,
      0.955516,
      6,
      3,
      3,
      9,
      NULL,
      3,
      NULL,
      NULL,
      3,
      2,
      2,
      3.948705,
      0.833975,
      2,
      0,
      2.260821,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.447946,
      NULL,
      9.964612,
      0.691998,
      17,
      3,
      NULL,
      9,
      8,
      41.248834,
      21.108965,
      15.826777,
      NULL,
      NULL,
      18,
      8,
      29.053566,
      1,
      1,
      1.284170,
      2.138379,
      7,
      13,
      39,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      24,
      157,
      43,
      NULL,
      65.331223,
      153.987751,
      NULL,
      172,
      161,
      5,
      145,
      52.753568,
      48.665796,
      58,
      144,
      140,
      NULL,
      4.493332,
      134,
      NULL,
      NULL,
      80.914449,
      78.660768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.490211,
      4.438600,
      NULL,
      NULL,
      NULL,
      3.776826,
      NULL,
      6,
      5.478366,
      NULL,
      5,
      5.741423,
      1,
      5,
      5,
      7.340231,
      NULL,
      5,
      6,
      NULL,
      6.746628,
      NULL,
      8,
      5.469933,
      6.325136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8.673031,
      2,
      2,
      6,
      NULL,
      NULL,
      2.616490,
      5,
      5.949827,
      NULL,
      1.686787,
      NULL,
      1,
      7.985213,
      8,
      NULL,
      4,
      5,
      1.011231,
      1.560333,
      NULL,
      0,
      0.501320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.730716,
      2,
      0,
      1.822255,
      1,
      0.795565,
      NULL,
      NULL,
      NULL,
      0.040182,
      1.289874,
      0,
      1,
      1.252652,
      1,
      NULL,
      0,
      1,
      0,
      1.539372,
      1.324085,
      0,
      1.182189,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979639,
      0,
      1,
      0.358680,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1.874359,
      0,
      0.709571,
      1.109838,
      0.507138,
      1.680589,
      1.372798,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695487,
      0.078572,
      0,
      0,
      1.126725,
      0,
      0,
      NULL,
      1.271130,
      1.069835,
      NULL,
      NULL,
      0,
      0.893734,
      1,
      1,
      1,
      0.104687,
      NULL,
      1.933320,
      NULL,
      0.909485,
      0.267490,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798288,
      NULL,
      2.855700,
      5.047813,
      NULL,
      4.712470,
      0.933271,
      6.089303,
      4.824188,
      3.634315,
      0.692518,
      4,
      2,
      7.910620,
      1,
      6,
      NULL,
      3,
      NULL,
      NULL,
      2.206885,
      5.551116,
      2.922632,
      3.645756,
      2,
      0.541321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602981,
      3,
      0,
      5.004856,
      5,
      3,
      4.065079,
      5.344710,
      0,
      2,
      NULL,
      6.644440,
      NULL,
      3.281877,
      NULL,
      2,
      NULL,
      0,
      6,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3.925975,
      2.408232,
      3,
      0,
      NULL,
      2,
      0.221730,
      3.712409,
      1,
      2.853903,
      2,
      3,
      5,
      NULL,
      5.652408,
      3,
      NULL,
      0.266835,
      5.471562,
      2,
      1.592243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547405,
      NULL,
      0.004055,
      1.904289,
      0.539582,
      0.141488,
      NULL,
      1,
      NULL,
      1,
      0.326603,
      0,
      0,
      1,
      0.402069,
      NULL,
      1.067576,
      1.359232,
      0,
      0,
      0.974711,
      NULL,
      NULL,
      4.710033,
      5.701549,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.545913,
      NULL,
      1.271855,
      NULL,
      0,
      NULL,
      0.734250,
      1.143376,
      NULL,
      1,
      1,
      NULL,
      0.293297,
      1.151178,
      0.790083,
      0,
      1.681346,
      NULL,
      0,
      1.388162,
      0.047063,
      0.205569,
      1.577592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.034573,
      1,
      1,
      0,
      0,
      1.444868,
      0,
      0,
      0,
      0,
      0,
      1.427295,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1.737033,
      1,
      1.475935,
      0.113899,
      0,
      1.515452,
      0.308585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.981397,
      NULL,
      4,
      3.664689,
      2,
      1.702717,
      2.072423,
      2,
      2,
      4,
      6,
      NULL,
      4.147119,
      4,
      NULL,
      1.891144,
      7,
      3.845239,
      1.949621,
      NULL,
      0.342560,
      0.367894,
      1,
      NULL,
      1.921853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2,
      3,
      2.302649,
      2,
      4,
      0.611096,
      3,
      NULL,
      4.660459,
      NULL,
      0,
      2.446817,
      0,
      2.212057,
      NULL,
      3.270977,
      5.673046,
      3.493442,
      0,
      0,
      0.419645,
      0.801058,
      0.929310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.410662,
      3,
      5.707437,
      6.418159,
      NULL,
      NULL,
      4.980503,
      NULL,
      7,
      NULL,
      7.569896,
      4.689700,
      4.797984,
      3,
      5.103225,
      6.295583,
      3.148260,
      4.113614,
      NULL,
      1.490892,
      NULL,
      5.816102,
      NULL,
      9,
      8.396103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523294,
      0.345018,
      0,
      5,
      5,
      1,
      4,
      7.321494,
      NULL,
      2.962254,
      0.363144,
      NULL,
      2.824349,
      NULL,
      5.502131,
      5.085655,
      6.326641,
      NULL,
      5,
      2,
      7.474266,
      NULL,
      7.071041,
      3.009622,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.449158,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1.156100,
      NULL,
      NULL,
      0.351869,
      NULL,
      1.211394,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0.816771,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      7,
      NULL,
      0,
      0,
      2,
      3.661419,
      4,
      2,
      NULL,
      3.797435,
      2.251664,
      3,
      5,
      NULL,
      5.853786,
      2,
      5,
      NULL,
      0.817019,
      1,
      1,
      0.673499,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      3,
      NULL,
      4,
      1,
      6,
      0,
      1,
      1,
      2,
      1,
      2,
      1,
      3,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      3,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      3,
      NULL,
      1,
      2,
      0,
      NULL,
      0,
      3,
      0,
      3,
      0,
      4,
      2,
      5,
      NULL,
      0,
      2,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1986',
      NULL,
      '11-29-1976',
      NULL,
      ' 2- 5-1991',
      ' 1- 1-1990',
      ' 3-10-1991',
      '11-19-1975',
      '11-20-1975',
      ' 5- 1-1985',
      NULL,
      ' 9-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 8-2001',
      NULL,
      ' 1- 9-1996',
      ' 8- 0-1974',
      '10- 9-1992',
      ' 1- 6-1993',
      ' 5- 3-1989',
      ' 5-12-2001',
      ' 8- 8-2001',
      NULL,
      ' 8-27-1989',
      ' 1-11-1993',
      ' 2-26-2003',
      '11-24-1993',
      ' 3-10-1981',
      NULL,
      NULL,
      NULL,
      '10-13-1981',
      NULL,
      ' 1-24-1977',
      ' 0- 7-1984',
      '10- 6-1979',
      ' 5-22-1994',
      NULL,
      ' 5-15-2003',
      ' 2-17-1995',
      NULL,
      ' 1- 5-1982',
      '11-10-1983',
      NULL,
      NULL,
      '11- 7-1984',
      ' 2-15-1978',
      '11-27-1974',
      ' 7-12-1976',
      ' 5- 2-1985',
      ' 5-20-1981',
      ' 4-28-2002',
      NULL,
      ' 0- 4-1984',
      NULL,
      ' 4- 5-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 8-1987',
      NULL,
      ' 6-20-1976',
      ' 0- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995662);
commit;
end;
/


