set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '1433014',
      0,
      1.958709,
      1,
      '34133',
      0,
      ' 3- 4-1979',
      9,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1.750314,
      2.746963,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.662452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434138,
      NULL,
      0.034097,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      3,
      4,
      5,
      NULL,
      2,
      0.662607,
      1.971277,
      NULL,
      NULL,
      2,
      4,
      1.856130,
      1,
      NULL,
      5,
      4,
      1,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      45.117686,
      220.707843,
      81,
      1.332674,
      2.062658,
      NULL,
      0.533382,
      3,
      2,
      204.549463,
      0.817364,
      0.055877,
      0,
      159.125265,
      5.819369,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.119047,
      93.009688,
      2,
      2.187908,
      3.010759,
      141.297783,
      NULL,
      3.989064,
      6.988397,
      863.370764,
      2,
      NULL,
      1,
      160,
      10,
      NULL,
      3,
      196,
      171,
      3.215530,
      1,
      548,
      5.394758,
      3,
      3.751105,
      288.039014,
      109.587676,
      3.070807,
      3,
      171.276341,
      NULL,
      3,
      7.620649,
      704.940491,
      NULL,
      2,
      4,
      219,
      368,
      3,
      2.634552,
      196,
      31,
      0,
      NULL,
      NULL,
      246,
      NULL,
      0.388413,
      564.599585,
      NULL,
      0.577164,
      6,
      72,
      NULL,
      3,
      7.514518,
      48,
      128,
      1,
      3.778132,
      450,
      66.226997,
      1,
      2,
      10,
      4,
      0,
      1,
      62,
      1.043584,
      1,
      NULL,
      NULL,
      4.688062,
      3.350409,
      3.033287,
      309.389104,
      16.004636,
      2,
      NULL,
      101.934965,
      42,
      2,
      5,
      799,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '32242',
      '21111',
      '',
      '',
      '',
      '',
      0.974727,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      0,
      5,
      135,
      2.052529,
      23.721660,
      0,
      NULL,
      1.735964,
      NULL,
      3.291636,
      26.166465,
      NULL,
      NULL,
      0,
      NULL,
      1.551407,
      NULL,
      0.656951,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1993',
      22,
      3,
      9.407336,
      6.275140,
      NULL,
      NULL,
      1,
      5.927767,
      1,
      NULL,
      0.083240,
      4,
      0.512107,
      3.153575,
      4,
      3,
      7.450734,
      1,
      NULL,
      NULL,
      12,
      5,
      3,
      4.071538,
      4.645874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117846,
      27.186089,
      3.744630,
      2.531682,
      10.658634,
      32.784956,
      12,
      NULL,
      2.181483,
      21.331522,
      5.643692,
      31.688345,
      NULL,
      13.221014,
      0,
      NULL,
      1,
      3,
      16,
      25.872083,
      NULL,
      31,
      34.901328,
      10.050132,
      4,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      169.698752,
      140,
      150.058888,
      37,
      98,
      49,
      112.881336,
      85.519695,
      132,
      109,
      NULL,
      NULL,
      86.379123,
      17.105400,
      172.000645,
      13.915501,
      170.600077,
      70,
      30.954351,
      161,
      50,
      NULL,
      NULL,
      NULL,
      74,
      131.787229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.180088,
      4.806783,
      7.361917,
      3.030061,
      3,
      1,
      0,
      4,
      0.110173,
      2,
      4,
      0,
      4,
      5.352406,
      1,
      7.824655,
      1.740844,
      6,
      4.517912,
      NULL,
      NULL,
      3,
      6,
      NULL,
      0.753920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058910,
      0,
      0,
      8.323347,
      3,
      NULL,
      2.446218,
      0,
      NULL,
      NULL,
      1.600873,
      8.791355,
      10,
      8,
      8.447346,
      2.518908,
      7,
      7,
      4,
      3,
      NULL,
      4.282390,
      7.202847,
      2.353162,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.346820,
      3.162907,
      1.080700,
      NULL,
      0.336669,
      1,
      NULL,
      NULL,
      1.507359,
      0.637478,
      2.673152,
      NULL,
      6,
      1,
      5.988646,
      1.896846,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.341673,
      NULL,
      1.695686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.908111,
      1,
      NULL,
      1.774984,
      0,
      1.040717,
      0.870475,
      1,
      1,
      0,
      1.397047,
      1.317337,
      1.024095,
      1,
      NULL,
      0.064035,
      1,
      0,
      0.017319,
      0.407683,
      NULL,
      1,
      0.244448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.820001,
      5,
      NULL,
      9.375382,
      1,
      1,
      0.612817,
      0.925781,
      0.418025,
      NULL,
      6,
      7.614723,
      NULL,
      0,
      2.647708,
      4,
      NULL,
      3.868647,
      6.822530,
      1.217646,
      NULL,
      1.802643,
      2.748789,
      6.049824,
      7.990941,
      1.670912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.337212,
      3.581304,
      2,
      6.754532,
      7.649626,
      7,
      5.353364,
      NULL,
      5.177560,
      NULL,
      NULL,
      5.224324,
      6.182530,
      NULL,
      7,
      2.076851,
      2.595089,
      1.150823,
      0.411064,
      1,
      5.067050,
      2.236918,
      3.371180,
      0.206161,
      2,
      2.475655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.218738,
      NULL,
      3.409496,
      6,
      2.416477,
      6,
      2,
      5.606453,
      5.626877,
      7,
      NULL,
      NULL,
      NULL,
      1.755925,
      NULL,
      NULL,
      2,
      3.958219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.972119,
      5,
      6.547885,
      NULL,
      3.843280,
      0.989668,
      NULL,
      4.126485,
      3,
      NULL,
      1.100646,
      4.303123,
      5,
      7,
      5.012989,
      3,
      6.329622,
      3,
      6.763397,
      5.319690,
      4.080305,
      0,
      6,
      3.967235,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986959,
      5,
      8,
      1.576779,
      3.786432,
      NULL,
      0,
      2.199107,
      1.068900,
      3,
      1,
      0,
      NULL,
      1,
      1.554400,
      0.148961,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.389695,
      1,
      0.317642,
      1.676369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137423,
      0.894910,
      0,
      1.409632,
      1.574466,
      NULL,
      0.191814,
      0.538933,
      0.981797,
      1.707958,
      0,
      1,
      1.013349,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.641529,
      6.739725,
      1.465173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.402018,
      1,
      1,
      1.497506,
      1,
      0.831816,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.913069,
      1.098606,
      NULL,
      1.557111,
      1.764666,
      0,
      0.356589,
      0.652809,
      1.082930,
      1,
      1,
      0.977043,
      0,
      1.422060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.974809,
      7,
      7.528686,
      9.152643,
      0.714520,
      4,
      1.705088,
      2.201815,
      1.067508,
      NULL,
      0,
      2,
      9.113607,
      4.934144,
      9,
      5,
      NULL,
      2.790153,
      8.605904,
      2.632292,
      0,
      0,
      NULL,
      3.426563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      7.318863,
      NULL,
      7,
      5,
      0,
      1,
      2,
      2,
      0.918519,
      0.297212,
      0,
      0,
      1.765161,
      1.136574,
      NULL,
      NULL,
      1,
      5.437100,
      2,
      2,
      2.883844,
      0,
      0.407960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.738584,
      7,
      8,
      0.469651,
      8,
      7,
      5.604324,
      7,
      4,
      1.527364,
      6,
      6.917667,
      1,
      5.560413,
      5.659777,
      4,
      2,
      4,
      4.180260,
      NULL,
      6,
      4,
      6,
      NULL,
      2.603243,
      5.704698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9.665745,
      4,
      NULL,
      1.153222,
      2.505534,
      0.004678,
      NULL,
      NULL,
      6.796140,
      7.936314,
      0,
      0,
      NULL,
      6,
      0.965409,
      4,
      7.574102,
      2.896400,
      NULL,
      4.525355,
      7.612752,
      5.316799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379411,
      1,
      0,
      0,
      1,
      1.029050,
      1,
      NULL,
      1,
      1.264927,
      1,
      0,
      0,
      NULL,
      0,
      0.358425,
      1,
      1.031348,
      NULL,
      0.045473,
      1,
      1.925756,
      NULL,
      0.005315,
      1.345717,
      0.233655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.194030,
      3,
      6,
      3,
      4,
      0.373714,
      0.485055,
      0.835359,
      0.107196,
      4.239501,
      NULL,
      3,
      NULL,
      3.167964,
      2.009979,
      1.007381,
      1.138535,
      3.247698,
      NULL,
      NULL,
      0,
      2,
      3,
      8,
      0.922716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      4,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      5,
      1,
      2,
      2,
      5,
      NULL,
      2,
      5,
      2,
      NULL,
      2,
      0,
      0,
      3,
      1,
      5,
      NULL,
      2,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1986',
      NULL,
      ' 3- 2-1982',
      '10-19-1996',
      NULL,
      ' 5-16-1997',
      ' 9-27-1983',
      ' 0-25-1989',
      ' 5-19-1994',
      ' 9- 3-1982',
      ' 4-19-1983',
      ' 5- 1-1995',
      ' 4-15-2002',
      ' 7-11-1995',
      ' 8- 5-2000',
      ' 5- 7-2003',
      ' 6- 3-1980',
      ' 7-18-1996',
      ' 1-11-2003',
      ' 1-21-1977',
      ' 1-28-1981',
      '10-12-1992',
      ' 4-15-1981',
      NULL,
      NULL,
      ' 2-15-1984',
      NULL,
      ' 7- 8-1977',
      ' 6- 5-1979',
      ' 4-15-1974',
      '11-20-1986',
      NULL,
      ' 5- 7-1975',
      ' 7-13-1983',
      NULL,
      ' 7- 8-1989',
      ' 8- 3-2001',
      ' 2-18-1997',
      ' 1-27-2003',
      NULL,
      '10-29-1975',
      ' 8-26-1989',
      ' 2-16-1985',
      ' 1-21-1979',
      ' 8-22-1983',
      ' 5- 5-1998',
      NULL,
      ' 3- 0-1994',
      ' 6- 2-1975',
      ' 2-19-1998',
      ' 5-13-1992',
      ' 5-15-1986',
      NULL,
      '10- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-1990',
      ' 5-17-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669863);
commit;
end;
/


