set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '2140304',
      3,
      NULL,
      NULL,
      NULL,
      1,
      '11- 6-1977',
      138.582657,
      NULL,
      1.439169,
      1,
      2.839660,
      1.459837,
      0.342810,
      0,
      1,
      3,
      2.773594,
      0,
      1.253252,
      6,
      NULL,
      NULL,
      1.718879,
      NULL,
      14.299467,
      3.551439,
      2.904778,
      0,
      NULL,
      NULL,
      3.970885,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956493,
      7,
      7,
      1,
      7,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3.763090,
      3,
      0,
      NULL,
      1,
      1,
      1,
      1,
      5.774289,
      0,
      1.372929,
      NULL,
      2.233116,
      1,
      3.642438,
      2,
      3.868893,
      1.718861,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615157,
      NULL,
      1,
      1,
      NULL,
      2,
      2,
      44.621173,
      58.439336,
      79,
      2,
      1.725894,
      351.887951,
      NULL,
      3.648629,
      6,
      21.358997,
      2.400661,
      3.054601,
      5,
      117,
      12,
      2.704980,
      NULL,
      132,
      4.693686,
      NULL,
      NULL,
      NULL,
      11.307549,
      NULL,
      3,
      18.493176,
      NULL,
      2.773855,
      1,
      323,
      0,
      1.984615,
      NULL,
      147,
      21,
      0,
      7.248056,
      118.060605,
      NULL,
      1.008587,
      3.271749,
      212,
      3.881707,
      1,
      NULL,
      250,
      NULL,
      NULL,
      7,
      102,
      39.668841,
      0,
      2.204397,
      724,
      2,
      1.156705,
      8,
      520,
      73,
      0,
      NULL,
      NULL,
      18,
      2.562473,
      9,
      138,
      238,
      1,
      2.074358,
      277,
      NULL,
      NULL,
      0,
      229.821005,
      70.795160,
      2.605911,
      9.110961,
      230.656914,
      62,
      NULL,
      9,
      43.749464,
      NULL,
      3.837714,
      1.237835,
      166.095849,
      17,
      1.794416,
      2.802591,
      541.582969,
      1,
      1,
      0,
      370,
      5,
      2.012050,
      3.940656,
      345.571428,
      NULL,
      0,
      0,
      356.027343,
      14,
      0,
      7.813636,
      949,
      NULL,
      3.199520,
      1,
      NULL,
      NULL,
      0.477200,
      2,
      NULL,
      72.728541,
      2.053724,
      0.567663,
      280.844387,
      0,
      NULL,
      0,
      181.592464,
      1,
      2,
      2,
      248.468239,
      80.302220,
      NULL,
      0,
      108,
      30.808252,
      1.440754,
      NULL,
      284,
      NULL,
      1.110516,
      NULL,
      182,
      202,
      3.144499,
      7.726257,
      562,
      280,
      2.994253,
      1.099753,
      203,
      37.203612,
      0.620629,
      1,
      66,
      295.862457,
      1.499034,
      3.902510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '20410',
      '01414',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      2,
      4.800342,
      302,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      10,
      NULL,
      0.983563,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      7.435949,
      2.138532,
      8,
      NULL,
      6,
      6.358600,
      NULL,
      NULL,
      8,
      12.575091,
      NULL,
      6.367570,
      4,
      2.505490,
      5.848211,
      NULL,
      NULL,
      2.180536,
      15.128292,
      12.523489,
      8,
      1,
      1,
      0.474686,
      5,
      1,
      9,
      NULL,
      NULL,
      6.000006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.111782,
      3,
      NULL,
      10,
      21.551318,
      17.378139,
      NULL,
      31,
      17.732597,
      20.243592,
      NULL,
      16.413653,
      18,
      22.483239,
      42,
      0,
      7.059225,
      19.371851,
      14,
      10.112359,
      41,
      0.036085,
      10,
      NULL,
      15,
      3,
      42.317364,
      25.766566,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      163,
      166.279638,
      155.523191,
      134,
      43,
      106,
      8,
      113.131696,
      NULL,
      11.101526,
      57.476689,
      134.492469,
      151.930234,
      83,
      NULL,
      177.259457,
      NULL,
      27.793501,
      179.919325,
      74.382753,
      162,
      NULL,
      20,
      185.437684,
      NULL,
      20,
      2,
      155.919482,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      6.244260,
      0,
      1,
      NULL,
      0,
      5,
      NULL,
      7,
      2.878139,
      7,
      3,
      NULL,
      7,
      2.031480,
      1,
      NULL,
      3.152144,
      5.714748,
      6,
      4,
      0,
      4.953160,
      1.437238,
      2,
      2.307403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      9.079989,
      7,
      6.326794,
      NULL,
      9.488252,
      5,
      0.645854,
      5,
      1,
      NULL,
      NULL,
      0.706758,
      7,
      8,
      NULL,
      3,
      2.339825,
      NULL,
      NULL,
      NULL,
      2.989510,
      8.740948,
      5,
      7,
      5.431822,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832648,
      0.537604,
      NULL,
      1,
      1,
      1.386014,
      0.133212,
      NULL,
      1.437329,
      NULL,
      NULL,
      0.848388,
      0,
      1,
      6.629852,
      NULL,
      1,
      1.862648,
      0.093420,
      0.992981,
      1,
      0.453172,
      0,
      0.566853,
      0,
      0,
      1.426535,
      0.085835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545967,
      1.387508,
      0,
      0.249793,
      1,
      0,
      NULL,
      0.638869,
      1,
      NULL,
      0.973006,
      0,
      0,
      0,
      NULL,
      1.843509,
      1,
      0.839282,
      0.833023,
      0.066650,
      0,
      0,
      0.471276,
      0.842948,
      1.855539,
      NULL,
      0.368109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095562,
      2.164468,
      0.072729,
      1,
      NULL,
      3,
      2,
      3.925064,
      2.989445,
      5,
      7,
      5.663765,
      4.340552,
      1.703352,
      5.879847,
      0.776631,
      3,
      0,
      5,
      NULL,
      NULL,
      4,
      3,
      6,
      4.763032,
      3,
      0.583716,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.195530,
      5.413654,
      0.078446,
      NULL,
      3,
      2.856320,
      5.328277,
      NULL,
      0,
      5.649048,
      3.805767,
      1,
      NULL,
      2,
      0.834795,
      9,
      1.218506,
      0.110488,
      5.957684,
      NULL,
      0.881985,
      NULL,
      1.056081,
      NULL,
      4,
      1.147091,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.247258,
      3.331888,
      NULL,
      3,
      NULL,
      3.407234,
      6.226545,
      3.584894,
      NULL,
      NULL,
      NULL,
      6.484980,
      3.461809,
      NULL,
      3,
      2.086833,
      0,
      1.247790,
      7,
      6.938249,
      NULL,
      2,
      1.548207,
      NULL,
      1.587405,
      NULL,
      1.868483,
      0.128917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1.795237,
      3,
      NULL,
      NULL,
      4,
      3.901773,
      5.141361,
      5.650813,
      0,
      0,
      NULL,
      4,
      NULL,
      0,
      3.445869,
      4.192238,
      4,
      2,
      3.610561,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.903699,
      1.820414,
      7.003641,
      9,
      6.171277,
      4,
      2,
      NULL,
      2.984274,
      2.886775,
      1,
      3,
      1,
      1.993414,
      1,
      1,
      1.574825,
      0.119035,
      0.142148,
      NULL,
      1,
      0.441789,
      1,
      1.347000,
      7,
      0.023630,
      0,
      0,
      0.201265,
      1.056980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959144,
      1.852930,
      NULL,
      0,
      3.347303,
      NULL,
      1.689287,
      NULL,
      0.699275,
      1,
      NULL,
      0,
      1.394655,
      1.836357,
      0,
      0.040270,
      1,
      0.196879,
      1,
      0,
      1,
      0.826538,
      1,
      3.505170,
      0,
      0.204238,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307750,
      0.902190,
      NULL,
      0.955323,
      NULL,
      1,
      1.277711,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0.428530,
      0.649000,
      NULL,
      0,
      1.422650,
      1.451540,
      1,
      1.224670,
      0,
      0,
      1.912015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      9.046097,
      2,
      8.872020,
      1,
      4,
      2,
      4.619910,
      4.690820,
      0.343208,
      3,
      1,
      NULL,
      NULL,
      7.941326,
      2.292903,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3.917566,
      3.205858,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447670,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.770895,
      1.417707,
      3.068334,
      0.375190,
      7.270503,
      3.395301,
      1,
      0.326623,
      5.199953,
      1.928251,
      5,
      NULL,
      0,
      4,
      NULL,
      2,
      0,
      1,
      1,
      1.745164,
      3.687636,
      1.398604,
      NULL,
      1.253048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      8,
      4,
      6.128711,
      4.996644,
      8.825769,
      NULL,
      6,
      7.226339,
      NULL,
      NULL,
      3.067877,
      4.201185,
      NULL,
      9.969789,
      NULL,
      3.312611,
      0,
      3.519007,
      4.120700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.942010,
      4,
      6,
      5.067693,
      NULL,
      6,
      1.317417,
      1.054380,
      0,
      3,
      0,
      5.634369,
      NULL,
      3,
      3.343111,
      6.747516,
      1.181556,
      NULL,
      5.261209,
      6,
      0.811839,
      3.639539,
      7,
      0.939808,
      3,
      3.458951,
      0,
      4.850723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301985,
      1.649385,
      0,
      0,
      1.542715,
      NULL,
      NULL,
      NULL,
      0.619084,
      1,
      NULL,
      1.698991,
      1,
      0.250709,
      0.071861,
      NULL,
      NULL,
      1.674493,
      0,
      NULL,
      1.843241,
      0,
      1.788952,
      1.034991,
      1,
      1,
      0,
      1,
      0,
      0.831448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544441,
      7,
      NULL,
      6,
      3,
      1,
      4.914271,
      5.133409,
      4.290436,
      1.825685,
      NULL,
      NULL,
      0,
      3,
      1,
      5.925851,
      4,
      1.742801,
      1.074638,
      7.808766,
      0,
      6,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      2,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      5,
      3,
      3,
      2,
      5,
      2,
      0,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      3,
      1,
      NULL,
      0,
      4,
      NULL,
      NULL,
      4,
      1,
      2,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-22-1989',
      ' 3-20-1998',
      ' 3- 1-1974',
      ' 8-17-1978',
      ' 4-22-1985',
      ' 9-17-2002',
      ' 7-14-1994',
      '11-25-1996',
      ' 5- 7-2002',
      ' 9-12-1982',
      ' 5- 2-1977',
      ' 1- 5-1991',
      ' 2- 8-1979',
      ' 1-26-2000',
      ' 7- 3-1992',
      NULL,
      ' 3-27-1976',
      NULL,
      ' 9-28-1986',
      '10-12-1983',
      ' 8- 4-2001',
      '10-23-1996',
      ' 6- 0-1974',
      ' 8-18-1996',
      ' 8-15-1994',
      '11-20-1987',
      NULL,
      ' 9-29-1981',
      ' 6- 1-1984',
      ' 5-13-1995',
      NULL,
      ' 0- 2-1994',
      ' 3-29-1989',
      '10-19-1978',
      NULL,
      ' 9-16-2001',
      ' 0-12-1992',
      ' 1-17-1983',
      '11-26-1990',
      ' 7- 7-1992',
      ' 5-21-1994',
      ' 5- 1-2000',
      NULL,
      ' 5-18-1995',
      '10-19-1978',
      ' 8- 1-1992',
      ' 2-12-1984',
      ' 4-26-1974',
      '10-24-1974',
      ' 8- 4-1989',
      NULL,
      ' 5-21-1984',
      '11-15-1992',
      ' 4-13-1982',
      ' 4-17-2000',
      NULL,
      NULL,
      ' 9- 3-1979',
      ' 9-29-1991',
      ' 3-26-2002',
      ' 0-19-1976',
      NULL,
      ' 0-17-1992',
      '11-10-1977',
      ' 5-23-1977',
      ' 8- 0-1990',
      NULL,
      ' 4-11-1996',
      NULL,
      NULL,
      ' 4- 8-1984',
      NULL,
      NULL,
      NULL,
      ' 7-16-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-16-1983',
      ' 1- 0-2001',
      ' 3-18-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


