set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '40103032',
      29.687256,
      40,
      '0403100',
      3,
      7,
      1,
      NULL,
      5,
      NULL,
      109,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      2.678748,
      0.578549,
      0,
      NULL,
      1.660116,
      0.318776,
      8,
      NULL,
      NULL,
      0,
      NULL,
      0.541107,
      42,
      NULL,
      4.132363,
      NULL,
      NULL,
      3,
      1.044215,
      1,
      NULL,
      2,
      3.360967,
      0,
      3,
      1,
      2,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      0,
      0,
      2,
      3,
      9,
      3,
      2,
      1,
      0,
      0.263462,
      0.618050,
      3,
      3,
      NULL,
      0.163515,
      3.658456,
      5,
      2,
      0,
      3,
      8,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032573,
      2.630760,
      6,
      NULL,
      3,
      NULL,
      3,
      108.002254,
      533.200267,
      51.251880,
      2.461319,
      3.946051,
      99.718089,
      15,
      NULL,
      0,
      8.412025,
      721,
      1.481859,
      0.031754,
      388.301423,
      256,
      1.715677,
      4,
      584.844016,
      1418.660823,
      1.521703,
      3,
      NULL,
      4,
      3.413677,
      0.422683,
      136.632079,
      75,
      2.893176,
      3,
      217,
      8,
      2,
      3.053705,
      34.702224,
      1,
      1,
      6.055406,
      189,
      7.806587,
      NULL,
      3,
      183,
      0.578604,
      2,
      4,
      129.647411,
      7,
      1.904220,
      1.416084,
      227,
      4,
      0.670091,
      1,
      183.894697,
      8,
      2.135687,
      6.907676,
      356.227188,
      3.831871,
      0,
      3,
      NULL,
      6,
      2,
      0.912532,
      245,
      31,
      NULL,
      7,
      244.731177,
      4,
      3.360426,
      NULL,
      180,
      5,
      1,
      6.980034,
      NULL,
      4.877668,
      0.245301,
      7,
      377.946766,
      NULL,
      2,
      2.592540,
      235.359522,
      NULL,
      NULL,
      NULL,
      228,
      1.404229,
      1,
      NULL,
      49,
      10.770750,
      NULL,
      1.389636,
      67,
      4,
      0,
      1.129615,
      227,
      5.027163,
      3,
      3,
      457,
      31.410741,
      1.620604,
      3,
      86.184965,
      7.987978,
      1.208350,
      7.297487,
      35.147036,
      7,
      2.760181,
      3,
      92.755423,
      NULL,
      0.380269,
      5.135937,
      170,
      2,
      NULL,
      NULL,
      205.478548,
      4.717309,
      0,
      7.575423,
      NULL,
      163.923887,
      1.813324,
      3,
      241.565699,
      24,
      0.726489,
      NULL,
      250,
      12.712349,
      1.824637,
      2,
      210.740344,
      82.909066,
      3,
      1,
      21.383246,
      183.797256,
      2.193618,
      5.383643,
      193,
      171.301600,
      1.818165,
      NULL,
      151,
      53,
      3,
      NULL,
      283,
      5,
      1,
      1.013267,
      724,
      8.493402,
      1.222553,
      1.172889,
      135.669559,
      3.596513,
      3,
      0,
      232,
      321,
      3.386693,
      2,
      47,
      3,
      2.799284,
      1.782554,
      NULL,
      68,
      NULL,
      6,
      121,
      1.730097,
      2,
      NULL,
      NULL,
      207,
      1,
      2,
      156.719463,
      NULL,
      NULL,
      4,
      NULL,
      43,
      3.828793,
      NULL,
      130.558985,
      NULL,
      1.638619,
      1.150783,
      112,
      128,
      5,
      NULL,
      268,
      0,
      3,
      3,
      104,
      138.322399,
      2.427076,
      5.621776,
      143,
      41.684219,
      0.332006,
      1.351304,
      117,
      182.945394,
      0,
      2,
      153.667432,
      0,
      3,
      2.325528,
      74.742211,
      NULL,
      2,
      NULL,
      793.355544,
      406.235308,
      2,
      1.305802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.451475,
      NULL,
      '34442',
      '24232',
      '',
      NULL,
      '',
      1.773075,
      NULL,
      '',
      '',
      1.965492,
      '',
      '',
      '',
      0,
      3.584184,
      97,
      1,
      NULL,
      5.366028,
      4,
      1.835078,
      NULL,
      1,
      NULL,
      0.238267,
      NULL,
      0,
      109.458092,
      NULL,
      NULL,
      4,
      211,
      1.983067,
      1,
      ' 5-25-2003',
      0,
      2.878263,
      NULL,
      5.380116,
      3.154952,
      4.624480,
      1.568667,
      11,
      2.886372,
      4.855410,
      7,
      6.575156,
      9.764753,
      2,
      NULL,
      4.310844,
      10.360799,
      NULL,
      21.016084,
      9,
      NULL,
      6.401305,
      6.954209,
      13,
      17.227684,
      NULL,
      NULL,
      12.545998,
      5,
      13.979770,
      7,
      7,
      5,
      5.523841,
      2,
      10.768839,
      7.337759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.215766,
      2.247047,
      NULL,
      3.041852,
      15,
      11.045382,
      1.671493,
      21.272725,
      24,
      7.813752,
      13,
      8,
      3.362057,
      NULL,
      NULL,
      23.459347,
      5.119614,
      NULL,
      NULL,
      NULL,
      1,
      35.775541,
      NULL,
      11,
      15.783341,
      22,
      15,
      14.366218,
      6,
      15.909030,
      6,
      2.109489,
      5.807225,
      14.168673,
      25.499465,
      8,
      5.461471,
      8.633003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      184,
      NULL,
      160,
      55.511000,
      23,
      NULL,
      43,
      NULL,
      141.248955,
      17.059621,
      43,
      NULL,
      NULL,
      2,
      136,
      158,
      90.574823,
      150.245472,
      NULL,
      176.670910,
      152.277587,
      NULL,
      120,
      NULL,
      NULL,
      59,
      82,
      194,
      1,
      NULL,
      0,
      0.677293,
      1,
      NULL,
      2,
      NULL,
      3.832982,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.025899,
      1,
      NULL,
      5.998668,
      0,
      4.142910,
      1.019950,
      1.230767,
      7,
      5,
      5,
      NULL,
      2,
      2.810994,
      5.562859,
      8.540267,
      8,
      4,
      2.355419,
      6,
      1.326426,
      2,
      1,
      2.616082,
      1.546338,
      6,
      NULL,
      9.739252,
      2,
      NULL,
      3.331187,
      NULL,
      NULL,
      0,
      NULL,
      2.756994,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      7,
      3.020714,
      NULL,
      5.618380,
      NULL,
      NULL,
      2.481389,
      8,
      NULL,
      NULL,
      6,
      NULL,
      1,
      2,
      5.058656,
      NULL,
      7.785706,
      5,
      6.287884,
      4,
      0.263029,
      NULL,
      5,
      5,
      8.854613,
      8,
      6.782618,
      5.972492,
      3,
      4.110322,
      0.703740,
      1.869622,
      1.450653,
      2.949025,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255231,
      3,
      4.341060,
      0.731152,
      5.493922,
      0,
      2,
      2.222857,
      2.381558,
      6,
      1.357454,
      3,
      3.934211,
      1.155315,
      1.251072,
      NULL,
      0.115048,
      0.514134,
      0.319104,
      NULL,
      0,
      1.124262,
      0.760677,
      NULL,
      1.781591,
      3,
      NULL,
      3.423927,
      1,
      7,
      1.662547,
      2.114650,
      1,
      2.616922,
      3.690976,
      1.716733,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.147623,
      2,
      2,
      NULL,
      0,
      4,
      2.372052,
      6,
      1.458152,
      0.874276,
      1.257862,
      1,
      1,
      1,
      1.429347,
      1,
      0.884308,
      0.948914,
      1.002081,
      NULL,
      1,
      NULL,
      1,
      1.026535,
      0.130847,
      0.641761,
      1,
      1.407723,
      NULL,
      1.360520,
      NULL,
      1,
      0.727410,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195552,
      5,
      3.838129,
      4,
      1,
      3.800960,
      2.703502,
      0.278288,
      5,
      3.855595,
      3.029432,
      0,
      1,
      1,
      0.511700,
      1.128677,
      1.734093,
      1.773175,
      0.310243,
      NULL,
      NULL,
      1.514483,
      NULL,
      0.728360,
      NULL,
      0.914089,
      3,
      5.973448,
      NULL,
      0.553277,
      0.356616,
      1,
      1,
      NULL,
      0.416621,
      2.157846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.026629,
      NULL,
      6.459843,
      1,
      3.230309,
      1.012861,
      2.529023,
      5,
      1.107964,
      2,
      1,
      NULL,
      3.155603,
      2,
      0,
      1,
      NULL,
      2.195478,
      0,
      2.515179,
      2.849775,
      1.957611,
      NULL,
      0,
      NULL,
      5,
      4,
      3.438547,
      NULL,
      1,
      1.998361,
      0,
      1.822660,
      NULL,
      0.475176,
      3.493417,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414922,
      4.930462,
      1.673136,
      7,
      1,
      0.573993,
      2,
      2,
      1.489019,
      NULL,
      2,
      NULL,
      4.680051,
      2,
      2,
      1,
      4,
      0.786482,
      NULL,
      4,
      NULL,
      0.742302,
      0.789110,
      3,
      9,
      6,
      0,
      6.916201,
      7.209868,
      2.693940,
      2.105820,
      5,
      NULL,
      4,
      1.260861,
      6,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.519125,
      4,
      9,
      4,
      4.022558,
      4,
      NULL,
      3.208419,
      4,
      3,
      5.769784,
      NULL,
      4.011132,
      NULL,
      1.337645,
      1.274948,
      1,
      1.416708,
      NULL,
      0,
      1,
      6.148257,
      NULL,
      1.165831,
      4.904228,
      5,
      2,
      2,
      2.024541,
      1.976866,
      NULL,
      1.865042,
      NULL,
      1,
      0,
      0.038513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.146744,
      2.240501,
      5.092792,
      3,
      3.884517,
      5.738155,
      3.081040,
      0.838192,
      3.529820,
      4,
      1.098170,
      1,
      0,
      1,
      1.983623,
      3,
      0.732416,
      0.559890,
      NULL,
      1,
      1.500891,
      1,
      4,
      7,
      0.655191,
      5,
      0,
      1.582179,
      1.709131,
      0,
      1.884235,
      1,
      NULL,
      0,
      3,
      5,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858692,
      NULL,
      2.898749,
      4,
      0,
      NULL,
      NULL,
      1.576686,
      4,
      8,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0.276084,
      0,
      0.564051,
      0,
      0,
      1.819079,
      0.691854,
      0.026734,
      0,
      NULL,
      1.933092,
      2,
      2.726778,
      1.800426,
      1.450164,
      1,
      0.637108,
      0.285160,
      1.146323,
      0.240336,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.365795,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.715887,
      1,
      3,
      4,
      2.092797,
      2.370569,
      NULL,
      0.085902,
      1.420268,
      1,
      1.115687,
      NULL,
      NULL,
      0.234371,
      0,
      1,
      1.932214,
      0,
      NULL,
      0.497738,
      0.841605,
      0,
      0.560727,
      NULL,
      NULL,
      0,
      NULL,
      1.462973,
      NULL,
      NULL,
      0.753150,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      2.620472,
      1.233170,
      3,
      0,
      2.215105,
      NULL,
      3.292409,
      4.611029,
      0.732672,
      3.490464,
      2.873002,
      1.420876,
      NULL,
      1,
      3.815213,
      1,
      2,
      0.779303,
      0,
      2.236619,
      NULL,
      5,
      4,
      NULL,
      4,
      2,
      0.873349,
      4.823962,
      5.732266,
      1,
      NULL,
      1.469416,
      0,
      0.832226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243599,
      0.939716,
      1.884149,
      NULL,
      1,
      1.749797,
      4.530602,
      3,
      2,
      2.750089,
      0,
      NULL,
      2.357775,
      0,
      NULL,
      NULL,
      5.650151,
      1,
      4,
      0,
      1,
      NULL,
      NULL,
      0,
      0.865921,
      NULL,
      2.756245,
      1,
      3,
      NULL,
      0.714751,
      1.077605,
      0.429226,
      3.522136,
      0.835978,
      NULL,
      1.336051,
      0.029486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433232,
      1,
      4,
      6,
      3,
      2.295773,
      NULL,
      2,
      9.351958,
      NULL,
      1,
      5.540730,
      6.015423,
      NULL,
      NULL,
      1.819816,
      4,
      NULL,
      0,
      2.127609,
      5.186641,
      1.902021,
      4,
      6.598641,
      2,
      NULL,
      1.204936,
      7,
      6,
      3,
      4,
      0.828155,
      NULL,
      1,
      2.312398,
      0.773935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.925161,
      0.625739,
      NULL,
      2,
      0,
      7,
      3.325830,
      5,
      0.223018,
      NULL,
      1,
      4,
      4,
      3,
      0,
      1,
      2,
      NULL,
      2.996824,
      4,
      0,
      0.684727,
      1,
      5.561879,
      0.583034,
      6.288055,
      6,
      1,
      6,
      4.600416,
      0.506238,
      NULL,
      4,
      NULL,
      1,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.833322,
      NULL,
      1,
      3.919708,
      2,
      NULL,
      0,
      2.146588,
      3.667957,
      NULL,
      3,
      0,
      1.510451,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.108938,
      0.254694,
      1,
      1.480303,
      1.109342,
      0.138113,
      0,
      1.100756,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.025680,
      NULL,
      0,
      1.496505,
      1.149337,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.496026,
      3,
      3.354838,
      NULL,
      NULL,
      1,
      0.071856,
      3.559880,
      0.844921,
      3,
      NULL,
      3.742282,
      0.543487,
      1,
      NULL,
      1.458351,
      NULL,
      3,
      1.444705,
      0.576333,
      0,
      NULL,
      0,
      NULL,
      4,
      NULL,
      2,
      3.944456,
      0,
      3.661647,
      NULL,
      1.223816,
      4.346686,
      3,
      NULL,
      1,
      1.993984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      2,
      1,
      1,
      3,
      1,
      1,
      NULL,
      0,
      3,
      7,
      NULL,
      NULL,
      6,
      6,
      NULL,
      6,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      3,
      0,
      NULL,
      4,
      2,
      3,
      1,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      3,
      2,
      4,
      4,
      NULL,
      7,
      2,
      3,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      6,
      2,
      1,
      NULL,
      0,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      0,
      0,
      2,
      3,
      1,
      NULL,
      5,
      2,
      2,
      1,
      1,
      1,
      4,
      2,
      5,
      1,
      3,
      5,
      5,
      2,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      3,
      4,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      2,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-1988',
      ' 7- 0-1979',
      ' 3-29-1975',
      NULL,
      ' 2-25-2003',
      ' 6-26-1991',
      ' 7-27-1980',
      NULL,
      ' 4- 3-1989',
      NULL,
      ' 9- 3-1982',
      ' 0-18-1980',
      '11-10-1975',
      ' 1-11-1985',
      ' 8-17-1998',
      ' 9-22-1998',
      ' 8-26-2003',
      '10- 9-1975',
      ' 7-16-1988',
      ' 3-12-1975',
      NULL,
      ' 3-26-1990',
      ' 7- 5-1979',
      NULL,
      ' 7-26-1986',
      NULL,
      ' 9-14-1983',
      ' 0-26-1979',
      ' 5- 9-1981',
      ' 6-29-1987',
      ' 2-29-1989',
      ' 8-19-1976',
      '11- 0-1976',
      '10-22-1996',
      ' 0-21-2001',
      ' 3-11-1976',
      ' 0-26-1998',
      ' 4- 0-1999',
      ' 3-12-1989',
      ' 4-29-2002',
      ' 8- 4-2002',
      ' 8- 4-1985',
      NULL,
      ' 6-29-2003',
      ' 0-26-1990',
      ' 5- 3-1998',
      ' 6-11-1974',
      ' 0-20-1982',
      ' 4-25-2002',
      ' 8- 7-1990',
      ' 7- 2-1984',
      NULL,
      ' 0- 3-1984',
      ' 1-13-1987',
      NULL,
      ' 8-18-2000',
      NULL,
      ' 4-24-2002',
      '11-29-1990',
      ' 0-18-1996',
      ' 0-11-1979',
      '11- 9-1991',
      ' 3- 6-1987',
      ' 4-28-1984',
      ' 8-23-1996',
      NULL,
      ' 2- 9-2000',
      NULL,
      '11-18-1974',
      ' 5-14-1979',
      '10-14-1991',
      ' 0-27-1981',
      ' 2- 0-1982',
      ' 7- 4-1998',
      '10- 3-2000',
      ' 0-14-1990',
      NULL,
      ' 7-12-1998',
      NULL,
      NULL,
      ' 9-17-2000',
      ' 9-25-1990',
      ' 4-26-1975',
      ' 5- 4-1979',
      ' 6-24-1974',
      ' 6-11-1986',
      NULL,
      ' 5-29-1989',
      NULL,
      ' 6-29-1993',
      ' 1- 1-1977',
      NULL,
      ' 9-28-1984',
      ' 2-15-1985',
      '10- 1-1993',
      '10- 1-2001',
      ' 4- 2-1982',
      ' 7- 5-1977',
      ' 7- 3-1978',
      ' 1-27-1992',
      NULL,
      ' 3- 9-1999',
      NULL,
      ' 0-22-1985',
      NULL,
      ' 9-17-1997',
      ' 5-28-2000',
      ' 9-19-1984',
      '10-22-1983',
      ' 4-25-1981',
      ' 4- 0-1991',
      ' 7- 6-1987',
      '11-23-1988',
      ' 5- 2-1997',
      '10-20-1992',
      ' 1- 8-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1974',
      NULL,
      ' 2- 3-2000',
      '10-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


