set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '42010431',
      NULL,
      38.160215,
      '4134131',
      1,
      NULL,
      3,
      '22021',
      3,
      ' 5-15-1993',
      148.980069,
      NULL,
      1,
      2,
      1,
      0,
      0,
      0,
      NULL,
      3,
      0.124639,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      76.265871,
      7.464579,
      5.793887,
      1.147107,
      NULL,
      6.195676,
      0,
      2.418740,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      2,
      0,
      0.499054,
      0,
      0.863040,
      3,
      0,
      1.456124,
      NULL,
      1.827054,
      NULL,
      0.667864,
      4,
      5,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954910,
      0.703219,
      3,
      1,
      NULL,
      NULL,
      NULL,
      38.045436,
      111,
      107,
      3,
      1,
      935.556217,
      13,
      3.996744,
      2,
      587,
      2075.560567,
      NULL,
      0,
      216.869793,
      NULL,
      3,
      7.769011,
      61.315932,
      2.908702,
      2,
      2.543973,
      101.650994,
      16,
      2.961474,
      NULL,
      218.738047,
      NULL,
      1,
      1,
      69.562338,
      1,
      0.693981,
      2,
      522.426753,
      54,
      3,
      3.912270,
      28.361940,
      NULL,
      NULL,
      2.778371,
      15,
      6.676920,
      0.758514,
      2,
      161.390021,
      6,
      2.897112,
      2.518810,
      836.547129,
      1544,
      3.764065,
      3.433793,
      NULL,
      51.268523,
      0,
      0,
      137,
      681.105121,
      0,
      3,
      224.933840,
      3,
      NULL,
      1,
      231,
      28,
      3.551039,
      1,
      299.562165,
      42.913668,
      2,
      3,
      257,
      436.949217,
      3.046352,
      1.305269,
      110.354095,
      485,
      2,
      NULL,
      NULL,
      8,
      1,
      3,
      174.814107,
      394,
      0.528416,
      3.690108,
      NULL,
      47,
      3.708659,
      NULL,
      188,
      126,
      1,
      1,
      NULL,
      90,
      2.269011,
      NULL,
      116,
      0.863051,
      0,
      0.221373,
      811.799773,
      NULL,
      3,
      3.850251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '23113',
      '4014',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '3332',
      '0103',
      '34000',
      NULL,
      2.229095,
      89,
      1.438546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      30,
      1.707565,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.703717,
      NULL,
      ' 2-28-1979',
      2.797632,
      17,
      13,
      NULL,
      0,
      3.530182,
      4,
      3,
      NULL,
      11.538455,
      7.669185,
      NULL,
      NULL,
      NULL,
      3.863974,
      17,
      13,
      NULL,
      0.067281,
      8.760294,
      5.952967,
      14.033630,
      NULL,
      12.911209,
      3,
      9,
      5.139698,
      NULL,
      8.898397,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.213137,
      3.544616,
      1.469647,
      0,
      NULL,
      NULL,
      8.070752,
      5,
      10.951051,
      9,
      1,
      38,
      11,
      NULL,
      29,
      NULL,
      49,
      3,
      NULL,
      1.764520,
      NULL,
      NULL,
      12.910236,
      22.963900,
      41.938459,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      112,
      107.349208,
      NULL,
      178.883295,
      7.684378,
      26,
      186.687782,
      144,
      13,
      6.595003,
      0,
      NULL,
      1.845592,
      1,
      0,
      NULL,
      0.203019,
      0,
      2.990143,
      0.819650,
      2.915647,
      1,
      1,
      1,
      2,
      1,
      5.525258,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.076391,
      2,
      4.271893,
      6.652109,
      6,
      NULL,
      0.811392,
      1.761725,
      7,
      4.629459,
      7.776577,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.056650,
      NULL,
      1,
      0,
      1.842435,
      1,
      1,
      NULL,
      2.503703,
      0.901115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054038,
      7.679277,
      1,
      2,
      0.952821,
      3.307548,
      6,
      0.514104,
      NULL,
      0.696905,
      4.138474,
      NULL,
      0,
      1.456630,
      1.332385,
      0,
      1.080946,
      2,
      NULL,
      NULL,
      3,
      3,
      0,
      0.118221,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901892,
      NULL,
      0,
      0,
      7.110194,
      0.335038,
      0,
      4,
      0.325111,
      1.878894,
      0,
      1,
      NULL,
      NULL,
      0.592889,
      1,
      1,
      NULL,
      NULL,
      1.216232,
      NULL,
      0,
      0.471918,
      0,
      1.200422,
      0,
      NULL,
      0.535564,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.888884,
      NULL,
      0,
      4,
      3,
      4.212736,
      0.485028,
      0,
      0,
      4.789448,
      NULL,
      5,
      1.161055,
      NULL,
      0.601372,
      4.978699,
      5,
      NULL,
      NULL,
      4,
      2.587273,
      NULL,
      4,
      3,
      NULL,
      2.258622,
      0,
      0,
      5.521769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050736,
      1,
      1.388726,
      1.507410,
      1.902638,
      1.420521,
      0.714579,
      0.523754,
      NULL,
      NULL,
      1,
      0,
      0.896178,
      1.286722,
      NULL,
      0.627304,
      0.145176,
      1.935932,
      1,
      0.908830,
      1,
      NULL,
      4,
      4,
      NULL,
      2,
      5.354143,
      0.281186,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.853209,
      2,
      NULL,
      9,
      3.128171,
      NULL,
      4,
      5,
      4.532570,
      4,
      0,
      5,
      3.159513,
      2.500867,
      3,
      2.883863,
      3,
      1,
      3,
      5,
      2.134125,
      7,
      0,
      NULL,
      6,
      2.909153,
      2,
      2.943069,
      NULL,
      3.528840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.402651,
      NULL,
      4,
      9,
      2,
      NULL,
      7.244338,
      7.399312,
      6,
      0.360844,
      2,
      3,
      NULL,
      5,
      3.788988,
      4.931241,
      1,
      3,
      0.254726,
      3.823220,
      2,
      5,
      1.013014,
      0,
      1.873961,
      NULL,
      1.977734,
      2.670959,
      1,
      0.309360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.219457,
      2,
      5,
      5.332009,
      3.479827,
      4,
      2.346222,
      0.836155,
      5,
      1,
      NULL,
      2.620826,
      3,
      NULL,
      5,
      2.659643,
      NULL,
      NULL,
      3,
      2.890774,
      3.696530,
      2.880866,
      2.673139,
      1.254033,
      2.004422,
      NULL,
      3.536469,
      2.263545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881604,
      3,
      NULL,
      2.940801,
      3,
      3,
      NULL,
      1,
      NULL,
      1.263798,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1.985051,
      0.653062,
      0.065496,
      1.267304,
      1.314521,
      3,
      0.240357,
      0.447103,
      0,
      0,
      0,
      0.697607,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672834,
      1,
      0.229577,
      1,
      NULL,
      NULL,
      NULL,
      1.467716,
      0.513502,
      0.850932,
      0.171764,
      1,
      0.916574,
      0,
      1.437465,
      0.060958,
      1,
      1.639301,
      1,
      NULL,
      NULL,
      0.487120,
      0,
      NULL,
      0.431918,
      0.082169,
      0,
      0,
      NULL,
      1.669753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613624,
      0,
      1,
      1,
      1.781963,
      1,
      NULL,
      0.308797,
      0,
      1,
      0,
      1,
      0.394157,
      0.343770,
      0.213493,
      0,
      0,
      1.259750,
      0,
      0.705770,
      NULL,
      1,
      NULL,
      0.290757,
      NULL,
      NULL,
      0.968225,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.711433,
      0,
      NULL,
      0,
      NULL,
      2.146737,
      2,
      NULL,
      1.282471,
      1,
      1.067041,
      NULL,
      NULL,
      0,
      0.715373,
      1,
      0.979370,
      1.507510,
      NULL,
      0.428715,
      0.607565,
      NULL,
      NULL,
      0.802299,
      0.143410,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217640,
      NULL,
      2.082706,
      3,
      NULL,
      NULL,
      3.534586,
      2.227763,
      0,
      1.173078,
      0,
      1,
      0.513142,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.581253,
      0.893012,
      1,
      2,
      0.446099,
      1.303743,
      NULL,
      1.881939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.212520,
      8,
      5,
      1.174556,
      2.779000,
      2,
      3,
      NULL,
      1.383066,
      1.756253,
      3.919326,
      3,
      1.433088,
      5.550366,
      5.590654,
      3.305948,
      5,
      1,
      NULL,
      5.500012,
      0.962385,
      1.814494,
      3,
      NULL,
      4.383319,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      NULL,
      6,
      7.632569,
      2,
      1.957390,
      4,
      2,
      4,
      NULL,
      2.602161,
      NULL,
      4,
      2.366200,
      NULL,
      1.360573,
      1,
      0.456136,
      0.444306,
      5.270346,
      1,
      0,
      NULL,
      NULL,
      2.671736,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104206,
      0.793104,
      1.593154,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1.568938,
      0.194217,
      1,
      0,
      1,
      1,
      1.426277,
      0.229176,
      1,
      NULL,
      0.057864,
      NULL,
      0.110534,
      1,
      0,
      1,
      1,
      NULL,
      0.313666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.635645,
      0,
      4.864295,
      1,
      4.222565,
      0,
      0.904728,
      0.510783,
      0.552521,
      NULL,
      0,
      0,
      0.292593,
      0,
      1,
      1,
      0.114124,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.977216,
      NULL,
      0.477269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      2,
      0,
      0,
      0,
      1,
      2,
      3,
      NULL,
      1,
      4,
      4,
      NULL,
      0,
      NULL,
      5,
      NULL,
      1,
      1,
      0,
      0,
      2,
      NULL,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 7-1982',
      '11- 4-1978',
      ' 3-12-1986',
      ' 6- 6-1975',
      ' 9- 4-1981',
      NULL,
      ' 8-16-1976',
      ' 4- 6-1978',
      ' 3-13-1992',
      ' 3-26-1986',
      ' 3-26-2000',
      ' 1- 2-1983',
      ' 0- 2-1995',
      ' 9-18-1981',
      ' 5-25-1986',
      ' 6-27-1985',
      ' 7-29-1984',
      ' 5-10-1999',
      NULL,
      ' 3-10-1978',
      ' 3-13-1987',
      ' 8- 0-1985',
      ' 2-17-1986',
      ' 2-14-2000',
      NULL,
      ' 6-28-2001',
      ' 3-15-1990',
      ' 3- 9-1976',
      ' 7-13-1990',
      '11- 4-1985',
      ' 0-23-1983',
      NULL,
      ' 3-18-2003',
      ' 5-29-2000',
      NULL,
      '10-22-1982',
      '11-25-1981',
      ' 0-28-1992',
      ' 7-20-1979',
      ' 3-29-2003',
      ' 4-29-2000',
      ' 5-23-1975',
      NULL,
      ' 0-12-1997',
      ' 9- 0-2001',
      '11-26-1988',
      ' 3- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-24-1985',
      ' 0-15-1996',
      ' 6-11-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 0-1981',
      NULL,
      ' 0-11-1993',
      ' 1-28-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


