set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      '32001200',
      72,
      9,
      NULL,
      1,
      5,
      3,
      '01242',
      NULL,
      ' 8-19-1984',
      79,
      NULL,
      0,
      0,
      0.763920,
      1,
      0.689245,
      1.697420,
      NULL,
      1,
      NULL,
      1,
      NULL,
      5,
      0,
      NULL,
      0,
      NULL,
      1.109023,
      NULL,
      13,
      0.758080,
      1,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      6,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.502450,
      2,
      6.697593,
      2,
      0.686074,
      1.874641,
      0,
      1.072688,
      3,
      3,
      3,
      0.640307,
      NULL,
      0,
      3,
      NULL,
      4,
      0,
      2.809843,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534936,
      4,
      NULL,
      1,
      3,
      NULL,
      4,
      17.745618,
      70,
      171.746680,
      2,
      3.933204,
      407.070459,
      15.432087,
      NULL,
      NULL,
      642.557657,
      1853,
      3.319973,
      0.464036,
      66,
      NULL,
      2,
      2.352668,
      233.329832,
      NULL,
      2.688929,
      1.218566,
      NULL,
      15,
      2.475970,
      3.695248,
      NULL,
      8,
      1,
      NULL,
      NULL,
      0.982213,
      2.115601,
      1,
      713.887829,
      34.156543,
      NULL,
      3.416918,
      8.210968,
      0.821710,
      0.004780,
      2.569333,
      194,
      2.709444,
      0,
      3,
      72.231109,
      0,
      3.132418,
      3.357377,
      381.516326,
      1492.562830,
      2,
      3,
      626.096501,
      151,
      1.832902,
      3.034275,
      221.747339,
      555.894662,
      3.770973,
      NULL,
      NULL,
      NULL,
      0.297114,
      3,
      517.014420,
      26,
      1.011244,
      2,
      NULL,
      26.682011,
      3.626423,
      2,
      226,
      NULL,
      0.359764,
      0,
      169,
      948,
      NULL,
      1.258446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '1143',
      NULL,
      '',
      '',
      NULL,
      0.104920,
      '',
      '',
      '',
      6,
      NULL,
      '2431',
      '40230',
      0,
      3,
      311,
      0.289762,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      367.895036,
      1.452853,
      NULL,
      1.312678,
      NULL,
      1.931425,
      NULL,
      1,
      NULL,
      1.731114,
      NULL,
      '10-23-1991',
      1,
      8.938757,
      19,
      11,
      2,
      1.851349,
      NULL,
      0.539199,
      4.322488,
      19,
      21.525800,
      2.021740,
      NULL,
      3.639171,
      11,
      0,
      NULL,
      0,
      NULL,
      5,
      17.542298,
      NULL,
      14,
      NULL,
      15.726274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.179525,
      1.456527,
      NULL,
      1.029259,
      7.412253,
      21.282125,
      31.190490,
      NULL,
      12,
      18,
      1,
      29.902535,
      10.227163,
      6,
      7.440976,
      0,
      20.977803,
      2.612267,
      3.183454,
      1.403390,
      5.604802,
      20,
      6.747880,
      45.907759,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      177.349291,
      53,
      NULL,
      31.952224,
      52,
      188,
      142.738963,
      NULL,
      NULL,
      53.483000,
      10,
      97,
      1,
      0.018166,
      1,
      1,
      1.910274,
      NULL,
      1,
      0.396193,
      3.414509,
      NULL,
      2,
      3,
      1.794492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.935456,
      2,
      NULL,
      8.122553,
      2.147483,
      1,
      NULL,
      3,
      5,
      1,
      2,
      NULL,
      0,
      NULL,
      0.527914,
      0.348061,
      0,
      1.379510,
      1.567128,
      NULL,
      1,
      1,
      0.606668,
      1.876749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.673560,
      1.983894,
      1,
      5.389384,
      NULL,
      3,
      NULL,
      4.776143,
      4.486202,
      4.032112,
      2,
      0.491922,
      0.070395,
      NULL,
      0.722479,
      1,
      1,
      4.692471,
      0.876260,
      4,
      7,
      0,
      1.620029,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.871850,
      5.273672,
      1.855501,
      6,
      0.796582,
      NULL,
      0.439034,
      1.399957,
      NULL,
      1,
      NULL,
      1,
      1.297654,
      1,
      0.943057,
      1.516872,
      1,
      NULL,
      0,
      NULL,
      1,
      1.484334,
      0,
      0.550299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.743580,
      0,
      5.982565,
      NULL,
      1.734747,
      NULL,
      0.093936,
      3,
      4,
      0.155635,
      3,
      2,
      1.625112,
      4.705030,
      0.387853,
      NULL,
      0.278992,
      4,
      NULL,
      NULL,
      NULL,
      5,
      0.028478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051125,
      0.259378,
      0.459546,
      0,
      1,
      NULL,
      0.252470,
      1,
      0,
      0.232750,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1.614597,
      0,
      0,
      1,
      1,
      0.740536,
      4.316742,
      NULL,
      0.063229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.481445,
      NULL,
      9.858664,
      3,
      NULL,
      4,
      NULL,
      4.985160,
      3.574281,
      0.712119,
      4.707036,
      5,
      3,
      4.358104,
      1.600974,
      3,
      4.433039,
      NULL,
      4.330088,
      4.638504,
      NULL,
      3.768546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.131585,
      NULL,
      11.509164,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      5,
      2.888121,
      0,
      5,
      NULL,
      1.975711,
      0.044042,
      0,
      4.885519,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.089702,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      3.256471,
      2,
      5,
      NULL,
      4.519363,
      1.700431,
      3,
      4.574815,
      1,
      2,
      3,
      4,
      3,
      1,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811252,
      4.152693,
      2.235787,
      3,
      NULL,
      1.643379,
      0.271222,
      0.415908,
      0,
      0,
      0,
      1.718425,
      1,
      1,
      0.716323,
      1.656893,
      1,
      NULL,
      1,
      1,
      NULL,
      1.597079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584934,
      0.465772,
      0.769320,
      NULL,
      1.643212,
      0.421475,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.031302,
      NULL,
      1.736886,
      0.972224,
      1,
      1.363984,
      0,
      0,
      0,
      0.749006,
      1.256484,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324739,
      NULL,
      0.511203,
      1,
      1.871431,
      1.861398,
      0,
      0,
      0.825268,
      1.421968,
      0.184393,
      0,
      0.853303,
      1,
      1,
      1.163860,
      1.848896,
      0,
      1.650732,
      0.756580,
      1,
      NULL,
      0.215597,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.319354,
      2.789461,
      NULL,
      NULL,
      1.886949,
      1.669865,
      0.079536,
      1,
      0,
      1.674264,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.211591,
      1.509564,
      0.381336,
      0.172280,
      0.526863,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277888,
      1.192760,
      2,
      2,
      3.805526,
      3,
      1,
      0.388145,
      NULL,
      1,
      NULL,
      1,
      1,
      1.113699,
      1.194965,
      1.287272,
      0.850109,
      0,
      1.695062,
      1.877041,
      0,
      1.988745,
      0.099172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.425402,
      8.743883,
      NULL,
      4.256873,
      4,
      8,
      5,
      5.901952,
      1,
      NULL,
      3,
      3,
      NULL,
      3,
      NULL,
      2,
      1,
      3,
      5.503501,
      1,
      5,
      3,
      0,
      0.276064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      8,
      2.945430,
      4,
      NULL,
      0.223844,
      3.550127,
      NULL,
      NULL,
      4.536639,
      2.488502,
      NULL,
      0.887306,
      1,
      3.306620,
      2.427731,
      3.621339,
      3,
      4,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.835214,
      NULL,
      1,
      1,
      1.471661,
      1,
      0.713639,
      NULL,
      NULL,
      1.871323,
      1.297196,
      1,
      0.228734,
      1.890059,
      1.839930,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.393373,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980211,
      2,
      4,
      5.400712,
      3.003597,
      1,
      5.506914,
      2,
      3,
      1.169946,
      1.711404,
      0.980329,
      NULL,
      0.278740,
      0.520636,
      0,
      0,
      1.695251,
      0,
      0,
      1.234312,
      1,
      0,
      0,
      1.073304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      NULL,
      1,
      1,
      3,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      3,
      3,
      5,
      1,
      5,
      3,
      1,
      3,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1985',
      NULL,
      '11-10-1975',
      ' 7-25-1997',
      '10-19-1990',
      ' 3-19-1985',
      ' 7-19-1983',
      ' 2- 0-1997',
      ' 3-17-1989',
      ' 3-24-1982',
      NULL,
      ' 3- 3-1988',
      ' 3-13-1984',
      NULL,
      '10-10-1999',
      NULL,
      ' 6-10-1979',
      '10-16-2002',
      ' 1-26-1998',
      NULL,
      ' 8-29-1987',
      NULL,
      ' 9-27-1978',
      ' 9-20-1986',
      ' 5- 9-1998',
      ' 6- 7-1999',
      ' 7- 0-1997',
      '10-12-2001',
      ' 3- 3-1984',
      ' 4-11-1980',
      ' 9-27-2000',
      ' 9-18-1994',
      ' 3- 8-1986',
      NULL,
      ' 5-19-1991',
      NULL,
      ' 8-18-1987',
      ' 9-18-2003',
      ' 5-29-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-12-1985',
      NULL,
      ' 5- 0-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


