set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '1212234',
      2,
      NULL,
      0,
      '12242',
      2.869847,
      ' 7-10-1975',
      50,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      3.460791,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.445048,
      0,
      1.979513,
      3.808899,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1.265179,
      0,
      2,
      3,
      0,
      0,
      0,
      0.529445,
      3,
      6,
      17,
      3,
      0,
      4,
      4.478861,
      5,
      7.089385,
      NULL,
      3,
      1.182601,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491916,
      NULL,
      4,
      0,
      0,
      10,
      3,
      49,
      1601.960279,
      481,
      8.658007,
      1.817198,
      1748,
      NULL,
      0.491873,
      4,
      133,
      4.573360,
      1,
      NULL,
      144.744536,
      14,
      1,
      5.490811,
      122.541115,
      NULL,
      NULL,
      1,
      21,
      32.050638,
      3,
      3.563255,
      65,
      19.810187,
      NULL,
      7,
      222,
      40.488587,
      3,
      NULL,
      161.400490,
      NULL,
      0,
      1.413801,
      NULL,
      1236,
      3,
      NULL,
      62.624494,
      527.844057,
      1,
      0,
      51,
      38,
      2,
      6.910100,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4.802351,
      2,
      5.070416,
      162.625866,
      NULL,
      3,
      2,
      1396,
      1200,
      2.209335,
      NULL,
      265.182134,
      NULL,
      3.811885,
      3.444182,
      941,
      0.001097,
      3,
      3.076091,
      221,
      60.372161,
      1.867765,
      2,
      122,
      4.618496,
      3,
      6.820356,
      85.010465,
      60.510136,
      1.640098,
      9.471017,
      98.856914,
      38,
      2.172812,
      0,
      316.196416,
      NULL,
      0,
      7.176743,
      376,
      0.619025,
      0.246884,
      5,
      88,
      1,
      NULL,
      3.404289,
      1126.667608,
      NULL,
      0.800444,
      2.894374,
      132,
      12,
      0,
      1,
      123,
      NULL,
      NULL,
      3,
      108.381524,
      11,
      0.624708,
      3.041049,
      NULL,
      4,
      3.684933,
      0.315555,
      193,
      0,
      NULL,
      3.148950,
      831.530365,
      5,
      2.050262,
      3,
      453,
      7.024509,
      3.668415,
      3.905776,
      488.305156,
      2,
      NULL,
      NULL,
      1012.118194,
      5,
      0.705542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '20332',
      NULL,
      '',
      NULL,
      '',
      '',
      1.058953,
      '',
      NULL,
      '',
      1,
      '1244',
      '',
      '',
      3,
      6.842488,
      NULL,
      0.502545,
      60.354240,
      3,
      3.257964,
      0,
      NULL,
      0.599810,
      6.391362,
      1.932192,
      NULL,
      1,
      NULL,
      0.442327,
      NULL,
      0.692442,
      NULL,
      0,
      NULL,
      '10- 4-1980',
      NULL,
      2,
      3.029674,
      2.357140,
      9,
      5.426863,
      13,
      16,
      NULL,
      NULL,
      0,
      1,
      18.825813,
      21.301935,
      7,
      17,
      3,
      3.059114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.449937,
      14.681541,
      14,
      2.022778,
      31.835698,
      14.209802,
      3,
      26,
      26.263261,
      6.686085,
      3,
      9.798792,
      9.859620,
      3,
      2,
      NULL,
      13.460950,
      1.741149,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      90.447309,
      74.220644,
      149,
      93.911451,
      147.503434,
      150,
      96,
      134.652629,
      25.821720,
      102,
      141.553521,
      61,
      34,
      27,
      101,
      123.320644,
      NULL,
      99.237471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7.967771,
      NULL,
      1.553295,
      5,
      1.895485,
      7.812591,
      0.637870,
      6.416355,
      0.078489,
      NULL,
      NULL,
      NULL,
      NULL,
      0.530903,
      6,
      NULL,
      NULL,
      7.037334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.189718,
      6.926943,
      0,
      0.084995,
      3,
      NULL,
      0,
      0.293305,
      0,
      1.918918,
      1,
      2.029289,
      0,
      3,
      0,
      0.411362,
      2.073254,
      1.088032,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.487278,
      NULL,
      NULL,
      1,
      5,
      3,
      NULL,
      2.443446,
      0,
      3.971706,
      1.240655,
      2,
      3,
      0,
      2,
      NULL,
      0.502305,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.172001,
      4.031339,
      7,
      3.920266,
      1.875454,
      0,
      NULL,
      0,
      1,
      NULL,
      5,
      NULL,
      5,
      4.399488,
      5,
      7.897384,
      5.482039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233817,
      1,
      3.064783,
      5.271711,
      5.126301,
      NULL,
      6,
      3.241203,
      0,
      5.570758,
      NULL,
      1,
      1,
      1.107011,
      6.892839,
      6,
      2.168537,
      7,
      3.165065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      9,
      0.552362,
      NULL,
      8.532726,
      4.393276,
      5,
      5,
      NULL,
      8,
      9.181682,
      0,
      NULL,
      0.642766,
      1.283714,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      8,
      0.788704,
      3.923621,
      6,
      9.508374,
      11.477303,
      NULL,
      6.129094,
      NULL,
      8,
      9,
      4.565061,
      8,
      NULL,
      9,
      8.309285,
      6.293706,
      9.734119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.989625,
      2,
      5.632753,
      3.869117,
      6.874186,
      NULL,
      3,
      4,
      1.535441,
      2.428540,
      3.097920,
      2.713054,
      7.931848,
      NULL,
      NULL,
      NULL,
      6.730359,
      7.279346,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      5.162678,
      11,
      3,
      3.465862,
      NULL,
      3,
      3,
      1,
      5,
      7.917621,
      6,
      1,
      3,
      9.443734,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.812592,
      0,
      5,
      6.924253,
      4.392577,
      9,
      2,
      3,
      3.585028,
      NULL,
      0,
      7,
      1.675270,
      NULL,
      3.889137,
      3.511251,
      7.946257,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512067,
      0.491734,
      0.014756,
      0.318686,
      NULL,
      0.230035,
      1.484672,
      4.425535,
      1,
      NULL,
      0.601770,
      NULL,
      0,
      0.001119,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.875921,
      2,
      3.744011,
      2,
      4,
      1.555519,
      0.312877,
      3.674006,
      1,
      1.184119,
      1,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      NULL,
      0.001439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270033,
      NULL,
      1,
      0.420816,
      1.169507,
      1.076899,
      0.400730,
      0,
      0,
      0.616043,
      2,
      1.528083,
      1,
      NULL,
      0,
      1,
      0.374101,
      0.944299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6.451267,
      1.834518,
      NULL,
      7,
      3.446728,
      2.564244,
      NULL,
      2.786664,
      0.172122,
      4,
      NULL,
      6,
      3.316225,
      5.869247,
      3.690149,
      NULL,
      6.720811,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.690092,
      NULL,
      7.297722,
      1.662777,
      8,
      3.220646,
      4,
      4.937088,
      NULL,
      4,
      4.211571,
      3,
      8,
      3.386015,
      4.462795,
      7.475122,
      5,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666764,
      1.409115,
      0,
      0.905535,
      1.855362,
      0,
      0.915998,
      NULL,
      7.446851,
      0.210689,
      1.377619,
      0,
      0.831210,
      1,
      0,
      1.416682,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781031,
      4.013946,
      2,
      4.332565,
      2.610950,
      NULL,
      3,
      0.264315,
      0,
      3.738014,
      NULL,
      2.924267,
      NULL,
      1,
      3,
      4.384763,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      5,
      1,
      3,
      2,
      3,
      3,
      4,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-1999',
      NULL,
      NULL,
      NULL,
      '10- 8-1978',
      ' 7-20-1985',
      ' 5-16-1978',
      NULL,
      '11-26-1984',
      ' 7-16-2001',
      ' 4-23-1988',
      ' 4- 8-1996',
      ' 4-29-2000',
      NULL,
      ' 1-19-1978',
      ' 7-25-2002',
      ' 7-24-1978',
      ' 9-10-1976',
      '11- 3-1987',
      NULL,
      NULL,
      ' 7- 9-1998',
      ' 8- 9-1977',
      NULL,
      NULL,
      ' 4-27-1980',
      NULL,
      ' 7-23-1982',
      ' 2- 2-1995',
      ' 6-15-1982',
      '11-25-1989',
      ' 1-15-1980',
      NULL,
      NULL,
      ' 1-29-1993',
      ' 3- 1-1974',
      NULL,
      NULL,
      ' 0- 3-2003',
      NULL,
      '10- 4-1983',
      NULL,
      ' 3-12-1994',
      ' 2- 9-1974',
      ' 4-23-2002',
      NULL,
      '10-10-2001',
      NULL,
      ' 3-22-2003',
      NULL,
      ' 6-15-1979',
      ' 8-10-1980',
      NULL,
      ' 8-15-1982',
      '11- 3-1981',
      NULL,
      '10-14-1980',
      ' 8-12-1994',
      NULL,
      '11-27-1974',
      ' 5-27-1984',
      ' 4-29-1996',
      ' 2-25-1988',
      ' 4-25-1979',
      ' 8-17-1987',
      ' 9-19-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068378);
commit;
end;
/


