set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8013144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '1000313',
      0,
      NULL,
      1,
      '24422',
      1.658188,
      NULL,
      5,
      NULL,
      1.457000,
      3,
      0,
      0.036315,
      0.014142,
      NULL,
      NULL,
      3,
      NULL,
      1.031878,
      0.997442,
      7,
      0,
      NULL,
      2,
      NULL,
      1.878536,
      48.847107,
      11.038565,
      3,
      1,
      NULL,
      4.499889,
      1.196361,
      0.320579,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      4,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.689416,
      3,
      NULL,
      0,
      0.401012,
      1,
      1,
      NULL,
      1,
      NULL,
      1.722085,
      1,
      3,
      3,
      NULL,
      NULL,
      1.511084,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      0,
      4.012960,
      NULL,
      NULL,
      NULL,
      8765.831005,
      NULL,
      4,
      NULL,
      16743.333764,
      1.952837,
      4,
      NULL,
      9890.831464,
      2,
      2.052259,
      104,
      2442,
      3.733488,
      NULL,
      225.095138,
      11.447596,
      NULL,
      NULL,
      68,
      227.918779,
      1,
      0,
      378.435837,
      NULL,
      2,
      NULL,
      375.594817,
      42.269760,
      NULL,
      2.847932,
      214,
      92,
      2,
      5.466763,
      120.573050,
      174.330769,
      NULL,
      2,
      542.636213,
      15,
      NULL,
      NULL,
      874.414989,
      20.274915,
      1,
      2.007510,
      NULL,
      21.079979,
      1,
      2,
      163,
      39.031000,
      3,
      7.079013,
      187.042444,
      29,
      3,
      3,
      NULL,
      40.414545,
      3.526960,
      2.395399,
      89,
      86,
      1.003312,
      NULL,
      802,
      997,
      3.519636,
      1,
      NULL,
      2.106728,
      0.412955,
      3,
      456.730730,
      40,
      0,
      NULL,
      89,
      4,
      3.155889,
      2,
      381.480967,
      916.493292,
      3.008172,
      6.591710,
      649,
      546.892502,
      1,
      3,
      87.324735,
      36.641872,
      3.402281,
      3.206270,
      149,
      6,
      0,
      1,
      168,
      16,
      1.962797,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '42004',
      '32144',
      '',
      '',
      1,
      '',
      '',
      '',
      0.748815,
      '',
      '',
      NULL,
      0,
      11.903573,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.086832,
      NULL,
      1,
      NULL,
      2.024018,
      211.078242,
      0.324684,
      NULL,
      0.066491,
      NULL,
      0.168208,
      NULL,
      '10- 9-1985',
      12,
      5,
      6.830987,
      1,
      5.254149,
      12.598870,
      12,
      13,
      0,
      8,
      0,
      NULL,
      5.462164,
      NULL,
      0,
      0.806907,
      4.833460,
      1,
      3.426587,
      NULL,
      0.758806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.780072,
      32,
      18.894308,
      3,
      37.065939,
      39,
      9.615849,
      0.836795,
      30.497828,
      NULL,
      18,
      52,
      13,
      1.814062,
      1,
      0.321509,
      38,
      NULL,
      NULL,
      39,
      25.479100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.837713,
      104.644125,
      91.371007,
      141,
      161.612473,
      53.328671,
      5.322863,
      1,
      59,
      69.161133,
      NULL,
      122.412678,
      60,
      171.151988,
      99,
      38.870841,
      NULL,
      69.723379,
      NULL,
      135.037015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.370874,
      3,
      1,
      4.711530,
      2.157798,
      0.108391,
      1,
      4,
      1,
      1,
      3,
      NULL,
      1.344276,
      1,
      0,
      NULL,
      1,
      NULL,
      3.368292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.890255,
      0.258295,
      4,
      0,
      NULL,
      NULL,
      3,
      1.372070,
      1.853326,
      0.565803,
      1,
      0,
      1,
      NULL,
      7,
      0,
      0.277514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862042,
      0,
      0.455294,
      NULL,
      0.307801,
      NULL,
      NULL,
      1.558745,
      1.071499,
      0.748955,
      1,
      1,
      1.586519,
      NULL,
      NULL,
      0,
      0.497989,
      0,
      NULL,
      0.301715,
      1.587983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934675,
      1,
      0,
      NULL,
      0,
      1.720965,
      1.270385,
      5.847058,
      0,
      5.951880,
      1.368315,
      NULL,
      1.056103,
      2,
      2.744775,
      3.433768,
      3.722540,
      2.025836,
      3.120534,
      NULL,
      1.369632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.730637,
      2,
      0,
      3,
      1.063718,
      1.828371,
      0,
      1.444901,
      0,
      NULL,
      1.765077,
      1.358919,
      1,
      0,
      1.111923,
      3,
      1.155461,
      3,
      1.715618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      1.670589,
      3,
      8,
      5,
      8.738256,
      NULL,
      4.304865,
      2,
      0,
      4.724160,
      3,
      5.125110,
      4.780558,
      3,
      5.367353,
      3.681113,
      NULL,
      5.787143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.334669,
      2.393272,
      1.143157,
      4,
      4,
      3,
      3,
      7,
      7.377960,
      2,
      8,
      3,
      1.310677,
      2,
      3,
      3.944175,
      7.460939,
      4.183738,
      9,
      3.361249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599963,
      2.285416,
      1,
      1.055759,
      1,
      NULL,
      1,
      4,
      0.136793,
      3.359415,
      0.071963,
      5,
      NULL,
      3.954007,
      0,
      2,
      3.881114,
      0,
      2.017427,
      0.216999,
      1.941646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      7,
      1,
      4,
      1,
      0.019948,
      0,
      5,
      0,
      NULL,
      0,
      1.843255,
      NULL,
      3,
      0,
      2.601325,
      1.366035,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.565025,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.377388,
      2,
      1.026900,
      0.404089,
      0,
      0.321156,
      NULL,
      0,
      0.597694,
      3.392601,
      2.895491,
      0.127271,
      1.503936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926359,
      0.501796,
      1.620978,
      0.338761,
      1,
      0.586683,
      1.339307,
      0.328368,
      1.132319,
      1,
      0.883071,
      0.070658,
      0.131641,
      NULL,
      1,
      1.174142,
      0.193019,
      NULL,
      4,
      1.918086,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      3.141315,
      2.577508,
      0.981771,
      2,
      1.001623,
      0.040339,
      2.138997,
      2,
      3.727244,
      NULL,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4,
      NULL,
      3,
      1.117945,
      2,
      1.792865,
      0.718900,
      2,
      2,
      0,
      NULL,
      3,
      NULL,
      3,
      0,
      1.920038,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.294839,
      NULL,
      3,
      0,
      9.083638,
      0.629932,
      1.978979,
      1,
      3,
      0.417646,
      4.689298,
      1.982720,
      0,
      1.077581,
      1,
      2,
      6,
      4.335698,
      4,
      1.180073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.940468,
      6.272777,
      3,
      NULL,
      0,
      6,
      5.219232,
      0,
      2,
      0,
      NULL,
      9,
      1.184675,
      3,
      1.827578,
      0,
      1,
      5.277776,
      8,
      5.887834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144783,
      0.675254,
      0,
      1.354460,
      1,
      1.177367,
      0.193769,
      0.204171,
      1.944336,
      1.555726,
      0.592770,
      1,
      1,
      1,
      1,
      NULL,
      1.133026,
      0.639763,
      2.423499,
      0.591789,
      0.177970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.222174,
      2.277791,
      2.084271,
      2.230826,
      NULL,
      0,
      3.128922,
      2,
      3.526748,
      3,
      1,
      3,
      0,
      3.051771,
      2,
      1.854255,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      4,
      3,
      NULL,
      2,
      1,
      0,
      4,
      0,
      3,
      1,
      NULL,
      4,
      4,
      0,
      4,
      1,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 9-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 6-1990',
      NULL,
      '10-13-2001',
      NULL,
      ' 6-25-1988',
      NULL,
      ' 7-21-1992',
      NULL,
      '10-29-1987',
      NULL,
      ' 4- 7-1992',
      NULL,
      NULL,
      NULL,
      ' 6-19-2000',
      ' 4-15-1977',
      NULL,
      '11-11-2002',
      NULL,
      ' 2-13-1976',
      ' 7-24-1985',
      ' 9-11-1995',
      NULL,
      NULL,
      NULL,
      ' 6-19-1986',
      ' 5- 6-2003',
      ' 8-29-1999',
      ' 2-27-1983',
      ' 7- 4-1996',
      '11-21-1975',
      '11-19-1984',
      NULL,
      NULL,
      ' 2-15-1994',
      ' 6-16-1999',
      '10-10-1989',
      ' 7-10-1981',
      ' 0- 7-2002',
      ' 5- 1-1994',
      ' 4- 3-1991',
      ' 7-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-18-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


