set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9855678';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      NULL,
      39.562822,
      10.420467,
      '0300344',
      2,
      NULL,
      2,
      NULL,
      4,
      ' 9-26-1981',
      177.780656,
      NULL,
      2,
      3,
      3.747169,
      0,
      NULL,
      NULL,
      1.533755,
      NULL,
      1.476912,
      1,
      1.189175,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.664207,
      4.089646,
      1,
      1,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      4,
      1,
      8,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      2,
      0,
      1,
      9,
      7,
      6,
      NULL,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.378685,
      NULL,
      1,
      NULL,
      5,
      NULL,
      1,
      51.416643,
      108.266289,
      15,
      0.103613,
      2.345599,
      179.003863,
      NULL,
      NULL,
      NULL,
      22.576551,
      NULL,
      2,
      1.892028,
      115,
      54.376938,
      0,
      3,
      181.243664,
      175.402988,
      1,
      4,
      63,
      387,
      2.554707,
      NULL,
      NULL,
      156,
      1.337762,
      NULL,
      NULL,
      132,
      0.759786,
      4.875109,
      NULL,
      77.980019,
      3.740997,
      0.796007,
      196.005687,
      441.627623,
      3,
      NULL,
      34,
      345,
      0.284759,
      3,
      176,
      64,
      2.849695,
      NULL,
      NULL,
      4.394063,
      2.641996,
      1.130874,
      460,
      40.643417,
      3,
      3,
      157,
      24.114453,
      1.644091,
      1,
      53.691588,
      NULL,
      0.882207,
      2.593358,
      29,
      351.937683,
      NULL,
      4.307954,
      21.568862,
      373.047193,
      2,
      6.638259,
      21.566687,
      766.166721,
      NULL,
      NULL,
      25,
      5.073791,
      NULL,
      0.023567,
      234,
      165.528075,
      1.798064,
      NULL,
      NULL,
      157.641062,
      3.944590,
      3.861108,
      758.945624,
      NULL,
      NULL,
      0,
      181.953425,
      62.824054,
      3.897878,
      1,
      53,
      42,
      2.540668,
      1,
      199,
      113.537023,
      2.408897,
      4.613195,
      1312.020478,
      4,
      3,
      2.424686,
      NULL,
      2,
      1.410423,
      0,
      NULL,
      305.811115,
      1,
      8.866050,
      NULL,
      281,
      1,
      4.393169,
      90.890343,
      91.989876,
      1,
      9,
      212,
      NULL,
      NULL,
      1,
      127,
      NULL,
      2,
      NULL,
      97,
      8.007924,
      NULL,
      2,
      8.160494,
      112,
      1.282657,
      NULL,
      NULL,
      3,
      2.411969,
      0.967364,
      93.043157,
      NULL,
      1.573611,
      6.307542,
      184,
      12.239827,
      2.882793,
      1.486964,
      69.801398,
      8,
      1,
      7,
      NULL,
      NULL,
      2,
      NULL,
      113,
      0.488159,
      NULL,
      9,
      42,
      NULL,
      3,
      1.821490,
      NULL,
      203.997140,
      NULL,
      NULL,
      184.126635,
      NULL,
      NULL,
      5.406826,
      111.604718,
      6,
      NULL,
      NULL,
      152.014120,
      30.223538,
      1.526023,
      1,
      8,
      1,
      2.370114,
      1,
      224.141519,
      NULL,
      1.113625,
      1.467297,
      229,
      47,
      3,
      0.192429,
      9,
      46,
      NULL,
      2.556303,
      211,
      NULL,
      2,
      4,
      147,
      111,
      2.858904,
      1.800580,
      191,
      365.182009,
      NULL,
      3.283260,
      154,
      485.734033,
      3,
      7.265461,
      94,
      526,
      NULL,
      0,
      25,
      363.611466,
      0,
      5.628122,
      193.425150,
      NULL,
      0.102603,
      3.619279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '12430',
      '',
      '',
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      1.397822,
      897.461651,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.209731,
      NULL,
      1,
      NULL,
      1.754983,
      NULL,
      NULL,
      NULL,
      NULL,
      8.700508,
      10.097502,
      3,
      12.558933,
      8,
      10,
      12,
      11,
      13.976600,
      16.408268,
      14,
      17,
      18.559340,
      5,
      5.962838,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646814,
      NULL,
      5.616509,
      37.057814,
      NULL,
      1.054566,
      10,
      NULL,
      22.571370,
      43,
      NULL,
      NULL,
      5.400500,
      NULL,
      36.552375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      150,
      145.254444,
      105,
      104.174300,
      NULL,
      28,
      41,
      NULL,
      182,
      1.061412,
      1,
      0.045561,
      2.563392,
      NULL,
      2.803072,
      1.302392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.518822,
      4.615430,
      4,
      0.674720,
      1,
      9,
      NULL,
      NULL,
      NULL,
      9,
      3.964684,
      5.001764,
      4.271551,
      8,
      9,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.135142,
      5.711796,
      NULL,
      6,
      NULL,
      5.652817,
      5.246390,
      3,
      0.812685,
      0,
      5.304873,
      0.536300,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.700650,
      1.993491,
      NULL,
      1,
      1,
      2,
      1.160919,
      1,
      1,
      1.594914,
      1.281115,
      NULL,
      0.362335,
      1.205462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007327,
      7,
      0,
      1,
      NULL,
      9.320311,
      5.095402,
      6,
      4.792444,
      1.088220,
      9,
      3.727928,
      1.201424,
      4.357317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.531179,
      NULL,
      1.649497,
      0.787120,
      2.654242,
      0,
      0,
      2.805631,
      0.659773,
      0.346864,
      0.841059,
      5,
      1.635963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.477842,
      2.736005,
      4.889565,
      0.945062,
      8,
      1,
      4.368204,
      4,
      3.616719,
      NULL,
      4,
      6.588908,
      5,
      8,
      7.637804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152666,
      0.621545,
      NULL,
      0.716193,
      3.438792,
      7,
      2,
      3,
      6.917876,
      6.190175,
      5.544097,
      8,
      9,
      2,
      3,
      7.809932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189129,
      NULL,
      0.442696,
      NULL,
      0,
      NULL,
      4.860916,
      NULL,
      NULL,
      4,
      3,
      2,
      3.003227,
      2.829214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.674616,
      2.724603,
      2.435111,
      0.291810,
      NULL,
      NULL,
      5.841298,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673555,
      NULL,
      0,
      0.979231,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.607652,
      1.777443,
      0,
      1.040034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383302,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.980462,
      0,
      NULL,
      0,
      0,
      0.440013,
      0.803116,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689951,
      NULL,
      0,
      0,
      1.053576,
      1,
      3.672880,
      3,
      NULL,
      1.476354,
      NULL,
      0,
      0.973669,
      3,
      NULL,
      1.459826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.071436,
      NULL,
      4.117619,
      0,
      2.966799,
      4.490584,
      1,
      2.817882,
      1,
      NULL,
      3,
      0.268154,
      3,
      2.738427,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.564731,
      4.183328,
      1.362862,
      1,
      4.357444,
      11,
      3.507901,
      10.223830,
      NULL,
      6.604797,
      0,
      NULL,
      8.578436,
      4.874770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.087296,
      1,
      5,
      5,
      1.527453,
      2.618419,
      8.497397,
      4.403871,
      NULL,
      1,
      NULL,
      NULL,
      5,
      6.183503,
      4.681387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.198059,
      1,
      1.892658,
      0.744573,
      0.501652,
      0.077233,
      0.548104,
      1,
      1.929043,
      0.261665,
      0.226298,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250112,
      NULL,
      3.438329,
      NULL,
      0.912989,
      0.144537,
      NULL,
      0.355648,
      NULL,
      3,
      0,
      NULL,
      2.216468,
      3,
      0,
      0.342729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      0,
      1,
      5,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      4,
      5,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-18-1996',
      NULL,
      NULL,
      ' 8-25-1985',
      '11- 7-1988',
      NULL,
      ' 2-26-1980',
      '11-19-1998',
      ' 9-19-1987',
      ' 8-18-1980',
      '10- 7-1994',
      NULL,
      ' 6-22-1983',
      ' 5- 6-1990',
      ' 0- 0-1997',
      ' 5-16-1974',
      '10-12-1990',
      ' 7-14-1984',
      ' 6-23-1996',
      NULL,
      NULL,
      '10-16-1986',
      ' 1-15-2001',
      '11-19-1982',
      ' 7-25-1977',
      ' 6- 9-1986',
      NULL,
      ' 4-14-1980',
      ' 0-29-1978',
      NULL,
      ' 7- 5-1974',
      '11-10-1975',
      ' 2-25-1974',
      NULL,
      ' 2-12-2003',
      '10-26-1989',
      ' 8-14-1998',
      '10-28-1974',
      '11-26-1992',
      ' 0-18-1977',
      ' 2- 9-1989',
      ' 8- 2-1985',
      NULL,
      NULL,
      ' 9- 5-1983',
      ' 6- 5-1986',
      ' 4-29-1998',
      ' 1-16-1975',
      ' 2-19-1974',
      NULL,
      '11-25-1985',
      ' 6-21-1990',
      ' 0-18-1979',
      NULL,
      ' 8-23-1980',
      ' 8-24-1980',
      NULL,
      ' 1- 0-1989',
      ' 9-21-1985',
      ' 3- 8-1999',
      '11-10-1975',
      ' 1- 5-1996',
      ' 9- 7-1986',
      ' 4-18-1979',
      '11-12-2001',
      ' 8- 2-1993',
      ' 1- 4-1989',
      ' 4- 6-1978',
      NULL,
      ' 8- 2-1999',
      ' 0-22-1984',
      ' 8- 8-1986',
      '11-14-1986',
      ' 8-28-1975',
      NULL,
      NULL,
      ' 6-18-1997',
      ' 6-21-1980',
      NULL,
      '10- 2-1974',
      ' 0- 0-1987',
      ' 9- 2-1985',
      ' 5- 6-1985',
      ' 3-26-2001',
      ' 6-20-1976',
      ' 3-28-2000',
      ' 2-15-1989',
      '10-23-1979',
      ' 8-22-2002',
      NULL,
      ' 9-11-1978',
      ' 0-29-1975',
      '10-20-1974',
      ' 5- 0-1979',
      ' 9- 9-1980',
      ' 7- 6-1983',
      NULL,
      NULL,
      ' 1-27-1995',
      ' 8-20-2002',
      ' 5-21-1978',
      NULL,
      NULL,
      ' 6-13-1992',
      ' 4-13-1986',
      ' 4-11-1994',
      ' 1- 8-1989',
      '10- 2-2000',
      '11- 9-2003',
      ' 6-16-2001',
      ' 8-17-1987',
      ' 6- 1-1976',
      ' 6-14-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305915);
commit;
end;
/


