set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8421847';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '3013144',
      NULL,
      1.658976,
      2,
      '32332',
      0,
      ' 4-26-2001',
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.607977,
      0,
      0.653576,
      NULL,
      3.573809,
      1,
      1,
      3,
      NULL,
      NULL,
      3.686379,
      NULL,
      0,
      28.636606,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      2.513753,
      3,
      NULL,
      3,
      3,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      4,
      7.682216,
      2,
      0.705552,
      NULL,
      0.916827,
      0,
      1,
      1,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      6,
      0,
      2,
      NULL,
      NULL,
      2,
      9,
      ' 1- 4-1989',
      3,
      NULL,
      1,
      1,
      1,
      1,
      0,
      3,
      59,
      64,
      1.369911,
      0,
      1.046937,
      336,
      4,
      NULL,
      1,
      44,
      NULL,
      NULL,
      1,
      476.009445,
      2932,
      NULL,
      NULL,
      351.032803,
      47.619394,
      1,
      2,
      227.456981,
      87,
      0.258141,
      3.317057,
      57,
      782.883126,
      NULL,
      1.204128,
      93.373891,
      194,
      1.875678,
      3.962221,
      95.246680,
      6.488531,
      3.101570,
      3,
      NULL,
      2,
      NULL,
      NULL,
      254.491632,
      468,
      3,
      1,
      416,
      NULL,
      NULL,
      2.675219,
      151,
      NULL,
      0.786860,
      0.317793,
      NULL,
      1.829381,
      3.419440,
      1.772869,
      112,
      16,
      1.224729,
      NULL,
      520,
      1178.650166,
      1,
      2.144707,
      394.227291,
      618.073587,
      3.060727,
      8,
      64.593868,
      NULL,
      3,
      NULL,
      157,
      194,
      2.008239,
      1,
      481.987753,
      2133,
      1.793559,
      3.333954,
      897.560030,
      57,
      2,
      2.119156,
      924,
      NULL,
      NULL,
      2,
      146,
      9,
      3,
      NULL,
      NULL,
      9,
      2.942105,
      1.418799,
      217.298286,
      137.346850,
      0.280312,
      NULL,
      584,
      NULL,
      NULL,
      4,
      66,
      16,
      3,
      5,
      NULL,
      NULL,
      3,
      2.487616,
      286.064448,
      5.587820,
      NULL,
      4.580571,
      NULL,
      58,
      0.135054,
      NULL,
      217,
      856,
      3.413265,
      1,
      NULL,
      NULL,
      2.803906,
      0.602367,
      224,
      254,
      1.510144,
      0,
      NULL,
      15,
      1.569892,
      1,
      89,
      NULL,
      0.417443,
      NULL,
      211.269773,
      50.557673,
      0.029363,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11.641840,
      '44202',
      '41411',
      NULL,
      NULL,
      '21241',
      NULL,
      NULL,
      '34432',
      '',
      '',
      NULL,
      '32113',
      '43302',
      '',
      NULL,
      1.833908,
      79.760106,
      1.041674,
      NULL,
      2.046412,
      5,
      0.403493,
      NULL,
      3,
      NULL,
      0,
      2.038723,
      1.675983,
      NULL,
      1.376106,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1978',
      NULL,
      NULL,
      4.846046,
      NULL,
      1,
      2,
      13,
      NULL,
      NULL,
      0,
      4,
      2.220236,
      20,
      12,
      0.995257,
      6.109224,
      NULL,
      4,
      2.220401,
      14,
      NULL,
      2,
      2.489233,
      5.473483,
      10,
      11,
      0,
      3.607927,
      6.447748,
      12.909176,
      NULL,
      1.246798,
      5.975966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.584705,
      3,
      NULL,
      3,
      3.887350,
      2.398787,
      15,
      16,
      NULL,
      NULL,
      2.812738,
      34,
      1,
      NULL,
      1.462539,
      NULL,
      12,
      16.696281,
      NULL,
      NULL,
      29,
      3.079738,
      37.224992,
      11.929805,
      18.446171,
      37.922082,
      5,
      43.945185,
      NULL,
      29.450185,
      53,
      10,
      1.907541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      120,
      46,
      125.416963,
      163,
      163.057583,
      93.376769,
      79,
      163,
      78,
      4,
      18.855948,
      51.121080,
      135,
      106,
      89.665685,
      52,
      112.721814,
      86,
      110.369584,
      14.900750,
      99.983442,
      113,
      79.164018,
      88,
      143.958620,
      147,
      115.725843,
      168.421556,
      62.565951,
      NULL,
      28,
      127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.212180,
      0.575241,
      3.687920,
      1,
      3,
      5.729029,
      NULL,
      1,
      1,
      0.925181,
      8,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      1.965962,
      0.244540,
      3,
      0.621074,
      4.252097,
      3.314155,
      NULL,
      NULL,
      0,
      1,
      0.158384,
      0,
      3.764399,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.446482,
      NULL,
      3,
      3.458766,
      0.556390,
      3,
      3.421627,
      0,
      1,
      NULL,
      0,
      1.709543,
      1.554030,
      1.248849,
      NULL,
      2,
      1.170249,
      3.108706,
      2.667235,
      8,
      2.359484,
      3,
      7,
      2.138238,
      2.927048,
      8.510503,
      NULL,
      4.059334,
      1.237942,
      8,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133248,
      0.022219,
      0.836497,
      0,
      0,
      0.113948,
      1,
      1.942783,
      NULL,
      NULL,
      0,
      0,
      1.883274,
      0.430038,
      1.111592,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0.347649,
      1.122370,
      1.770903,
      1,
      0,
      0,
      1.850886,
      0,
      NULL,
      1,
      0.920951,
      1.696182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.787069,
      NULL,
      1.851808,
      0.438882,
      1.575376,
      NULL,
      3,
      3,
      1,
      1,
      NULL,
      2.663218,
      1.962225,
      3,
      NULL,
      1,
      0.433259,
      3.315503,
      3,
      0,
      1,
      NULL,
      NULL,
      2.595824,
      NULL,
      2.753019,
      0,
      0,
      NULL,
      1.236469,
      1.043988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.716132,
      1.558508,
      0,
      0,
      1,
      NULL,
      0,
      1.792481,
      1,
      0,
      3,
      3,
      2.996283,
      NULL,
      1.656604,
      2.486538,
      1.913138,
      3.515835,
      1,
      0.012049,
      3,
      NULL,
      1.389907,
      0,
      2,
      1.232720,
      1,
      NULL,
      5.410806,
      0.377009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635702,
      6.167577,
      NULL,
      8.644830,
      2,
      4.846443,
      1.544226,
      NULL,
      0,
      3.368663,
      4.709837,
      4,
      6.330978,
      NULL,
      5.664809,
      5,
      NULL,
      5,
      3,
      0,
      0.823632,
      3.484506,
      5,
      NULL,
      6,
      3,
      NULL,
      5.107534,
      1.095161,
      0,
      0,
      7.558610,
      3.523566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.971305,
      NULL,
      2,
      NULL,
      4.597185,
      1,
      1.610441,
      9,
      NULL,
      NULL,
      4,
      4.085015,
      NULL,
      NULL,
      5.289397,
      NULL,
      2.172491,
      NULL,
      2.923187,
      5.259061,
      7.161603,
      0.987885,
      2,
      3.832054,
      NULL,
      1.246473,
      0,
      3.887436,
      6.420158,
      4,
      4.291057,
      3.629516,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      3.125842,
      NULL,
      0.944644,
      0.727366,
      NULL,
      NULL,
      3,
      2.915436,
      3,
      NULL,
      1,
      2,
      1,
      1.269950,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      2.410160,
      2.222360,
      0,
      3,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      3,
      7.245847,
      7.176702,
      1,
      4,
      1,
      7,
      7,
      0,
      NULL,
      2,
      3.305039,
      2.868881,
      0.496226,
      0.448350,
      3.853282,
      4,
      2.949898,
      1.429765,
      2.850154,
      3,
      1.312936,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.199167,
      3,
      5.956293,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780402,
      1.866771,
      0,
      0.017257,
      NULL,
      1,
      0.192856,
      0,
      1,
      0.772510,
      0,
      NULL,
      1.729617,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1.516983,
      NULL,
      NULL,
      0,
      1.792898,
      0,
      1.281658,
      0,
      0.757971,
      0.614208,
      1.058840,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.408226,
      0.044528,
      0,
      1,
      1.874460,
      1.964943,
      1,
      NULL,
      1.293882,
      0,
      NULL,
      1.452150,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.701635,
      1.392667,
      0,
      1.883049,
      1.240952,
      1.576459,
      1.476711,
      0,
      1.917097,
      1.430818,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.419498,
      7,
      4,
      0.922845,
      3.564274,
      2.274926,
      5.901752,
      9,
      7,
      0,
      2,
      NULL,
      NULL,
      6,
      4,
      NULL,
      1.281143,
      5,
      3.751793,
      3,
      8,
      0,
      4,
      2.541378,
      NULL,
      3,
      1.846091,
      1,
      3,
      2,
      9,
      4.905509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.714138,
      NULL,
      4.973722,
      2,
      2.781176,
      0.222209,
      4,
      2.482561,
      0.344481,
      NULL,
      0.164530,
      2,
      NULL,
      NULL,
      1.322125,
      5.354824,
      5.352659,
      4.008645,
      2.686504,
      1.640712,
      2,
      NULL,
      3.855856,
      NULL,
      1.343581,
      2,
      2.365884,
      1,
      1,
      1.030134,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976188,
      NULL,
      1.018364,
      0,
      0.358320,
      3,
      4,
      0.443353,
      3.799947,
      NULL,
      NULL,
      5.733782,
      1,
      3.222135,
      1,
      NULL,
      NULL,
      5.489888,
      2,
      2,
      2,
      2.848043,
      1.699595,
      NULL,
      4,
      2.076485,
      1,
      1.077399,
      4,
      0.865908,
      7,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.440373,
      6.757941,
      0,
      3.490370,
      NULL,
      1,
      0,
      9.148032,
      NULL,
      2,
      NULL,
      0,
      7.980122,
      0,
      3,
      4,
      2,
      NULL,
      2,
      5,
      4.513865,
      NULL,
      4,
      2,
      7.108807,
      1,
      NULL,
      NULL,
      NULL,
      4.347064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133366,
      NULL,
      NULL,
      NULL,
      0,
      0.181972,
      1,
      0,
      0.910722,
      4.938401,
      0,
      1,
      0.954554,
      0.913476,
      0.277451,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1.529734,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854006,
      0,
      0,
      1.757816,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      5.518794,
      9.807747,
      1,
      5.398039,
      4.479911,
      6,
      2,
      1,
      4,
      4,
      1,
      6.420652,
      2.506673,
      7,
      0,
      NULL,
      6,
      1.256410,
      2.915756,
      NULL,
      NULL,
      NULL,
      8,
      0.907218,
      5.767246,
      3,
      5.849152,
      2,
      NULL,
      5.771894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      NULL,
      1,
      3,
      3,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      1,
      3,
      1,
      3,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1995',
      ' 9- 2-2003',
      ' 3-12-1990',
      NULL,
      '10- 8-1981',
      '10-25-1994',
      ' 5-25-1985',
      ' 8-14-1991',
      ' 6-10-1989',
      ' 6-10-1985',
      ' 5- 1-1984',
      ' 6- 7-1997',
      NULL,
      ' 0- 9-1999',
      NULL,
      NULL,
      ' 7-21-1980',
      '11- 3-1974',
      ' 6-27-1974',
      ' 7-28-2000',
      ' 8-29-1991',
      ' 7- 2-1993',
      '10-15-1995',
      '10- 3-2003',
      ' 0-24-1991',
      NULL,
      '10-13-1982',
      ' 6-15-1977',
      NULL,
      NULL,
      ' 7-22-1975',
      ' 9- 2-1998',
      NULL,
      ' 4-17-1989',
      ' 7-12-1995',
      '10-21-1980',
      ' 1- 8-1989',
      NULL,
      ' 4-25-1985',
      '10-21-1983',
      ' 1-10-1989',
      NULL,
      ' 1-10-1979',
      ' 2-18-1980',
      ' 2-21-1975',
      ' 5- 2-1991',
      ' 5-24-1999',
      ' 0-18-1991',
      ' 2- 4-2002',
      NULL,
      NULL,
      ' 2- 6-1975',
      ' 9-19-1998',
      ' 0- 6-2000',
      ' 5-22-1977',
      NULL,
      '11-13-1983',
      ' 9-21-1993',
      ' 6-10-1992',
      ' 9-29-1989',
      ' 8- 1-1995',
      NULL,
      ' 8- 6-1994',
      ' 1-14-1993',
      NULL,
      NULL,
      NULL,
      '10-12-1978',
      NULL,
      ' 6-10-2003',
      ' 6-23-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1976',
      NULL,
      ' 3-13-1995',
      NULL,
      ' 4-16-1983',
      ' 8-22-1994',
      '10-20-1983',
      ' 7-12-1994',
      NULL,
      ' 1-18-1993',
      ' 3-16-1974',
      NULL,
      NULL,
      ' 4-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


