set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7100746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '3012121',
      NULL,
      0,
      3,
      '02132',
      1.465030,
      ' 6-24-1982',
      114,
      NULL,
      1.662487,
      NULL,
      NULL,
      0.626674,
      NULL,
      1,
      0.767407,
      3.452170,
      NULL,
      3,
      1.335651,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187167,
      0.020838,
      NULL,
      NULL,
      0.324946,
      5,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      6,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.896800,
      1,
      1,
      2,
      2.750259,
      1,
      0,
      NULL,
      6,
      NULL,
      NULL,
      4,
      9,
      2,
      1909,
      12,
      NULL,
      79.123114,
      NULL,
      4.339493,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      69,
      413.097816,
      3,
      2.039261,
      47.437647,
      270.578488,
      NULL,
      1.161883,
      26,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      4,
      184,
      100.884370,
      3,
      4,
      148.358703,
      1635.910701,
      3.233060,
      2,
      NULL,
      20.242393,
      1,
      3.375445,
      56.208447,
      117.407177,
      3.191651,
      2.703406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.516576,
      '30420',
      '',
      '',
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      5.014429,
      '10433',
      '04233',
      '',
      4,
      1.722642,
      NULL,
      0.461329,
      2313.945123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.940963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      0.665333,
      1.372989,
      5.860881,
      1,
      NULL,
      16.065342,
      NULL,
      5,
      9.996589,
      NULL,
      3,
      9,
      13.791168,
      6,
      9.805086,
      2,
      10,
      9,
      14,
      0.100953,
      3.148946,
      2,
      7.613063,
      2,
      7,
      2.111117,
      1,
      9,
      15,
      0.135539,
      10,
      14.317550,
      2,
      1.108546,
      2,
      7,
      20,
      1,
      NULL,
      3.943273,
      17.564260,
      3,
      1,
      1.093997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.550201,
      35,
      3,
      3.369031,
      2,
      12.370891,
      1,
      4,
      2,
      1.460992,
      1.770732,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.891925,
      3,
      2,
      9,
      3.976132,
      8,
      2,
      3.606320,
      2.763745,
      1.155663,
      1.629309,
      8,
      1,
      NULL,
      1,
      3.741527,
      0,
      6,
      3.564416,
      18.311198,
      0.874948,
      3,
      2.119824,
      1.527662,
      22.223589,
      13.435377,
      3,
      NULL,
      25.947642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106.754854,
      NULL,
      51.322244,
      NULL,
      NULL,
      24.713648,
      116.917483,
      NULL,
      88,
      91,
      NULL,
      63,
      20.128987,
      19.175772,
      NULL,
      NULL,
      75.496440,
      25.886110,
      55.122459,
      141.972772,
      23.420815,
      104,
      48.637318,
      134.598816,
      29,
      95.438908,
      6,
      121,
      NULL,
      146,
      NULL,
      94.379761,
      106,
      NULL,
      NULL,
      138,
      118.172272,
      121.871274,
      155,
      45.976386,
      21.642658,
      64.670392,
      122,
      163,
      137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.755545,
      11.280032,
      NULL,
      4,
      5,
      0.864873,
      NULL,
      1.484973,
      2.668443,
      6.001195,
      4.231637,
      NULL,
      0.593870,
      5.387493,
      NULL,
      5.432777,
      NULL,
      5,
      6,
      5.577001,
      3,
      5.347241,
      1,
      4.463457,
      NULL,
      4,
      3,
      1,
      6,
      2.942614,
      2.091452,
      NULL,
      6,
      5,
      1.600843,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      6,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.465708,
      7,
      6,
      5.407015,
      NULL,
      7.740800,
      1,
      6.088946,
      3.597086,
      3,
      3,
      2.147288,
      6.570444,
      7.116329,
      NULL,
      0.955603,
      7,
      NULL,
      2.446276,
      6,
      4,
      NULL,
      0.473994,
      0,
      4.878433,
      4.422654,
      3,
      NULL,
      NULL,
      NULL,
      6.682488,
      6,
      NULL,
      NULL,
      0.263295,
      6,
      0,
      7,
      9,
      9.211593,
      9,
      6.979337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      7,
      7,
      5.861748,
      1.009548,
      0,
      1.093581,
      0.603682,
      NULL,
      NULL,
      1,
      NULL,
      0.532567,
      0.514861,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.063419,
      NULL,
      NULL,
      NULL,
      0.135784,
      0.625132,
      0,
      0,
      1.677836,
      0,
      1,
      NULL,
      0.538709,
      0.386037,
      0,
      2.124930,
      2,
      2,
      NULL,
      3.211630,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      6,
      7.189104,
      2,
      5.968853,
      4,
      4.922507,
      4,
      2.062942,
      4,
      NULL,
      0.155580,
      4.819961,
      0,
      7.360217,
      6.740157,
      7,
      2,
      7.427608,
      NULL,
      6.854084,
      4.203648,
      1.524755,
      6,
      0.337277,
      0.752892,
      5.581302,
      2.174982,
      6.263789,
      0.582806,
      NULL,
      0,
      7.004796,
      5.526556,
      5,
      7.857768,
      NULL,
      2.855085,
      0.858662,
      0.340007,
      NULL,
      3.609055,
      0,
      1.013812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.102215,
      4,
      6.115260,
      7.208869,
      3.061473,
      9,
      2.817410,
      NULL,
      NULL,
      NULL,
      4,
      6.971122,
      4,
      0,
      NULL,
      2.064114,
      4,
      8.215877,
      3,
      1.443037,
      6.720691,
      6,
      4,
      9.246553,
      NULL,
      NULL,
      1,
      3.721577,
      4,
      9,
      2.729649,
      8.884155,
      4,
      6.549345,
      1.142058,
      1.718637,
      1,
      3,
      8.392931,
      NULL,
      5.340143,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.178367,
      NULL,
      9.547582,
      6.790832,
      0,
      1.211620,
      0,
      11.319964,
      NULL,
      NULL,
      10.564841,
      3.718352,
      1.736715,
      2,
      NULL,
      10,
      10.200416,
      8.683874,
      3.399921,
      NULL,
      6,
      6.085728,
      5.661407,
      1,
      8.437751,
      NULL,
      NULL,
      6,
      6,
      6,
      NULL,
      NULL,
      7.039327,
      1,
      NULL,
      9,
      NULL,
      11.670456,
      5,
      NULL,
      0.169156,
      5.194200,
      9.715967,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      6,
      5.412890,
      NULL,
      6,
      0,
      7,
      NULL,
      1,
      4.002379,
      NULL,
      NULL,
      7.144225,
      NULL,
      1.827755,
      6,
      0,
      7.696555,
      0,
      9,
      6,
      1.286978,
      NULL,
      8,
      7,
      8,
      8,
      6.525797,
      4.859891,
      0,
      9.052878,
      3.700513,
      NULL,
      NULL,
      7.516571,
      6.121188,
      NULL,
      7.338808,
      8,
      1.200377,
      7.091218,
      NULL,
      0.767608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508940,
      1,
      3.286469,
      0.010771,
      4.768326,
      2,
      5.137781,
      0,
      NULL,
      3,
      0,
      5,
      NULL,
      1,
      5.215855,
      3.494048,
      2.958378,
      3,
      0.017712,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      4,
      2.487924,
      3,
      NULL,
      2,
      NULL,
      1,
      5.613048,
      3,
      0.336771,
      1.431638,
      1.775575,
      0.006802,
      NULL,
      5.845952,
      9,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.939938,
      3.422373,
      3.414049,
      2,
      3,
      0,
      0,
      3,
      2,
      1,
      3,
      NULL,
      2,
      3,
      3,
      3.859196,
      2,
      NULL,
      1.684125,
      NULL,
      NULL,
      3.383106,
      NULL,
      0,
      3.304712,
      3.411938,
      1.194537,
      0,
      NULL,
      0,
      1.836070,
      NULL,
      2.382932,
      1,
      1.256973,
      3.055905,
      3.709670,
      3.272902,
      NULL,
      0.780699,
      NULL,
      2.118032,
      3.797303,
      2.820930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971818,
      NULL,
      NULL,
      3.556782,
      NULL,
      NULL,
      0,
      1.625908,
      2.569248,
      2,
      2,
      3.651571,
      2,
      0.371358,
      NULL,
      1,
      3.585313,
      0.059987,
      0.077700,
      NULL,
      3.278461,
      0.839215,
      3.988395,
      3.129095,
      2.408881,
      3.767701,
      1,
      3,
      2,
      2,
      1.917995,
      1,
      2,
      1.979095,
      0.121532,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      3,
      2.449012,
      NULL,
      0.787687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.588376,
      0,
      NULL,
      0.685834,
      NULL,
      1.985306,
      1.785621,
      1.462580,
      NULL,
      1,
      0.465459,
      0.677215,
      0.381928,
      0.177485,
      1.268517,
      1,
      0.559204,
      0,
      1,
      0.327613,
      1,
      0.126286,
      0.024722,
      0,
      NULL,
      1.382543,
      0.684094,
      0.997031,
      0.729189,
      0.394410,
      0.303974,
      1.885558,
      0,
      0.767839,
      0,
      1,
      0.081667,
      0,
      0.408738,
      NULL,
      NULL,
      1.221435,
      1.996257,
      1.592538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.059762,
      0,
      0.042099,
      0.523678,
      1,
      NULL,
      0,
      0,
      1.847461,
      NULL,
      0,
      1,
      NULL,
      1.229569,
      0,
      0.302388,
      0.716082,
      0,
      0.527500,
      0.512453,
      0.492413,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.462294,
      0.395364,
      NULL,
      1.755665,
      0,
      NULL,
      1.451167,
      1.504959,
      1.013024,
      0.333457,
      0.928338,
      0,
      1,
      0,
      0,
      1,
      1.472055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.102742,
      1.489613,
      NULL,
      NULL,
      NULL,
      0.376014,
      0.785405,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0.706498,
      0.048528,
      1,
      0.012534,
      0,
      0,
      1,
      0.921288,
      1.866538,
      1.057411,
      NULL,
      1.484125,
      0.524510,
      1.745991,
      NULL,
      0,
      NULL,
      1,
      1.173700,
      1.644863,
      1,
      0,
      1.236165,
      NULL,
      NULL,
      0.146083,
      1,
      0,
      0.167530,
      1.541063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      7.844167,
      7,
      7,
      2,
      7,
      4,
      6,
      NULL,
      0,
      7,
      4.011250,
      NULL,
      1,
      0.868809,
      2.307070,
      8.510189,
      0,
      NULL,
      9.720759,
      4.881559,
      1.242603,
      1,
      9.371314,
      6.056192,
      9.456385,
      2.043562,
      4,
      8.421299,
      0.511006,
      5.907009,
      8.817390,
      8.817007,
      NULL,
      8.700723,
      2.499479,
      0.866260,
      9.089910,
      3.533639,
      3,
      3,
      0,
      4.093055,
      1.005301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.726011,
      1.884417,
      5,
      NULL,
      6.089796,
      NULL,
      0,
      1,
      NULL,
      0.808384,
      1.625192,
      2,
      5.663715,
      4,
      8,
      5.356254,
      6,
      7,
      NULL,
      1.997042,
      NULL,
      5.429553,
      6.715806,
      2,
      7.292779,
      NULL,
      2,
      5.395205,
      1,
      2.957998,
      0.432180,
      3,
      5.926225,
      2.881680,
      5.801349,
      8,
      9.882757,
      NULL,
      7,
      8.022701,
      0.344416,
      5,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113631,
      1.677520,
      1.695726,
      NULL,
      0.555844,
      1.402693,
      1.858489,
      NULL,
      1.383575,
      NULL,
      NULL,
      0,
      NULL,
      1.163499,
      1,
      1.522765,
      1.782250,
      NULL,
      0.593283,
      NULL,
      1.657239,
      NULL,
      0.606185,
      1,
      1.648784,
      0.663660,
      NULL,
      0,
      1,
      0,
      1.456634,
      0.001505,
      NULL,
      1.065323,
      1,
      1,
      0,
      0.651633,
      1.269195,
      0.380023,
      0.624813,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.151406,
      1.778425,
      1.962066,
      NULL,
      0.544320,
      NULL,
      0.320489,
      0,
      1,
      1,
      0.549914,
      1,
      NULL,
      1.246719,
      1.234817,
      1,
      1.941481,
      1.685470,
      0.020100,
      0.357391,
      1.097754,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1.347164,
      1,
      1.997968,
      1.245153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.274642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      2,
      NULL,
      4,
      NULL,
      5,
      2,
      1,
      2,
      3,
      3,
      4,
      2,
      3,
      NULL,
      5,
      3,
      1,
      NULL,
      4,
      NULL,
      0,
      2,
      2,
      0,
      2,
      2,
      1,
      2,
      3,
      1,
      4,
      3,
      NULL,
      2,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-13-2003',
      ' 2-19-1997',
      ' 4-10-1988',
      ' 3- 6-1995',
      ' 5- 2-1979',
      ' 7- 2-1976',
      ' 5- 0-1998',
      NULL,
      ' 3-17-1995',
      ' 6-27-1979',
      ' 7-26-1983',
      NULL,
      ' 9- 0-2001',
      NULL,
      '11-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


