set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '4113414',
      3,
      1.155787,
      1,
      NULL,
      2,
      NULL,
      38.531268,
      NULL,
      0,
      1,
      3.887961,
      0.635881,
      0,
      3.964139,
      NULL,
      2,
      1,
      1.327230,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      6,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      1.325208,
      0,
      NULL,
      NULL,
      0,
      1.075071,
      4,
      5,
      5,
      0.379954,
      NULL,
      0,
      0,
      1,
      10,
      ' 5- 1-1978',
      17.025795,
      1.192164,
      NULL,
      1,
      3,
      0,
      4.391775,
      3,
      66.520294,
      980,
      46.460623,
      NULL,
      2.782625,
      119,
      0.264251,
      2,
      3,
      285,
      18,
      3,
      NULL,
      NULL,
      20.660190,
      1.604664,
      3,
      74.356898,
      12,
      3,
      2,
      397,
      148.313550,
      0,
      3.835394,
      160.895302,
      40.529028,
      0.484323,
      2,
      131.207290,
      30.864174,
      1.417589,
      NULL,
      131,
      68,
      0.459989,
      NULL,
      151,
      5.506539,
      2,
      2.357542,
      76,
      50.726416,
      2.242075,
      2,
      11,
      71,
      1,
      9.137634,
      NULL,
      54,
      NULL,
      3.954404,
      195,
      49,
      NULL,
      6,
      234.496041,
      39.482566,
      NULL,
      8,
      79.978363,
      22,
      1.858649,
      2.934310,
      369,
      72.926634,
      3,
      9.785720,
      103.962655,
      41.655418,
      3.216767,
      1,
      336,
      616,
      1.629048,
      6,
      249,
      5,
      3.815298,
      3.201498,
      386,
      2.275745,
      1,
      8.556949,
      287,
      5.522494,
      1.216448,
      2,
      212,
      141,
      NULL,
      3.839687,
      80.236855,
      57,
      0.455663,
      0,
      115.697754,
      110.847298,
      3,
      2,
      327.789971,
      2226.965197,
      NULL,
      8.246451,
      NULL,
      79,
      1.650559,
      3,
      NULL,
      25,
      2.824274,
      1,
      78.137806,
      962,
      1,
      0,
      1164,
      410,
      NULL,
      NULL,
      147,
      NULL,
      NULL,
      4.303600,
      NULL,
      99,
      0.417733,
      1.547168,
      NULL,
      660.781936,
      1,
      7,
      55.594920,
      417.371625,
      1,
      3.436018,
      17.458085,
      NULL,
      1.167362,
      3,
      194,
      NULL,
      0.411532,
      4.427830,
      42,
      NULL,
      2,
      3,
      208,
      193.508253,
      3,
      2,
      88.395189,
      NULL,
      1,
      6.104946,
      146.206660,
      311,
      1.292414,
      2,
      161.746571,
      337,
      NULL,
      0.473167,
      10,
      102.194559,
      1,
      3,
      143.054293,
      236.330564,
      2.428923,
      4.538473,
      NULL,
      211,
      3.138206,
      3,
      141.226981,
      273.917094,
      3,
      6.736382,
      72.822578,
      232,
      NULL,
      7,
      211.078647,
      370,
      2,
      NULL,
      170,
      633,
      NULL,
      7.607316,
      140,
      164,
      0,
      2,
      395,
      16.912018,
      0.138929,
      0,
      416,
      19.728345,
      1.766307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      '33022',
      '33114',
      '12230',
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '24300',
      NULL,
      '',
      0,
      8,
      31,
      0.172752,
      393,
      0.999326,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.789794,
      NULL,
      0.511096,
      NULL,
      0.070249,
      NULL,
      ' 5-21-1994',
      0,
      NULL,
      5,
      3,
      NULL,
      10,
      3,
      9,
      3.262021,
      NULL,
      NULL,
      NULL,
      3.507806,
      10.266372,
      11,
      NULL,
      6.570955,
      13,
      17.817088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      19.728202,
      1,
      2.507969,
      27,
      21.668170,
      10.113502,
      12,
      NULL,
      14,
      13.365043,
      17,
      2.978097,
      5.003735,
      8,
      NULL,
      28.748326,
      43.596042,
      15.937504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      153.812449,
      153.907341,
      60,
      54,
      110.751633,
      36.338676,
      86.866128,
      78.376691,
      132.334450,
      146.449340,
      68.263635,
      146,
      NULL,
      135.872530,
      24,
      27,
      NULL,
      49,
      136.550174,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.077056,
      1,
      4.371736,
      NULL,
      3,
      1.082292,
      3,
      NULL,
      5.311510,
      2.878664,
      0,
      3,
      7,
      2,
      1,
      9.580263,
      4.316817,
      2.825065,
      4.529883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.532300,
      3.949769,
      1.267167,
      NULL,
      0.809950,
      NULL,
      NULL,
      4,
      8,
      2.718638,
      3,
      7.575014,
      3,
      6.899653,
      2,
      NULL,
      3.974543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.659223,
      NULL,
      NULL,
      0.683004,
      8.621781,
      3.884963,
      NULL,
      1.709499,
      4.053905,
      11.997910,
      8.437453,
      2,
      7.928682,
      NULL,
      2,
      7,
      5.608770,
      7,
      3.440749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522476,
      2,
      2,
      NULL,
      2.273824,
      1.363374,
      0,
      5.491216,
      2,
      NULL,
      4,
      1,
      9,
      NULL,
      0,
      2.727715,
      NULL,
      5.981069,
      11.255512,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.096564,
      5.066781,
      1.765005,
      5,
      3,
      0,
      NULL,
      3.982930,
      2,
      7.651572,
      1,
      0.016746,
      NULL,
      NULL,
      0,
      0.830272,
      7,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.219991,
      0,
      4,
      3.641187,
      5,
      NULL,
      3.668845,
      NULL,
      1,
      7,
      2.527375,
      NULL,
      2.284108,
      3.520128,
      4,
      5.434092,
      8,
      0.795863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.519274,
      1,
      1,
      1,
      0,
      0,
      6.485826,
      5.721472,
      8,
      8,
      5,
      NULL,
      0,
      4,
      7.603638,
      2,
      2.912320,
      8.256749,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.075015,
      NULL,
      0.329337,
      5.945470,
      0.114470,
      9.823683,
      5,
      9.741562,
      8.430950,
      NULL,
      1.852777,
      NULL,
      7,
      2.110173,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233087,
      NULL,
      5.430352,
      NULL,
      3.862212,
      0.121266,
      2,
      1.667658,
      0,
      9.776883,
      1.941119,
      8.759944,
      7.279344,
      5.081823,
      7,
      NULL,
      NULL,
      5.960644,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.867557,
      3.090189,
      0.237626,
      7.406761,
      0.401923,
      3,
      0.878279,
      NULL,
      NULL,
      5.308470,
      7,
      5.630594,
      6,
      1.738518,
      1.062638,
      3.581894,
      9.362682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.545778,
      NULL,
      1.033159,
      NULL,
      0,
      0.788541,
      0,
      2.505429,
      3,
      0,
      NULL,
      0,
      0.660077,
      0.207073,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.206173,
      5.628369,
      0.901377,
      NULL,
      NULL,
      0.519520,
      1,
      3,
      2,
      1.413560,
      NULL,
      1.406336,
      0,
      NULL,
      0.850314,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.054846,
      NULL,
      2,
      1.015182,
      0,
      NULL,
      3.343830,
      2.464643,
      1.143937,
      7,
      1,
      1,
      NULL,
      NULL,
      1.356531,
      NULL,
      0.268930,
      0.198113,
      1.334775,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      8,
      3,
      2,
      3,
      3.899703,
      NULL,
      7.922027,
      6.576884,
      0,
      3,
      7,
      7,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.679800,
      6,
      3.293530,
      2,
      5,
      5.033810,
      3,
      0,
      4.022586,
      7.037114,
      4,
      2,
      7.061166,
      NULL,
      2.913118,
      4,
      1,
      3.086042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.327969,
      1,
      1.004309,
      0.581811,
      0,
      1,
      NULL,
      1,
      1,
      1.779901,
      NULL,
      NULL,
      1.421563,
      0.633614,
      1,
      0.436384,
      0.530299,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.697937,
      4,
      0.337096,
      5,
      0.768724,
      NULL,
      1.280450,
      1.287735,
      0,
      1,
      0.109228,
      1.113537,
      0,
      1,
      1,
      0,
      1,
      0,
      1.098936,
      0.004877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4,
      0,
      2,
      0,
      2,
      2,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      3,
      1,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      1,
      5,
      0,
      3,
      2,
      3,
      2,
      2,
      1,
      0,
      2,
      3,
      4,
      2,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1975',
      ' 9-20-1982',
      ' 8-29-1992',
      NULL,
      NULL,
      ' 7- 4-1997',
      NULL,
      ' 6-10-1991',
      ' 2- 7-1984',
      '11- 6-1998',
      NULL,
      ' 0-20-1996',
      ' 8-10-1997',
      ' 9- 0-1990',
      ' 8-27-1997',
      ' 9-24-1992',
      ' 7-26-1993',
      ' 6- 5-2000',
      ' 8-21-2001',
      ' 6-14-1999',
      ' 8-23-1996',
      ' 2-15-1992',
      NULL,
      ' 2- 1-1981',
      ' 1-17-1974',
      ' 4- 3-1977',
      NULL,
      ' 1-27-1995',
      ' 3- 3-1976',
      NULL,
      '10-27-1989',
      NULL,
      ' 1-28-1989',
      ' 3- 2-1984',
      NULL,
      ' 0-13-2001',
      ' 5-26-1987',
      ' 3- 8-1988',
      ' 6-23-1987',
      ' 8- 4-2003',
      NULL,
      ' 1-25-1984',
      ' 7-18-1984',
      ' 5- 6-1987',
      ' 7- 9-1996',
      ' 4- 9-1982',
      ' 9-16-1979',
      ' 8-20-2002',
      ' 3-21-1996',
      ' 8- 4-2001',
      '10-10-1989',
      ' 5-28-1974',
      ' 5-22-1974',
      ' 5- 7-1979',
      NULL,
      NULL,
      ' 3-20-1975',
      NULL,
      '11-16-1995',
      ' 2-15-1975',
      '10- 8-1974',
      '10- 6-1991',
      NULL,
      NULL,
      ' 3- 0-1992',
      NULL,
      ' 8-19-1994',
      ' 6-18-1998',
      ' 9-16-2003',
      ' 0-10-1993',
      ' 4-27-2003',
      ' 7-29-1996',
      NULL,
      ' 5-22-1986',
      ' 9- 5-1992',
      ' 7-11-1997',
      NULL,
      ' 6-19-1974',
      ' 6- 4-1984',
      ' 4-27-2003',
      ' 8-21-1979',
      NULL,
      ' 1- 1-1988',
      ' 8-22-1990',
      ' 6-25-1991',
      NULL,
      ' 7- 2-1985',
      NULL,
      NULL,
      NULL,
      ' 7-15-1998',
      ' 8- 8-1996',
      ' 2-21-1998',
      ' 2-10-1977',
      NULL,
      ' 9-19-1995',
      ' 7- 9-1989',
      NULL,
      NULL,
      ' 9-17-1992',
      ' 7-17-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 0-2000',
      '11- 5-1985',
      ' 8-10-1984',
      '10-10-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892366);
commit;
end;
/


