set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.363268,
      NULL,
      1.523615,
      NULL,
      NULL,
      1,
      1.864366,
      2.869666,
      1,
      3.188675,
      2,
      1.984789,
      0.554529,
      9,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.778331,
      0.942458,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      9.501897,
      6,
      NULL,
      2,
      NULL,
      0.612364,
      0,
      1.913097,
      NULL,
      3,
      NULL,
      1,
      1.024819,
      9,
      5.990108,
      4,
      0.004423,
      6,
      1.159720,
      0.204666,
      NULL,
      NULL,
      NULL,
      NULL,
      2.798613,
      3,
      1,
      NULL,
      2,
      5.377785,
      3,
      28.689828,
      52,
      3852.166306,
      NULL,
      10,
      39.661699,
      1.171289,
      0,
      0,
      41.963707,
      19796.617183,
      2,
      1,
      234,
      18,
      2.361588,
      NULL,
      145,
      39,
      NULL,
      3,
      155,
      NULL,
      1,
      6,
      79,
      23,
      0,
      NULL,
      218,
      278,
      2,
      1,
      56,
      389.623793,
      NULL,
      2.270359,
      214.783135,
      NULL,
      0,
      4,
      19,
      NULL,
      5,
      1,
      976,
      NULL,
      1.994270,
      1,
      173.482836,
      NULL,
      2.276138,
      0.543674,
      749,
      9155.828901,
      0,
      NULL,
      465,
      4114,
      0.499159,
      1,
      239,
      8,
      1,
      NULL,
      230,
      8,
      NULL,
      0,
      NULL,
      71,
      0,
      2,
      255,
      NULL,
      2,
      1.201081,
      268,
      NULL,
      1.940681,
      3.638875,
      203,
      100.977317,
      2,
      0.220663,
      32.200211,
      NULL,
      NULL,
      1,
      122,
      40,
      2.394297,
      3.951346,
      66,
      NULL,
      1.073464,
      3,
      159,
      78,
      2.938588,
      5.120176,
      NULL,
      89.762795,
      NULL,
      3.395951,
      54,
      NULL,
      2,
      1,
      NULL,
      84,
      1,
      4.844612,
      NULL,
      55,
      NULL,
      5.514187,
      210.602834,
      150,
      2,
      4.794371,
      NULL,
      41.593061,
      1.695991,
      1.584989,
      85,
      101.126213,
      2.581177,
      NULL,
      876,
      1.209066,
      NULL,
      1,
      205.554690,
      23,
      3.285244,
      NULL,
      NULL,
      2576,
      NULL,
      0.097147,
      NULL,
      8,
      3.282540,
      3,
      127.114784,
      1315,
      NULL,
      2.237227,
      820,
      3.310799,
      3.706019,
      0,
      70,
      14,
      2,
      7.737548,
      NULL,
      32,
      3,
      NULL,
      6.409163,
      NULL,
      2,
      NULL,
      NULL,
      97,
      2,
      2,
      194,
      210.641688,
      1.472068,
      NULL,
      176,
      52.803568,
      0.695681,
      7,
      NULL,
      361.125877,
      0.512684,
      NULL,
      NULL,
      260.341300,
      0.681864,
      3,
      152.830931,
      199,
      2.296035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9.863067,
      '32312',
      '32234',
      '24131',
      NULL,
      '24311',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '2140',
      '34233',
      '',
      5,
      NULL,
      NULL,
      2.806815,
      250,
      0,
      NULL,
      1.702810,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      472.966411,
      0.513682,
      NULL,
      2,
      432.850841,
      0,
      NULL,
      ' 2-21-1977',
      NULL,
      NULL,
      7.290812,
      5,
      0.112357,
      13,
      6.854176,
      5,
      14,
      3.697623,
      0.427065,
      NULL,
      5.877953,
      3,
      9.739446,
      21.704575,
      24.459992,
      19.504085,
      4.162312,
      NULL,
      16.459934,
      NULL,
      9,
      11.212059,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.741802,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      32.559323,
      8,
      32,
      52,
      11,
      29,
      30.853830,
      7,
      22,
      3,
      NULL,
      NULL,
      17.230742,
      NULL,
      NULL,
      22.519047,
      NULL,
      28,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      131.286205,
      47.368947,
      7.419629,
      NULL,
      120.706787,
      134.800664,
      87.081175,
      35.781204,
      NULL,
      NULL,
      161,
      57.196929,
      NULL,
      NULL,
      64.246442,
      137,
      57,
      107,
      152.938059,
      NULL,
      170.870444,
      NULL,
      65.413693,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.129459,
      4.057768,
      8,
      1.279614,
      11,
      3.552396,
      0.029559,
      2.076616,
      7.304081,
      7.991475,
      NULL,
      4.599183,
      2.762579,
      NULL,
      9,
      6,
      1.979616,
      1,
      5.337788,
      NULL,
      7.035998,
      6.473668,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833400,
      2.378007,
      6,
      9,
      6.715038,
      3,
      NULL,
      9.349835,
      8.907977,
      NULL,
      5.990937,
      4,
      4,
      6,
      5,
      8,
      3,
      NULL,
      2,
      NULL,
      3.711059,
      NULL,
      7,
      6,
      1.573087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.376662,
      NULL,
      1,
      1.389317,
      1,
      0,
      1.053443,
      0,
      NULL,
      NULL,
      1.514624,
      1,
      1,
      0,
      1,
      0,
      0,
      0.894993,
      0,
      NULL,
      1.769415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739988,
      1.115176,
      1.506290,
      NULL,
      NULL,
      NULL,
      6.475045,
      5,
      0,
      3,
      0.574248,
      2.957112,
      NULL,
      2.604689,
      1.092639,
      2.685699,
      0.728190,
      0.533176,
      3,
      1,
      3.878847,
      5,
      NULL,
      NULL,
      5.267224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      6,
      3,
      7,
      6,
      1.201827,
      2,
      5.953486,
      6,
      1.834757,
      NULL,
      NULL,
      7.355608,
      3,
      3,
      3,
      5,
      2.546097,
      1,
      3,
      4,
      NULL,
      1.876674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      5,
      6,
      NULL,
      4.683394,
      5.445686,
      3,
      4,
      9,
      5.973319,
      8,
      NULL,
      3,
      5.171911,
      0.631661,
      7,
      3,
      5,
      NULL,
      1.355956,
      6.463996,
      3.677855,
      0.875686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.014210,
      6,
      2.248828,
      4,
      3.590328,
      NULL,
      NULL,
      5.118950,
      11.646721,
      7.276480,
      3,
      1,
      1,
      7.241085,
      2.192509,
      5.838764,
      NULL,
      0,
      4.934118,
      5,
      2.447192,
      5,
      4.499672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.917359,
      NULL,
      NULL,
      6,
      NULL,
      5.551909,
      6,
      5.689793,
      0.362100,
      5,
      0,
      6.002675,
      NULL,
      NULL,
      6.509573,
      NULL,
      3.743617,
      2,
      7,
      3,
      7,
      4.109696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805998,
      NULL,
      2.749042,
      NULL,
      4.876407,
      4.386463,
      1,
      6,
      6.671964,
      0.910140,
      0,
      1,
      9,
      5,
      7.511450,
      2,
      2,
      4,
      6.617015,
      7,
      2,
      7,
      1,
      NULL,
      0.315117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.598785,
      4.529253,
      7.056069,
      1,
      2,
      NULL,
      6.545663,
      2.481428,
      3.510653,
      1,
      2.722214,
      NULL,
      5,
      0.468677,
      7.804632,
      4.248879,
      5,
      0.528188,
      0,
      NULL,
      3.886412,
      6.625104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755762,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      1.847660,
      2,
      0.149100,
      2.943259,
      0,
      1,
      1,
      3.694688,
      1,
      NULL,
      NULL,
      2.814409,
      1.901743,
      2.616824,
      0.511356,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.462708,
      1.900992,
      NULL,
      1,
      NULL,
      NULL,
      1.650915,
      0.404880,
      1,
      1,
      0,
      1,
      2,
      NULL,
      3,
      0.005499,
      0.438465,
      1,
      0,
      1,
      1,
      2.038100,
      0.208347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295527,
      0,
      1,
      1,
      0,
      1.204292,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.929895,
      1.562707,
      0,
      1.312766,
      0.921417,
      0.601677,
      NULL,
      1.372746,
      0.491600,
      NULL,
      0.883178,
      1.342465,
      0.152428,
      1.755931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4,
      NULL,
      5,
      5,
      8.007012,
      0,
      7,
      1,
      NULL,
      5.183807,
      8.283108,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      3.336690,
      3.225373,
      6.088017,
      8,
      3.543941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620554,
      1,
      5.967541,
      1,
      1,
      NULL,
      9.899165,
      5.275205,
      5,
      3.050384,
      9.661432,
      3.523195,
      NULL,
      6.917286,
      6,
      NULL,
      3.506497,
      7,
      4.313782,
      2,
      7.576269,
      7,
      3.859276,
      0.652886,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.096544,
      0,
      0.903838,
      NULL,
      1.306699,
      0.897227,
      NULL,
      0.029134,
      0,
      1,
      1.148347,
      0.585015,
      0.504054,
      1.921142,
      0,
      NULL,
      0.232397,
      1.011527,
      1,
      1,
      0,
      1.590510,
      0.780558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.429480,
      0.672878,
      0.015775,
      1,
      0.191659,
      0,
      1.875696,
      1.179293,
      NULL,
      0.433958,
      NULL,
      1,
      1,
      0.487543,
      0,
      NULL,
      0.959902,
      0.970492,
      1,
      0,
      1,
      0,
      0.207272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      6,
      1,
      6,
      0,
      2,
      0,
      3,
      0,
      1,
      NULL,
      3,
      1,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      4,
      1,
      6,
      0,
      2,
      0,
      7,
      0,
      2,
      0,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-13-1977',
      NULL,
      ' 6-23-1987',
      NULL,
      ' 9-10-1992',
      NULL,
      ' 9- 1-1997',
      ' 1-20-1983',
      NULL,
      NULL,
      ' 9-27-1974',
      '11-24-1975',
      NULL,
      ' 4-17-1981',
      ' 9- 7-1982',
      ' 0- 1-2000',
      NULL,
      NULL,
      ' 1-10-1989',
      ' 4-21-1991',
      ' 9-24-1995',
      ' 2- 1-1997',
      ' 9- 7-1977',
      ' 3- 4-2003',
      NULL,
      '11- 4-1995',
      NULL,
      ' 3-21-2003',
      NULL,
      ' 5- 8-1980',
      ' 7-20-1999',
      ' 4-23-1988',
      '10-20-1983',
      NULL,
      ' 4- 0-1987',
      ' 1-28-1978',
      ' 4-18-2003',
      '11- 3-1998',
      '11-17-1975',
      ' 7-27-1998',
      ' 3-15-1991',
      NULL,
      ' 2-13-1986',
      ' 2- 7-1977',
      ' 0-13-1985',
      ' 2-22-1987',
      ' 5-14-1993',
      '11-20-1975',
      ' 4-18-1989',
      NULL,
      ' 9-26-1977',
      ' 4-20-1989',
      NULL,
      '11-20-1985',
      '10-15-1983',
      ' 1- 4-1993',
      ' 2-29-2003',
      NULL,
      ' 1-17-1981',
      ' 7- 0-1997',
      ' 0-26-1993',
      NULL,
      NULL,
      '10- 1-1989',
      NULL,
      NULL,
      ' 0-15-1980',
      NULL,
      NULL,
      '11- 3-1982',
      ' 4- 9-1987',
      '11- 4-1979',
      ' 8-24-1990',
      ' 6-21-1995',
      ' 7-14-1977',
      ' 5-27-1979',
      NULL,
      NULL,
      ' 8-13-1974',
      ' 8-28-2001',
      ' 7- 9-1990',
      ' 6-18-1977',
      NULL,
      ' 6-26-1996',
      NULL,
      '10-11-1997',
      ' 7- 0-1998',
      ' 9- 3-1984',
      ' 4- 9-1996',
      ' 2- 8-1991',
      NULL,
      ' 8- 0-1989',
      ' 1-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1994',
      NULL,
      NULL,
      NULL,
      '11-11-1997',
      NULL,
      ' 0-15-2000',
      ' 6-11-1998',
      '10-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228424);
commit;
end;
/


