set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0108712';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      NULL,
      76,
      12,
      '4143214',
      NULL,
      2,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.706584,
      0,
      1.165168,
      1,
      1.979869,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0.970277,
      1,
      5,
      0,
      3.075108,
      NULL,
      4.618444,
      2,
      1.349280,
      2,
      NULL,
      NULL,
      0,
      1,
      7,
      2,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      5,
      3,
      7,
      1.231017,
      7,
      NULL,
      1,
      0,
      0,
      3,
      4,
      NULL,
      0.985799,
      0,
      2,
      5.237937,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.003148,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      8.223227,
      857.653030,
      1,
      1.458014,
      NULL,
      126,
      0.373913,
      3.040907,
      3.651759,
      227.117795,
      8.244331,
      3,
      NULL,
      NULL,
      NULL,
      2,
      3.597768,
      NULL,
      3,
      1.633149,
      0,
      56.544081,
      107.895597,
      1,
      NULL,
      41,
      43,
      NULL,
      NULL,
      20,
      98,
      2,
      3,
      214.248654,
      127.964402,
      0,
      0.572942,
      133,
      3.888849,
      1.193679,
      0,
      78.954230,
      37.976520,
      2.178599,
      2,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.378333,
      '21234',
      '00023',
      '44420',
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.885291,
      '',
      '',
      '',
      NULL,
      0.297216,
      180.206197,
      0,
      NULL,
      1.591393,
      NULL,
      0.388024,
      NULL,
      2.512667,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.482827,
      NULL,
      2.312738,
      39.759654,
      ' 2-23-1986',
      NULL,
      NULL,
      1.315294,
      NULL,
      5.316563,
      2,
      15,
      10.607904,
      3,
      NULL,
      0.459288,
      9,
      NULL,
      9,
      2.225819,
      8,
      13.523988,
      2,
      NULL,
      8.629341,
      3.057063,
      NULL,
      15,
      NULL,
      2,
      2.249804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.514934,
      6,
      56.180270,
      2.297697,
      12,
      36,
      6.548109,
      2.767022,
      8.324412,
      11,
      NULL,
      22.818833,
      NULL,
      21.587515,
      2.176933,
      18.127936,
      19.377436,
      NULL,
      20.916412,
      NULL,
      NULL,
      20.687549,
      13.220193,
      14,
      NULL,
      16.863446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      115,
      185,
      139,
      149.485766,
      146.268901,
      171,
      162.036850,
      NULL,
      1,
      NULL,
      2.950591,
      3,
      5.149070,
      2.559982,
      0,
      4,
      NULL,
      1,
      4.144132,
      3,
      NULL,
      3,
      5.558416,
      NULL,
      2.508958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.996572,
      3,
      NULL,
      6,
      2,
      4,
      6,
      8.163804,
      2,
      9,
      7.156890,
      NULL,
      2,
      NULL,
      3.627295,
      0.725018,
      2.884686,
      3,
      6.995762,
      6,
      1.942435,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914019,
      1,
      NULL,
      0,
      NULL,
      1.497493,
      4.937544,
      1,
      4,
      4,
      5,
      0.770415,
      4.768299,
      2.123733,
      5,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      0.295125,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916246,
      0,
      0.845352,
      2,
      2.278664,
      0.574091,
      NULL,
      2,
      4.509962,
      NULL,
      7.644153,
      5.472541,
      3,
      1.323592,
      0.348634,
      0,
      0,
      1.891537,
      NULL,
      2,
      3.078261,
      4,
      0,
      1.385782,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002503,
      4.276028,
      NULL,
      1.176472,
      5.804958,
      4,
      2.780524,
      5.233354,
      3.937187,
      1,
      0,
      3.793617,
      0,
      0,
      4,
      2.795929,
      1.907397,
      0,
      0.232021,
      6,
      4,
      3,
      1,
      5.330306,
      3,
      1.375126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.392393,
      1,
      4.723372,
      1.536392,
      3,
      NULL,
      3,
      0.929742,
      0,
      0.407714,
      NULL,
      2,
      1,
      1.574669,
      1.826175,
      1.982066,
      3,
      1.114927,
      1.787150,
      1,
      0.118854,
      1.335984,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934922,
      NULL,
      NULL,
      9,
      NULL,
      5.381165,
      9,
      9,
      9,
      NULL,
      3.201269,
      5.047318,
      0,
      NULL,
      NULL,
      2.061614,
      2.848613,
      4,
      9,
      6.833684,
      8.706645,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079741,
      0.459633,
      6.540682,
      NULL,
      1.522457,
      7,
      NULL,
      9.387485,
      1,
      1,
      7.904334,
      4,
      8,
      7,
      NULL,
      6,
      7,
      4,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      4.049926,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440857,
      NULL,
      5,
      5,
      3.656094,
      0.210449,
      2,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      2.072287,
      3,
      0,
      1.642815,
      NULL,
      3,
      2,
      0.455816,
      1.827917,
      1.556757,
      0,
      0.106451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      4.707309,
      5.026632,
      3.258755,
      0.200646,
      2.505501,
      3.226502,
      NULL,
      2.772708,
      4.274473,
      NULL,
      1,
      2,
      4.004320,
      1,
      5.124150,
      2,
      1.943990,
      1.711577,
      NULL,
      1,
      1.869301,
      5.297368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.443287,
      0,
      0.103868,
      0.896169,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      0.582348,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.725396,
      NULL,
      0.741990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660674,
      0,
      NULL,
      1,
      3,
      NULL,
      0.030295,
      0,
      NULL,
      1.770269,
      0.664401,
      0.427748,
      0.154636,
      NULL,
      NULL,
      1.267081,
      0,
      1.216577,
      0.953930,
      3.366391,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128032,
      3,
      5,
      3.782331,
      2.416920,
      NULL,
      0.200453,
      NULL,
      0,
      0.067950,
      1.921389,
      1.497756,
      2.941705,
      4.041422,
      1,
      NULL,
      NULL,
      1,
      0.316375,
      1,
      NULL,
      0.876502,
      1.493934,
      0.493627,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136780,
      4,
      NULL,
      2.580276,
      3,
      0.177368,
      0.841770,
      NULL,
      0,
      3,
      0.759903,
      2,
      5.933164,
      2.790720,
      2.151522,
      0.093980,
      0.836895,
      0,
      1,
      0.692480,
      1,
      0.705456,
      NULL,
      5.491109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      2.791647,
      0.390665,
      0,
      7.817613,
      NULL,
      NULL,
      NULL,
      2.981531,
      4.590980,
      NULL,
      5,
      5,
      7,
      NULL,
      NULL,
      0.366908,
      3.126202,
      4,
      NULL,
      0.007261,
      1,
      3.705300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5.391129,
      1,
      4.436861,
      9,
      2,
      NULL,
      NULL,
      6.935689,
      NULL,
      5,
      4.132679,
      9.936561,
      1,
      3.330743,
      NULL,
      NULL,
      0,
      0.457840,
      4,
      8.544641,
      1.062070,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      1.158209,
      NULL,
      2.268803,
      1.049428,
      0.322741,
      0.964560,
      1,
      NULL,
      1.806632,
      0,
      0.902290,
      0.532759,
      0.108216,
      0.861587,
      1.480361,
      NULL,
      NULL,
      NULL,
      1,
      0.715304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.552593,
      NULL,
      2,
      1.699590,
      0,
      NULL,
      NULL,
      0,
      1.693436,
      2.789005,
      NULL,
      7,
      0,
      NULL,
      0.411723,
      1.778530,
      1,
      1.063244,
      NULL,
      1.552494,
      NULL,
      NULL,
      1,
      1.439793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1,
      1,
      5,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      7,
      1,
      1,
      0,
      NULL,
      1,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      7,
      0,
      1,
      NULL,
      2,
      3,
      NULL,
      3,
      3,
      2,
      3,
      0,
      1,
      1,
      2,
      1,
      4,
      1,
      3,
      1,
      2,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-1977',
      NULL,
      ' 4-19-1983',
      ' 7- 9-2003',
      ' 3-28-1988',
      ' 3-13-2000',
      '11-24-1976',
      NULL,
      ' 4-18-1978',
      ' 0-11-1996',
      ' 5- 0-2001',
      NULL,
      NULL,
      ' 7- 2-1976',
      ' 7-19-1990',
      ' 0- 5-1999',
      ' 1- 3-1989',
      NULL,
      ' 8- 8-1980',
      NULL,
      ' 9-15-1977',
      NULL,
      ' 2-10-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


