set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8807476';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '0421043',
      NULL,
      0,
      NULL,
      '43132',
      0,
      ' 5-24-1991',
      15.618127,
      NULL,
      1.521130,
      2,
      3,
      1.020663,
      0,
      2.733843,
      0.338487,
      0.468796,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.171472,
      0.687050,
      1,
      4.763411,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      0,
      4,
      2,
      0,
      0,
      NULL,
      1,
      9,
      NULL,
      0,
      1,
      3,
      0,
      1,
      0,
      0.540371,
      1,
      4,
      4,
      1.816101,
      0,
      8,
      7.710319,
      4,
      2,
      4,
      7.210568,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.756315,
      4,
      4,
      NULL,
      6,
      2.618320,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1748.530976,
      1,
      4,
      193.250335,
      13184,
      2,
      NULL,
      170.589487,
      15798,
      3.326404,
      0,
      149,
      NULL,
      1,
      3,
      301.164013,
      NULL,
      NULL,
      NULL,
      850.887948,
      19605.644346,
      NULL,
      4,
      NULL,
      67.858062,
      1,
      2,
      132,
      8064.141768,
      1.932453,
      3,
      73,
      6,
      NULL,
      3,
      211,
      20.712984,
      2.882354,
      2,
      213,
      2.571786,
      0,
      3,
      98,
      NULL,
      NULL,
      3,
      NULL,
      136.772074,
      1.571641,
      0.677156,
      NULL,
      11138,
      0,
      3.903355,
      83,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2,
      176.650507,
      NULL,
      3.580481,
      3,
      107.087073,
      NULL,
      NULL,
      4.601424,
      12,
      23,
      0.632905,
      0.465040,
      66.754125,
      196,
      2,
      2.115341,
      2.453237,
      39.114374,
      2,
      4.501522,
      NULL,
      83,
      3,
      NULL,
      135,
      NULL,
      1.499024,
      NULL,
      NULL,
      147.264884,
      NULL,
      6,
      NULL,
      351,
      NULL,
      6.237593,
      152,
      250.746631,
      1.397750,
      0,
      49,
      182.655436,
      0.467138,
      0,
      NULL,
      2732,
      1.245798,
      0,
      457.545111,
      15960.397602,
      1,
      2.493607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '21243',
      '40244',
      '34302',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      3,
      '34113',
      '1034',
      '3320',
      4,
      1.708794,
      NULL,
      3,
      56.789528,
      0.010621,
      NULL,
      1.282754,
      NULL,
      0,
      NULL,
      0.471527,
      NULL,
      3.583180,
      276.572141,
      0.710143,
      NULL,
      1.687693,
      435,
      1.841576,
      NULL,
      NULL,
      0.367267,
      3.005296,
      1.838954,
      4.793676,
      4.115214,
      NULL,
      NULL,
      3,
      2,
      12,
      5,
      14.429009,
      2.208487,
      6,
      0.835127,
      23,
      5.986595,
      0,
      10.638910,
      10.879240,
      4,
      8.967446,
      11,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.070695,
      3.770375,
      16,
      3,
      1.240006,
      1.930325,
      6,
      3.976938,
      2,
      3,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3.866030,
      31.059947,
      3.076537,
      10,
      10.345398,
      8.673756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      125,
      136.104925,
      123.569537,
      131.899864,
      17.713264,
      NULL,
      115.646504,
      101,
      129,
      11.577111,
      100.748609,
      NULL,
      NULL,
      50,
      NULL,
      NULL,
      NULL,
      49.808267,
      NULL,
      23,
      144,
      119.275543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.442250,
      6.434144,
      7.229731,
      2,
      NULL,
      4.898531,
      7,
      NULL,
      NULL,
      2.584059,
      7,
      6.082338,
      0.139510,
      0.616721,
      NULL,
      2.141092,
      0.103461,
      5.676192,
      9.552345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.689564,
      NULL,
      2.536211,
      NULL,
      5,
      9,
      2,
      6,
      NULL,
      4,
      5,
      6,
      3,
      7,
      NULL,
      6,
      4.739606,
      9.414733,
      7,
      8.835561,
      5,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11,
      2,
      4.707611,
      3.240686,
      5,
      2,
      0,
      1.024356,
      5,
      2.902658,
      4.620905,
      3,
      1,
      0.001431,
      1,
      2.167643,
      5.852767,
      1,
      NULL,
      5.704139,
      3,
      1.359194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      4.199879,
      0,
      4,
      NULL,
      NULL,
      1,
      5.388475,
      1,
      NULL,
      0,
      2,
      0,
      2.280784,
      NULL,
      1.156467,
      NULL,
      1.970511,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824962,
      0,
      5,
      0.725395,
      4.014410,
      NULL,
      5.840502,
      2.657846,
      NULL,
      5.730478,
      NULL,
      NULL,
      7,
      NULL,
      5.137646,
      6,
      6,
      1.032535,
      5.213849,
      7.516649,
      2.563015,
      8.699155,
      3.334533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.334873,
      8,
      2,
      7.806504,
      NULL,
      6,
      7,
      1.948371,
      6,
      11.620941,
      7.492787,
      5,
      0.942183,
      NULL,
      NULL,
      5,
      5,
      7,
      0,
      8,
      4.923687,
      3.903716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      9,
      6.101289,
      8,
      1.925555,
      7,
      NULL,
      3,
      5,
      0.381192,
      0.619095,
      NULL,
      7.577109,
      NULL,
      8,
      6.539778,
      1.792844,
      10,
      5.443083,
      8.095863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.602253,
      6.591692,
      7,
      3.144653,
      4.498477,
      4,
      NULL,
      2.833974,
      1.918258,
      NULL,
      3.143410,
      5,
      NULL,
      NULL,
      NULL,
      2.620701,
      3.128844,
      5,
      2.646311,
      0.146892,
      7.128008,
      5.499326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      3.371203,
      NULL,
      8.029974,
      0,
      5.354850,
      2,
      9,
      0.276724,
      1.363971,
      5.979794,
      5.252680,
      NULL,
      5.995037,
      NULL,
      NULL,
      2.949068,
      NULL,
      8,
      3.604999,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918844,
      6,
      NULL,
      3,
      2,
      4.554947,
      NULL,
      1,
      0.636143,
      0.213631,
      1.899465,
      1.741654,
      2,
      2.945673,
      2,
      NULL,
      3.250182,
      3,
      0.742765,
      2,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132918,
      1.018502,
      0.833266,
      1.954729,
      1,
      1.298277,
      0,
      0.590111,
      NULL,
      NULL,
      0.268838,
      1,
      0.248935,
      NULL,
      0,
      1.191637,
      1.582600,
      0,
      0,
      NULL,
      0,
      1.543166,
      1.636373,
      1.903670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.447026,
      0.512237,
      0,
      NULL,
      NULL,
      1.300712,
      1,
      1.257128,
      0.684904,
      0.208646,
      1,
      0,
      0.741025,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0.479127,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.995867,
      1.759974,
      0.295129,
      1,
      0.908871,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1.493493,
      NULL,
      0.903982,
      1.442078,
      0.020625,
      1.666982,
      NULL,
      0.707120,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.305489,
      11.158162,
      2.304519,
      0.257939,
      0.600612,
      3.737779,
      2,
      8.032796,
      5,
      1,
      6,
      2,
      3.838010,
      8.413579,
      NULL,
      7,
      NULL,
      NULL,
      2.097814,
      NULL,
      NULL,
      1,
      3.903226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4,
      NULL,
      NULL,
      4.942266,
      5,
      1.459667,
      NULL,
      1,
      7,
      7.242964,
      0,
      4,
      9,
      NULL,
      4.572014,
      3.828473,
      8,
      8,
      1,
      5,
      2.144622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.541941,
      0,
      0.692501,
      1.684825,
      0.270301,
      NULL,
      0,
      NULL,
      1,
      1,
      0.649908,
      0,
      1.406347,
      0.351033,
      1.530601,
      1.623451,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.060141,
      0,
      1.311495,
      0.669110,
      1,
      NULL,
      1,
      0.432349,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.539196,
      0.779881,
      NULL,
      1,
      1.091232,
      1,
      0.836574,
      0,
      0.154047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      5,
      NULL,
      7,
      1,
      3,
      0,
      2,
      0,
      7,
      0,
      6,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      1,
      1,
      1,
      5,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      5,
      0,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 2-2000',
      ' 8- 8-1990',
      ' 9- 8-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-12-1999',
      NULL,
      ' 1-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1983',
      NULL,
      ' 6- 3-1974',
      ' 8- 9-1979',
      ' 4-24-1987',
      ' 5-10-1977',
      NULL,
      NULL,
      '11-10-1989',
      '11-21-1980',
      ' 4- 1-1976',
      ' 5-16-1979',
      ' 9-20-1992',
      ' 4-18-1998',
      ' 4- 2-1979',
      ' 9- 3-2002',
      '10-26-1986',
      ' 2- 4-1993',
      ' 2- 0-1987',
      ' 0-13-1979',
      NULL,
      NULL,
      NULL,
      ' 3- 0-1988',
      '11- 2-1994',
      ' 6-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-23-1977',
      ' 6- 6-1994',
      ' 6-25-1975',
      ' 6-13-1987',
      NULL,
      ' 0-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260024);
commit;
end;
/


