set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '2014443',
      NULL,
      1.409071,
      NULL,
      NULL,
      NULL,
      ' 4-26-1984',
      NULL,
      NULL,
      0.876270,
      1,
      2,
      0,
      0.812726,
      1,
      0,
      0,
      NULL,
      1,
      0.730145,
      7,
      NULL,
      NULL,
      0.794723,
      NULL,
      NULL,
      33,
      1,
      0.274485,
      2,
      NULL,
      7,
      NULL,
      0,
      0.552289,
      NULL,
      NULL,
      3,
      5,
      2,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      4,
      NULL,
      NULL,
      2.808538,
      0,
      0,
      0.080508,
      NULL,
      0.196015,
      0,
      3,
      NULL,
      0.069308,
      4,
      2,
      4.193401,
      3,
      1,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312661,
      NULL,
      5,
      1,
      4,
      NULL,
      3,
      34,
      54.272866,
      NULL,
      3,
      3,
      229.002931,
      1962.809593,
      NULL,
      2.451798,
      960,
      207.273142,
      3,
      3.504457,
      670.799547,
      NULL,
      1.850884,
      1.262096,
      246,
      4,
      1,
      0,
      624,
      41,
      NULL,
      2,
      171,
      23,
      1.760614,
      3,
      657.933179,
      NULL,
      0,
      8.122051,
      49,
      2.816142,
      2,
      2.231555,
      63,
      NULL,
      NULL,
      0,
      71.075494,
      2,
      1,
      1.744064,
      107.365208,
      8,
      1,
      5,
      101.885945,
      3.311713,
      2,
      7,
      601.931972,
      NULL,
      NULL,
      6,
      490.591043,
      38.898951,
      2,
      3.799014,
      517.360231,
      129.929899,
      1,
      2.331564,
      8.059499,
      1.925803,
      1,
      5.577591,
      33,
      15,
      0,
      1,
      156,
      24,
      3,
      2.537717,
      928.956514,
      NULL,
      0,
      1,
      149,
      13.973884,
      3.263991,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '04130',
      '11324',
      '',
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.550679,
      '',
      '',
      '',
      2,
      3.037310,
      21.856876,
      0,
      NULL,
      0.634971,
      NULL,
      0,
      NULL,
      NULL,
      7.503587,
      0,
      NULL,
      1,
      71.602174,
      NULL,
      NULL,
      1.816870,
      328,
      0.837646,
      NULL,
      ' 7-13-1999',
      8.406815,
      3,
      0,
      0.301299,
      13,
      13.201271,
      24,
      NULL,
      7.618771,
      0,
      6,
      4,
      4.396982,
      1.437691,
      9,
      15.308207,
      13,
      0,
      6.366103,
      16,
      18,
      9.489056,
      21,
      0,
      8,
      9.882836,
      6.712682,
      5,
      NULL,
      14,
      12,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      27,
      36,
      8.852855,
      14.790690,
      9.803844,
      1.278281,
      10,
      12,
      21,
      16,
      10.259695,
      5.801127,
      2.708668,
      26,
      18,
      34,
      NULL,
      0,
      11,
      12.775840,
      NULL,
      9,
      30.111670,
      5,
      5.499723,
      22.139333,
      0,
      4,
      14.134153,
      0,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      129.679156,
      113.225950,
      100.507260,
      107.966438,
      70.953703,
      54.570294,
      NULL,
      62.641418,
      106,
      86.817888,
      100.796076,
      70,
      NULL,
      26,
      184,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      19.179479,
      31,
      181.332844,
      NULL,
      87.381002,
      73.487441,
      31,
      169,
      179.838912,
      97.040641,
      149.946917,
      170,
      96,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.926963,
      1,
      4.352729,
      6.848944,
      1.323441,
      2,
      1.874546,
      1.930017,
      1,
      0.793881,
      NULL,
      8,
      1.777637,
      8.402165,
      1.742371,
      1,
      2.186132,
      1.294109,
      1.358480,
      1.202007,
      4.648861,
      4.949981,
      NULL,
      8,
      4,
      9.388120,
      5.126546,
      5.345029,
      1.603561,
      NULL,
      2,
      2.182624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211820,
      7.927404,
      2,
      0,
      2.893427,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      7,
      3.583137,
      1.424154,
      NULL,
      NULL,
      1.281998,
      0.249480,
      1.474900,
      0.553329,
      4.870608,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960664,
      NULL,
      3,
      1.601535,
      2.288651,
      NULL,
      NULL,
      0.294825,
      0.608914,
      NULL,
      1.842705,
      1.042387,
      0.881355,
      1.489324,
      0,
      1.647456,
      1,
      NULL,
      NULL,
      1,
      1.042740,
      0,
      NULL,
      1,
      0.650587,
      0,
      0.320816,
      1.129409,
      0,
      0,
      0.508384,
      NULL,
      1.539727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.132226,
      1,
      1,
      1,
      0.509908,
      NULL,
      NULL,
      0,
      1,
      0,
      1.485028,
      1.062556,
      0.025640,
      1,
      1.415779,
      0.900822,
      1.496214,
      0.217953,
      1,
      1.194075,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008309,
      0.057536,
      0,
      NULL,
      NULL,
      1,
      1,
      1.710189,
      1,
      0.490252,
      1,
      1,
      1,
      1.252269,
      0.323897,
      0.075916,
      1,
      1.297511,
      0.871768,
      0.825562,
      1.667279,
      NULL,
      3.138044,
      1,
      NULL,
      0.388026,
      NULL,
      1.821428,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497711,
      5.189793,
      6.207016,
      2.689132,
      9.864723,
      1.279768,
      4.830697,
      7,
      NULL,
      1.184005,
      NULL,
      7,
      NULL,
      5.241986,
      NULL,
      4,
      3.953539,
      9.758315,
      5,
      8.275033,
      2.911234,
      0.019221,
      3.818845,
      0,
      1.759813,
      5,
      0,
      7.693719,
      0.090777,
      9.734865,
      6,
      7.116389,
      0.411158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842304,
      5.299052,
      NULL,
      4,
      0,
      0.041058,
      NULL,
      9.163898,
      4.710410,
      5.325923,
      1,
      NULL,
      9,
      0,
      2,
      6,
      0.112266,
      7.490375,
      5,
      NULL,
      4.640688,
      7.286046,
      3,
      7,
      8.672650,
      NULL,
      3,
      4.957370,
      NULL,
      3.637960,
      8.506462,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.319864,
      1,
      0,
      1,
      NULL,
      0,
      1.000574,
      0,
      1,
      1.161237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088837,
      0.775745,
      0.769205,
      2,
      4,
      NULL,
      NULL,
      5,
      2,
      4,
      9,
      3,
      1,
      0,
      1,
      1,
      0.595419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.479972,
      2.274676,
      5,
      4,
      NULL,
      NULL,
      0.125539,
      0.824384,
      3.171874,
      4.144419,
      4,
      2,
      7.983715,
      1.799724,
      4,
      1,
      NULL,
      3,
      3,
      7.501057,
      5,
      3.245006,
      NULL,
      4,
      2.885430,
      2,
      8,
      2,
      1,
      NULL,
      3.287804,
      1.654821,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0.220705,
      0,
      0.872896,
      1.661482,
      0,
      0.249818,
      NULL,
      NULL,
      0.262533,
      0,
      0.456086,
      1.449553,
      0.828926,
      0,
      1.916822,
      NULL,
      NULL,
      0.695165,
      0,
      0.113488,
      1.673764,
      NULL,
      1,
      NULL,
      NULL,
      0.714817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.213181,
      1,
      2,
      0.541102,
      0,
      1,
      1.659451,
      0.187591,
      NULL,
      2,
      0,
      1,
      1.220547,
      3,
      NULL,
      0.323598,
      1.427463,
      1,
      0.358915,
      1.817582,
      NULL,
      NULL,
      1,
      1.406359,
      1,
      0.608291,
      0.815128,
      1.723361,
      1.301336,
      1.267893,
      1.804700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.396046,
      1,
      1.672609,
      0.802263,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      4,
      2,
      4.355526,
      0,
      4,
      5.684519,
      0.758820,
      4.650941,
      4.838806,
      NULL,
      NULL,
      4,
      5.381667,
      2,
      0.239198,
      1.967453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.812123,
      1.628011,
      NULL,
      1.486018,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.153678,
      1,
      1.768971,
      3.788679,
      0,
      2,
      NULL,
      0,
      1,
      1.303216,
      NULL,
      3,
      3.124406,
      NULL,
      5,
      3.753969,
      3.494144,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.173676,
      4.854532,
      NULL,
      6.423024,
      NULL,
      3.750515,
      2.482393,
      0,
      0,
      0.739373,
      3,
      NULL,
      3,
      2,
      NULL,
      2.172331,
      4.625421,
      0,
      0,
      1.744189,
      2.155045,
      1,
      5,
      9,
      0.513878,
      1.919168,
      5,
      9.653752,
      NULL,
      2.689140,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419071,
      7.573255,
      5,
      1,
      NULL,
      7,
      2.948628,
      0.079590,
      2.739894,
      0.341957,
      4,
      NULL,
      1.208809,
      3.856329,
      NULL,
      6.113488,
      NULL,
      4.135715,
      4,
      NULL,
      NULL,
      3,
      4,
      NULL,
      5,
      6,
      0,
      5,
      3,
      6,
      7,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.165321,
      0.058988,
      0.302580,
      0.472447,
      0,
      1.380810,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.244137,
      NULL,
      1.731173,
      0,
      1.836145,
      1.083824,
      0,
      NULL,
      0.465262,
      1,
      1,
      NULL,
      0.265880,
      0.602538,
      NULL,
      1,
      0.000931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418374,
      0,
      NULL,
      0.023752,
      NULL,
      1.025185,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0.634919,
      1.470177,
      NULL,
      0.818771,
      1.771057,
      NULL,
      0,
      4.086236,
      1.991968,
      0.548842,
      3.990387,
      4,
      0.774491,
      NULL,
      5.323317,
      5,
      NULL,
      4.642034,
      3,
      0,
      1.851451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      0,
      1,
      3,
      0,
      NULL,
      0,
      2,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      2,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4,
      NULL,
      3,
      4,
      4,
      1,
      0,
      3,
      5,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      5,
      0,
      3,
      NULL,
      2,
      3,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-28-2001',
      ' 5-10-1996',
      ' 7-19-1988',
      ' 2- 5-1990',
      '11-29-2000',
      ' 5-23-1981',
      ' 4-12-1990',
      NULL,
      ' 5-23-1991',
      ' 9- 1-1994',
      ' 6-18-2003',
      ' 9-25-1994',
      ' 1- 2-1981',
      '10-16-1979',
      '10-11-1997',
      ' 9- 6-2001',
      NULL,
      ' 0- 4-1982',
      ' 0-15-2002',
      ' 0-28-1981',
      ' 5-16-1989',
      ' 3-10-1985',
      ' 3-22-1988',
      ' 0-29-1993',
      ' 4- 7-1982',
      ' 8- 6-1997',
      ' 1-15-1989',
      '10-16-1991',
      '10-11-1975',
      '11-17-1996',
      '11-27-1984',
      ' 1-15-1978',
      ' 9-24-1985',
      ' 3-12-1979',
      ' 7-17-1980',
      ' 0- 1-1975',
      ' 2- 7-1985',
      ' 7-26-1984',
      ' 8- 9-1994',
      ' 5-24-1983',
      ' 6-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-1983',
      NULL,
      ' 5-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


