set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7938212';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '1333232',
      NULL,
      0,
      NULL,
      '10400',
      NULL,
      NULL,
      10.711822,
      NULL,
      0.700386,
      1,
      NULL,
      1.095093,
      NULL,
      1,
      1.542322,
      2,
      NULL,
      1.359680,
      0,
      9,
      NULL,
      NULL,
      0.284043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.795192,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      4,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      6,
      1,
      9,
      NULL,
      0,
      0,
      1,
      1.620463,
      1.169156,
      0,
      3,
      3,
      NULL,
      19,
      9,
      2,
      6,
      0.387221,
      NULL,
      1.090372,
      2.765274,
      6,
      1,
      ' 4-21-1987',
      3.916769,
      0.497930,
      NULL,
      NULL,
      2,
      NULL,
      0.029406,
      3,
      60,
      78,
      17034.024944,
      5.419384,
      0,
      122.187610,
      17596,
      19.217218,
      1,
      216.129733,
      26.567016,
      1,
      7,
      173.415841,
      24,
      0,
      1,
      176.406317,
      17.106751,
      1,
      3,
      99,
      20,
      NULL,
      1.667461,
      124,
      9,
      1,
      1.651642,
      NULL,
      NULL,
      2,
      NULL,
      151,
      2.204303,
      3.417507,
      3,
      178.994061,
      41.946251,
      0.697612,
      4,
      113,
      258,
      7,
      NULL,
      67,
      18089.649000,
      2,
      2.288182,
      148.129321,
      9872,
      3,
      2.103372,
      47,
      16979,
      1.278769,
      NULL,
      98.598927,
      16649.774118,
      3.062746,
      1,
      78,
      2,
      0.267388,
      1.317036,
      81.746787,
      NULL,
      1.050297,
      1.296151,
      NULL,
      155.455743,
      NULL,
      2,
      281.100206,
      494.168654,
      3.861545,
      0,
      104,
      63.020857,
      NULL,
      9.175381,
      195.557477,
      33,
      2.173577,
      0,
      100,
      71.063861,
      NULL,
      9.499352,
      37.164421,
      12,
      3.386580,
      0.410831,
      165.813886,
      NULL,
      1,
      7,
      154,
      13,
      0.300887,
      0.098414,
      133.251062,
      94,
      2.611045,
      6,
      117.460785,
      NULL,
      3,
      9.786486,
      46,
      197,
      3,
      6.589346,
      120.458914,
      NULL,
      1.931577,
      NULL,
      93.425639,
      274,
      0,
      0.793050,
      NULL,
      NULL,
      1,
      9,
      NULL,
      122,
      1,
      6.248914,
      95,
      265,
      0,
      9,
      2.663779,
      657.946103,
      3.826769,
      2,
      213.108780,
      339,
      NULL,
      6.275316,
      61,
      1126.501050,
      0.228809,
      3.083081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24120',
      '',
      NULL,
      NULL,
      '',
      '',
      1.252183,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2,
      1,
      16,
      3,
      70,
      0.018054,
      NULL,
      1.740687,
      NULL,
      1.359508,
      NULL,
      NULL,
      NULL,
      0.039684,
      NULL,
      1.627820,
      NULL,
      0,
      NULL,
      1.032401,
      NULL,
      ' 8-10-1989',
      NULL,
      9.639171,
      12.539820,
      1,
      4.364370,
      3.041580,
      NULL,
      NULL,
      19.210079,
      0,
      NULL,
      3.990808,
      25,
      4,
      12,
      8,
      3,
      2,
      4,
      13,
      NULL,
      1,
      4,
      NULL,
      7.104949,
      20,
      4.714569,
      NULL,
      14,
      1,
      19,
      1,
      NULL,
      7,
      NULL,
      15,
      20,
      1.459479,
      1,
      0.652036,
      7,
      12.284345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639975,
      12.561480,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.319414,
      3.581845,
      3.986720,
      1,
      2.729722,
      2.449778,
      20,
      4.059675,
      23.868934,
      NULL,
      7.444874,
      6.982345,
      NULL,
      1,
      0,
      24,
      34,
      9.556471,
      24.484047,
      23.941263,
      28.804515,
      5.860007,
      28.621681,
      30,
      16.900611,
      11.194623,
      10,
      NULL,
      22,
      NULL,
      9.605043,
      1,
      NULL,
      2,
      3,
      0,
      22.471208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      145.876704,
      141,
      139.702670,
      93,
      58.165179,
      50.604188,
      19.804659,
      NULL,
      152.560871,
      NULL,
      58.958153,
      29.761972,
      140,
      122,
      49.716334,
      128.927773,
      23.132648,
      30.976426,
      9.947678,
      13,
      37,
      NULL,
      66.867111,
      20,
      107,
      17,
      99.440407,
      5.360475,
      166.278784,
      128,
      153.980144,
      77,
      79.731832,
      4,
      174,
      57.101982,
      110.708896,
      87.090027,
      48.051916,
      153.656294,
      37.405419,
      59.683801,
      93,
      26.996432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.578044,
      NULL,
      NULL,
      5,
      NULL,
      5,
      6.781016,
      0.659938,
      6,
      7.444362,
      NULL,
      6,
      7,
      NULL,
      5,
      2,
      0,
      1,
      NULL,
      3,
      7.730028,
      NULL,
      7,
      1.742294,
      7,
      NULL,
      NULL,
      6,
      NULL,
      4,
      0.597107,
      3,
      NULL,
      5.757688,
      4,
      NULL,
      7,
      7.347948,
      5,
      NULL,
      4,
      0.670182,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.105751,
      NULL,
      1.973217,
      1,
      0,
      0.056763,
      0.330181,
      0,
      1,
      0,
      0.194036,
      NULL,
      0,
      0.964706,
      1,
      1,
      1.693926,
      0,
      NULL,
      0.165028,
      NULL,
      NULL,
      0,
      0.139158,
      NULL,
      0,
      1,
      1,
      NULL,
      0.630242,
      1.573435,
      1,
      NULL,
      1.230411,
      0.491454,
      1.478509,
      1.861592,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      3,
      6,
      0.434814,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7.032823,
      NULL,
      5,
      3.953717,
      NULL,
      5,
      2,
      0,
      3.257617,
      5.594383,
      4.169684,
      5.369864,
      6.392946,
      7,
      6,
      4.404160,
      3.566564,
      NULL,
      3,
      0,
      5,
      NULL,
      4,
      1,
      5,
      3,
      1,
      3.892185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459738,
      1,
      0,
      0.398934,
      5.769854,
      0,
      3.749924,
      4.994501,
      2,
      2.297861,
      0.006298,
      NULL,
      3.043836,
      2.370236,
      4.543101,
      4,
      4,
      0.442408,
      1.051957,
      5,
      5.694901,
      3.787899,
      5,
      4.375814,
      3,
      2.364102,
      NULL,
      5.426731,
      5,
      3,
      3.064540,
      3,
      1.956398,
      3,
      1.525286,
      NULL,
      NULL,
      3.065438,
      3,
      0,
      1.874251,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586081,
      8,
      2,
      0.289010,
      0.393056,
      3.006653,
      3,
      NULL,
      3.168404,
      9,
      7,
      7.269587,
      7,
      NULL,
      7.737063,
      8,
      6.551412,
      5,
      6,
      NULL,
      4,
      3,
      1,
      NULL,
      7.846062,
      NULL,
      3,
      2,
      8.885221,
      NULL,
      NULL,
      NULL,
      3.661023,
      1,
      6.273690,
      1.487986,
      4,
      5.954487,
      0,
      4.030409,
      8.346861,
      4,
      2.847496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.898680,
      NULL,
      2,
      7,
      2.445904,
      8,
      9.991810,
      9,
      NULL,
      0,
      8,
      NULL,
      6,
      7.801311,
      5,
      4.899380,
      9.115711,
      6.012463,
      2,
      8.737665,
      6,
      2.902963,
      7.566058,
      5.702388,
      2.722791,
      NULL,
      9.685618,
      8,
      0.717262,
      8.906981,
      9,
      7.798884,
      NULL,
      8,
      9.407670,
      7,
      3,
      NULL,
      3.924410,
      6,
      1.828330,
      7.041479,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920874,
      8.309978,
      3,
      0.662410,
      3,
      7,
      4.288842,
      4.475128,
      9.218306,
      10,
      NULL,
      0.426694,
      NULL,
      6.464585,
      5,
      4.773981,
      6.530979,
      3,
      9.096270,
      2.032080,
      10.146409,
      NULL,
      1,
      9,
      4.322865,
      9,
      5.150174,
      10,
      4.909871,
      6,
      8.048879,
      5.910684,
      6,
      2.560754,
      NULL,
      11.101777,
      5,
      6,
      NULL,
      0.472747,
      1.772511,
      NULL,
      7.484537,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.257524,
      0,
      1,
      9.033075,
      4,
      8,
      7.065979,
      0.955127,
      0.993793,
      NULL,
      7,
      7.476876,
      5,
      7,
      6,
      6.435666,
      6.950648,
      5,
      0.660164,
      9,
      NULL,
      NULL,
      5.522053,
      8,
      9,
      2,
      NULL,
      9.715233,
      1.396059,
      6,
      1,
      NULL,
      1.374721,
      3,
      NULL,
      8,
      7,
      NULL,
      0.600093,
      4,
      6.198143,
      7.716251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9.750489,
      1.799867,
      NULL,
      2.582082,
      10.618197,
      9.298713,
      3.578591,
      0.767715,
      2,
      0.506341,
      3.116368,
      1,
      0.638842,
      NULL,
      0.373706,
      6,
      4.896067,
      5,
      7,
      NULL,
      4,
      3.088616,
      8.240993,
      1.714074,
      0.184514,
      7,
      3.249423,
      9,
      NULL,
      1,
      9,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      9.836373,
      3.060251,
      3,
      7.569317,
      7,
      NULL,
      2.006307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.905238,
      1.039415,
      1.472582,
      1,
      NULL,
      1.218654,
      7,
      0,
      0,
      6,
      NULL,
      0,
      6.214995,
      0.939343,
      5,
      2.267327,
      2,
      4.595786,
      NULL,
      NULL,
      5,
      NULL,
      5.377254,
      1.108803,
      5.896889,
      6,
      6,
      3.151426,
      NULL,
      0,
      5,
      NULL,
      7,
      5,
      6,
      NULL,
      NULL,
      3,
      2,
      1.061091,
      0.820475,
      1.608765,
      1.667522,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575538,
      0,
      0,
      1,
      0.023967,
      0.182177,
      NULL,
      0,
      1,
      NULL,
      0.372720,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.421326,
      0.269854,
      NULL,
      1.584166,
      0,
      0,
      1.191424,
      1,
      0.782540,
      1,
      1.897825,
      NULL,
      1,
      1.104914,
      NULL,
      NULL,
      0,
      1,
      0.160036,
      0.411119,
      NULL,
      1.820622,
      1.268711,
      1,
      0.490614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.358790,
      NULL,
      2.637496,
      2,
      NULL,
      1.700564,
      1,
      1,
      2.963759,
      NULL,
      3,
      3.062283,
      2,
      1,
      2.040901,
      NULL,
      3,
      2,
      1,
      3.096408,
      2.326746,
      2,
      NULL,
      3,
      3.309084,
      3.261952,
      0.741405,
      1.264477,
      NULL,
      NULL,
      2.761656,
      3.442190,
      3.795979,
      NULL,
      0,
      3,
      NULL,
      3.689314,
      0,
      2.142043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356020,
      0,
      0,
      1,
      1.985050,
      NULL,
      1,
      1,
      1.745363,
      1,
      1,
      NULL,
      0.543370,
      1,
      NULL,
      1.552204,
      1,
      0,
      0,
      1.987569,
      0.057076,
      1.132247,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0.591032,
      NULL,
      1,
      0.310389,
      0,
      1.751326,
      0.846001,
      0,
      0.393877,
      1.526558,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.973911,
      4,
      2,
      7,
      NULL,
      9,
      2,
      2,
      6.304863,
      5.379197,
      NULL,
      5,
      1,
      NULL,
      7.586396,
      NULL,
      NULL,
      4.828867,
      4.043778,
      0,
      7.612759,
      5,
      0,
      7,
      5.806197,
      1.747879,
      4.161733,
      NULL,
      NULL,
      4.432320,
      7,
      6,
      2,
      3.130986,
      5,
      NULL,
      6,
      8.331684,
      3,
      0,
      7,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.547894,
      9.778848,
      3.954191,
      10,
      3,
      5.386369,
      8,
      1,
      NULL,
      10.584749,
      0,
      8.380100,
      6,
      1,
      NULL,
      3.005308,
      2,
      7.224622,
      9,
      8,
      NULL,
      NULL,
      4,
      3,
      2.462567,
      0.854981,
      2,
      6,
      5.224319,
      NULL,
      0.677842,
      NULL,
      2.348028,
      10,
      NULL,
      11.869768,
      4,
      10,
      3,
      1,
      0,
      5.048679,
      3.729644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0.192589,
      1.759918,
      1.977129,
      1,
      0,
      1.764554,
      1.001218,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1.705717,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1.773962,
      0.358519,
      1.397471,
      0.505991,
      1.436163,
      1.928022,
      0.712829,
      0.412037,
      0.696543,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3.277297,
      0,
      3.637910,
      0,
      2,
      1.637838,
      3,
      NULL,
      2.804561,
      2,
      1,
      0,
      0.208847,
      NULL,
      1,
      NULL,
      3.592781,
      NULL,
      0,
      1,
      0,
      3.142154,
      1.511475,
      0.706161,
      2.028100,
      2,
      3.859405,
      NULL,
      2,
      NULL,
      1,
      3.756310,
      NULL,
      NULL,
      1.168287,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      2,
      2,
      5,
      0,
      NULL,
      1,
      2,
      3,
      3,
      1,
      1,
      3,
      3,
      0,
      2,
      0,
      3,
      1,
      1,
      3,
      4,
      1,
      NULL,
      3,
      3,
      3,
      2,
      3,
      0,
      0,
      5,
      3,
      NULL,
      3,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1979',
      NULL,
      ' 1-23-1981',
      ' 5-13-1991',
      ' 7-27-2001',
      ' 4-24-1978',
      ' 9-14-1989',
      NULL,
      ' 0-29-1979',
      ' 3-15-1976',
      ' 6-17-1985',
      NULL,
      ' 9-25-1976',
      ' 1- 8-2003',
      ' 7-28-1984',
      ' 2- 5-1994',
      ' 1- 3-1977',
      ' 7-25-1977',
      ' 3-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1994',
      ' 4-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-2001',
      ' 9- 4-1980',
      ' 5-24-1978',
      ' 9- 9-1990',
      NULL,
      NULL,
      ' 7-28-1985',
      ' 9- 8-2000',
      NULL,
      ' 2- 8-1979',
      '10-17-1997',
      NULL,
      ' 6- 8-1981',
      ' 4-22-1977',
      '10-18-2002',
      ' 5-10-1975',
      ' 3-22-1982',
      ' 7- 5-1977',
      ' 8-26-1985',
      ' 2- 8-1994',
      '11-12-1991',
      ' 0- 4-1997',
      ' 3- 7-1979',
      ' 4-12-1981',
      ' 4-24-1996',
      ' 8-22-1993',
      ' 9- 3-1999',
      NULL,
      ' 7- 0-1992',
      '11- 6-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


