set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7941726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '02023132',
      54.594914,
      29,
      NULL,
      6,
      NULL,
      NULL,
      '30020',
      3.882288,
      '10- 0-1993',
      150,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0.619553,
      1,
      NULL,
      1,
      1,
      1,
      8,
      NULL,
      NULL,
      0.465591,
      3.373838,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.669342,
      0,
      5,
      NULL,
      NULL,
      6,
      2,
      2,
      4,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      7,
      4,
      1,
      0,
      1,
      NULL,
      NULL,
      0.344788,
      NULL,
      3,
      2,
      2,
      NULL,
      0,
      6,
      4,
      1,
      6,
      5,
      2.738211,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      0,
      NULL,
      0,
      17.380784,
      774.921142,
      93,
      0.377399,
      0.799620,
      22.514708,
      10,
      0,
      0,
      492,
      NULL,
      NULL,
      5,
      501,
      NULL,
      0,
      NULL,
      179.022185,
      NULL,
      3.779584,
      6,
      92.293154,
      13,
      1.346378,
      1.214581,
      104.664068,
      7.725711,
      1,
      1,
      381,
      864,
      2,
      3,
      181.431517,
      95.349094,
      2.696358,
      1.677193,
      33.092536,
      535,
      1.113443,
      7,
      150,
      NULL,
      2.569342,
      0.960806,
      178,
      156.854512,
      0,
      3.474070,
      25.191345,
      11.398286,
      6.340482,
      7.369819,
      170,
      31.598408,
      NULL,
      2,
      417.562528,
      5,
      NULL,
      0,
      578.901985,
      4.080095,
      NULL,
      1,
      NULL,
      7,
      1,
      NULL,
      231,
      NULL,
      0,
      0.305030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.126580,
      '21223',
      '14003',
      NULL,
      '',
      NULL,
      '',
      1.407683,
      '',
      NULL,
      NULL,
      3,
      '43034',
      '',
      '',
      NULL,
      0,
      NULL,
      1,
      1218,
      0.789949,
      NULL,
      NULL,
      NULL,
      1.090501,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.069214,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      23,
      2.460157,
      7,
      14,
      NULL,
      8,
      8.754942,
      9,
      18,
      23.983435,
      3,
      1,
      6,
      4,
      10,
      21.316100,
      14,
      NULL,
      NULL,
      2.610350,
      9.457102,
      2,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.144690,
      23.238059,
      14.488191,
      0.002881,
      10,
      7,
      3,
      30,
      57,
      24,
      21.376387,
      NULL,
      0.403713,
      45.500229,
      44.381181,
      2,
      NULL,
      NULL,
      32,
      0.534658,
      48,
      6,
      14.230365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      118.231679,
      NULL,
      64,
      NULL,
      85,
      104,
      53,
      1,
      100,
      93.721722,
      33,
      103.909790,
      NULL,
      38,
      27.695041,
      4.818186,
      147,
      NULL,
      59.344100,
      0,
      2.118676,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.924893,
      1,
      5.432144,
      NULL,
      3,
      1,
      NULL,
      NULL,
      9.232382,
      6.961304,
      7.952992,
      NULL,
      0.857196,
      3,
      3.870367,
      NULL,
      0.283008,
      2,
      0.396142,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643442,
      0,
      1,
      1.798635,
      9,
      NULL,
      7,
      11.609061,
      3.744542,
      NULL,
      5,
      1,
      0.799021,
      2.010058,
      5,
      9,
      7.369050,
      6.454844,
      3,
      3.515975,
      6,
      0,
      1.592197,
      3.219147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941119,
      1.657427,
      NULL,
      4,
      4.690458,
      5.251682,
      1.945723,
      1,
      5.231766,
      10.047786,
      6.888927,
      3,
      7,
      0,
      NULL,
      4.002823,
      0.006593,
      0.048844,
      NULL,
      3,
      1.041566,
      4.368903,
      2,
      4.674527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.851980,
      NULL,
      1.154514,
      0.312703,
      2,
      NULL,
      5,
      1.411528,
      4,
      2,
      NULL,
      7.590872,
      1.237880,
      7,
      NULL,
      2.175016,
      2,
      3,
      0,
      0.332988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.239666,
      0,
      2,
      NULL,
      3,
      1.344598,
      NULL,
      1,
      4.003040,
      2,
      4,
      2.582017,
      4,
      2,
      2.626291,
      3.799680,
      0.598869,
      NULL,
      NULL,
      0.414252,
      1,
      0.011861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.958634,
      4.232969,
      8,
      NULL,
      NULL,
      4,
      NULL,
      0.493979,
      5.200668,
      0,
      1.599387,
      9.760586,
      9,
      6.735225,
      0.800066,
      11,
      8.849283,
      3.860830,
      3.535735,
      5.098237,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.918588,
      2.951687,
      NULL,
      6,
      6,
      6.256351,
      NULL,
      5,
      7,
      NULL,
      7.666227,
      8.859550,
      1,
      1.496768,
      0.592565,
      2.965916,
      5.004981,
      NULL,
      NULL,
      9.632120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482035,
      1,
      0,
      0.523072,
      6,
      3,
      2,
      NULL,
      0.105186,
      6.665605,
      4,
      5.491541,
      7.828919,
      5,
      1.779442,
      NULL,
      3,
      5,
      6.577053,
      5,
      2.301586,
      1,
      2.821707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0.518525,
      NULL,
      1.340598,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1.455621,
      1.048416,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.614125,
      1.080392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830220,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0.950023,
      NULL,
      0,
      0,
      1.663268,
      0,
      1.393404,
      0.285885,
      1,
      0,
      0.890975,
      0,
      NULL,
      0,
      0,
      1.464399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0.866045,
      0.254536,
      0,
      1,
      1,
      0,
      0.552637,
      0.509589,
      NULL,
      1,
      0,
      1,
      1.889673,
      0,
      0.994496,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099436,
      0,
      0,
      0,
      5.261888,
      0.536651,
      0,
      0,
      0,
      1,
      0.146436,
      2,
      0.588903,
      NULL,
      NULL,
      1,
      1.707749,
      NULL,
      1.228723,
      NULL,
      NULL,
      0.948248,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692475,
      NULL,
      0.383850,
      1.736251,
      1,
      0.208918,
      0.654896,
      1.899991,
      0.984588,
      1.609836,
      1,
      0.678624,
      0,
      0,
      1,
      0.700613,
      1,
      1,
      0,
      0.125898,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      8,
      NULL,
      8,
      NULL,
      8.207870,
      NULL,
      1,
      4,
      7,
      1,
      7.292582,
      5,
      1.409886,
      8.069541,
      9.493408,
      NULL,
      9,
      NULL,
      3.531349,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.803934,
      2.097939,
      6.891559,
      7.947346,
      9.412080,
      4.168942,
      2,
      8.938205,
      6,
      8,
      6.579573,
      1,
      4.996466,
      9,
      4,
      1.897070,
      NULL,
      NULL,
      NULL,
      9.597671,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815583,
      NULL,
      0.534401,
      0.909231,
      1,
      0.221330,
      0.208270,
      1.088647,
      1.063950,
      NULL,
      1.794001,
      1,
      0,
      1.761718,
      1,
      0,
      0.846043,
      1.113493,
      NULL,
      1,
      1.704287,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.098980,
      1,
      NULL,
      0.635665,
      1.237023,
      NULL,
      1.581190,
      1,
      0,
      NULL,
      0.104047,
      NULL,
      0,
      0.689566,
      NULL,
      0,
      0,
      1.237692,
      1,
      1,
      1.887297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4,
      0,
      4,
      0,
      0,
      0,
      2,
      0,
      4,
      1,
      4,
      0,
      4,
      4,
      1,
      NULL,
      1,
      2,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4,
      1,
      5,
      2,
      6,
      NULL,
      3,
      0,
      7,
      6,
      5,
      1,
      4,
      5,
      NULL,
      5,
      1,
      6,
      3,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      5,
      2,
      1,
      1,
      4,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1,
      0,
      2,
      5,
      4,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-2001',
      NULL,
      NULL,
      ' 0-28-1988',
      ' 9- 6-1992',
      ' 3-25-1990',
      '11-15-1997',
      ' 6- 8-1982',
      ' 5-13-1989',
      ' 7- 9-1998',
      ' 4- 9-1990',
      ' 2- 2-1990',
      ' 1- 2-1993',
      ' 5- 4-1999',
      NULL,
      ' 2-15-1981',
      NULL,
      ' 9-11-1977',
      NULL,
      ' 7- 6-1992',
      NULL,
      ' 8-23-1993',
      ' 6-29-1980',
      ' 2-22-2000',
      ' 6-19-1980',
      ' 2-12-1991',
      NULL,
      NULL,
      ' 7-19-1980',
      NULL,
      ' 4-27-2000',
      ' 2-17-1990',
      ' 2- 6-1990',
      NULL,
      ' 6-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666762);
commit;
end;
/


