set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      NULL,
      35,
      NULL,
      '1400131',
      NULL,
      0.943649,
      1,
      '13111',
      0.441029,
      ' 4-15-1988',
      3.366240,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      2.148045,
      NULL,
      0,
      18,
      8.852456,
      3.112556,
      1.723183,
      NULL,
      6,
      3.116938,
      0,
      1.981623,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      2,
      NULL,
      3,
      9,
      NULL,
      7,
      1,
      NULL,
      1,
      0.799029,
      1,
      NULL,
      NULL,
      1.020600,
      0,
      7,
      4.509169,
      4,
      NULL,
      NULL,
      NULL,
      1.792099,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      28.575815,
      142,
      NULL,
      1,
      1,
      40,
      3.396743,
      2.355082,
      3.787291,
      118.442526,
      5.980507,
      NULL,
      2.750610,
      185.453889,
      26,
      3,
      NULL,
      0,
      4.363701,
      NULL,
      NULL,
      28.261106,
      21.615111,
      NULL,
      6.869975,
      NULL,
      NULL,
      NULL,
      3.282089,
      NULL,
      24.176380,
      1.616344,
      NULL,
      201.473251,
      1,
      0,
      1,
      178,
      6.868603,
      0.194332,
      1,
      241.617713,
      33.008950,
      3.905168,
      NULL,
      NULL,
      77,
      0.510374,
      3.062423,
      NULL,
      14,
      1.642173,
      3.932741,
      87,
      18.704192,
      0,
      2.322676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '00340',
      '',
      '',
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      4,
      4.482368,
      146.128142,
      1.040831,
      NULL,
      1.628114,
      NULL,
      0,
      NULL,
      0.362945,
      63.063309,
      1.831967,
      NULL,
      1.608814,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '10- 8-1985',
      5.306527,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5.117908,
      4,
      16.685045,
      8.874625,
      3,
      5.253500,
      6,
      20,
      17.247474,
      6,
      11,
      NULL,
      6,
      14,
      1,
      NULL,
      3,
      1,
      3.156331,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      2,
      35.461508,
      7,
      15,
      16,
      53,
      41,
      13,
      48.503851,
      45.921494,
      36.448455,
      11.700187,
      33.015639,
      12,
      2.130205,
      7,
      2.726397,
      4.970445,
      NULL,
      30,
      50,
      NULL,
      4.509058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      168,
      145.284792,
      89,
      39.250996,
      166,
      NULL,
      87,
      148.474557,
      NULL,
      70.992656,
      184.428528,
      NULL,
      67.051375,
      NULL,
      150.491446,
      95,
      151.288739,
      151.972423,
      40.701455,
      NULL,
      98.287998,
      0,
      1.355391,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.534926,
      0,
      5.664662,
      4.086457,
      9.859366,
      7,
      4.649818,
      3.243009,
      5,
      4,
      3,
      2.733479,
      NULL,
      2,
      0,
      1.901003,
      1.073457,
      NULL,
      3,
      4,
      8,
      NULL,
      2.844782,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.638362,
      1,
      1.288957,
      3.581635,
      3.201390,
      NULL,
      2,
      0,
      0.580109,
      1,
      1.138690,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      4.946474,
      6.573969,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482948,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.202201,
      NULL,
      1.809277,
      1,
      0.632212,
      0.954276,
      1,
      1,
      3.519935,
      1,
      1,
      NULL,
      1.787532,
      NULL,
      0,
      0.245962,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842213,
      1.195289,
      1,
      0,
      0.840691,
      1.274269,
      1.687677,
      NULL,
      NULL,
      1,
      1,
      1.245995,
      1,
      0.174642,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206696,
      1,
      0,
      0.038690,
      1.262967,
      1.817135,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.575384,
      0.699291,
      1.873240,
      0,
      0.439151,
      NULL,
      5.534904,
      3,
      NULL,
      NULL,
      1.870250,
      5.721770,
      5,
      1,
      NULL,
      2.093549,
      4,
      0,
      1.110995,
      1.951545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.133995,
      NULL,
      1.836313,
      NULL,
      4,
      1,
      NULL,
      3.962281,
      6.462573,
      NULL,
      5.433667,
      6.114213,
      NULL,
      8,
      4,
      NULL,
      6.343314,
      6,
      5.110619,
      0,
      4.900062,
      7,
      NULL,
      5.266119,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335653,
      NULL,
      0,
      0,
      1.809585,
      0.125492,
      0.112901,
      1,
      NULL,
      1.288079,
      1,
      2.501838,
      4.291665,
      2.575749,
      4.152924,
      5,
      0,
      1,
      5.979015,
      5.658389,
      6,
      4.763594,
      NULL,
      NULL,
      9,
      3.825305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236047,
      0,
      0.038959,
      0.582268,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0.455499,
      0,
      2,
      3.417370,
      0,
      4,
      2,
      3.945664,
      1.613081,
      3,
      6,
      4.666646,
      11.639041,
      0.936119,
      1.957565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958245,
      1,
      0,
      1.341326,
      2.098826,
      1.218963,
      1.699664,
      0,
      1.280205,
      NULL,
      NULL,
      0,
      0,
      0.246769,
      0,
      1.613448,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.301349,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539276,
      1.806036,
      1.506149,
      0.369807,
      0,
      NULL,
      1,
      2.907487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.080041,
      0,
      1,
      0,
      0,
      0.748853,
      0.666911,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.269942,
      1.967039,
      0.557170,
      1.604144,
      1,
      1,
      0,
      1.900429,
      NULL,
      NULL,
      0.512104,
      0.230380,
      1.527618,
      1,
      0,
      1.568094,
      1,
      NULL,
      0,
      1,
      1.664192,
      1.580262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.504903,
      NULL,
      1,
      1,
      1.778460,
      1,
      0.070881,
      NULL,
      NULL,
      NULL,
      0,
      1.585549,
      NULL,
      6,
      2,
      NULL,
      8.462333,
      4,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978475,
      0.525376,
      1.898688,
      NULL,
      3.228518,
      3.314504,
      NULL,
      1,
      0.567818,
      0.921821,
      2,
      4.790315,
      1,
      2,
      3,
      0.504390,
      NULL,
      2,
      0.593622,
      6.385742,
      NULL,
      2.095431,
      0.504921,
      0,
      5.740914,
      3.042958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230194,
      0,
      0.794717,
      NULL,
      NULL,
      3.405747,
      1.120518,
      7.678122,
      3,
      1.609954,
      NULL,
      2,
      2,
      3.983215,
      1,
      0,
      0.636239,
      8.530492,
      9,
      6,
      3.254493,
      NULL,
      2,
      5,
      1.795985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1,
      0,
      5,
      4.770183,
      NULL,
      5.038465,
      3.727362,
      4.283361,
      4,
      NULL,
      0,
      NULL,
      3.828190,
      5,
      2.191883,
      4.344713,
      8.793615,
      2,
      1,
      10,
      0.326011,
      3.923173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683630,
      1.381136,
      0,
      1,
      1.739509,
      1,
      1,
      1.435750,
      NULL,
      1.274582,
      NULL,
      1,
      NULL,
      0,
      1.420710,
      0.431591,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.242291,
      1.487249,
      1.506339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.645781,
      NULL,
      NULL,
      0,
      0,
      1,
      0.049263,
      1,
      0,
      3,
      0,
      1,
      0,
      0,
      NULL,
      0.269050,
      0.498464,
      6,
      NULL,
      7,
      NULL,
      4,
      4,
      1.547081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      4,
      2,
      3,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1980',
      ' 1-23-1993',
      NULL,
      ' 9-28-1976',
      ' 9- 8-1977',
      ' 5-17-2001',
      NULL,
      '10- 9-1982',
      ' 9- 1-1992',
      NULL,
      ' 3-12-1984',
      NULL,
      '11- 1-1985',
      ' 2-18-1992',
      NULL,
      '11-18-1997',
      ' 2-21-1979',
      NULL,
      ' 9-29-1988',
      ' 9-16-1998',
      ' 5-21-2000',
      ' 0-23-1975',
      ' 1- 4-1998',
      ' 5-26-1998',
      ' 3-22-2000',
      ' 5-22-1988',
      ' 1- 4-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


