set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '3002111',
      2,
      5,
      3,
      '21410',
      3,
      ' 2-20-1983',
      NULL,
      NULL,
      0.056657,
      NULL,
      NULL,
      NULL,
      0.158327,
      1,
      1.060031,
      3.920439,
      0.055297,
      2.830326,
      NULL,
      0,
      5,
      NULL,
      0.823168,
      NULL,
      4.251229,
      48.487043,
      NULL,
      1,
      3.770667,
      NULL,
      8.770569,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      6,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      5,
      9,
      0,
      1,
      0,
      NULL,
      0.076418,
      NULL,
      0,
      NULL,
      1.800022,
      NULL,
      1.094661,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      10,
      ' 6-22-1976',
      0.114893,
      3.778158,
      NULL,
      5,
      3,
      4,
      NULL,
      4,
      NULL,
      170,
      19847,
      2.753953,
      10,
      NULL,
      3,
      NULL,
      2.282169,
      NULL,
      6,
      0.842360,
      1,
      37,
      59.384930,
      1.632732,
      4,
      260,
      8,
      NULL,
      NULL,
      NULL,
      4.712117,
      0,
      0,
      525,
      156.667370,
      3.707702,
      15.128056,
      264,
      1688.921723,
      0,
      9,
      NULL,
      NULL,
      5.743018,
      NULL,
      314,
      54,
      1.215333,
      0.567498,
      NULL,
      3.784051,
      1,
      0.419347,
      174.518626,
      2,
      1.746016,
      1.014075,
      124,
      80.822842,
      0.243212,
      1,
      95.317049,
      17.298993,
      1.892992,
      3.360461,
      35.503250,
      23.393191,
      0,
      NULL,
      NULL,
      NULL,
      1.592321,
      3.483728,
      59.337893,
      197.045824,
      3,
      2.666102,
      900,
      NULL,
      2,
      1.027968,
      1087,
      80.906173,
      0.136737,
      1,
      904,
      NULL,
      2.096263,
      1,
      880,
      NULL,
      2.022922,
      3.115505,
      398.329353,
      2.184867,
      0.932548,
      2,
      347.477504,
      1.723579,
      1.636003,
      NULL,
      NULL,
      334.891936,
      2.545522,
      0,
      29.609770,
      68.556088,
      1.895664,
      1,
      389.555806,
      989,
      3,
      NULL,
      641.745469,
      896.177384,
      NULL,
      3.115520,
      479,
      1252.968082,
      3.624559,
      1,
      275.336918,
      30.542224,
      2.573641,
      3.839617,
      351,
      61,
      0,
      3,
      584.904906,
      1019,
      1,
      1,
      136.574736,
      398.540966,
      NULL,
      NULL,
      NULL,
      338.589434,
      NULL,
      0.269152,
      653,
      516.466014,
      0,
      2.463244,
      377.812235,
      53,
      0.842298,
      2.196809,
      669,
      NULL,
      0,
      8,
      270.483302,
      111,
      0.006813,
      3.921215,
      NULL,
      0.976122,
      2,
      3.109123,
      48,
      528,
      NULL,
      2,
      6,
      9,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '32214',
      NULL,
      '',
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      3,
      NULL,
      1.124161,
      7,
      1,
      NULL,
      0.845121,
      NULL,
      3.123318,
      4,
      NULL,
      NULL,
      0.245541,
      NULL,
      NULL,
      NULL,
      0.108969,
      NULL,
      1,
      NULL,
      ' 2-20-1990',
      11.478207,
      NULL,
      NULL,
      14,
      0,
      6.205954,
      3,
      0.530258,
      NULL,
      15,
      15.110592,
      9.618823,
      19.679769,
      NULL,
      15.752584,
      2,
      NULL,
      3,
      6.647026,
      13.833448,
      NULL,
      21.781626,
      22,
      9.520154,
      9.877750,
      2.495818,
      9.186552,
      15.971417,
      5,
      NULL,
      NULL,
      4,
      4.935045,
      8.705001,
      NULL,
      NULL,
      6.660026,
      NULL,
      2,
      9,
      10.454208,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946889,
      0,
      NULL,
      20,
      22,
      6.520956,
      18,
      6.042622,
      5,
      NULL,
      31.663633,
      31,
      1.850977,
      8,
      9,
      8.691518,
      19,
      8.742474,
      45,
      1.200589,
      6,
      26.942498,
      11,
      10.931498,
      10,
      8.244120,
      1.008444,
      28.261507,
      27,
      26.050439,
      3,
      2,
      39,
      12,
      5.183405,
      1.684609,
      10.713662,
      30,
      16.153148,
      15,
      2,
      NULL,
      16.341031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.548600,
      NULL,
      148.925917,
      107,
      72,
      NULL,
      NULL,
      24,
      35.489322,
      81.949988,
      32.689828,
      NULL,
      169.966414,
      156,
      174.824005,
      1,
      174.422445,
      146,
      157,
      NULL,
      44.382636,
      NULL,
      NULL,
      NULL,
      147,
      139,
      NULL,
      134.173939,
      161.070400,
      132,
      139.508262,
      NULL,
      102,
      163.859905,
      155.010329,
      NULL,
      NULL,
      31.645222,
      106.506717,
      NULL,
      85,
      185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      10,
      0,
      1,
      9.288962,
      2.303627,
      NULL,
      NULL,
      NULL,
      NULL,
      6.254676,
      1.291871,
      7.912098,
      2.483892,
      2.696627,
      2,
      4.165720,
      4.568064,
      3.395225,
      2.367378,
      5.632100,
      7,
      2.329469,
      NULL,
      6,
      7.611995,
      9,
      NULL,
      3,
      4,
      4.955833,
      NULL,
      4.492086,
      1,
      2,
      NULL,
      NULL,
      4,
      3.819662,
      NULL,
      8.231564,
      0.715666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.281984,
      NULL,
      5,
      2.272094,
      NULL,
      4.557342,
      3,
      0.541785,
      1,
      NULL,
      7.539326,
      4.253307,
      6.261210,
      0.573624,
      1,
      3.462062,
      3.140778,
      2.752205,
      3.691538,
      0.001181,
      2.496697,
      0,
      0.639158,
      NULL,
      NULL,
      NULL,
      10,
      3,
      1,
      1.942827,
      3,
      1,
      2,
      1,
      NULL,
      4,
      2.199896,
      2,
      6.849944,
      0.398455,
      0,
      3,
      7.676527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9.737160,
      4,
      5,
      1,
      3,
      NULL,
      NULL,
      1.698703,
      NULL,
      4,
      2.547993,
      NULL,
      0.820727,
      1.150579,
      NULL,
      0,
      NULL,
      NULL,
      1.513824,
      NULL,
      NULL,
      1,
      3.866417,
      6,
      5,
      0,
      2,
      NULL,
      5.972936,
      4,
      2,
      1.619303,
      1.933303,
      NULL,
      1.161445,
      1.061443,
      1.013852,
      3.403705,
      1.611979,
      1.644696,
      0,
      1.586200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.983849,
      1.898766,
      0,
      3.356141,
      3,
      3.104318,
      1,
      1.683118,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.885852,
      0,
      0,
      0,
      0,
      1,
      1.530698,
      1,
      8.437239,
      NULL,
      4.683473,
      1,
      1.214837,
      1,
      0,
      2.355043,
      NULL,
      NULL,
      0,
      0.757041,
      1,
      1.636808,
      1.629723,
      1.502173,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.742833,
      0.509121,
      7,
      3,
      8,
      5.901965,
      1.343281,
      3.376910,
      NULL,
      4.798831,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      4.850129,
      4,
      7.363068,
      NULL,
      5.543139,
      NULL,
      5,
      4,
      4.808523,
      3,
      2,
      3.024438,
      4.806437,
      3,
      2.587832,
      1,
      1,
      4,
      4,
      0,
      5.213495,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.047200,
      8.761002,
      8.438906,
      3.451831,
      NULL,
      1.285818,
      9.856580,
      1,
      1.653932,
      1,
      3.819202,
      NULL,
      11,
      1.715386,
      1,
      6,
      9,
      0,
      6.149484,
      2.784834,
      6,
      0.019153,
      NULL,
      9,
      7.230921,
      10,
      NULL,
      2,
      NULL,
      NULL,
      8.310373,
      5.496198,
      2.300836,
      NULL,
      0,
      4,
      6.725098,
      3.443216,
      NULL,
      5,
      9.831094,
      5.011887,
      6.404427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.072623,
      3.361846,
      2,
      5,
      8,
      NULL,
      2.187020,
      7.854228,
      5.113577,
      6,
      1,
      NULL,
      NULL,
      5,
      4,
      9,
      7.351890,
      NULL,
      2,
      7.835196,
      6,
      2.198449,
      5,
      3.712841,
      5,
      5,
      NULL,
      9,
      5,
      5,
      3,
      9,
      9,
      4,
      1.661433,
      7,
      7,
      1,
      5,
      5,
      3.806249,
      NULL,
      0.647014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.062024,
      2,
      6,
      2,
      7.867686,
      7,
      5.939638,
      0,
      6.856082,
      1,
      5,
      NULL,
      NULL,
      NULL,
      2,
      3.242070,
      NULL,
      3,
      2,
      3.435333,
      4,
      0,
      4,
      0.856219,
      5,
      3,
      NULL,
      NULL,
      0,
      0,
      3.715243,
      5,
      2.767984,
      5.583151,
      0,
      0.898036,
      5,
      NULL,
      1,
      7,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      10,
      0.657443,
      9,
      4.320616,
      6.615157,
      4,
      6.875565,
      0.800092,
      0.720680,
      0,
      5,
      4,
      NULL,
      4.835200,
      NULL,
      5.443972,
      0.730844,
      1,
      4,
      0.579885,
      1.710587,
      NULL,
      5.488755,
      NULL,
      0.192588,
      6.390742,
      NULL,
      NULL,
      3,
      0.286932,
      3.869477,
      6.862182,
      0.572814,
      3.750900,
      3.651513,
      0,
      2,
      0.748881,
      2,
      0.820350,
      0.629955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.579452,
      1.799211,
      0.238375,
      1,
      1.667113,
      1,
      1.612153,
      1.029301,
      0,
      0.411533,
      1,
      1.504343,
      0.689590,
      1.539074,
      0.954194,
      0,
      0.851234,
      0,
      1.851554,
      1,
      NULL,
      0.147706,
      1.778087,
      0,
      NULL,
      0.879539,
      NULL,
      1.097415,
      1.033756,
      NULL,
      0,
      NULL,
      0.080257,
      1.969605,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1.877734,
      0,
      0,
      NULL,
      0.719383,
      0.449275,
      NULL,
      1,
      NULL,
      1,
      1,
      1.077306,
      1.093176,
      0.333144,
      0,
      1,
      NULL,
      0.225808,
      1.806782,
      1,
      0.558823,
      0.353625,
      1.961626,
      1,
      0.315241,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.078635,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.288507,
      1.557668,
      1,
      NULL,
      NULL,
      0.660839,
      NULL,
      0.496893,
      1.936971,
      1,
      1,
      3,
      NULL,
      NULL,
      2.170727,
      1.210800,
      7.820486,
      NULL,
      1.823275,
      0,
      0.765890,
      1,
      4.551802,
      NULL,
      1.566774,
      5,
      4,
      3.689500,
      0.480818,
      NULL,
      1.439907,
      0.594739,
      4,
      NULL,
      0,
      1.162130,
      1,
      NULL,
      0.130335,
      0.330783,
      NULL,
      2.103380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      3,
      4,
      5,
      2,
      2.478637,
      2,
      4.214486,
      5,
      1,
      4,
      10,
      2,
      5.558678,
      0.632703,
      0,
      1.410230,
      0,
      NULL,
      2,
      NULL,
      0,
      1.749663,
      NULL,
      4,
      5,
      2.756991,
      NULL,
      0,
      NULL,
      2,
      4.667150,
      1.846616,
      0,
      1.885310,
      2,
      0.833590,
      NULL,
      0.506509,
      5.804781,
      0.338479,
      3.393417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      3,
      2,
      0,
      9.813206,
      NULL,
      6,
      NULL,
      2,
      2,
      7.368986,
      5.032969,
      NULL,
      4,
      0,
      5,
      3.978242,
      5.136328,
      3.273546,
      4,
      5,
      2,
      NULL,
      8,
      NULL,
      7,
      6,
      3,
      1,
      4.309928,
      6.983107,
      4.600048,
      0,
      2,
      1,
      NULL,
      NULL,
      4.125480,
      5,
      11.867858,
      4.314422,
      6.480804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.709028,
      1,
      7,
      NULL,
      7.424882,
      8.999216,
      NULL,
      2,
      4,
      3.858199,
      3,
      7,
      5.146091,
      5.013290,
      0,
      9,
      2.956654,
      8,
      6,
      NULL,
      7,
      NULL,
      NULL,
      0.121749,
      1.427986,
      NULL,
      9,
      NULL,
      8,
      4.627879,
      9.394972,
      NULL,
      1.436937,
      5.639716,
      4.116994,
      3,
      3,
      2.109243,
      NULL,
      4,
      8.428842,
      NULL,
      5.094517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1.975251,
      0,
      5,
      NULL,
      1,
      1,
      1,
      NULL,
      1.654650,
      1,
      1,
      0.960237,
      0.982512,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.614708,
      1,
      1.327636,
      NULL,
      0.052779,
      1.303853,
      0.565739,
      1.612241,
      NULL,
      1,
      0.680439,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409747,
      0,
      0.757045,
      4,
      3.270313,
      5.858519,
      0,
      NULL,
      2,
      1,
      1.144306,
      4,
      2,
      2,
      3.149703,
      4.360534,
      4.735883,
      5.547228,
      1.876341,
      0.163140,
      0,
      1,
      NULL,
      0.198963,
      1,
      0.008568,
      NULL,
      3,
      1.850754,
      3.070239,
      1.246716,
      4.233014,
      1,
      3.517469,
      0.396198,
      0,
      0.255576,
      NULL,
      0.291084,
      0.740722,
      3.186027,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7,
      5,
      0,
      2,
      0,
      NULL,
      6,
      2,
      2,
      2,
      3,
      0,
      NULL,
      1,
      7,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      7,
      4,
      2,
      7,
      7,
      5,
      2,
      4,
      3,
      2,
      7,
      7,
      6,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2,
      1,
      3,
      1,
      6,
      1,
      NULL,
      2,
      NULL,
      1,
      5,
      2,
      1,
      NULL,
      4,
      3,
      7,
      4,
      4,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      4,
      3,
      2,
      5,
      NULL,
      2,
      5,
      3,
      0,
      2,
      2,
      4,
      4,
      4,
      1,
      2,
      0,
      1,
      0,
      0,
      5,
      3,
      5,
      0,
      2,
      1,
      3,
      NULL,
      1,
      3,
      2,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 6-1992',
      NULL,
      ' 6-10-1996',
      NULL,
      '10- 7-1994',
      ' 7- 4-1989',
      ' 1-22-1997',
      '11-10-1983',
      ' 3-18-1986',
      ' 4- 9-2003',
      '11- 6-1999',
      ' 6- 5-1998',
      NULL,
      ' 3- 3-1994',
      '11-19-1996',
      ' 6- 9-1983',
      '10-25-1993',
      ' 3- 0-1975',
      ' 1-27-1992',
      ' 3-11-1986',
      ' 5-10-1984',
      ' 0-18-1991',
      NULL,
      NULL,
      ' 5-18-1999',
      ' 6-12-1987',
      ' 3-11-1987',
      ' 0-15-1976',
      ' 3-12-1996',
      '11-29-1987',
      ' 9-11-2003',
      ' 0-15-1976',
      NULL,
      NULL,
      ' 0-20-1994',
      NULL,
      ' 6-21-1997',
      ' 0-14-2000',
      '11-19-1990',
      NULL,
      NULL,
      ' 0- 7-1989',
      NULL,
      ' 0- 8-1997',
      NULL,
      ' 7-24-1992',
      ' 4- 0-1992',
      ' 7- 9-1986',
      ' 9- 4-1998',
      ' 0-26-1994',
      '11-10-1996',
      NULL,
      ' 3-22-1979',
      ' 4-15-2001',
      ' 6- 3-1996',
      ' 1-26-1980',
      ' 2- 2-1990',
      '10-11-1981',
      ' 5- 1-1974',
      ' 6-20-1988',
      ' 5- 3-1981',
      ' 6-10-1987',
      ' 0-26-1988',
      '10- 6-1986',
      ' 6-26-2002',
      ' 1-26-1983',
      ' 1- 0-1999',
      NULL,
      ' 2-15-1989',
      '10-29-1982',
      ' 3- 3-1976',
      NULL,
      NULL,
      ' 1- 3-1980',
      '10-26-1992',
      NULL,
      NULL,
      ' 0-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


