set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '0300102',
      0,
      NULL,
      0,
      '10014',
      0.957378,
      ' 1-10-1995',
      51.301305,
      NULL,
      15.254423,
      2,
      2,
      0,
      NULL,
      0.450192,
      1.098283,
      2.014005,
      0.696027,
      0,
      3.586081,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      41,
      7.009333,
      NULL,
      0.120927,
      NULL,
      9,
      4,
      1.634228,
      NULL,
      NULL,
      NULL,
      0,
      4,
      5,
      3,
      NULL,
      0,
      0,
      0,
      2,
      0,
      NULL,
      1,
      2,
      2.761939,
      NULL,
      5,
      0,
      0,
      0.627980,
      1.081964,
      0.960563,
      1,
      6,
      0,
      1.863906,
      1,
      NULL,
      3.488221,
      6,
      0,
      4,
      3.413653,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.290871,
      0.336268,
      NULL,
      1,
      1,
      3,
      1,
      23,
      58.565599,
      0.373272,
      NULL,
      3,
      187.035046,
      2.113104,
      NULL,
      1.067818,
      2,
      NULL,
      0,
      NULL,
      123,
      0,
      0,
      3,
      58.807499,
      NULL,
      3.072419,
      0,
      NULL,
      NULL,
      2.576909,
      1.240014,
      203.756063,
      23,
      2.735313,
      4,
      NULL,
      33,
      3,
      3.765322,
      283,
      NULL,
      1.452930,
      1,
      207,
      2.773871,
      3,
      2.631283,
      16.916298,
      NULL,
      NULL,
      NULL,
      175.754987,
      36.025733,
      3.530880,
      NULL,
      159,
      5.247312,
      1,
      8,
      487,
      NULL,
      1.098295,
      NULL,
      NULL,
      10,
      0,
      6.682682,
      39,
      8.600217,
      1.037053,
      NULL,
      130,
      46,
      NULL,
      1,
      NULL,
      585,
      1,
      5,
      NULL,
      NULL,
      2,
      4,
      119.776601,
      16,
      2,
      6.753968,
      NULL,
      0.238783,
      3.292673,
      1.599517,
      124.188520,
      NULL,
      0,
      1.228999,
      340,
      NULL,
      3,
      0.438516,
      NULL,
      28,
      1,
      5.624932,
      89,
      389,
      NULL,
      3,
      NULL,
      596.603436,
      1,
      0.309184,
      101.800414,
      3,
      0,
      1.148016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.529433,
      NULL,
      '00211',
      '10142',
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.311619,
      '',
      '',
      '',
      4,
      3,
      NULL,
      1.107005,
      120,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.766884,
      NULL,
      1.541163,
      NULL,
      1,
      NULL,
      0.979675,
      67.726128,
      0,
      NULL,
      NULL,
      NULL,
      0.366584,
      6.730842,
      3.377241,
      7,
      9,
      0,
      7,
      13,
      NULL,
      11,
      NULL,
      4.239258,
      NULL,
      17.384555,
      8,
      11,
      1,
      5,
      7.461756,
      15,
      1.761908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.678163,
      17,
      13,
      3.148858,
      NULL,
      1,
      28.284229,
      22.340777,
      8,
      31,
      21.010836,
      NULL,
      42.994585,
      28,
      3.340968,
      NULL,
      4.173474,
      2.093166,
      6.109361,
      12.813484,
      8,
      11.818481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      1,
      81.878262,
      34,
      NULL,
      109.798615,
      62,
      29.086921,
      62,
      NULL,
      8,
      41,
      NULL,
      56,
      16.835049,
      91.130650,
      NULL,
      164,
      39,
      NULL,
      173.751052,
      138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.259562,
      3.457046,
      3,
      1.536248,
      0.265823,
      1,
      NULL,
      2.146758,
      2,
      9,
      8.346054,
      4,
      6,
      NULL,
      3,
      2.038334,
      5,
      8,
      7,
      4.156125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.262962,
      NULL,
      0,
      1,
      5.288737,
      7.894563,
      0,
      3.182490,
      4,
      4.231462,
      7.619184,
      3,
      5.089922,
      3.593575,
      NULL,
      6.407154,
      3.231260,
      3.918856,
      4.876974,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1.447757,
      1.393751,
      3.772759,
      3,
      NULL,
      NULL,
      2,
      0.230077,
      1.710376,
      1.444615,
      1.588072,
      1.947749,
      0,
      0,
      2,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.749749,
      1,
      0.733671,
      0.520719,
      3,
      0.997060,
      6.894922,
      1.687578,
      1.938830,
      2.344521,
      0.820046,
      1,
      1.752884,
      1.914491,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399103,
      1,
      NULL,
      2.648333,
      5.567927,
      NULL,
      2.287442,
      0.720044,
      6.142131,
      NULL,
      5,
      7,
      0.025251,
      5.533783,
      7,
      4.196650,
      6.721977,
      NULL,
      6.580288,
      1.666215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      4.444113,
      5,
      2.199692,
      1.248353,
      NULL,
      NULL,
      NULL,
      0.857213,
      5,
      4,
      5.621885,
      7,
      8,
      3.557249,
      5.208873,
      2,
      2,
      9.370411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031034,
      1,
      0,
      3.934711,
      NULL,
      5,
      0,
      4,
      1,
      5,
      NULL,
      2,
      0.869156,
      6,
      2.966087,
      3,
      3.534958,
      0.365411,
      2,
      5.940209,
      4,
      7.957485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.758407,
      1.368219,
      3,
      3.541284,
      1,
      2.335205,
      1,
      6,
      NULL,
      0.977764,
      0.208730,
      1.978799,
      5,
      7.350551,
      3.516376,
      7.748231,
      4,
      0.464664,
      NULL,
      5,
      8.843252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2.044567,
      9.145149,
      1.920808,
      3.444202,
      2,
      7.169696,
      NULL,
      1.235047,
      NULL,
      8,
      3.572763,
      2.928439,
      1.119952,
      NULL,
      NULL,
      NULL,
      2.772687,
      NULL,
      1.512605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148139,
      0,
      0.591402,
      1.729968,
      0.306862,
      0.697652,
      NULL,
      NULL,
      NULL,
      0,
      1.024624,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.562353,
      0,
      0.767348,
      0.966769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.416224,
      0,
      1.819235,
      NULL,
      1.782419,
      1.998508,
      0.492059,
      1,
      0.260722,
      0,
      1.722485,
      1.578519,
      NULL,
      NULL,
      NULL,
      1,
      1.800852,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799317,
      0.313343,
      0.313104,
      3.685590,
      1.486595,
      0.032717,
      NULL,
      1,
      1.525350,
      2.247678,
      3.498628,
      0,
      4.703795,
      2.597145,
      6,
      0,
      0.239101,
      NULL,
      3.585385,
      6,
      2.317852,
      1.262943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000579,
      0,
      2.519888,
      0,
      2,
      2,
      1,
      3,
      3.730484,
      NULL,
      NULL,
      2.401778,
      1.118465,
      NULL,
      1,
      2.092772,
      2.383978,
      0.717877,
      0,
      2,
      3,
      3.997701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790974,
      0.336925,
      0,
      6,
      3.420723,
      2,
      5.679020,
      2.784831,
      6.529644,
      0.183027,
      5,
      8,
      4,
      4,
      0.657467,
      NULL,
      2,
      6,
      6.591033,
      9,
      4,
      9.082790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.155549,
      NULL,
      3.562164,
      1.014375,
      1,
      NULL,
      3.218047,
      NULL,
      7.338358,
      0.091170,
      NULL,
      7,
      5.736132,
      4.953346,
      NULL,
      2,
      2.015851,
      1.734817,
      5.846002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909477,
      1.973807,
      0,
      1,
      0,
      NULL,
      0.642503,
      1.777727,
      0.893667,
      1,
      NULL,
      1.645604,
      1,
      NULL,
      1,
      1.802261,
      0.165608,
      1,
      NULL,
      1,
      1.321858,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693624,
      0.822246,
      0.365606,
      1.432309,
      4,
      1,
      1,
      1,
      0.111263,
      1.376896,
      3.722893,
      0,
      4,
      1,
      0,
      NULL,
      2.202080,
      3.328200,
      0,
      1,
      3,
      3.939108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      2,
      NULL,
      1,
      3,
      1,
      0,
      0,
      2,
      1,
      NULL,
      0,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      1,
      1,
      5,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      3,
      2,
      1,
      3,
      0,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 9-2002',
      '10-28-1986',
      NULL,
      ' 0- 0-1977',
      ' 1- 9-1993',
      ' 9- 8-1985',
      NULL,
      ' 0- 3-1992',
      NULL,
      '10-16-1989',
      ' 1-24-1993',
      NULL,
      ' 4-25-1986',
      ' 7-21-1985',
      ' 7-13-1997',
      ' 6-15-1983',
      ' 1-23-1986',
      ' 1- 6-1997',
      NULL,
      NULL,
      ' 4- 1-1978',
      ' 7-10-1993',
      ' 6-18-2003',
      ' 0- 4-1998',
      ' 2-17-1992',
      '10- 7-1992',
      '10- 8-2000',
      NULL,
      NULL,
      '11-12-1992',
      '10- 9-1999',
      '10- 3-1985',
      ' 4-23-1996',
      ' 0-12-2001',
      ' 6-19-1975',
      NULL,
      ' 0- 1-1986',
      NULL,
      ' 5- 2-1975',
      ' 1-21-1990',
      ' 7-27-1991',
      ' 4- 5-2001',
      ' 0- 4-1977',
      '11-11-1990',
      NULL,
      NULL,
      '11- 1-1975',
      ' 5-26-1984',
      ' 1-13-1999',
      NULL,
      ' 9-11-1994',
      NULL,
      ' 8-11-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


