set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611946';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '2413224',
      0,
      2,
      2,
      '32332',
      2,
      NULL,
      124,
      NULL,
      1,
      2,
      0.494968,
      0,
      0.880353,
      0.684564,
      0,
      3,
      3,
      1.121309,
      NULL,
      8,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.539357,
      3,
      1,
      3.104677,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      1.781945,
      1,
      1.820467,
      3,
      0,
      1.967816,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      65.243700,
      128,
      18.572324,
      0.821033,
      6,
      212,
      0,
      1,
      1,
      155.731106,
      8.618272,
      2.751133,
      2.207189,
      50,
      21.126775,
      NULL,
      5.127767,
      83,
      44,
      1,
      0,
      208,
      27,
      2,
      1,
      NULL,
      63.625911,
      0,
      NULL,
      99,
      5,
      0.753086,
      3.043805,
      198.676721,
      NULL,
      3.373747,
      3,
      NULL,
      54,
      NULL,
      NULL,
      67.871373,
      61,
      1,
      7.362905,
      37,
      63,
      NULL,
      4,
      131.066068,
      NULL,
      3.622165,
      8,
      85,
      5,
      1,
      1.077524,
      NULL,
      6.529595,
      0,
      0,
      214,
      15.102819,
      1.704564,
      6.128702,
      30.655997,
      24,
      3.081362,
      3,
      59,
      147,
      0,
      1,
      125,
      276,
      NULL,
      NULL,
      209,
      383.741446,
      6.387631,
      7,
      148,
      411.856898,
      NULL,
      4.129095,
      109.582883,
      292,
      6,
      2,
      130,
      6.497021,
      NULL,
      4.581469,
      97,
      15.693693,
      3,
      0,
      142,
      105.656111,
      3,
      4.883191,
      NULL,
      455.930555,
      2.482671,
      3,
      420.300980,
      27,
      0,
      2.537649,
      837,
      577,
      1,
      4,
      NULL,
      561.452781,
      NULL,
      7.111734,
      NULL,
      259.210908,
      3.887533,
      NULL,
      278.040434,
      247,
      2,
      NULL,
      139.359587,
      18,
      0,
      2,
      256.486377,
      796,
      1,
      7.907096,
      411,
      76,
      2,
      0.116059,
      NULL,
      15,
      NULL,
      2,
      NULL,
      81.906718,
      1,
      3,
      NULL,
      59,
      3.804787,
      4.110440,
      NULL,
      282.523160,
      0,
      3,
      419.618767,
      73.784927,
      2,
      4.083619,
      286,
      11.210302,
      0.778123,
      2,
      136,
      3.761303,
      0.223265,
      0.940512,
      4,
      18,
      3,
      2.917792,
      365.474632,
      32,
      1,
      5,
      224,
      61,
      NULL,
      2.499333,
      1259,
      3.893009,
      1,
      NULL,
      NULL,
      0,
      2,
      3.638886,
      404,
      3,
      0,
      4,
      229,
      2,
      3.719691,
      4.550860,
      180.505436,
      NULL,
      2.601887,
      NULL,
      152.257844,
      5.020028,
      NULL,
      0.979154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '30321',
      '',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      5,
      '33332',
      '21340',
      NULL,
      3,
      0,
      NULL,
      3,
      2205,
      NULL,
      NULL,
      0.671223,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.509741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-2001',
      3,
      NULL,
      6.749059,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7.226469,
      0,
      9,
      2,
      4,
      9,
      3,
      5.360772,
      6,
      5,
      7,
      0,
      1,
      5.131881,
      1.489264,
      NULL,
      2,
      2.898307,
      NULL,
      1,
      8,
      NULL,
      6,
      15.582835,
      13,
      12.226560,
      NULL,
      8.675855,
      5,
      7.891049,
      5.231653,
      9.612247,
      0,
      NULL,
      14,
      4,
      17.489401,
      19.886760,
      NULL,
      15.287146,
      5,
      8,
      NULL,
      12,
      NULL,
      21,
      NULL,
      1,
      2.216218,
      NULL,
      3,
      2,
      0.035502,
      5,
      NULL,
      20,
      2,
      2,
      3,
      0,
      1,
      3.895711,
      1,
      0.650854,
      1.440509,
      0,
      NULL,
      2.302120,
      NULL,
      2,
      1.574011,
      10.094349,
      26,
      NULL,
      NULL,
      2,
      2,
      1,
      2.265479,
      22.172008,
      10.522399,
      45.830812,
      17,
      4.352512,
      3,
      NULL,
      10,
      NULL,
      2.812758,
      3,
      NULL,
      18.692393,
      0,
      28.516269,
      23.899723,
      14.937319,
      7.346874,
      99,
      83.306805,
      51.964954,
      122,
      138,
      27.825856,
      NULL,
      0,
      34,
      137,
      137.679289,
      58.718372,
      23.904828,
      NULL,
      21.427501,
      138,
      7,
      87.925727,
      113,
      100.147965,
      43.918564,
      135.844159,
      106.173849,
      59.410724,
      76,
      45,
      NULL,
      62.445251,
      105,
      NULL,
      99,
      35,
      14.881847,
      117,
      32,
      49.607193,
      150.173934,
      25,
      90.869330,
      187.336062,
      11.952668,
      NULL,
      77.437644,
      177.532061,
      188.139465,
      93,
      63,
      16.171237,
      166,
      92,
      172.287095,
      5.833166,
      3,
      5,
      7,
      5,
      NULL,
      5.133674,
      6,
      2,
      7,
      6.651513,
      4,
      7,
      NULL,
      0.329612,
      5,
      0.305451,
      7,
      8,
      0,
      NULL,
      2.345157,
      9.677089,
      NULL,
      2,
      7,
      NULL,
      9.512386,
      NULL,
      NULL,
      4,
      11,
      NULL,
      9.372642,
      6.123232,
      4,
      0,
      NULL,
      8.192131,
      7,
      6.068265,
      11.034761,
      NULL,
      2,
      9.735780,
      2,
      1.834234,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      11.744818,
      7,
      9,
      5,
      3,
      0.833243,
      NULL,
      10.900566,
      NULL,
      7.306356,
      NULL,
      1.960622,
      7,
      1,
      9,
      7,
      2.792397,
      8.374707,
      8.147452,
      5,
      NULL,
      11.715299,
      7.324935,
      3,
      6,
      5.050366,
      7,
      7,
      0.648702,
      NULL,
      10.125004,
      NULL,
      NULL,
      NULL,
      2.487964,
      8.702826,
      5,
      8.845566,
      6.092557,
      10,
      1,
      5.858316,
      NULL,
      7.225869,
      1.076385,
      5.335475,
      5.186235,
      0.226000,
      7,
      5.834379,
      6.585741,
      1.674998,
      0,
      2.796720,
      1,
      5,
      3.284030,
      0,
      1.958594,
      4,
      0.610002,
      1.074540,
      NULL,
      2,
      0,
      4,
      1.465013,
      5.656971,
      NULL,
      0.056924,
      1,
      4,
      1.072506,
      0.912194,
      1.550513,
      3,
      1.940585,
      0.125215,
      5.796996,
      1,
      1.292232,
      1,
      5.210236,
      1.146261,
      NULL,
      0.524923,
      NULL,
      0,
      1,
      3,
      1,
      0,
      2,
      0,
      1.115295,
      NULL,
      5.660905,
      0.616780,
      0.654449,
      3.405550,
      0,
      7.599288,
      NULL,
      5.133123,
      7,
      4.696885,
      0.915064,
      1,
      4.647720,
      NULL,
      2,
      4.771461,
      NULL,
      NULL,
      2.461507,
      0,
      2.059926,
      2.489901,
      1.163743,
      4.373490,
      2.717484,
      NULL,
      3.498839,
      2.147734,
      NULL,
      6,
      5,
      7.002601,
      4.090092,
      NULL,
      5,
      4.677357,
      5.400555,
      NULL,
      3.668190,
      2,
      1.865162,
      2,
      0.707082,
      2,
      1.817869,
      1,
      4,
      3.303923,
      4,
      4,
      2.737247,
      4.516334,
      2.139154,
      4,
      4.503329,
      3,
      NULL,
      0,
      0,
      0.424902,
      4,
      0,
      1,
      NULL,
      NULL,
      0.118679,
      1.740068,
      5,
      1.788678,
      2,
      NULL,
      2.670741,
      1.773898,
      0.714568,
      0,
      3.869399,
      1,
      NULL,
      1.868778,
      NULL,
      NULL,
      4,
      1,
      3.446243,
      1.386403,
      1,
      5.636827,
      1,
      5.065170,
      0,
      5,
      NULL,
      5,
      1.439112,
      5.875873,
      1.945451,
      0,
      3,
      NULL,
      1,
      NULL,
      2,
      2.307173,
      0.447789,
      NULL,
      0,
      3.609873,
      1.752566,
      5,
      1.463094,
      0,
      3.221137,
      NULL,
      0.175807,
      0.221020,
      8,
      2.468986,
      0,
      3.212010,
      7.080529,
      3.144341,
      2.876515,
      1,
      3,
      3.098580,
      7.990063,
      2.074680,
      0.741679,
      4,
      5.398065,
      NULL,
      8,
      1.933246,
      5,
      3,
      NULL,
      4.149200,
      4,
      8.695472,
      3,
      6,
      2,
      4.610000,
      2.360038,
      1,
      6.112180,
      NULL,
      5,
      1.570116,
      NULL,
      3.819024,
      NULL,
      0.491313,
      5,
      3,
      6,
      5.765699,
      4,
      4,
      6,
      5,
      2.603003,
      4,
      4.367681,
      4,
      7.381863,
      6.123015,
      4.529598,
      5.260177,
      NULL,
      NULL,
      4,
      6,
      NULL,
      6.239335,
      7,
      2,
      5.626886,
      1,
      5,
      NULL,
      7,
      0.348626,
      6,
      0.336574,
      6.908666,
      1,
      4.254578,
      7,
      2.590856,
      NULL,
      5.866204,
      NULL,
      7,
      0,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      9.125302,
      NULL,
      NULL,
      3,
      1,
      NULL,
      5.850341,
      5,
      4.556240,
      2.253486,
      NULL,
      NULL,
      4,
      0.005718,
      1.114939,
      1,
      1.701395,
      1,
      2.800519,
      5,
      NULL,
      NULL,
      6.366197,
      1,
      5.669225,
      NULL,
      4.033057,
      0,
      3.575431,
      0,
      1.573755,
      0.494250,
      5,
      0.936945,
      1,
      1.710303,
      0,
      5.574008,
      0,
      4.352321,
      4,
      4,
      1.964845,
      4,
      NULL,
      0,
      3.123033,
      NULL,
      2.429215,
      0.391732,
      5,
      1,
      NULL,
      1,
      2.773551,
      2.623642,
      NULL,
      1,
      2,
      4.106784,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.609577,
      7,
      2.902759,
      NULL,
      0,
      3.340719,
      1,
      NULL,
      7.974662,
      NULL,
      7,
      3.314864,
      1,
      2,
      2.307271,
      1.960304,
      7,
      5.021452,
      5.279273,
      4,
      NULL,
      2.927507,
      NULL,
      4.181021,
      NULL,
      4,
      1.935045,
      4,
      0,
      4.954023,
      NULL,
      1.205243,
      5.778935,
      6.719057,
      3.487252,
      2,
      0.087359,
      NULL,
      2.020608,
      1,
      5.275531,
      1.946783,
      3.650529,
      1,
      NULL,
      4,
      0,
      4.541781,
      3,
      6,
      NULL,
      1,
      1,
      2.117789,
      1,
      1.853710,
      2.153710,
      0,
      1.083211,
      1.760223,
      0,
      NULL,
      NULL,
      0.591868,
      1,
      0.248475,
      NULL,
      0,
      2.513392,
      0.600719,
      1.858453,
      0.400987,
      0,
      0.803226,
      3.141974,
      1.614673,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.317684,
      1.032282,
      0,
      1,
      0.371140,
      0,
      1.517687,
      1.026997,
      1,
      1.843843,
      1.077286,
      NULL,
      0,
      NULL,
      1.062828,
      0,
      0.534251,
      1.792493,
      1.983728,
      0,
      NULL,
      1.703903,
      NULL,
      NULL,
      1,
      1.355094,
      NULL,
      0,
      0.062516,
      NULL,
      0.098099,
      0,
      NULL,
      NULL,
      1.010963,
      NULL,
      0.422609,
      NULL,
      1,
      NULL,
      NULL,
      1.031662,
      0.701670,
      1,
      0.588739,
      0,
      1,
      1.764301,
      1.294922,
      0,
      NULL,
      NULL,
      0.761949,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326881,
      1,
      1.600021,
      NULL,
      0,
      NULL,
      0.173730,
      0,
      NULL,
      0.320995,
      1,
      0,
      0.147621,
      1,
      NULL,
      1.536585,
      0,
      2.431575,
      0.427156,
      1.183931,
      0.316362,
      2.206682,
      1.340411,
      NULL,
      0.662646,
      NULL,
      2.610401,
      4,
      NULL,
      3,
      2,
      NULL,
      2,
      0.944351,
      0,
      1.649271,
      0.067272,
      NULL,
      NULL,
      4,
      3,
      0.800467,
      NULL,
      3.456753,
      2,
      2.663912,
      NULL,
      1.098509,
      2.204031,
      1,
      1,
      5.381532,
      2,
      1,
      6,
      NULL,
      2,
      5,
      NULL,
      5,
      4,
      NULL,
      5,
      0,
      1,
      3.084147,
      NULL,
      1.403942,
      NULL,
      1,
      2,
      2.094993,
      3,
      NULL,
      0.925143,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.526564,
      0.133327,
      NULL,
      0.198064,
      0,
      3.141530,
      NULL,
      0.199362,
      5,
      NULL,
      1.081305,
      NULL,
      0.193727,
      1.498360,
      3,
      5,
      NULL,
      2.849795,
      NULL,
      5,
      1.482545,
      1,
      3,
      5,
      NULL,
      5,
      5,
      3.185870,
      NULL,
      5,
      1,
      3,
      1.057452,
      2,
      1.671541,
      9.568665,
      4.401088,
      NULL,
      5.959764,
      NULL,
      5,
      2,
      4,
      6,
      7,
      5.490018,
      9.168195,
      0.108550,
      4.404799,
      NULL,
      0.542226,
      1,
      0.713856,
      3.241198,
      4,
      1,
      NULL,
      7,
      5.810974,
      4.179662,
      9.859665,
      1.880824,
      6.549906,
      5,
      NULL,
      5.648187,
      6,
      7,
      1.803247,
      NULL,
      6,
      0,
      0,
      3,
      7.303996,
      7.394496,
      0,
      5,
      3.137296,
      1.193952,
      NULL,
      2.546962,
      1,
      6.819626,
      2,
      3.157435,
      NULL,
      5,
      7,
      3.937297,
      2,
      4,
      5,
      0.860210,
      5,
      3.081829,
      6.630446,
      4.739767,
      NULL,
      NULL,
      2,
      3,
      5,
      1.348624,
      NULL,
      NULL,
      5,
      4.753877,
      NULL,
      4,
      3,
      5.689495,
      NULL,
      5,
      5.119051,
      5,
      5.281600,
      4,
      1,
      2,
      4,
      NULL,
      NULL,
      1.159175,
      7.570486,
      NULL,
      7.674076,
      7,
      2,
      3.979868,
      5.295737,
      6,
      NULL,
      4,
      1,
      6.891811,
      6.619832,
      1.029522,
      0.875942,
      1.575124,
      1.712816,
      NULL,
      0,
      1.267155,
      NULL,
      0.269523,
      1.325951,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0.701412,
      0,
      1.388701,
      0.227773,
      0,
      0.949808,
      0.862026,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.310189,
      NULL,
      1,
      1.793715,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.383646,
      NULL,
      NULL,
      1,
      0.741652,
      0.539774,
      0.601065,
      0.155928,
      1.026491,
      1,
      NULL,
      0.025580,
      1.191425,
      1.635856,
      NULL,
      0,
      0,
      1.134621,
      NULL,
      4.536122,
      2.671524,
      3.316969,
      3,
      NULL,
      3.404128,
      4,
      NULL,
      1.342431,
      2,
      0,
      NULL,
      5,
      1,
      2.383951,
      0.013152,
      5.787239,
      3.928420,
      1,
      2,
      0,
      2.529431,
      3.992260,
      5,
      1.025409,
      NULL,
      1.205659,
      0,
      1.419939,
      4,
      NULL,
      0.824890,
      1.285833,
      NULL,
      3.605153,
      NULL,
      5,
      2,
      0,
      0.736683,
      NULL,
      1.066550,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      3,
      1,
      2,
      NULL,
      NULL,
      2,
      0,
      3,
      2,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      2,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      3,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      3,
      4,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      3,
      NULL,
      2,
      3,
      4,
      0,
      4,
      1,
      4,
      NULL,
      0,
      0,
      3,
      NULL,
      0,
      2,
      0,
      3,
      0,
      5,
      NULL,
      2,
      3,
      0,
      NULL,
      5,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      2,
      4,
      1,
      2,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1988',
      ' 4-22-1978',
      NULL,
      ' 0-25-1989',
      ' 0- 0-1981',
      ' 5-14-2003',
      NULL,
      '10- 2-2000',
      ' 5-13-1985',
      ' 6-10-1988',
      NULL,
      ' 4-27-1978',
      ' 7-28-1986',
      ' 9- 0-1999',
      NULL,
      NULL,
      ' 9- 0-1999',
      '10-19-1983',
      '10-21-1977',
      ' 3- 2-1986',
      ' 5- 6-1984',
      ' 6- 6-2003',
      ' 5-10-1978',
      ' 6-19-1990',
      ' 2- 4-1974',
      ' 3- 4-1987',
      ' 2-13-1980',
      ' 9-13-2003',
      '11-29-1980',
      ' 1-25-1985',
      ' 0-14-1996',
      NULL,
      '11- 5-1983',
      ' 8-24-2003',
      ' 6-18-1976',
      ' 2-25-1976',
      ' 7- 7-1994',
      ' 6-13-2003',
      ' 6-14-1984',
      ' 0- 0-1987',
      ' 1-15-1989',
      ' 5-21-1981',
      ' 0- 4-1978',
      ' 9-15-1981',
      ' 7- 6-1984',
      NULL,
      '11- 8-1988',
      ' 2- 3-1979',
      '11-19-1994',
      NULL,
      NULL,
      ' 7-24-1996',
      NULL,
      ' 8-26-1974',
      NULL,
      ' 2- 1-1974',
      NULL,
      ' 0-18-1982',
      ' 5-13-2002',
      ' 5- 8-1992',
      ' 4-18-1980',
      ' 2-18-1985',
      ' 7-27-1975',
      ' 5- 1-1978',
      ' 4- 5-1977',
      ' 1-10-1984',
      NULL,
      '10- 7-1980',
      ' 7- 9-1997',
      ' 9-23-1982',
      NULL,
      NULL,
      ' 7-28-1999',
      ' 3-13-1998',
      ' 0- 3-2001',
      ' 1-29-1990',
      ' 0- 7-1989',
      ' 4-21-1995',
      NULL,
      ' 4-23-1977',
      ' 5-22-1985',
      NULL,
      ' 3-26-1981',
      ' 9-29-1989',
      '11- 3-1990',
      ' 0- 7-1977',
      ' 7-24-1990',
      '11-12-1998',
      NULL,
      ' 0-25-1990',
      NULL,
      ' 4- 0-1976',
      '10-16-1985',
      NULL,
      NULL,
      ' 9-24-1978',
      ' 2- 8-1982',
      ' 1- 4-1995',
      ' 2- 0-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663276);
commit;
end;
/


