set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '4302432',
      3,
      2,
      NULL,
      '34310',
      NULL,
      ' 5-22-2000',
      22,
      NULL,
      0.553466,
      1,
      3,
      NULL,
      0.755682,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0.442967,
      0.286766,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968216,
      NULL,
      NULL,
      4.363083,
      3,
      NULL,
      9,
      0.060280,
      1,
      5,
      3,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      1.485371,
      4,
      NULL,
      1,
      1,
      0.076779,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      3,
      4.291395,
      NULL,
      3.481320,
      0,
      3.438486,
      3.644180,
      2,
      5.740694,
      ' 1-27-1978',
      NULL,
      1,
      NULL,
      2,
      0,
      3,
      4,
      0,
      0.000251,
      276,
      NULL,
      1.713073,
      4,
      166,
      116.110939,
      0.494057,
      1.064017,
      190.077269,
      49.936198,
      1.268412,
      1,
      43,
      3,
      1,
      4,
      155.067328,
      2.052176,
      0.297582,
      3.379220,
      381,
      1.743622,
      NULL,
      2.531280,
      1045.565786,
      53,
      2,
      3,
      204.517345,
      NULL,
      2,
      8.107031,
      1191,
      774,
      2,
      NULL,
      187,
      1,
      0,
      3,
      72,
      2.901773,
      NULL,
      6,
      NULL,
      1,
      2.728580,
      5.285005,
      280.050397,
      5,
      0,
      0.579581,
      131,
      11,
      1,
      3,
      219,
      4,
      3,
      1.191880,
      18.332157,
      NULL,
      NULL,
      2.117413,
      450,
      326,
      0.953486,
      2.494664,
      314.440553,
      4.315976,
      2.857756,
      NULL,
      338,
      0.023532,
      0,
      0.395946,
      NULL,
      NULL,
      0.377268,
      NULL,
      303,
      442,
      1.781506,
      2.081093,
      238,
      NULL,
      3,
      0.460405,
      487.331496,
      NULL,
      0,
      2.992319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.649371,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.486192,
      '',
      '',
      '',
      0.832801,
      '',
      '',
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.676476,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.212043,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.215095,
      12.063580,
      5.599205,
      NULL,
      3,
      NULL,
      1,
      7,
      NULL,
      3,
      8,
      0,
      2,
      NULL,
      16,
      NULL,
      3.762406,
      16,
      NULL,
      NULL,
      2,
      1.608167,
      1.504421,
      5.250041,
      0.649601,
      2,
      3.516047,
      3.605397,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.367292,
      22.573305,
      24.397906,
      22.593774,
      NULL,
      30.227806,
      NULL,
      23.350596,
      29.299030,
      0.386470,
      14,
      32,
      NULL,
      19,
      NULL,
      1,
      19,
      NULL,
      16,
      5.415703,
      4.339236,
      30.083982,
      5,
      6.181333,
      15.984083,
      25.071239,
      20,
      2.201439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.241445,
      107.189978,
      110,
      33,
      41,
      132,
      66.945112,
      74,
      153.793217,
      86.213975,
      98.221516,
      NULL,
      98.880272,
      155,
      181,
      31,
      34,
      48,
      179.041523,
      132.590306,
      NULL,
      35,
      59.160526,
      146,
      169,
      155.624616,
      13,
      22.883555,
      3.294596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      5,
      8.141733,
      8,
      0.627455,
      0.247131,
      1,
      0.841370,
      0.483985,
      1,
      2.365820,
      NULL,
      1.357679,
      1.714426,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      3,
      2,
      5.726342,
      2,
      2.496393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.575229,
      5,
      4,
      6,
      1.305347,
      1.404848,
      1,
      2.007410,
      NULL,
      7,
      0.007940,
      NULL,
      2,
      1,
      NULL,
      3.722802,
      NULL,
      3,
      2.893822,
      0.659764,
      NULL,
      0.440067,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.135771,
      NULL,
      4.827521,
      2.203425,
      5.857923,
      0,
      1,
      NULL,
      5,
      5.847475,
      6.860086,
      NULL,
      4,
      1.789594,
      1,
      5,
      0.978575,
      6,
      5,
      1.672236,
      1,
      1,
      3,
      1,
      0.240399,
      0.077409,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921870,
      2.992413,
      1.599608,
      7.906939,
      6.986721,
      5,
      0,
      4.695052,
      3,
      1.715554,
      0.176857,
      0,
      2,
      3.079333,
      0,
      2,
      0.279757,
      0,
      NULL,
      NULL,
      1.062519,
      1,
      0,
      0.882608,
      0,
      NULL,
      1.837211,
      0.973803,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855156,
      NULL,
      0,
      3,
      NULL,
      3,
      3,
      2,
      NULL,
      4.870310,
      NULL,
      0.968327,
      3,
      4.663154,
      3,
      3.731733,
      5,
      2,
      0,
      5.968753,
      1,
      1.432583,
      0,
      0,
      0.367526,
      0,
      1.132019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      3.031260,
      6,
      3,
      0,
      5,
      7.566065,
      5,
      1,
      9,
      7,
      4,
      1.160886,
      3.942764,
      5,
      4,
      5,
      9.436780,
      NULL,
      3.058657,
      0,
      5.626774,
      NULL,
      0,
      6,
      2.504719,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.939647,
      5,
      3,
      6.035475,
      4.258021,
      2,
      8,
      3,
      0,
      NULL,
      NULL,
      10.526411,
      7.281627,
      8.368882,
      NULL,
      5,
      NULL,
      4,
      7.305277,
      1,
      4,
      6,
      NULL,
      2.762854,
      5.087185,
      2,
      7.069782,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.801535,
      1.396738,
      4.375588,
      4.086260,
      3.077895,
      3,
      NULL,
      4.546272,
      2,
      0,
      2,
      4.908390,
      5,
      0,
      3,
      NULL,
      4.572496,
      0,
      2.006777,
      5.448442,
      3.061401,
      5.289437,
      0,
      3.155790,
      5,
      2.089152,
      2.635939,
      0,
      1.363212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.254652,
      7.883644,
      4,
      0,
      5,
      0,
      1.839184,
      0,
      0,
      1.056021,
      NULL,
      0.762668,
      NULL,
      0.838544,
      0,
      2.490755,
      2,
      2.990594,
      5,
      NULL,
      4.542830,
      5.614979,
      1.371463,
      1.282400,
      4.853231,
      0.739765,
      0.055198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127579,
      NULL,
      0,
      0,
      2,
      NULL,
      1.097160,
      0,
      1.092949,
      1,
      1.358402,
      2,
      NULL,
      0,
      7,
      2.631550,
      3,
      4.562998,
      0,
      4.465253,
      2,
      0,
      5.530499,
      NULL,
      0.275493,
      1.607379,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988470,
      1,
      1,
      NULL,
      NULL,
      1.094563,
      0.544204,
      0,
      1.023214,
      1,
      0.111512,
      NULL,
      0.703878,
      0.430376,
      0,
      0.902773,
      1.089065,
      1,
      NULL,
      1.440949,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1.725841,
      0.227215,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528039,
      5,
      0.191657,
      1,
      NULL,
      5,
      5,
      5.406231,
      0,
      3.313498,
      2.682341,
      3.901838,
      2.221311,
      2.488088,
      3,
      NULL,
      2,
      0,
      4.397030,
      0.337305,
      2,
      NULL,
      1,
      0,
      1,
      2,
      4.987400,
      1.471692,
      0.425781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.588507,
      6,
      4,
      0.700553,
      3.448885,
      NULL,
      1,
      2.503233,
      NULL,
      1.069585,
      3.821265,
      5.966669,
      NULL,
      NULL,
      1.593955,
      1,
      NULL,
      3,
      3,
      2,
      NULL,
      1,
      1,
      0.213680,
      5.566327,
      0.124848,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.389403,
      3.451025,
      2,
      NULL,
      NULL,
      NULL,
      6,
      6.133953,
      0.612996,
      NULL,
      NULL,
      6.237628,
      3,
      3,
      NULL,
      3,
      2.021630,
      2,
      7,
      4,
      2,
      2.553467,
      1.670567,
      4,
      5,
      5,
      7,
      3.071244,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.428117,
      7.261667,
      7,
      0,
      9,
      NULL,
      0.223542,
      NULL,
      5.722394,
      2.630783,
      5,
      7.661743,
      9,
      3.375297,
      NULL,
      2,
      4.194023,
      3,
      6,
      NULL,
      NULL,
      0.978095,
      7,
      5.727017,
      7.326731,
      NULL,
      2.710394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152776,
      1.437338,
      NULL,
      NULL,
      0.539059,
      0.974649,
      0.619287,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.907549,
      1,
      0.305950,
      NULL,
      0,
      1,
      0.221308,
      NULL,
      1,
      1,
      0.405514,
      0.871673,
      0,
      0.823716,
      0.122497,
      0.016551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.512175,
      5.074383,
      0.104383,
      2,
      6,
      4,
      0,
      2.127174,
      2.961981,
      1,
      0,
      1,
      2,
      2.060641,
      2,
      4.638682,
      0,
      NULL,
      5,
      NULL,
      0.487860,
      0,
      0.642693,
      NULL,
      2.281893,
      1.355274,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      2,
      1,
      NULL,
      4,
      2,
      1,
      4,
      0,
      4,
      5,
      5,
      4,
      0,
      NULL,
      0,
      NULL,
      6,
      NULL,
      1,
      1,
      1,
      0,
      3,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      3,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      2,
      2,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1999',
      ' 8-20-1976',
      NULL,
      NULL,
      ' 3- 8-1984',
      NULL,
      NULL,
      ' 5-15-1979',
      ' 2-21-2001',
      ' 8-21-1995',
      ' 2- 3-2002',
      NULL,
      ' 8-29-1989',
      ' 2-15-1999',
      ' 5- 8-1986',
      NULL,
      NULL,
      ' 3- 5-1988',
      ' 3- 5-1997',
      ' 6- 4-1983',
      ' 7- 9-1978',
      ' 7- 2-2002',
      '11-26-1995',
      ' 0-15-1992',
      '11- 0-1999',
      ' 0- 1-2000',
      ' 3-22-1999',
      ' 6- 2-1978',
      '11-20-1980',
      NULL,
      ' 1- 6-1983',
      '11-16-1986',
      '10-19-1987',
      ' 3-14-1995',
      NULL,
      ' 4-11-2001',
      ' 2-13-2000',
      ' 0-19-1985',
      ' 2- 1-1983',
      ' 4-23-1996',
      ' 6-27-1982',
      ' 4- 8-1995',
      ' 8-20-1987',
      '11-26-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


