set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636027';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      '03214',
      3,
      ' 1-23-1996',
      NULL,
      NULL,
      0.707602,
      1,
      2.922951,
      0.058883,
      0.978458,
      1,
      1.882891,
      0.208111,
      NULL,
      2,
      1.327352,
      6,
      NULL,
      NULL,
      1.475777,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      5.963176,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      2,
      3,
      3.056034,
      1,
      NULL,
      6,
      0,
      0.120611,
      0.927917,
      1,
      2,
      1,
      2,
      1.403310,
      0,
      1,
      1.864730,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424426,
      3.102602,
      NULL,
      0,
      0,
      3.443184,
      5,
      38,
      216.252279,
      144.420286,
      0,
      2,
      NULL,
      NULL,
      1,
      0.978502,
      31.970999,
      36,
      1,
      9.679785,
      79,
      NULL,
      2.392268,
      NULL,
      159.631242,
      1.088431,
      0.585265,
      NULL,
      165,
      17.841534,
      3,
      NULL,
      119,
      10.169730,
      1.917091,
      4,
      828,
      1,
      0.337322,
      4.309572,
      169.621901,
      5.411440,
      2.115720,
      2.579378,
      344.893239,
      NULL,
      0,
      2,
      NULL,
      3.127397,
      0.776830,
      0.718129,
      229.317686,
      NULL,
      NULL,
      NULL,
      NULL,
      216,
      2,
      NULL,
      234.633413,
      NULL,
      NULL,
      0.224783,
      366,
      20.284247,
      1.380409,
      2,
      NULL,
      NULL,
      1,
      5.873821,
      171.047790,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      2.380755,
      681.037122,
      2,
      2.925789,
      8.618273,
      NULL,
      1.868649,
      NULL,
      1,
      130.360044,
      23.602480,
      1.273155,
      3.392965,
      405,
      151.129770,
      NULL,
      NULL,
      190,
      16.206522,
      3,
      3,
      15.840478,
      8.953993,
      3,
      3.944437,
      NULL,
      9,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.212163,
      '00400',
      '21331',
      '',
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      4.021219,
      '34314',
      '0300',
      '',
      2,
      2.951606,
      NULL,
      0.240210,
      NULL,
      0.337310,
      NULL,
      1,
      NULL,
      0.110721,
      NULL,
      0.273021,
      NULL,
      1.156724,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.577003,
      NULL,
      ' 8-12-1994',
      9.735526,
      0.406666,
      6.068901,
      9.305524,
      3,
      4,
      9.626353,
      11.944876,
      12.211997,
      21,
      NULL,
      20,
      4,
      10,
      NULL,
      7,
      5,
      2.138045,
      NULL,
      17.303822,
      NULL,
      0,
      4.125634,
      2,
      1,
      9.566461,
      0.321453,
      0.213590,
      10.097199,
      16.898509,
      2,
      10,
      22.489627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.910987,
      0,
      NULL,
      35.932760,
      7.337867,
      12.580370,
      18,
      17,
      43,
      NULL,
      10,
      38.190443,
      1.653874,
      10,
      1,
      21.533848,
      NULL,
      2,
      28,
      2,
      29.363579,
      9.776756,
      27.676554,
      NULL,
      10,
      NULL,
      3.954310,
      2,
      11.957526,
      NULL,
      21.774329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      137,
      152.794841,
      49,
      131.592170,
      110,
      167.102189,
      NULL,
      62,
      57,
      100.721043,
      NULL,
      113,
      NULL,
      NULL,
      40.830043,
      160,
      155,
      7.617194,
      58,
      NULL,
      NULL,
      136.990038,
      47,
      1.915316,
      160.191673,
      NULL,
      68,
      45.328707,
      1.363587,
      131,
      102,
      163.076732,
      8.822783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.282949,
      NULL,
      0.004363,
      2,
      7,
      1.098658,
      0.279815,
      2.283636,
      NULL,
      NULL,
      8,
      2.889475,
      2.936685,
      5,
      2,
      4,
      NULL,
      5.575209,
      10,
      5.100324,
      3,
      2,
      0,
      5.587718,
      NULL,
      0,
      4.149967,
      3,
      1,
      1.655988,
      0.090909,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.389501,
      NULL,
      0,
      1.965744,
      1.064074,
      NULL,
      NULL,
      1.613072,
      0,
      4,
      2.684858,
      NULL,
      NULL,
      NULL,
      1,
      1.796605,
      2,
      0,
      NULL,
      1,
      0.689727,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.584173,
      0,
      0.816876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.321803,
      0,
      8.476652,
      NULL,
      NULL,
      1.377488,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1.628637,
      1,
      NULL,
      1.138971,
      1.918601,
      0.537600,
      1,
      0,
      NULL,
      0.145662,
      1.594478,
      0.475230,
      1.165962,
      1.631123,
      1.734472,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248494,
      0,
      0.839028,
      NULL,
      1,
      0.957762,
      0.607747,
      1.218331,
      0,
      NULL,
      2.997600,
      0.683832,
      0.292130,
      1.504659,
      0,
      0,
      0.023783,
      0,
      1.458779,
      1,
      0,
      0.173766,
      NULL,
      1.720939,
      NULL,
      0.712157,
      NULL,
      0,
      1.786579,
      1,
      1.765990,
      1.006342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176908,
      1.896807,
      1.354861,
      0.321891,
      1,
      1,
      1.233495,
      0.227419,
      0.379518,
      NULL,
      NULL,
      0.229233,
      1,
      0,
      0,
      0.708909,
      1.954987,
      1.303507,
      NULL,
      1,
      0,
      1.988601,
      1,
      1.803683,
      1,
      NULL,
      1.342852,
      1,
      0.570289,
      1.537747,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.843948,
      7.618268,
      1,
      2.354948,
      1.068080,
      0,
      3,
      NULL,
      3,
      4,
      1.837608,
      7,
      NULL,
      0,
      1,
      0.140667,
      2.593605,
      1,
      NULL,
      3.382051,
      2,
      NULL,
      0.820227,
      2.636547,
      NULL,
      0.533627,
      1.305248,
      0.345961,
      0.094127,
      0.900291,
      0,
      1.213815,
      0.004503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248232,
      2.625222,
      7,
      3,
      0,
      7.881894,
      5,
      0.367346,
      5,
      3,
      NULL,
      5,
      5.206195,
      NULL,
      2,
      NULL,
      2.521396,
      5,
      5,
      4,
      0.504189,
      3,
      0.320131,
      3,
      1.060649,
      NULL,
      0.300416,
      1,
      1.761974,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.066082,
      1.883065,
      3.046162,
      0.851937,
      1,
      NULL,
      0.971097,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.376404,
      1,
      NULL,
      0.044649,
      5,
      0,
      3.583295,
      1.558286,
      NULL,
      1.377926,
      0.579140,
      1.076527,
      1.977495,
      1.321912,
      1,
      0.192475,
      1.258869,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577760,
      NULL,
      1.823761,
      1,
      0.090220,
      1.312922,
      0,
      1,
      0.376405,
      1.892589,
      1,
      0,
      NULL,
      1.848318,
      1,
      1.014126,
      0.468405,
      0.701235,
      0.393326,
      1.316382,
      0,
      1,
      1.917573,
      NULL,
      NULL,
      1.204004,
      0,
      1.183908,
      1,
      1,
      1.757919,
      1,
      0.871297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108515,
      NULL,
      1.299055,
      1.022794,
      1.794245,
      0,
      1.507238,
      NULL,
      0.598704,
      0.755493,
      0.162760,
      0,
      0.982436,
      0,
      NULL,
      0.412988,
      0.762130,
      1,
      0.009933,
      0.767970,
      0,
      0,
      1.368978,
      1,
      0.294808,
      0,
      NULL,
      0.883281,
      0,
      0.861806,
      0.792953,
      0.355465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013464,
      0,
      1.192661,
      1,
      0.861733,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.349540,
      1,
      1,
      0.971383,
      0,
      NULL,
      1.883447,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0.985851,
      0.957609,
      0.572927,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.879206,
      1.317081,
      1,
      0.883042,
      1.747846,
      3.271925,
      NULL,
      4.558969,
      2.547670,
      3,
      NULL,
      0,
      1.513888,
      0.346069,
      0,
      NULL,
      3.237193,
      0.136633,
      NULL,
      0,
      3.731896,
      5,
      0,
      0,
      1.247557,
      1.169996,
      1.239729,
      1.482802,
      1.434592,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.493237,
      NULL,
      0.476414,
      0.379345,
      1,
      NULL,
      1.795082,
      0,
      0,
      1.436562,
      1.059890,
      NULL,
      1,
      NULL,
      0.319270,
      2.470831,
      0.696475,
      5,
      5,
      NULL,
      3.984275,
      1.032645,
      0.244411,
      0.192798,
      1,
      0.119797,
      0,
      1,
      1.685197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.290204,
      3,
      2.777988,
      NULL,
      4.858168,
      8.918804,
      2.661627,
      3,
      NULL,
      2,
      1.271441,
      NULL,
      NULL,
      3.359067,
      1.270975,
      0.523938,
      7,
      4.333489,
      3,
      6.131737,
      0.612064,
      3.194502,
      1,
      NULL,
      1,
      1.993526,
      3,
      4,
      1.982527,
      1.398188,
      0.054544,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.229651,
      1.044698,
      0,
      1,
      0,
      1.515832,
      NULL,
      0.458209,
      1,
      2.942349,
      2.076499,
      NULL,
      2.702050,
      0,
      1,
      1.233698,
      4.275148,
      NULL,
      NULL,
      2.822416,
      NULL,
      2.113354,
      2.596908,
      0,
      2.738943,
      3.976247,
      1,
      1.515071,
      1,
      0,
      0.115203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202303,
      0,
      1,
      0,
      1,
      1.598171,
      NULL,
      1,
      NULL,
      1.959464,
      1.491379,
      0,
      1,
      NULL,
      1,
      0.006472,
      0.632546,
      1.703654,
      NULL,
      NULL,
      1,
      0,
      1,
      1.860178,
      NULL,
      0.637864,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1.657159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.312135,
      1.416579,
      1,
      0.628773,
      1.861197,
      1.715741,
      0.108396,
      4.161422,
      4,
      0.786291,
      NULL,
      0,
      1.784692,
      NULL,
      1,
      1.626414,
      1.488499,
      1,
      0.080193,
      0,
      0,
      0,
      0,
      1,
      1.413798,
      1,
      0.403214,
      1.851242,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      NULL,
      1,
      2,
      1,
      NULL,
      2,
      NULL,
      1,
      3,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      2,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1996',
      ' 0- 1-1987',
      ' 4-25-2001',
      ' 7-28-1993',
      NULL,
      ' 1-19-1976',
      ' 5-10-1995',
      NULL,
      NULL,
      NULL,
      ' 3-16-1974',
      NULL,
      ' 9-15-1976',
      ' 1-11-2003',
      ' 5- 5-1974',
      ' 4-10-1998',
      ' 2- 7-1979',
      ' 0- 4-1990',
      ' 3-28-2003',
      ' 0- 3-1974',
      NULL,
      ' 7-10-1999',
      ' 2- 5-1993',
      NULL,
      NULL,
      ' 8-20-1992',
      ' 2- 3-1986',
      ' 2-20-1978',
      '10- 8-1977',
      NULL,
      ' 6- 5-2003',
      ' 6-10-2002',
      ' 1-18-1996',
      ' 9-27-1992',
      ' 1-13-1987',
      NULL,
      ' 2-17-1984',
      ' 6-17-1984',
      NULL,
      ' 9-13-1978',
      NULL,
      ' 0-12-1991',
      ' 5- 9-2001',
      NULL,
      '11-25-1979',
      ' 6-14-1997',
      NULL,
      ' 5- 3-1989',
      ' 1- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-22-1978',
      NULL,
      '10-19-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


