set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637671';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      3,
      1.483741,
      2,
      '20402',
      3,
      ' 4-23-1997',
      45,
      NULL,
      NULL,
      NULL,
      2.489729,
      1.063043,
      NULL,
      1,
      2.077975,
      2.678248,
      1.123619,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.899049,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.410341,
      2.618064,
      0,
      1.804829,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      7,
      NULL,
      3,
      2,
      0.032503,
      1,
      1.728299,
      0,
      3,
      0,
      0,
      0.323388,
      NULL,
      NULL,
      7,
      7,
      9.212825,
      NULL,
      3,
      0,
      NULL,
      6.961797,
      ' 8- 5-1996',
      7.474806,
      3,
      NULL,
      0,
      NULL,
      0,
      2.694727,
      2,
      75.820345,
      176,
      NULL,
      3,
      NULL,
      NULL,
      103.064837,
      3,
      1.081765,
      32,
      2,
      2,
      NULL,
      522,
      115,
      0.580768,
      NULL,
      180,
      4,
      2.551865,
      4.754367,
      225,
      9.596243,
      2,
      4,
      220,
      4,
      0.129175,
      0.599039,
      44.598974,
      6.292760,
      0,
      2,
      21,
      NULL,
      NULL,
      0,
      133,
      1.641933,
      2,
      1.892000,
      184,
      NULL,
      3,
      2.547832,
      112.821986,
      NULL,
      1.166867,
      1,
      414,
      14.999423,
      3.787517,
      NULL,
      207,
      NULL,
      1.579636,
      6.701379,
      7.882929,
      1029,
      3.140941,
      NULL,
      NULL,
      NULL,
      0,
      8.793867,
      170,
      310.022958,
      2.857759,
      3.668168,
      396.408617,
      NULL,
      3.837219,
      1.466514,
      NULL,
      6.607151,
      3.156533,
      4,
      NULL,
      185,
      NULL,
      4,
      NULL,
      24,
      NULL,
      7.857537,
      86.171358,
      7.266660,
      2,
      NULL,
      200.359867,
      37.570352,
      0,
      3.158373,
      22.862111,
      310,
      3.167756,
      NULL,
      191.354438,
      275.179385,
      NULL,
      NULL,
      139,
      NULL,
      NULL,
      NULL,
      73.457642,
      279.555150,
      1,
      1,
      33.526652,
      75.220301,
      3,
      3,
      96.686694,
      165.579933,
      1,
      2,
      NULL,
      325.419923,
      0.876468,
      7.774531,
      162,
      120.735327,
      3.809766,
      4.773214,
      56,
      85.086089,
      NULL,
      5.754116,
      NULL,
      839.943393,
      3,
      9,
      132,
      710.578844,
      NULL,
      1,
      34.414168,
      13.244020,
      1.262192,
      3,
      340.104871,
      81,
      3.602182,
      NULL,
      105,
      28,
      3.817357,
      NULL,
      211,
      306.633600,
      0,
      6,
      NULL,
      NULL,
      3.742983,
      3,
      NULL,
      958.673783,
      1.861357,
      NULL,
      NULL,
      75.800020,
      1,
      1.931213,
      1045.027991,
      1,
      NULL,
      1.521314,
      19,
      NULL,
      1,
      NULL,
      1181,
      588,
      NULL,
      NULL,
      162.911215,
      60.705625,
      NULL,
      NULL,
      139.701585,
      57,
      4,
      2,
      NULL,
      2.523040,
      1,
      1.538926,
      146,
      8,
      0.014434,
      0,
      125,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '42012',
      '',
      '',
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      801.200978,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463642,
      NULL,
      0,
      NULL,
      0.649309,
      NULL,
      0.083966,
      NULL,
      ' 6-28-1978',
      24.664786,
      1,
      11.320203,
      9.771684,
      7,
      21,
      1,
      7.090861,
      14.926947,
      NULL,
      5.899478,
      NULL,
      NULL,
      21.546314,
      2,
      2.503085,
      1.146271,
      7.934681,
      3,
      NULL,
      1,
      0,
      4.616112,
      2,
      10,
      3.435106,
      NULL,
      23.766604,
      3.189771,
      2.187037,
      7.704459,
      0.341358,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.779962,
      9,
      16.653869,
      NULL,
      0,
      1.802603,
      NULL,
      5.511767,
      3,
      NULL,
      9.932288,
      2.601997,
      0,
      3.342683,
      0,
      11,
      27,
      NULL,
      0.978546,
      15.655447,
      NULL,
      NULL,
      0.503256,
      35.782890,
      44,
      1.826980,
      21.235237,
      10,
      7,
      24,
      17,
      6.643395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      118.957400,
      123,
      NULL,
      118.755577,
      NULL,
      44,
      69,
      6,
      NULL,
      3,
      143.283782,
      137,
      0.504384,
      134,
      65,
      147,
      7,
      63,
      156.434071,
      NULL,
      10.969156,
      77.214241,
      NULL,
      114.957590,
      NULL,
      47,
      139.686509,
      156,
      116.564453,
      99.287749,
      12.551285,
      NULL,
      34.250924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.679023,
      2.650693,
      6.218422,
      6,
      0,
      4,
      6.392936,
      1,
      7.029921,
      3.564550,
      4,
      NULL,
      9,
      5.744854,
      8.749218,
      NULL,
      5.276615,
      1,
      3.821696,
      1,
      5.392974,
      0,
      4,
      NULL,
      5.418951,
      6.771554,
      3,
      7,
      5.736751,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      5.380214,
      2,
      1.250261,
      0.580401,
      1.308404,
      3.986500,
      2,
      0,
      2,
      2,
      3.014898,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      3.504560,
      0.755579,
      7,
      3.261738,
      1,
      1,
      3,
      2.463871,
      1,
      0.051155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8.372272,
      4,
      2,
      NULL,
      7,
      2,
      1,
      5.926713,
      1,
      3,
      6.082303,
      3,
      1.955874,
      NULL,
      1.718632,
      0,
      2.963828,
      1,
      2,
      7.905491,
      5.292341,
      2.912545,
      2,
      1.237239,
      6.704668,
      2.262299,
      5.658864,
      NULL,
      5,
      4.710169,
      NULL,
      0.196832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.980698,
      6.367094,
      2,
      0.327147,
      4,
      NULL,
      2,
      2.503974,
      2.314745,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.479529,
      3,
      5,
      5,
      3.376986,
      2.372184,
      3.429072,
      2,
      1.791545,
      NULL,
      NULL,
      5.611609,
      0,
      2,
      2,
      NULL,
      5,
      0.815446,
      4.277181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249655,
      0.431652,
      3.158797,
      NULL,
      1.848731,
      3,
      6.770670,
      1.021610,
      0.464957,
      4.472998,
      5.145968,
      NULL,
      0.282172,
      3.691756,
      2,
      NULL,
      2.721143,
      0,
      3,
      2.876478,
      0.352023,
      0.232105,
      2.113991,
      2.982988,
      NULL,
      0,
      NULL,
      3,
      3,
      NULL,
      3,
      2.362657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      5,
      2.646931,
      6,
      0,
      2,
      2.491305,
      6,
      3,
      5.111071,
      6.015896,
      2,
      2.392593,
      7,
      1.700806,
      0.825087,
      7.259834,
      2.271840,
      NULL,
      2,
      5,
      4,
      0,
      8,
      3.975900,
      9.702883,
      0.208608,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822209,
      0.225492,
      2.585750,
      0.255598,
      4,
      NULL,
      3,
      4.394336,
      3.535140,
      7.965391,
      6,
      2.335686,
      7.512033,
      1,
      3.940695,
      3,
      6,
      8,
      2.315558,
      5.863024,
      2,
      6.276569,
      0,
      6,
      5,
      NULL,
      NULL,
      2,
      0.209715,
      3,
      0,
      7.131804,
      5.375377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      0,
      3,
      3,
      0.575073,
      2.467586,
      0,
      NULL,
      2.137277,
      0,
      NULL,
      2,
      2.551228,
      5,
      4.648483,
      0,
      1.967118,
      4,
      5.971293,
      3.994888,
      NULL,
      2,
      1.276767,
      NULL,
      1.561497,
      1.360381,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539248,
      NULL,
      NULL,
      NULL,
      3,
      0.135368,
      0,
      3,
      1.444233,
      3,
      2,
      0,
      0,
      1,
      1,
      2.991840,
      1.582755,
      3.977976,
      1.853690,
      1,
      3.603419,
      NULL,
      2,
      NULL,
      3.316825,
      4.268179,
      0.661272,
      0,
      0.427407,
      1,
      0,
      3.738884,
      4.919627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121349,
      0,
      0,
      0,
      0,
      0,
      1,
      0.192509,
      NULL,
      2.660765,
      0.454172,
      0,
      NULL,
      1.184654,
      1.996957,
      0.121064,
      1.896724,
      0.254508,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.756563,
      0,
      5,
      1,
      0.282467,
      2,
      4.079983,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904186,
      0.215894,
      0,
      0,
      NULL,
      1.401882,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.112950,
      0,
      0.029218,
      0,
      1,
      0,
      1.270913,
      0.611995,
      1,
      1.722577,
      1,
      0.537897,
      NULL,
      1.891557,
      1,
      1.412909,
      1,
      0,
      1.930096,
      1.614399,
      NULL,
      1.745039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.439059,
      1.171798,
      1,
      0.146833,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.606908,
      1,
      0.082864,
      0.341691,
      0,
      1.497997,
      NULL,
      NULL,
      0,
      2.406112,
      NULL,
      NULL,
      1,
      0,
      3,
      2.344141,
      0,
      0,
      1,
      2.955595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.359378,
      NULL,
      0,
      NULL,
      1.675346,
      0.731592,
      NULL,
      0,
      NULL,
      0.451934,
      0.154308,
      1,
      1,
      NULL,
      1.010981,
      0,
      0.534138,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.013284,
      0,
      0.469317,
      0,
      1.108980,
      1,
      0,
      1.851642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064643,
      0.480716,
      4.904228,
      5.703861,
      6,
      1.831967,
      6.017946,
      0.604199,
      1.992323,
      4.723284,
      7.684124,
      1.480145,
      NULL,
      4.975341,
      7,
      3,
      4.252643,
      2.456592,
      7.694850,
      0,
      NULL,
      NULL,
      5.165283,
      9.889664,
      3.170853,
      5.303573,
      NULL,
      5.437766,
      NULL,
      2.013329,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141764,
      1,
      4.428339,
      7,
      7.013918,
      6.553660,
      5,
      NULL,
      1.234333,
      2,
      3,
      3.923297,
      4.953091,
      7,
      4.226941,
      NULL,
      4.290153,
      6,
      2,
      2,
      3.007229,
      3.179201,
      0,
      4,
      NULL,
      NULL,
      3.407589,
      4,
      3,
      1,
      3.406034,
      0.660788,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.996198,
      0,
      1.848825,
      0,
      NULL,
      NULL,
      0.424162,
      NULL,
      0,
      0,
      1.847938,
      0.196238,
      1,
      NULL,
      0.918849,
      0.507618,
      1.163399,
      1,
      NULL,
      0.662504,
      0,
      0,
      1.379479,
      1,
      1,
      0.186296,
      0.503243,
      0,
      0.273626,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0.168621,
      NULL,
      0,
      NULL,
      0.819543,
      1.872934,
      1.355841,
      0.948221,
      1,
      1,
      1.508132,
      0.569794,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413173,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      3,
      3,
      NULL,
      1,
      1,
      2,
      4,
      0,
      3,
      NULL,
      NULL,
      3,
      5,
      5,
      3,
      5,
      0,
      0,
      5,
      2,
      4,
      NULL,
      NULL,
      0,
      5,
      3,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1977',
      '10-23-1979',
      ' 7-19-1979',
      NULL,
      NULL,
      NULL,
      ' 9-20-1991',
      ' 6- 4-1992',
      ' 5-29-1992',
      NULL,
      ' 2-28-1991',
      ' 9-20-2001',
      ' 6-19-2003',
      NULL,
      '10-19-1983',
      ' 0- 2-1988',
      ' 9- 9-1990',
      ' 4- 3-1992',
      NULL,
      ' 6- 1-1993',
      ' 6-16-2000',
      NULL,
      NULL,
      NULL,
      ' 6-10-2001',
      ' 9-15-1989',
      ' 7- 6-1977',
      ' 8-27-1996',
      ' 1-23-1982',
      ' 4-25-1986',
      ' 0-10-2000',
      ' 1-29-1994',
      ' 1-13-1978',
      NULL,
      ' 2-21-1981',
      NULL,
      ' 0-20-2002',
      NULL,
      '10-12-1993',
      '10-12-1989',
      ' 4- 4-1989',
      '11- 4-1990',
      '11-19-1988',
      NULL,
      '11-14-2003',
      '11-22-2000',
      ' 7-24-1984',
      '11-20-1982',
      ' 1-28-1998',
      '10-27-2003',
      ' 7-23-1990',
      ' 9-14-1988',
      NULL,
      ' 3-14-1987',
      ' 1-13-1998',
      NULL,
      NULL,
      ' 6-11-1999',
      NULL,
      ' 3-10-1990',
      ' 1-13-2002',
      ' 4- 5-2001',
      '10-11-1990',
      ' 1-13-1980',
      ' 7- 4-1982',
      ' 0-12-1988',
      ' 9- 3-1986',
      NULL,
      ' 2-14-1991',
      ' 3- 3-1976',
      NULL,
      '10-25-1989',
      ' 8- 2-1997',
      ' 2-18-1980',
      '11-25-1994',
      NULL,
      ' 5- 3-1991',
      NULL,
      '11- 4-1982',
      ' 0- 9-1986',
      '11-27-2003',
      ' 0-22-1979',
      ' 1-14-1990',
      NULL,
      NULL,
      ' 3-10-1999',
      ' 5- 4-1996',
      ' 6-22-1978',
      NULL,
      NULL,
      ' 6- 2-1987',
      ' 8- 9-1986',
      ' 4-25-1986',
      NULL,
      ' 1-20-1986',
      NULL,
      ' 5- 9-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 3-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500346);
commit;
end;
/


