set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8426905';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '3212002',
      2,
      0,
      0,
      '20040',
      NULL,
      ' 0-13-2002',
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.353929,
      0,
      0,
      0.447437,
      2.640634,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.328550,
      2.709643,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306003,
      NULL,
      7.917645,
      0.077386,
      1.704734,
      0.029198,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      4,
      5,
      7,
      3,
      1,
      1,
      0.655165,
      NULL,
      1,
      2,
      3,
      NULL,
      0,
      5,
      4.954958,
      3,
      5,
      6,
      9,
      2.652138,
      1.990168,
      12.374582,
      NULL,
      4,
      1,
      4,
      3,
      2,
      5,
      NULL,
      1,
      NULL,
      210.442627,
      11.602932,
      3.237411,
      0.818187,
      25.042125,
      1019,
      0.983533,
      8,
      14.083761,
      909.914588,
      2,
      NULL,
      NULL,
      NULL,
      2,
      0.635358,
      10.100886,
      10,
      NULL,
      NULL,
      55,
      344.228871,
      0,
      3,
      189.275652,
      124.075235,
      NULL,
      9,
      120.471503,
      190.225869,
      NULL,
      7,
      97.526258,
      NULL,
      NULL,
      4,
      86,
      784.504916,
      NULL,
      6.896319,
      6,
      181.021902,
      3.454754,
      NULL,
      180,
      21,
      1.409707,
      3,
      96,
      NULL,
      0.029717,
      2.904421,
      43,
      37,
      1,
      0,
      294,
      NULL,
      1,
      1,
      39,
      NULL,
      NULL,
      0.449835,
      229,
      2,
      3,
      NULL,
      567,
      10.246354,
      NULL,
      0.182711,
      572,
      NULL,
      1,
      3.064538,
      217,
      21.931684,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      6.238194,
      NULL,
      NULL,
      1,
      0,
      17.054417,
      11.028682,
      2.453125,
      NULL,
      539,
      243,
      2.727189,
      NULL,
      259,
      38,
      NULL,
      0,
      NULL,
      310.844435,
      NULL,
      NULL,
      315,
      64,
      3,
      3.152656,
      302.535844,
      7933,
      NULL,
      1,
      220,
      45.421847,
      3.133440,
      0.247911,
      667.507177,
      NULL,
      1,
      2.123494,
      420.474503,
      17330.307297,
      2,
      2.562274,
      8.590692,
      NULL,
      0.849773,
      NULL,
      33,
      7,
      0.939868,
      0,
      61,
      0.852753,
      1.077329,
      1,
      485.413857,
      79.191910,
      NULL,
      0.110888,
      NULL,
      NULL,
      2.417540,
      0,
      625,
      75.572836,
      3.779639,
      0.030569,
      157.535644,
      401.084698,
      0.791600,
      3,
      200.289653,
      1674.186345,
      0.678621,
      0.342830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.063355,
      '01241',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0.656555,
      '',
      '',
      '',
      1,
      1,
      NULL,
      NULL,
      532.716280,
      0,
      NULL,
      0.161718,
      NULL,
      1.015002,
      NULL,
      1.529386,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.010118,
      NULL,
      NULL,
      NULL,
      ' 2-13-1998',
      NULL,
      19.202468,
      18,
      3,
      0.418756,
      7,
      12,
      NULL,
      8,
      22.089210,
      9,
      7,
      3.312020,
      NULL,
      2.103444,
      6.643366,
      0.992950,
      16,
      9,
      7.042472,
      14,
      7.883391,
      17.956721,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.222345,
      18.279508,
      44,
      25.211984,
      21.169606,
      4,
      6,
      19,
      2.712674,
      NULL,
      NULL,
      2.228617,
      27,
      15.798282,
      2,
      NULL,
      16,
      0,
      13,
      7,
      8,
      20,
      21.293473,
      3.026359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.328620,
      37,
      NULL,
      44,
      20.193295,
      46.745177,
      126,
      66,
      71.393090,
      125.364824,
      77,
      11.044309,
      20,
      NULL,
      NULL,
      146,
      167.979207,
      57.344302,
      166.378252,
      36,
      NULL,
      NULL,
      103.032078,
      167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.413912,
      5.094931,
      3.029080,
      7,
      NULL,
      0,
      5.664874,
      6.639174,
      3.987449,
      5.351959,
      NULL,
      2.151911,
      NULL,
      1.231006,
      2,
      8,
      4.272616,
      4,
      6.809287,
      1.195872,
      0,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.387469,
      0.256080,
      0.157795,
      0.946466,
      0.530548,
      1.663287,
      0.341114,
      0.636211,
      0.051714,
      0,
      0,
      1.400053,
      0.718190,
      0.495808,
      1.183057,
      0.389398,
      1,
      0.772890,
      0,
      1,
      1.033630,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.424138,
      3,
      NULL,
      NULL,
      NULL,
      2,
      3.151025,
      NULL,
      6,
      0.452273,
      2,
      4.568118,
      4.763176,
      6,
      NULL,
      0,
      1.290912,
      3.588290,
      6.020675,
      5,
      NULL,
      2,
      5.976076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.269297,
      0,
      5,
      1.516519,
      1,
      NULL,
      5,
      1,
      5,
      NULL,
      5.513901,
      NULL,
      4,
      1.464585,
      NULL,
      2.028907,
      1.459728,
      NULL,
      4.573677,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      6,
      1.788353,
      3.724835,
      3,
      3.185306,
      5.860684,
      NULL,
      6.056798,
      8.349850,
      4.435749,
      0.238118,
      NULL,
      0.265875,
      NULL,
      9.234735,
      7.796870,
      1.648347,
      3,
      8,
      4.478230,
      5,
      7.747702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.540537,
      NULL,
      5,
      7.646550,
      9,
      4.459370,
      3,
      4,
      0.963617,
      4.333193,
      9,
      NULL,
      4,
      4.260127,
      4,
      3,
      0,
      5.969207,
      8,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.634815,
      11.216788,
      1,
      3,
      10,
      9.119628,
      5.803736,
      NULL,
      3,
      9.768200,
      9.540974,
      NULL,
      11,
      5.671763,
      2,
      1.774797,
      1,
      4.236270,
      NULL,
      NULL,
      6,
      NULL,
      6,
      4.350041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.421787,
      7,
      2,
      8,
      1.733632,
      0.267378,
      NULL,
      NULL,
      NULL,
      7,
      5,
      NULL,
      2,
      NULL,
      3,
      8.311452,
      2,
      NULL,
      NULL,
      8.444689,
      1,
      4.427467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.146340,
      2,
      7,
      2.194027,
      6.250766,
      4,
      0.941873,
      NULL,
      9,
      4,
      7,
      NULL,
      5,
      1.651263,
      5.722815,
      NULL,
      9.983262,
      2.896351,
      5.645448,
      2,
      4,
      7.583048,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188442,
      1.266410,
      1,
      NULL,
      2.163333,
      2.640109,
      NULL,
      2.978009,
      1,
      3,
      1,
      3.440196,
      2,
      1,
      NULL,
      1.536283,
      3,
      0.180015,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146784,
      1.825488,
      1.419944,
      NULL,
      0,
      1.610087,
      NULL,
      1.330466,
      0.396063,
      1.255270,
      1,
      NULL,
      0.282488,
      1,
      0,
      NULL,
      1,
      0.713522,
      NULL,
      0.482866,
      0,
      0.340209,
      0.292675,
      0.555019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119411,
      0.532156,
      NULL,
      2.159106,
      1,
      3.861787,
      1.945590,
      2,
      3,
      2.832282,
      3.399568,
      NULL,
      3.996118,
      3.289572,
      3.245688,
      1,
      3,
      NULL,
      3,
      0,
      0,
      2,
      0.297881,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935567,
      3,
      3,
      1.481440,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      3.539557,
      0,
      1,
      1.646072,
      3.208957,
      1.451243,
      1,
      0,
      1.305284,
      0,
      1,
      NULL,
      2.757918,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      9,
      NULL,
      3,
      7,
      1,
      0,
      2.284327,
      NULL,
      6.655325,
      0.038258,
      NULL,
      1.629600,
      4.552864,
      5.739426,
      9,
      2.454092,
      4,
      4.487833,
      8,
      4,
      0.278430,
      0.826997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.841548,
      2,
      7.396276,
      4.620918,
      4,
      8.793956,
      1,
      5.238985,
      1.949584,
      6.613614,
      1.885147,
      4.774616,
      NULL,
      2.409291,
      6,
      7.932902,
      NULL,
      NULL,
      0.783303,
      1,
      6,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539463,
      NULL,
      0.106194,
      0.522644,
      0,
      1,
      0.907587,
      NULL,
      1,
      1,
      1,
      NULL,
      1.659124,
      0,
      0,
      0.237969,
      1.911011,
      1,
      0.813913,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903028,
      NULL,
      NULL,
      1.696728,
      1.658290,
      1.412263,
      1.669585,
      0.200203,
      1.222172,
      1,
      1.907234,
      NULL,
      0.105041,
      0.620462,
      1,
      1,
      0.438185,
      1.911117,
      0,
      0,
      0,
      0.976765,
      0.846031,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2,
      5,
      3,
      0,
      3,
      1,
      0,
      NULL,
      0,
      5,
      2,
      2,
      NULL,
      2,
      3,
      4,
      3,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2,
      NULL,
      3,
      NULL,
      NULL,
      3,
      2,
      0,
      3,
      NULL,
      2,
      3,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-1987',
      ' 1- 6-1998',
      NULL,
      NULL,
      '10-23-1984',
      ' 7-29-1979',
      '10-22-1998',
      ' 3-14-1981',
      ' 0- 2-1991',
      ' 1-12-1977',
      ' 9- 3-1996',
      ' 2-21-1983',
      ' 1-13-1984',
      ' 6-28-2000',
      '11- 5-1976',
      NULL,
      ' 6-13-1976',
      ' 0-25-2001',
      ' 0-26-1991',
      ' 0- 0-1995',
      ' 9-13-2003',
      ' 4-25-1997',
      ' 3-29-2003',
      ' 0- 3-1976',
      ' 2- 3-1982',
      ' 8-27-1984',
      '10-28-1993',
      ' 4- 1-1998',
      '10-25-1992',
      NULL,
      ' 5-24-1977',
      ' 6-21-1987',
      ' 7-29-2003',
      ' 7-11-2001',
      ' 3-17-1993',
      ' 5-13-1991',
      ' 9- 7-1985',
      NULL,
      '10-24-1997',
      ' 5- 2-1997',
      '10-19-1991',
      ' 3-10-1978',
      ' 5-19-1993',
      ' 9-26-1989',
      NULL,
      '11-25-1993',
      ' 1- 6-1991',
      ' 8-16-1993',
      NULL,
      '10-12-1991',
      NULL,
      ' 4-18-1994',
      ' 0-24-1975',
      NULL,
      NULL,
      NULL,
      ' 6- 1-1994',
      ' 3-26-1984',
      ' 1-14-2003',
      NULL,
      '10-16-2002',
      NULL,
      ' 6-21-1978',
      NULL,
      ' 6- 0-1974',
      NULL,
      ' 0-18-1975',
      ' 7-26-1992',
      ' 8-13-1981',
      ' 7- 6-1997',
      ' 7-24-2001',
      ' 3-18-1979',
      ' 2-16-1991',
      NULL,
      ' 0-14-1989',
      NULL,
      ' 1-11-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


