set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7825995';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '3403022',
      1,
      2,
      NULL,
      NULL,
      0.071301,
      ' 1-18-1992',
      19.319110,
      NULL,
      NULL,
      1,
      0.521188,
      0.205391,
      0,
      NULL,
      NULL,
      2,
      1.395984,
      3,
      0.914064,
      3,
      NULL,
      NULL,
      1.515572,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4,
      0.476430,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      2,
      4,
      8,
      0,
      2,
      0.886773,
      1.714462,
      1.496946,
      0.814300,
      3,
      3,
      1,
      1,
      1,
      0,
      4,
      2,
      0,
      6,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      41,
      70.271973,
      2.138439,
      NULL,
      2.836342,
      38.620871,
      16.972733,
      0.593198,
      0,
      128,
      18,
      0.918474,
      1.546198,
      114,
      8,
      2,
      9,
      NULL,
      1,
      0,
      1,
      223.546292,
      20.354399,
      2,
      NULL,
      221,
      6,
      1,
      5.986898,
      238.473472,
      23.564169,
      1,
      6,
      136,
      NULL,
      1,
      9.421034,
      NULL,
      NULL,
      2,
      NULL,
      10.178199,
      61.445307,
      0.171701,
      NULL,
      109,
      NULL,
      3.967758,
      0,
      NULL,
      1,
      3.716889,
      9,
      5.744943,
      8,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7.431180,
      99.995885,
      2.852839,
      NULL,
      NULL,
      112.980197,
      6,
      1.228331,
      7,
      112.182304,
      9.094871,
      0,
      NULL,
      163.392630,
      NULL,
      NULL,
      0,
      120.992479,
      0.650056,
      NULL,
      NULL,
      NULL,
      13.242852,
      1,
      9.010134,
      101,
      NULL,
      3,
      NULL,
      162,
      17,
      2,
      6,
      170.376665,
      16.517909,
      NULL,
      7.246949,
      46,
      3.345221,
      NULL,
      7,
      154.230703,
      0,
      2,
      NULL,
      NULL,
      0.667358,
      3.230015,
      2.609595,
      33.645459,
      9,
      2,
      5.962824,
      NULL,
      9.954427,
      0,
      2.213149,
      129,
      NULL,
      NULL,
      7.329463,
      73,
      1.572058,
      1.513232,
      0.802554,
      131.057436,
      7.028550,
      0,
      1.863503,
      61,
      1.457780,
      2,
      5.664031,
      96.997190,
      42.809766,
      NULL,
      4,
      NULL,
      68,
      3.837103,
      1.258403,
      25,
      68,
      1.577168,
      1,
      205.575844,
      1980.057080,
      2,
      NULL,
      69,
      NULL,
      2,
      2.131170,
      128.611565,
      267.723316,
      NULL,
      6,
      129,
      264,
      2.607491,
      3,
      209,
      6,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      0.222184,
      NULL,
      NULL,
      3,
      NULL,
      3.041116,
      165.910755,
      NULL,
      2,
      0.373907,
      244,
      1,
      0,
      6.622798,
      301.038375,
      NULL,
      0,
      NULL,
      196,
      NULL,
      NULL,
      7,
      333,
      2.419879,
      NULL,
      8.302529,
      226,
      1.528876,
      NULL,
      0.734451,
      240,
      174.032028,
      1.459522,
      NULL,
      539,
      NULL,
      0.160986,
      5,
      NULL,
      2746,
      2,
      NULL,
      378,
      744.094199,
      2,
      2.936433,
      NULL,
      36.788395,
      2,
      7,
      306,
      414.392637,
      NULL,
      2.180052,
      1135.624454,
      915.370040,
      NULL,
      0,
      237,
      NULL,
      0.882170,
      1,
      36.218524,
      44.644612,
      3,
      1,
      310.062551,
      2.727639,
      2.228337,
      NULL,
      9,
      5.150679,
      0.850197,
      2,
      26,
      15,
      0.643955,
      3.918390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '02402',
      '',
      '',
      '',
      NULL,
      '',
      1.918113,
      '',
      NULL,
      '',
      0.487828,
      '21101',
      NULL,
      NULL,
      2,
      1.765255,
      NULL,
      NULL,
      NULL,
      1.612020,
      NULL,
      1.271958,
      NULL,
      0.155570,
      NULL,
      0.942313,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.480370,
      NULL,
      0,
      NULL,
      '10-15-1985',
      3,
      6,
      0.724348,
      NULL,
      4,
      2.118579,
      NULL,
      2.871367,
      10,
      9.832204,
      4.737410,
      16,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      4.535068,
      16.693615,
      8,
      NULL,
      13.978119,
      NULL,
      7.830147,
      17,
      NULL,
      NULL,
      25.391242,
      14.426321,
      2.511448,
      1.574359,
      4.573222,
      0,
      12,
      3.233305,
      2,
      3,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.885844,
      NULL,
      26.625895,
      0,
      1,
      33.965688,
      5,
      24,
      39,
      NULL,
      31.082090,
      33,
      59,
      22.931589,
      1.605816,
      12,
      29,
      1,
      15.997802,
      33.068839,
      NULL,
      53,
      NULL,
      3.953172,
      7.987955,
      47.749573,
      14.674489,
      46.961012,
      29,
      26,
      NULL,
      24.716020,
      5.451032,
      0,
      NULL,
      44,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      87.446177,
      139,
      40,
      41.946821,
      20.529313,
      31.061364,
      NULL,
      41.109941,
      53,
      131.243122,
      131.734722,
      119.027494,
      78,
      50.127808,
      52.900855,
      NULL,
      39.732396,
      92.678965,
      78.851851,
      NULL,
      69,
      70.787222,
      28.011479,
      37,
      2,
      NULL,
      124,
      127,
      0.571019,
      82.890511,
      89.680778,
      40,
      89.906149,
      142,
      73.890648,
      42,
      140.723687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.406210,
      2,
      4,
      3.864269,
      NULL,
      7,
      NULL,
      4,
      NULL,
      NULL,
      7.570096,
      3,
      NULL,
      NULL,
      NULL,
      4.424698,
      1.453410,
      2.887936,
      NULL,
      NULL,
      NULL,
      3,
      1.494982,
      NULL,
      9,
      3.977615,
      7,
      NULL,
      10,
      3,
      3.138981,
      0.471931,
      5.874401,
      3,
      2,
      0.452655,
      NULL,
      5.478785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.647049,
      1,
      0,
      1.595396,
      NULL,
      2,
      2.140915,
      8.260119,
      4,
      8.242555,
      NULL,
      1,
      2,
      7,
      3,
      4.777815,
      1,
      NULL,
      0.580308,
      1,
      NULL,
      NULL,
      7.663340,
      1.823263,
      0.573529,
      1.868346,
      6.192001,
      0.158050,
      11.013233,
      9,
      3,
      0,
      NULL,
      5.936538,
      1,
      11.928167,
      0.900157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      11.719757,
      2,
      2.838665,
      7,
      NULL,
      NULL,
      3,
      1.623690,
      1,
      4,
      6.546465,
      2.186180,
      2,
      1.576605,
      1.484491,
      0.067351,
      NULL,
      1,
      1,
      2.476250,
      0.940966,
      NULL,
      1.359288,
      0,
      4,
      0,
      2,
      0.811481,
      1.493485,
      7,
      1.970532,
      2.101558,
      0,
      0.127752,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      3.083504,
      1,
      1.517950,
      2,
      NULL,
      5.381180,
      NULL,
      2.611656,
      0.614670,
      0,
      5,
      3.845003,
      NULL,
      5.865439,
      4.736817,
      NULL,
      1.266790,
      NULL,
      NULL,
      4.480608,
      4.852695,
      5.513145,
      4.154027,
      2,
      NULL,
      1,
      2.310184,
      0,
      0,
      4.946210,
      2.470991,
      1.954110,
      0.214769,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      7.462060,
      3.851679,
      4,
      NULL,
      1,
      3,
      1,
      5.060574,
      0.253418,
      1.695214,
      NULL,
      2,
      1.497915,
      5,
      2.310553,
      5.756900,
      0,
      0.702352,
      2,
      6.454295,
      5.160229,
      3.619485,
      6.501590,
      NULL,
      5.270045,
      2,
      4.383222,
      5,
      2.012422,
      5,
      0,
      NULL,
      0.613041,
      NULL,
      5.603340,
      1.780944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.232488,
      NULL,
      1,
      9.145881,
      9.016772,
      4.258852,
      2.089187,
      NULL,
      6.602103,
      1.945914,
      1.977449,
      7.248073,
      0.745955,
      6.707095,
      NULL,
      5,
      0.045468,
      6,
      NULL,
      NULL,
      1,
      NULL,
      5.042516,
      4,
      2,
      4,
      7,
      1.125482,
      7,
      5,
      0,
      3.694652,
      1,
      4.025240,
      0.325963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.174334,
      8,
      3,
      0,
      2,
      2.957292,
      5.733648,
      2,
      2,
      4.843991,
      1.605893,
      8,
      1.898367,
      5.602730,
      5,
      NULL,
      3.142633,
      3.973910,
      5,
      1.699213,
      5,
      4.159133,
      1,
      4,
      6.027232,
      NULL,
      1.436084,
      3,
      2,
      0,
      5.116297,
      9,
      NULL,
      NULL,
      5,
      1,
      5.491652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928756,
      1.754566,
      8.791011,
      NULL,
      8,
      0,
      7.494907,
      1,
      2.361035,
      1.281441,
      4,
      1.723980,
      7.298737,
      1.749753,
      0.295057,
      NULL,
      6.665430,
      7,
      2,
      NULL,
      NULL,
      4,
      6.070172,
      1,
      1,
      6.883089,
      NULL,
      NULL,
      7,
      4.196446,
      6.093144,
      7.444179,
      NULL,
      7.638760,
      NULL,
      4,
      9.173235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900284,
      0,
      1.703097,
      NULL,
      2.303047,
      2,
      NULL,
      0,
      0.762921,
      3.768813,
      NULL,
      5,
      9.768467,
      0,
      0,
      3,
      1,
      4.355341,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      6,
      0.664829,
      NULL,
      0,
      3.690999,
      NULL,
      2,
      NULL,
      2.075543,
      2.366861,
      3.329008,
      0.395917,
      0,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751533,
      NULL,
      2,
      4.213599,
      NULL,
      1,
      0,
      NULL,
      4.014187,
      4,
      3,
      2.227974,
      6,
      3.039837,
      2,
      NULL,
      4,
      2,
      3,
      1,
      0,
      2.740606,
      1,
      NULL,
      7,
      NULL,
      5,
      0.906714,
      0,
      0,
      NULL,
      6,
      NULL,
      0,
      4.300135,
      0,
      4,
      7.559243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.708905,
      1,
      0.377653,
      1.638825,
      1,
      0.954952,
      0.481894,
      NULL,
      0,
      0.182346,
      NULL,
      0.251429,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.020414,
      1.547120,
      NULL,
      0.074292,
      0.351564,
      1,
      1,
      NULL,
      0,
      0.068931,
      0,
      1.026285,
      1.434138,
      NULL,
      1,
      0.518954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.622863,
      0.680265,
      1.760031,
      0.837158,
      0.447873,
      1.773946,
      0.799301,
      0,
      1,
      NULL,
      1.384050,
      0,
      1,
      NULL,
      3.260328,
      2,
      NULL,
      1.044844,
      NULL,
      1,
      NULL,
      5,
      1.669050,
      1.915460,
      0.001532,
      0,
      1,
      1,
      0.233702,
      1.932252,
      1,
      NULL,
      1,
      0,
      6,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.537373,
      4.083195,
      0.805448,
      2.754755,
      6,
      7,
      0.058785,
      1.085011,
      NULL,
      4,
      7,
      2,
      2.978834,
      5.152931,
      NULL,
      4,
      3.437174,
      4,
      2,
      1.157673,
      4.717698,
      1.946622,
      3,
      6.868601,
      1.470120,
      1,
      NULL,
      3.783171,
      4,
      2,
      5,
      4,
      1.931842,
      3,
      3.513666,
      NULL,
      4.341750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133493,
      6,
      NULL,
      1,
      11,
      2,
      5.746293,
      NULL,
      NULL,
      7,
      NULL,
      4.169741,
      0,
      1,
      2.899662,
      1,
      NULL,
      NULL,
      NULL,
      4,
      6.983140,
      NULL,
      2,
      NULL,
      0.065512,
      5,
      6.775152,
      7,
      9,
      0.761178,
      6.885445,
      8,
      8,
      6.693876,
      0.109821,
      5,
      7.799805,
      6.759245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.802677,
      8.957820,
      2,
      5,
      4.200395,
      NULL,
      4.837232,
      NULL,
      NULL,
      2,
      NULL,
      7,
      NULL,
      4,
      4.170762,
      NULL,
      2,
      3.731461,
      3.580104,
      5,
      7,
      4,
      3.695658,
      7.241356,
      6,
      4,
      7,
      0,
      NULL,
      1.139027,
      4.402793,
      8.282858,
      7.982962,
      NULL,
      NULL,
      5.429635,
      NULL,
      8.943463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.463337,
      NULL,
      1.069811,
      0.733763,
      0,
      NULL,
      0,
      NULL,
      0.452417,
      0,
      0.743687,
      NULL,
      0.717870,
      NULL,
      0.925575,
      NULL,
      NULL,
      0.981350,
      0,
      0.135415,
      NULL,
      0,
      1,
      0.992821,
      1.757702,
      0,
      0.439496,
      0,
      1,
      0.230379,
      1,
      0,
      NULL,
      0.894219,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572223,
      1,
      NULL,
      1,
      1,
      1,
      1.868569,
      NULL,
      1,
      0,
      1.403383,
      1.155315,
      NULL,
      3,
      1,
      4.262139,
      0.677306,
      NULL,
      0.748861,
      1,
      0,
      1,
      0.430411,
      0.811417,
      1.443097,
      0.554923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.104508,
      1,
      NULL,
      NULL,
      1.747466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      0,
      1,
      3,
      1,
      NULL,
      3,
      0,
      0,
      3,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      3,
      1,
      NULL,
      1,
      NULL,
      3,
      3,
      2,
      0,
      1,
      0,
      NULL,
      4,
      3,
      3,
      5,
      5,
      0,
      4,
      NULL,
      4,
      NULL,
      NULL,
      5,
      1,
      5,
      2,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 5-1978',
      ' 5- 2-1982',
      NULL,
      NULL,
      ' 3-20-1988',
      ' 4-29-1980',
      NULL,
      ' 8- 4-2002',
      ' 3-24-1992',
      NULL,
      NULL,
      NULL,
      ' 6- 7-1976',
      '11-20-1986',
      '11-14-1985',
      '11-20-1992',
      ' 5- 4-2001',
      ' 9-23-1994',
      ' 3-17-1980',
      ' 0-26-1974',
      ' 7-22-2003',
      ' 3- 9-1990',
      NULL,
      ' 1-16-1999',
      NULL,
      '11- 6-2000',
      ' 6- 3-1982',
      ' 6-24-1992',
      NULL,
      ' 5-26-1974',
      '11-20-1994',
      NULL,
      '11- 5-1987',
      ' 1- 7-2002',
      ' 7-27-2000',
      ' 4- 8-1990',
      ' 2-17-1983',
      ' 8-18-1976',
      ' 3- 2-1985',
      '11-27-1979',
      ' 3- 8-1983',
      ' 9- 0-1980',
      ' 1-29-1979',
      ' 5- 4-1984',
      ' 6- 8-2002',
      ' 4-18-1994',
      ' 3-20-1987',
      NULL,
      ' 1-26-1985',
      '11-18-1996',
      '11-23-1981',
      ' 1-28-1997',
      ' 9- 0-2001',
      ' 3-14-1987',
      ' 8-24-1996',
      '11-13-1986',
      ' 7-13-1980',
      ' 5-14-1990',
      ' 0- 6-1980',
      ' 5-11-1978',
      NULL,
      ' 2-10-1990',
      ' 0-25-1982',
      ' 2-18-1997',
      ' 0-14-1996',
      '11- 4-2000',
      ' 2-24-2003',
      NULL,
      '11-25-1982',
      NULL,
      ' 5- 7-2001',
      ' 4-22-1999',
      NULL,
      ' 9- 0-1999',
      NULL,
      ' 6-28-1990',
      ' 8-22-1982',
      ' 5-28-2001',
      ' 7-19-1985',
      ' 0-20-2003',
      NULL,
      NULL,
      ' 3-21-1997',
      ' 0-10-1997',
      ' 8-28-1989',
      ' 9-24-1988',
      ' 0-29-1982',
      ' 5-10-2001',
      ' 1-27-1978',
      NULL,
      ' 9-27-2002',
      ' 6-16-1986',
      ' 8- 3-1985',
      '11- 8-1992',
      ' 5- 1-1993',
      NULL,
      ' 9-21-1992',
      NULL,
      '10- 5-1986',
      ' 6-23-1984',
      NULL,
      NULL,
      '10-23-1987',
      ' 7- 3-1988',
      '10-25-1983',
      NULL,
      ' 2- 8-1995',
      NULL,
      ' 2-10-1988',
      NULL,
      ' 2-20-1991',
      NULL,
      ' 0-18-1982',
      ' 1-28-1981',
      ' 5- 7-1980',
      ' 4- 1-2001',
      ' 5- 3-1979',
      NULL,
      ' 5-28-1990',
      NULL,
      ' 4- 0-1990',
      NULL,
      '10-15-1984',
      ' 7-25-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290089);
commit;
end;
/


