set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9805950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '3',
      84.113505,
      NULL,
      '3312104',
      2,
      3.543991,
      NULL,
      NULL,
      NULL,
      '11-18-1987',
      3,
      NULL,
      0.224266,
      NULL,
      NULL,
      0,
      1.349378,
      1.143223,
      0.600369,
      0,
      3,
      0,
      1.742557,
      0,
      NULL,
      NULL,
      NULL,
      2.470845,
      NULL,
      NULL,
      NULL,
      NULL,
      2.208521,
      NULL,
      NULL,
      1.603576,
      0,
      1,
      NULL,
      NULL,
      6,
      4,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      7,
      3,
      3,
      0.416465,
      1.810488,
      0,
      0.065109,
      2,
      2,
      2,
      0,
      0.362084,
      1,
      2.681167,
      NULL,
      1,
      7,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      2,
      NULL,
      3,
      0.951797,
      195.253861,
      NULL,
      1,
      1.744505,
      233.107575,
      0.470433,
      2.842482,
      0,
      NULL,
      61.979950,
      NULL,
      NULL,
      19,
      7.599336,
      2.961787,
      8,
      NULL,
      NULL,
      2.190182,
      0,
      NULL,
      NULL,
      NULL,
      0,
      72.211203,
      NULL,
      10,
      3,
      NULL,
      7,
      1.481496,
      0,
      346.635723,
      NULL,
      0,
      0.607034,
      NULL,
      NULL,
      1,
      4,
      177,
      3,
      10.388884,
      0.910253,
      NULL,
      27,
      0,
      3,
      111.332315,
      7.743105,
      3,
      2,
      NULL,
      NULL,
      0.195567,
      NULL,
      776,
      4.974517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '11330',
      '20310',
      '40423',
      '21420',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      '',
      NULL,
      NULL,
      0,
      NULL,
      1,
      2010,
      0,
      NULL,
      1,
      NULL,
      5.740766,
      2,
      0.776402,
      NULL,
      5.529453,
      NULL,
      0.320308,
      NULL,
      1,
      833.071993,
      1,
      NULL,
      ' 7- 1-1996',
      4,
      2,
      3,
      4.849186,
      1.987450,
      1.938424,
      5,
      5.722496,
      10.618078,
      5,
      0,
      9.193687,
      9.873640,
      6,
      6.445811,
      1,
      3,
      NULL,
      6,
      NULL,
      11.881223,
      6,
      25.994998,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.386552,
      16.849638,
      23.455048,
      1.844199,
      6,
      NULL,
      1.101105,
      22,
      NULL,
      0,
      3,
      NULL,
      3,
      0.071120,
      NULL,
      NULL,
      4.137707,
      NULL,
      33.542909,
      52.463687,
      16.401376,
      NULL,
      9,
      15.609619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      112,
      138.847854,
      109,
      72,
      39,
      68,
      162.419661,
      137,
      157,
      137.585290,
      140.145664,
      NULL,
      143.622050,
      157,
      102.268811,
      86,
      NULL,
      0.064274,
      0.693268,
      0.164690,
      0.549631,
      3,
      NULL,
      0.722956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      7.415934,
      1.953368,
      4,
      NULL,
      0.851484,
      7.512821,
      NULL,
      6,
      1,
      NULL,
      0,
      2,
      NULL,
      3,
      9.066578,
      2,
      3.875547,
      1.645407,
      6.768076,
      NULL,
      9,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      9,
      1,
      NULL,
      5,
      NULL,
      5.479865,
      1,
      1.316602,
      NULL,
      5.149782,
      4.099355,
      7.506610,
      3,
      1.293051,
      4.439279,
      10.945857,
      NULL,
      11.543928,
      0.475945,
      11,
      4,
      5.617051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290811,
      NULL,
      3.411851,
      7,
      2,
      0,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      0.582116,
      2,
      NULL,
      2,
      2.055296,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.135668,
      1.940646,
      2.061083,
      5,
      1.576532,
      3,
      2,
      1,
      2.147885,
      NULL,
      7.829547,
      5,
      9.464109,
      4,
      5,
      3.197298,
      5,
      0,
      7.806037,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132701,
      1,
      1.185221,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0.525513,
      3,
      5.705664,
      NULL,
      5,
      NULL,
      1.026456,
      1.279232,
      NULL,
      2,
      4,
      3,
      4,
      1,
      1,
      0,
      3.005805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846522,
      0,
      NULL,
      6,
      7,
      4.347149,
      4,
      5,
      7.606893,
      4.661462,
      4,
      6,
      6.975928,
      NULL,
      1.891911,
      NULL,
      1,
      NULL,
      5,
      1.062451,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489551,
      1.619848,
      5,
      3.575483,
      2,
      1.650389,
      5,
      NULL,
      1,
      2,
      4,
      3.235409,
      6.760434,
      7.718000,
      3,
      2.687089,
      1.141492,
      0.659680,
      NULL,
      0.500812,
      NULL,
      NULL,
      6.990614,
      3.922839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318504,
      0,
      1,
      3,
      0,
      NULL,
      1,
      0.277474,
      1,
      0.679591,
      1.393075,
      0.796109,
      0.917080,
      1,
      1.943523,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0.676569,
      1,
      1.043074,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.352561,
      1.185353,
      2,
      0.961743,
      1.019437,
      1,
      1,
      1,
      0,
      1,
      1,
      1.519425,
      NULL,
      0.535634,
      0,
      0,
      0,
      0,
      0.536281,
      0.196510,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847130,
      NULL,
      0.415830,
      1.746639,
      0.670432,
      NULL,
      1.311488,
      0.231148,
      0,
      0,
      1,
      0,
      0.061842,
      0.032867,
      0,
      0,
      1.301931,
      1,
      3.108967,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.158433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1.892468,
      0,
      0.463445,
      4.195329,
      1,
      1.629160,
      0.444647,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1.364479,
      0,
      0,
      NULL,
      1.175863,
      1.945481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063126,
      2.405705,
      4.333980,
      NULL,
      0.470251,
      6,
      2.532418,
      1.935334,
      3,
      0.615419,
      1.311168,
      3.478991,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      0,
      1.308632,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.476564,
      NULL,
      0,
      2.624743,
      4.696004,
      3,
      3,
      1,
      1.737836,
      NULL,
      2,
      1.249746,
      0,
      1.627774,
      NULL,
      NULL,
      NULL,
      1,
      1.130792,
      5,
      NULL,
      1.188521,
      1.680697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.583179,
      8.408331,
      0,
      9.856718,
      5,
      0,
      4.367102,
      NULL,
      NULL,
      1.160604,
      1.935780,
      7,
      3,
      6.762884,
      3,
      NULL,
      4,
      4.209468,
      9,
      3,
      NULL,
      4,
      0.692038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.227483,
      4,
      2.405264,
      NULL,
      1.563286,
      2.116191,
      2.279721,
      4,
      5.335831,
      2.902428,
      NULL,
      1.726827,
      7.206338,
      3.113596,
      2,
      4,
      5.205891,
      NULL,
      1.206726,
      0,
      5,
      0,
      3.375058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993017,
      0.516191,
      0.103251,
      0,
      1.316028,
      1,
      1,
      0,
      1.809154,
      0.864688,
      1,
      1,
      1,
      0,
      0,
      0.168390,
      1,
      1.555401,
      0,
      1.377419,
      0,
      NULL,
      0.183458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012374,
      2.315799,
      0,
      3,
      NULL,
      8,
      0,
      0.363322,
      0.045270,
      0.722780,
      0,
      1,
      2.723494,
      0.280839,
      0,
      0,
      0.023779,
      5,
      0.811258,
      0,
      2,
      1,
      0.811579,
      0,
      0.051171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      7,
      NULL,
      1,
      0,
      2,
      0,
      7,
      1,
      1,
      0,
      2,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      2,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      2,
      3,
      5,
      5,
      5,
      3,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      5,
      1,
      3,
      2,
      4,
      1,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1996',
      ' 3- 2-1995',
      ' 6-22-1976',
      '11-28-1979',
      ' 2-29-1974',
      '11-13-1985',
      NULL,
      '10- 5-2003',
      ' 8-16-1977',
      ' 3- 8-1996',
      NULL,
      ' 6-19-1991',
      ' 7-18-1980',
      ' 1- 3-2002',
      NULL,
      ' 7-18-1993',
      ' 4- 9-1989',
      NULL,
      ' 7-14-1998',
      NULL,
      ' 8-21-1990',
      ' 9- 7-1986',
      ' 2-21-2001',
      ' 0-15-2001',
      ' 4- 3-1985',
      NULL,
      ' 3- 6-1975',
      ' 4- 7-1977',
      ' 0- 4-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1994',
      ' 2-25-1981',
      NULL,
      ' 5- 2-1983',
      NULL,
      '11-25-1976',
      ' 6-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367832);
commit;
end;
/


