set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678994';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '40342414',
      19.904536,
      51,
      NULL,
      2,
      NULL,
      2,
      '01144',
      2,
      NULL,
      115.732263,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      1.909306,
      NULL,
      0,
      1,
      0.944945,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      51,
      11,
      2,
      0,
      NULL,
      8.084486,
      3,
      0,
      NULL,
      NULL,
      NULL,
      8,
      1,
      8,
      3,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      6,
      2.406081,
      NULL,
      2,
      NULL,
      1.067877,
      NULL,
      1.281218,
      0,
      3,
      8,
      4,
      0,
      2,
      4,
      3.615423,
      5,
      NULL,
      7,
      6.516700,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.545970,
      1.670746,
      NULL,
      0,
      3,
      NULL,
      2,
      4.547406,
      NULL,
      1366,
      2,
      0.688443,
      131,
      3.035115,
      NULL,
      3,
      1131.174812,
      738.522423,
      2.988715,
      2,
      357,
      1576,
      3.605404,
      NULL,
      435.398746,
      556.025458,
      3,
      3.555718,
      121,
      4,
      2.738487,
      NULL,
      114.081780,
      868.201311,
      2,
      3.504640,
      104.757957,
      105,
      0,
      2.697538,
      168.848908,
      5.577244,
      2,
      3.121211,
      NULL,
      2.978448,
      1,
      0.737154,
      162.247855,
      1.289711,
      2,
      NULL,
      1207,
      1999,
      NULL,
      NULL,
      990.247927,
      342,
      2.750085,
      1.658571,
      NULL,
      15.940209,
      NULL,
      NULL,
      104,
      2,
      3,
      3,
      170,
      26.697595,
      NULL,
      7.782535,
      159,
      52.306998,
      NULL,
      0.998089,
      51.184345,
      736.443171,
      NULL,
      0.653120,
      179,
      0,
      1,
      5,
      191,
      1,
      0.523794,
      NULL,
      237,
      NULL,
      2,
      3.252624,
      10.849718,
      5,
      2,
      NULL,
      1110,
      1111.786192,
      0.752743,
      2,
      222,
      4.932480,
      0.372797,
      NULL,
      4.541203,
      2092,
      NULL,
      1,
      219,
      2.020721,
      3.637541,
      2.016177,
      1010,
      NULL,
      2.394686,
      1,
      137,
      NULL,
      0,
      0,
      100,
      310,
      0.934689,
      1.559608,
      421,
      NULL,
      3,
      0.404332,
      161,
      58,
      0,
      2,
      56.333620,
      5.752696,
      0.307947,
      NULL,
      611.489877,
      212.242264,
      0,
      0.496382,
      242.843919,
      NULL,
      NULL,
      NULL,
      189,
      13,
      1.046050,
      2.864147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080432,
      '33322',
      NULL,
      '',
      '',
      '',
      '',
      1.523569,
      '',
      '',
      '',
      2.215264,
      NULL,
      '',
      NULL,
      NULL,
      7.426823,
      32,
      NULL,
      13,
      0.446579,
      4.700705,
      NULL,
      NULL,
      0.525732,
      11,
      1.967989,
      NULL,
      0.011760,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      ' 9-18-1987',
      7,
      12.583098,
      16,
      0.386728,
      0,
      NULL,
      1,
      4,
      1,
      0.924694,
      14,
      17.347820,
      19,
      1.429582,
      1.995785,
      NULL,
      1.139338,
      1,
      4,
      12.263920,
      11.252802,
      4.377669,
      13.650856,
      17,
      5.415552,
      3.126931,
      7.612405,
      NULL,
      12.561881,
      20.372133,
      2.234314,
      NULL,
      NULL,
      0,
      11,
      NULL,
      1,
      11,
      9.902194,
      NULL,
      NULL,
      NULL,
      5,
      4.189825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      15,
      42.067496,
      6.959399,
      2.130999,
      36,
      53,
      21,
      NULL,
      14.170423,
      8,
      1.757650,
      15,
      NULL,
      10.066177,
      3,
      NULL,
      7.712612,
      37,
      NULL,
      9,
      16,
      6,
      27,
      NULL,
      0.020633,
      9,
      10,
      0.324449,
      NULL,
      2.177241,
      6,
      18.032568,
      23.151435,
      0,
      2.675972,
      1.922431,
      16.668026,
      30,
      34,
      9.692448,
      NULL,
      0.596199,
      1.817688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      129,
      144,
      60,
      182,
      180,
      41,
      174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      172.890220,
      NULL,
      106,
      77,
      NULL,
      NULL,
      55.454168,
      NULL,
      71,
      122.462231,
      NULL,
      1,
      1,
      0.512184,
      0,
      1,
      NULL,
      NULL,
      3.511850,
      3.878810,
      NULL,
      3.589935,
      1.191927,
      NULL,
      0,
      6,
      1,
      4,
      NULL,
      5.950234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.925801,
      1,
      1,
      0.191495,
      0,
      1.708520,
      0,
      1,
      0.208735,
      NULL,
      1,
      0.761648,
      0,
      1.491171,
      3.171169,
      2.647206,
      2.120460,
      3,
      0,
      3.893344,
      3.150480,
      4.155437,
      NULL,
      2.504543,
      3,
      0,
      1,
      NULL,
      3,
      5.054652,
      4.058155,
      2,
      2,
      1,
      4.484692,
      NULL,
      5,
      2.721813,
      0.224968,
      7,
      3.645825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965804,
      0.891515,
      0.312662,
      1.539597,
      1.925256,
      0,
      0,
      0,
      1.159226,
      1,
      0.113149,
      1,
      NULL,
      1,
      0.404352,
      1.909727,
      0,
      0,
      0,
      1,
      1,
      0.504296,
      NULL,
      NULL,
      0.235911,
      0.779958,
      0.968022,
      0,
      3.577899,
      0,
      1.007540,
      NULL,
      1,
      1,
      1,
      1.708747,
      0.077642,
      3.562703,
      NULL,
      0,
      NULL,
      3,
      6.155788,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6,
      NULL,
      NULL,
      1,
      0,
      2.472979,
      3,
      2.921209,
      6.630284,
      4.128168,
      5,
      0.922407,
      5,
      3,
      5.937488,
      0.958861,
      NULL,
      3,
      2.396556,
      1,
      1.219890,
      0,
      2,
      0.797983,
      2,
      6,
      1,
      0.017782,
      2.576269,
      3.271331,
      3.537639,
      NULL,
      2,
      1,
      3,
      1,
      7,
      1,
      5,
      2.567056,
      4.649442,
      NULL,
      2.762318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      5.005918,
      NULL,
      3.652609,
      3.010615,
      4,
      1.256116,
      2,
      NULL,
      1,
      1,
      6,
      NULL,
      2,
      0,
      2,
      2.821716,
      3,
      0.988473,
      1,
      2.007799,
      2,
      NULL,
      NULL,
      7.839893,
      0,
      2,
      2,
      1,
      0.269799,
      2,
      NULL,
      3,
      7.790230,
      0,
      7,
      2,
      3.871086,
      4.564326,
      3,
      2.186164,
      5.104769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316159,
      NULL,
      3.024924,
      NULL,
      0,
      1,
      2.983189,
      NULL,
      0,
      1.637978,
      NULL,
      3.613250,
      0.498811,
      NULL,
      2,
      NULL,
      1,
      1.832423,
      0,
      0.792491,
      0,
      2.520211,
      NULL,
      NULL,
      2,
      NULL,
      2.349234,
      5,
      1.356284,
      NULL,
      2.485717,
      0.578360,
      NULL,
      0,
      2,
      NULL,
      3,
      7,
      4.972633,
      1,
      5,
      3.260091,
      7.340290,
      2.505502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.510122,
      2.683518,
      NULL,
      1.189780,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.437228,
      3,
      2,
      2,
      5,
      7.901031,
      1,
      7,
      3,
      NULL,
      4,
      5,
      1,
      3.952549,
      0,
      NULL,
      9.907825,
      7,
      4.821103,
      0.378582,
      2,
      0.833240,
      3.197933,
      NULL,
      NULL,
      7.522179,
      7,
      3,
      1.027624,
      7,
      9.660691,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.841550,
      0,
      1.528308,
      2.609780,
      5.372243,
      4,
      0,
      1,
      5.432615,
      2.955496,
      3.324597,
      0.736861,
      0.128908,
      4.934837,
      5,
      3.976611,
      6.922286,
      NULL,
      2,
      5,
      NULL,
      NULL,
      1,
      3.002946,
      4.634005,
      1.564926,
      1,
      7.212581,
      NULL,
      0.111307,
      9.956626,
      0.899381,
      0,
      4.313783,
      8,
      1,
      7.618408,
      8,
      9,
      0.640487,
      5.530468,
      7,
      2.061460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.571809,
      0.432815,
      3,
      2,
      0.511721,
      0.902507,
      0.619052,
      0.254730,
      1,
      NULL,
      0,
      0.181636,
      1,
      1,
      NULL,
      1,
      0.760909,
      2,
      2,
      3.117799,
      0.012834,
      5,
      5.274597,
      1.357816,
      2.256456,
      2,
      NULL,
      2.877550,
      2.350771,
      NULL,
      2,
      NULL,
      7.930373,
      0.659479,
      0.209146,
      NULL,
      3.868787,
      2,
      5.982589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746096,
      3.779387,
      1,
      1.344921,
      NULL,
      NULL,
      2,
      1.891806,
      2.033066,
      1,
      2,
      0.693517,
      3.985388,
      NULL,
      NULL,
      1.034386,
      NULL,
      2.228910,
      2,
      1.320706,
      3.923771,
      3,
      2,
      NULL,
      0.694275,
      0.824493,
      0,
      5.649537,
      6.270991,
      2,
      0.980549,
      0.878577,
      2,
      5.901321,
      2,
      NULL,
      4.348538,
      1.063999,
      4,
      6,
      5.341060,
      NULL,
      0.975658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.648914,
      1,
      0,
      0.634447,
      NULL,
      NULL,
      1.070850,
      0.650436,
      0,
      1.436753,
      NULL,
      1.769595,
      1.812931,
      1,
      NULL,
      0.408569,
      0,
      1,
      0,
      NULL,
      1.875720,
      0.742586,
      1.877410,
      0.320411,
      NULL,
      0,
      1,
      0.072969,
      1,
      1,
      0.938465,
      3.722114,
      0,
      NULL,
      1,
      0.286085,
      4.710122,
      0.199745,
      1.726357,
      1.481630,
      NULL,
      2.696337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.727177,
      0,
      5,
      2,
      0.067995,
      1.356491,
      8.201176,
      6,
      3,
      0,
      0.514679,
      NULL,
      0,
      5,
      NULL,
      NULL,
      1,
      0,
      0,
      4,
      0,
      2.325169,
      NULL,
      NULL,
      0.920373,
      NULL,
      1,
      2,
      1,
      1,
      1.181557,
      1.049149,
      0,
      NULL,
      NULL,
      0.729832,
      NULL,
      1.955681,
      1.117084,
      3,
      1,
      3.893907,
      0.318472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.985251,
      NULL,
      NULL,
      NULL,
      2.653968,
      1,
      1.066858,
      NULL,
      1.990588,
      1.513101,
      NULL,
      0.816219,
      NULL,
      1.205826,
      0.528398,
      1.453764,
      1.995980,
      0,
      1,
      1,
      1.217261,
      0.872125,
      1,
      NULL,
      1.397552,
      0.479076,
      NULL,
      3.215480,
      3.435897,
      3,
      NULL,
      NULL,
      2.678132,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.005623,
      0.024655,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450232,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.160252,
      0,
      1.817637,
      NULL,
      3.660115,
      1.952932,
      1.187082,
      NULL,
      0.772200,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.930421,
      3.888828,
      5.175649,
      1.338834,
      NULL,
      2,
      4.180444,
      0.662475,
      NULL,
      7,
      NULL,
      0.163413,
      2,
      1.019524,
      3,
      6,
      2.235604,
      NULL,
      NULL,
      1.175628,
      7,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.345531,
      3,
      NULL,
      5,
      NULL,
      0.694008,
      4,
      5,
      2,
      7.057326,
      NULL,
      0.164944,
      3.411703,
      2.622059,
      4,
      0.070049,
      0.383081,
      NULL,
      0,
      1.588555,
      NULL,
      2.270030,
      2.272699,
      4,
      NULL,
      2,
      5,
      0,
      NULL,
      1.654726,
      0,
      3,
      NULL,
      3.390764,
      1,
      6,
      NULL,
      NULL,
      2.339251,
      9,
      2.563093,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186569,
      7,
      3.572319,
      2.127994,
      2.469487,
      4.173582,
      NULL,
      1,
      0,
      3.347685,
      5,
      4,
      2.626721,
      5,
      5,
      2.544301,
      4,
      NULL,
      6.686986,
      4,
      1.567822,
      NULL,
      NULL,
      1.305047,
      7.247089,
      0.368783,
      NULL,
      4,
      8,
      5,
      0,
      4.705298,
      1.596409,
      1.737362,
      8.817015,
      8.895283,
      NULL,
      NULL,
      7.688415,
      NULL,
      NULL,
      6.812722,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.092113,
      4,
      0.792862,
      1,
      0.664385,
      9.576731,
      NULL,
      2,
      3.213167,
      0,
      1.209517,
      0.875004,
      2,
      3,
      0,
      0.296746,
      4,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      3.458674,
      1,
      3,
      1,
      0,
      NULL,
      1,
      1.983440,
      0,
      1,
      0.327039,
      1,
      NULL,
      1,
      3,
      0.443052,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.965176,
      0,
      1.796776,
      0,
      1.790285,
      NULL,
      0.963671,
      1,
      0.187541,
      0.366994,
      0.053078,
      1.404304,
      NULL,
      1.617006,
      1,
      0.265263,
      0,
      NULL,
      0,
      1.936143,
      0.388087,
      1.249929,
      1,
      0.208300,
      1,
      NULL,
      1.386628,
      1,
      1.356551,
      0,
      5,
      7.555251,
      NULL,
      0.134947,
      1.051341,
      NULL,
      1.911343,
      0,
      1.041297,
      0.015741,
      NULL,
      0,
      1.952203,
      1.380832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      2,
      2,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      2,
      0,
      1,
      0,
      0,
      2,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      3,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      2,
      2,
      1,
      1,
      1,
      2,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      5,
      4,
      0,
      0,
      1,
      4,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0,
      3,
      4,
      2,
      5,
      0,
      2,
      0,
      0,
      NULL,
      3,
      2,
      3,
      2,
      NULL,
      2,
      2,
      7,
      NULL,
      1,
      2,
      2,
      NULL,
      4,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1980',
      ' 4-21-1978',
      ' 9- 6-1974',
      ' 3-28-1985',
      '11-14-2002',
      '10-25-1980',
      ' 3-26-1978',
      NULL,
      ' 4- 1-1990',
      ' 0- 2-1989',
      ' 1-22-2002',
      ' 3-15-1991',
      '10-13-1977',
      ' 5-18-1992',
      ' 2-21-1998',
      ' 8-20-1990',
      NULL,
      ' 3-17-1989',
      ' 6-13-2003',
      ' 7-23-2001',
      ' 4-26-1997',
      ' 5- 6-1975',
      ' 8-20-1975',
      NULL,
      ' 3-17-1996',
      ' 2- 1-1996',
      NULL,
      ' 2-25-2003',
      ' 8-22-1984',
      ' 1- 2-1976',
      ' 7- 1-1982',
      ' 7-15-2003',
      NULL,
      NULL,
      ' 8-13-1993',
      ' 9-12-1983',
      ' 4-12-1983',
      ' 7-23-2002',
      NULL,
      ' 3-13-1983',
      ' 9- 9-1980',
      NULL,
      ' 0- 8-1999',
      ' 8-25-1992',
      NULL,
      ' 7-28-2001',
      ' 2- 3-1992',
      NULL,
      ' 4-18-1997',
      '11-13-2003',
      ' 6- 3-1985',
      ' 1-29-1988',
      ' 7-27-1997',
      ' 0-28-2001',
      NULL,
      ' 9-13-1980',
      ' 6-10-1983',
      ' 9- 4-1989',
      NULL,
      NULL,
      ' 5-25-1998',
      ' 7- 0-2001',
      ' 8- 7-1979',
      ' 8-18-1985',
      ' 7- 6-1987',
      ' 9-13-2002',
      ' 1-20-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


