set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204518';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '3424430',
      NULL,
      2.139331,
      0,
      '40320',
      3.049856,
      '10-21-1982',
      31,
      NULL,
      1.087720,
      0,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      0,
      1.494867,
      1.454013,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.136792,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      NULL,
      8,
      0,
      8,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      5,
      4.684200,
      5,
      7,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.600776,
      1.090721,
      NULL,
      2,
      6,
      NULL,
      6,
      0,
      NULL,
      3.447048,
      22.121255,
      ' 9-27-2003',
      15,
      0.016450,
      5.793722,
      2,
      4,
      NULL,
      4.772132,
      NULL,
      36,
      292,
      NULL,
      1.879954,
      1,
      50,
      528,
      3.626648,
      3.137479,
      125.265079,
      328,
      1,
      0.567437,
      NULL,
      1.022275,
      3,
      2.122536,
      113,
      42,
      3,
      1.996675,
      NULL,
      NULL,
      0,
      3,
      87.049684,
      15,
      1,
      1.960879,
      111.105853,
      70,
      3.146961,
      1,
      190.711539,
      0.506053,
      3.402549,
      2,
      42.015754,
      NULL,
      3,
      NULL,
      99.722773,
      32,
      3.144379,
      NULL,
      NULL,
      156,
      3.711631,
      2,
      31,
      2,
      NULL,
      1,
      132.955608,
      NULL,
      NULL,
      1.312870,
      202.230244,
      10,
      2.264805,
      2.964633,
      110,
      1,
      0.473001,
      1,
      234.983600,
      88,
      2,
      2,
      212.502047,
      NULL,
      0.883773,
      NULL,
      NULL,
      NULL,
      3.195596,
      2,
      149,
      12.153136,
      2,
      3,
      92.817582,
      1.732382,
      0,
      2,
      NULL,
      NULL,
      3.401185,
      1.817341,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.442875,
      301.490977,
      7,
      NULL,
      0.006381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '03122',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      5,
      NULL,
      NULL,
      NULL,
      34,
      1.550799,
      NULL,
      1,
      NULL,
      7.243254,
      NULL,
      0.080840,
      NULL,
      1.962692,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      '11-27-1998',
      NULL,
      2,
      NULL,
      14,
      0,
      16.586886,
      0,
      15,
      NULL,
      22,
      4.475321,
      NULL,
      1,
      NULL,
      1.466436,
      8.217687,
      NULL,
      24.658475,
      7,
      5,
      3,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      7,
      3.951917,
      1,
      12,
      7,
      3,
      13.082070,
      5,
      5,
      9.871393,
      9.809498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      12.081696,
      4,
      7,
      27.278115,
      44,
      10,
      NULL,
      18.324101,
      44,
      2,
      9.673383,
      12.131421,
      6,
      47,
      16.182397,
      26.797326,
      12.978583,
      25.489710,
      41,
      10,
      5,
      33,
      29,
      0,
      NULL,
      20.233123,
      2,
      6,
      41,
      37.009559,
      0,
      NULL,
      9.247801,
      47.603479,
      NULL,
      45,
      33.621056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93.740963,
      8.748309,
      96.300973,
      14,
      NULL,
      NULL,
      81.626849,
      8,
      47,
      84.176323,
      117,
      NULL,
      129.605935,
      93.215898,
      73.366281,
      128,
      NULL,
      87,
      NULL,
      160,
      132,
      149.527168,
      147,
      NULL,
      171,
      73,
      92,
      107.848815,
      81.501839,
      129.739666,
      111.269500,
      179.609301,
      182.891082,
      55.444185,
      166.728849,
      NULL,
      105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730067,
      0,
      NULL,
      4.932334,
      2,
      6.303593,
      3.423007,
      2,
      NULL,
      8.512579,
      3,
      5.609770,
      NULL,
      5.309185,
      3,
      2,
      4.084856,
      5,
      2,
      3,
      2.174740,
      1.637979,
      2.342586,
      3.540539,
      4.151705,
      9,
      4.167402,
      5,
      2,
      4.681498,
      5.555524,
      1,
      NULL,
      6,
      2.994577,
      8,
      6.902779,
      1.494629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759810,
      1.359693,
      3.363607,
      0.211847,
      NULL,
      NULL,
      0,
      0,
      0.505123,
      3.317578,
      NULL,
      NULL,
      0,
      3.692888,
      NULL,
      3.461650,
      2.795805,
      1,
      6,
      0,
      2,
      3.540820,
      0.321761,
      1.746342,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.037758,
      2,
      NULL,
      4.875836,
      6,
      0.092045,
      2,
      6.559475,
      4.075047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5.625459,
      7,
      3,
      NULL,
      0.211284,
      0.896636,
      3.953455,
      2.957603,
      NULL,
      7,
      11.730427,
      3.413761,
      11,
      NULL,
      1.202404,
      1.518857,
      0.297463,
      0.287422,
      0,
      0.935705,
      1.620546,
      3.275213,
      2,
      1,
      0.544504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.166921,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      9,
      2,
      2.293382,
      2.336191,
      NULL,
      NULL,
      2.200055,
      2.680805,
      5.549985,
      7.770390,
      0,
      NULL,
      8.627491,
      2.584960,
      6,
      0.841392,
      4,
      3.669627,
      1.455537,
      2.676514,
      5,
      NULL,
      5,
      3.257939,
      3,
      NULL,
      9.903576,
      3.890976,
      NULL,
      0,
      5.684925,
      2,
      NULL,
      1,
      NULL,
      4.689589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      7,
      3,
      3.397127,
      3,
      3.354844,
      2.474986,
      5,
      5,
      NULL,
      4.008117,
      3,
      7.635175,
      7,
      NULL,
      NULL,
      3,
      NULL,
      5.327136,
      3.640402,
      0,
      5.336452,
      3.054244,
      7,
      3,
      NULL,
      5.336633,
      7,
      5,
      NULL,
      1,
      4.218252,
      NULL,
      9,
      3.066841,
      0.782617,
      6.037984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.338421,
      NULL,
      4.139235,
      6.794598,
      NULL,
      6.715092,
      NULL,
      NULL,
      1,
      6.849082,
      4.453923,
      1,
      NULL,
      1.616777,
      NULL,
      1,
      1,
      5,
      1.804703,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.960101,
      7.747817,
      2,
      2,
      5,
      NULL,
      2,
      1,
      4,
      0.210660,
      7.002777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.504655,
      2.849062,
      6,
      3.351728,
      NULL,
      NULL,
      0.629561,
      8,
      3.860060,
      1.487945,
      5.316984,
      1.782665,
      4.039971,
      5,
      NULL,
      3.889805,
      4.768282,
      NULL,
      0,
      NULL,
      NULL,
      5,
      5.574989,
      4,
      NULL,
      1.881045,
      NULL,
      0,
      NULL,
      4,
      2,
      4.782692,
      NULL,
      NULL,
      0.204743,
      5,
      3,
      5.856851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010733,
      NULL,
      NULL,
      NULL,
      3.184551,
      0.342177,
      0,
      2.314356,
      1,
      5.659907,
      3.106303,
      1.065475,
      NULL,
      2.445723,
      0.716612,
      1.348633,
      3.619267,
      1,
      0.967512,
      3,
      NULL,
      1.114340,
      NULL,
      1.648840,
      2.006651,
      3.415325,
      0,
      0,
      3.045414,
      3,
      1.351728,
      1,
      0.121334,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.443573,
      1.256864,
      NULL,
      3,
      1,
      3.891402,
      NULL,
      4,
      NULL,
      0.084346,
      2,
      8,
      6.681419,
      4,
      0,
      2.955333,
      5,
      5.822723,
      3.830383,
      1.405776,
      0.952842,
      3.789399,
      NULL,
      3,
      6.793273,
      4.743416,
      0.548210,
      NULL,
      0,
      4.309511,
      7.280960,
      NULL,
      5.328682,
      3,
      5.834090,
      2.000949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.496341,
      NULL,
      3.899480,
      2.579252,
      NULL,
      NULL,
      0,
      0.794770,
      5.668101,
      3,
      3.364970,
      0,
      5.663726,
      NULL,
      NULL,
      4.832410,
      NULL,
      2,
      5.968959,
      2,
      1,
      2,
      0.766800,
      0,
      5,
      0,
      NULL,
      2,
      NULL,
      5,
      0,
      5.641582,
      0,
      1.011777,
      0,
      0.925601,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.721039,
      1.663209,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0.010149,
      0,
      0.109918,
      0.904846,
      1.901108,
      0,
      1.282045,
      1,
      1.948301,
      0,
      1.205282,
      1.026718,
      NULL,
      0,
      1.178465,
      1,
      0.976356,
      NULL,
      0.980628,
      1,
      1,
      0.590160,
      1,
      1,
      1.616969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.665876,
      1.271629,
      0.970734,
      NULL,
      1,
      NULL,
      1.054876,
      7.664583,
      0,
      NULL,
      0.408864,
      0,
      1.655914,
      NULL,
      7.812986,
      NULL,
      3,
      2.013372,
      2.465212,
      0.032775,
      NULL,
      1,
      0,
      NULL,
      0,
      1.360013,
      1.445381,
      0.719471,
      8.305033,
      5,
      0,
      1,
      1,
      0.078022,
      1,
      NULL,
      2.237033,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974031,
      1.705174,
      0.234162,
      3.843130,
      1.117320,
      0.843251,
      NULL,
      4.461346,
      2.411265,
      1.933170,
      0,
      0,
      0.591351,
      1,
      NULL,
      2,
      NULL,
      2.169506,
      5.209787,
      4.670703,
      3,
      NULL,
      0.223505,
      NULL,
      2,
      2,
      2.918347,
      1.775611,
      NULL,
      3,
      2,
      0.417336,
      1.200005,
      1.626725,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.279759,
      1,
      5.885687,
      1,
      4.772951,
      3,
      0,
      5.233260,
      4,
      5.794280,
      0,
      2.476281,
      NULL,
      NULL,
      2,
      1.311512,
      1,
      1,
      3.515353,
      1.481134,
      5.868167,
      0.732867,
      8,
      NULL,
      NULL,
      3,
      0,
      NULL,
      7.926605,
      6,
      1.048805,
      7,
      4.911084,
      1.027028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075781,
      1.744911,
      1.087592,
      0,
      2,
      3.190072,
      3,
      NULL,
      3,
      5,
      NULL,
      0,
      0.619504,
      6.060886,
      7,
      5.151509,
      5,
      3,
      0,
      0,
      5,
      3.232872,
      2,
      2.754810,
      4,
      1,
      2,
      NULL,
      9,
      2,
      5,
      1.875768,
      NULL,
      1,
      7.283612,
      0.616751,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193454,
      0,
      0,
      0.085916,
      0.421760,
      NULL,
      0.273186,
      0,
      1,
      0.910379,
      0,
      0.652898,
      0.560241,
      0.066191,
      NULL,
      0,
      1.764747,
      1,
      0,
      1.524900,
      1,
      0.767516,
      NULL,
      0,
      0.890047,
      1.955805,
      NULL,
      1.861368,
      NULL,
      0.809712,
      0,
      1,
      0.715479,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019712,
      0.527067,
      1.039021,
      1,
      1.944482,
      0,
      0.531261,
      5,
      0,
      4.590887,
      NULL,
      2.265290,
      0.442948,
      NULL,
      1,
      4.750494,
      0.421081,
      2,
      NULL,
      3.142238,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1.281658,
      1.032286,
      1.567246,
      0.689821,
      0.649840,
      0,
      1.099842,
      NULL,
      4.550076,
      0.574580,
      0.767833,
      1.966182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      7,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      4,
      0,
      2,
      2,
      5,
      0,
      2,
      NULL,
      2,
      6,
      NULL,
      6,
      1,
      5,
      3,
      NULL,
      NULL,
      3,
      3,
      5,
      NULL,
      1,
      2,
      1,
      5,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-15-1985',
      ' 5-19-2002',
      ' 3- 5-1995',
      ' 7-17-1978',
      ' 9-15-1990',
      ' 1-21-1991',
      ' 9-16-1984',
      ' 5-14-1990',
      ' 8- 6-1997',
      ' 0-16-1993',
      ' 0-28-1991',
      NULL,
      NULL,
      ' 7- 6-1976',
      ' 8-17-1984',
      ' 7- 0-1976',
      ' 1-11-2003',
      ' 2-27-1979',
      NULL,
      ' 6-26-1980',
      ' 5- 4-1999',
      ' 7-13-1977',
      ' 3-25-1983',
      ' 1-22-2002',
      NULL,
      NULL,
      ' 3-27-1982',
      ' 7-10-1992',
      NULL,
      ' 3- 0-1989',
      '10-28-1995',
      ' 9-10-1976',
      ' 9-28-1994',
      NULL,
      ' 4-18-1994',
      ' 2- 2-1995',
      ' 2-13-1974',
      NULL,
      ' 7-17-1980',
      '10- 6-1995',
      ' 1- 7-1991',
      NULL,
      ' 4-17-1995',
      ' 7- 3-1989',
      '11-17-1995',
      ' 1-26-1995',
      NULL,
      NULL,
      ' 5- 9-1992',
      ' 8-19-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346642);
commit;
end;
/


