set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5309016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '2412402',
      2,
      1.349177,
      3,
      '00210',
      NULL,
      ' 7- 7-1979',
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.663466,
      2.316187,
      0,
      NULL,
      2.632996,
      3,
      9,
      NULL,
      NULL,
      0.572898,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154258,
      NULL,
      2.984927,
      2.226877,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      6,
      7,
      NULL,
      1,
      1,
      12,
      8,
      6,
      0,
      1.527213,
      1.223517,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      9,
      NULL,
      8,
      7,
      NULL,
      9.000754,
      1.929980,
      1275.639159,
      NULL,
      NULL,
      124,
      NULL,
      NULL,
      3,
      0,
      1,
      3,
      4,
      11.657511,
      27.082709,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      8.080913,
      167,
      1844.650628,
      3,
      NULL,
      184.282221,
      11704.389808,
      2.762795,
      19.976094,
      165.781574,
      59.361462,
      1,
      2.773673,
      221.536856,
      18,
      3,
      4.660959,
      168,
      31,
      2,
      NULL,
      107,
      32,
      2,
      1,
      100.681317,
      14,
      0.116124,
      2,
      173.797802,
      8.383171,
      0,
      2,
      612.831597,
      1743,
      1,
      3.669687,
      494.266305,
      1300.433175,
      1.943796,
      NULL,
      672,
      3979,
      3,
      5,
      NULL,
      3460.618992,
      2.641982,
      0,
      652,
      576.954176,
      0.534070,
      0,
      188,
      1914,
      3.560354,
      2.088268,
      99,
      1,
      2.835606,
      3,
      1246,
      837,
      1.162349,
      0.777583,
      1355.899216,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.511854,
      NULL,
      352.524089,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.269138,
      NULL,
      74.016213,
      41.685237,
      NULL,
      3.785872,
      90,
      NULL,
      2.347341,
      0.643794,
      14.456120,
      9,
      1.429321,
      NULL,
      159.724212,
      NULL,
      2,
      3.378741,
      166,
      80,
      3.113904,
      2,
      59.127766,
      8.026237,
      0.970410,
      NULL,
      203.270123,
      241.939727,
      2.850986,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      209,
      140.714214,
      1.297344,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.926209,
      NULL,
      '31343',
      '21112',
      '30003',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      5,
      1.609746,
      NULL,
      NULL,
      NULL,
      NULL,
      27.907673,
      1,
      NULL,
      1.958397,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.897238,
      NULL,
      1.291347,
      NULL,
      0,
      NULL,
      ' 5- 1-1979',
      13.662508,
      NULL,
      6.292567,
      5.162646,
      7,
      NULL,
      4,
      13.396121,
      11.485011,
      0.146435,
      NULL,
      0,
      7,
      NULL,
      19.595908,
      2.499658,
      1.679193,
      0,
      6,
      18.541847,
      1.526140,
      0,
      4.205930,
      2,
      12,
      10.696926,
      2.580564,
      5,
      NULL,
      19.771963,
      21,
      16.927301,
      9.637655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      12.330255,
      21,
      17,
      7.852532,
      4,
      18.176689,
      27.479100,
      19,
      0,
      NULL,
      9,
      23.764244,
      31.286567,
      22.024681,
      29.639033,
      15,
      31.117153,
      30.160790,
      7,
      33.321523,
      27,
      24.817538,
      NULL,
      29.915846,
      48.733380,
      13.769574,
      36.427673,
      5.871461,
      1,
      47.714122,
      9,
      20,
      12.106170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85.115649,
      7.716556,
      NULL,
      47,
      NULL,
      99,
      NULL,
      75.995146,
      58,
      51,
      105.409072,
      104,
      81,
      115.906448,
      114.734045,
      51.863279,
      118.565482,
      115,
      NULL,
      115,
      44,
      17.746427,
      163.665767,
      38.450081,
      82,
      118,
      16,
      29,
      113,
      NULL,
      53,
      117.062743,
      101,
      18.155629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0.756175,
      4.393094,
      0,
      NULL,
      2,
      0,
      0.078503,
      3.107209,
      NULL,
      NULL,
      0.078368,
      5.787647,
      3.804929,
      7.950618,
      1,
      1,
      6.835679,
      NULL,
      0.933711,
      10,
      3,
      3.607787,
      7,
      NULL,
      1,
      7,
      7,
      7,
      NULL,
      5,
      5.857876,
      7.944833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.107698,
      NULL,
      8,
      3.739841,
      6.637933,
      NULL,
      3,
      3,
      2,
      5,
      4.177020,
      NULL,
      7,
      5.885276,
      6,
      4.264635,
      9,
      2,
      2,
      0.441136,
      6.967172,
      1,
      6.926054,
      2.070234,
      3,
      0.233632,
      1,
      3.786668,
      4.363709,
      NULL,
      4,
      NULL,
      5.414800,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.307624,
      7,
      4.832622,
      4,
      4.719149,
      NULL,
      1,
      10,
      1.524689,
      1,
      4.867707,
      NULL,
      4.861330,
      4.850771,
      0.987222,
      1.726485,
      5.603017,
      4,
      0.217689,
      NULL,
      2,
      1,
      5,
      2.663739,
      NULL,
      1,
      5.441788,
      8,
      0,
      6.073985,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.384126,
      0,
      NULL,
      0.019730,
      1,
      NULL,
      NULL,
      NULL,
      3.858095,
      0,
      1,
      2.638432,
      4.235147,
      1,
      4,
      NULL,
      NULL,
      5,
      3.051863,
      3,
      3.483158,
      6,
      5,
      7,
      NULL,
      4.266385,
      0,
      1,
      7.222506,
      3.835139,
      NULL,
      2.318011,
      2.082263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.010060,
      0.849254,
      NULL,
      1.056383,
      1,
      0.764083,
      NULL,
      0.481148,
      1,
      2.455324,
      0.680047,
      3,
      NULL,
      5.729825,
      4.855029,
      NULL,
      NULL,
      0,
      2,
      0,
      2.811006,
      NULL,
      2.608695,
      2.954795,
      NULL,
      NULL,
      2.447501,
      1.113527,
      5.051695,
      2.740691,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      NULL,
      4.823407,
      4.678991,
      2.075966,
      NULL,
      5.055572,
      0.048490,
      2.712649,
      5,
      5.423860,
      2.227006,
      5,
      3.302069,
      NULL,
      5.294319,
      NULL,
      0,
      2,
      5.188173,
      1.406948,
      5.524674,
      NULL,
      5.883303,
      3.456438,
      0,
      NULL,
      2,
      6.041590,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3.628898,
      NULL,
      4.210489,
      NULL,
      5.118154,
      2,
      0,
      3,
      0,
      5,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.386529,
      1,
      1,
      3.331032,
      3,
      2,
      NULL,
      NULL,
      5,
      3,
      NULL,
      6,
      7,
      0.384960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      1,
      3,
      2.125829,
      5,
      NULL,
      0,
      NULL,
      0,
      NULL,
      4,
      3,
      1,
      1,
      3.628283,
      3,
      NULL,
      3,
      3,
      3.871675,
      NULL,
      2,
      5,
      0.084253,
      NULL,
      NULL,
      2,
      2.545744,
      0.420216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.410650,
      3.717481,
      3,
      0.913164,
      1.506486,
      NULL,
      1,
      0.667788,
      3.104985,
      2,
      NULL,
      0.507854,
      3,
      0,
      1.856645,
      0.334450,
      NULL,
      0.120928,
      0,
      2.867726,
      3.066816,
      NULL,
      NULL,
      NULL,
      2.162817,
      NULL,
      3,
      3,
      2,
      1.518698,
      1.221028,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.895773,
      2.043979,
      2.482649,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.628204,
      1,
      3,
      0.635184,
      0.218036,
      3,
      1,
      3.924209,
      2,
      2,
      2.007716,
      3,
      NULL,
      3.398472,
      1.054498,
      NULL,
      2,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512883,
      0,
      0,
      1.630539,
      0,
      NULL,
      NULL,
      0,
      4.917314,
      0,
      2.126253,
      3.879593,
      NULL,
      0,
      3.956632,
      1.385256,
      4,
      0,
      0.390763,
      0,
      5,
      1,
      0,
      1,
      1,
      0.331560,
      0,
      0,
      0,
      4.927465,
      7,
      7.018573,
      3,
      5.663737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778967,
      0.818559,
      NULL,
      NULL,
      1.861080,
      1,
      NULL,
      1.992797,
      0.380272,
      1,
      3,
      1,
      NULL,
      2.110086,
      0,
      NULL,
      0.523744,
      NULL,
      0,
      NULL,
      0,
      3,
      2,
      0.010070,
      3.913636,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      1.753731,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468266,
      1.745410,
      0.743856,
      0,
      NULL,
      0,
      0,
      0,
      1.836815,
      0,
      1,
      0,
      0,
      0.713285,
      1,
      1.726337,
      1.403690,
      1,
      0.122669,
      0.900174,
      0.982094,
      NULL,
      0,
      0.129429,
      NULL,
      1.130195,
      1.873337,
      0.113009,
      0.528850,
      1.364816,
      1.150238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7.908699,
      NULL,
      4.158788,
      3,
      3.911462,
      5.956146,
      5,
      5,
      8.751235,
      1,
      3,
      3,
      NULL,
      1.717685,
      0.427478,
      7.327611,
      4,
      6,
      0,
      7.096855,
      NULL,
      NULL,
      0,
      7.571017,
      3.686426,
      6.363835,
      7.378284,
      NULL,
      6.186777,
      10,
      8.267521,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083313,
      0,
      0,
      NULL,
      5.512938,
      0,
      NULL,
      4,
      1,
      NULL,
      3.812395,
      0,
      1.902125,
      1,
      4,
      NULL,
      5.076003,
      3.840056,
      5.745692,
      4,
      2.966218,
      2.675135,
      3,
      4,
      3.126751,
      4.847216,
      0,
      3.617693,
      0,
      4.713065,
      2.621353,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499122,
      1.901665,
      NULL,
      1,
      0.285132,
      0,
      0,
      4,
      4,
      3.463479,
      NULL,
      4,
      0,
      3.801810,
      NULL,
      4,
      2.110886,
      2,
      0,
      3,
      3,
      0,
      0.971532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.557906,
      1,
      NULL,
      0.678585,
      1,
      1,
      1,
      0,
      0.384209,
      0,
      1.591139,
      NULL,
      0.837812,
      1,
      1,
      0,
      0.480832,
      2.613470,
      1,
      NULL,
      4,
      1,
      1,
      0.275945,
      NULL,
      1.152755,
      1.378688,
      1.519471,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      2,
      3,
      1,
      2,
      2,
      0,
      2,
      0,
      4,
      0,
      0,
      0,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-20-1976',
      '10- 1-1995',
      NULL,
      NULL,
      ' 5-19-2003',
      ' 2-19-1995',
      ' 6-14-1997',
      '11- 2-1974',
      ' 5-13-2001',
      '11-25-1975',
      ' 6-18-1978',
      ' 7-25-2002',
      ' 4-14-1984',
      NULL,
      ' 7- 3-2000',
      NULL,
      ' 5- 8-1981',
      '11-11-1989',
      ' 7- 6-1988',
      ' 1-22-1975',
      ' 7-11-1998',
      ' 4-20-1986',
      NULL,
      ' 0-23-1975',
      ' 1-27-1999',
      ' 5-17-1975',
      ' 4- 9-1988',
      ' 7-14-1981',
      ' 8-25-1988',
      '10- 8-1993',
      ' 0-23-2000',
      ' 6- 1-1975',
      ' 7-16-1997',
      ' 7- 2-2001',
      NULL,
      ' 6- 6-1996',
      ' 0-25-1976',
      ' 2-24-1988',
      ' 3-22-1976',
      ' 2-17-1997',
      ' 8- 5-1989',
      ' 8- 9-1979',
      ' 9- 1-1987',
      ' 8-17-1987',
      ' 6- 6-1977',
      NULL,
      NULL,
      ' 8- 8-1984',
      ' 2-26-1977',
      ' 6-17-1987',
      ' 7-14-1977',
      ' 1- 4-2000',
      ' 3-26-1989',
      ' 7-20-1984',
      ' 9- 7-1988',
      ' 3- 1-1992',
      ' 6-13-1983',
      NULL,
      ' 8- 9-1999',
      NULL,
      ' 8- 6-1993',
      ' 9-25-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-10-1983',
      NULL,
      ' 1-16-1986',
      NULL,
      ' 8-22-1981',
      '10-27-1987',
      ' 8-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343326);
commit;
end;
/


