set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5309016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '4233230',
      0,
      NULL,
      NULL,
      '00122',
      0,
      ' 0- 0-1974',
      52,
      NULL,
      0.656284,
      NULL,
      1,
      1.968129,
      0.458458,
      NULL,
      0,
      3,
      NULL,
      0,
      0,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.603156,
      NULL,
      1.123779,
      NULL,
      1,
      1,
      0,
      5,
      0,
      1,
      0,
      1,
      1,
      NULL,
      6,
      3,
      NULL,
      1,
      8,
      1.683281,
      5,
      2.858773,
      4,
      1,
      1,
      0.247061,
      0.555432,
      2,
      3,
      NULL,
      0,
      0,
      5,
      0.181879,
      NULL,
      5.566381,
      NULL,
      7,
      0.850880,
      1029.836452,
      86,
      NULL,
      195.460855,
      2.508795,
      NULL,
      0,
      5,
      NULL,
      0,
      NULL,
      37.305541,
      13,
      2216.219221,
      1.520222,
      1.269597,
      215.565405,
      4720,
      NULL,
      1,
      199.299404,
      9074.412083,
      3,
      0,
      NULL,
      7846,
      3.214955,
      2,
      NULL,
      1.636031,
      0.803262,
      1.730962,
      NULL,
      NULL,
      NULL,
      1.821291,
      45.163321,
      1,
      3,
      0.014580,
      177.555077,
      NULL,
      3,
      7,
      99.767885,
      66,
      1,
      3.044697,
      26,
      13.432033,
      2,
      2,
      794,
      470,
      NULL,
      2,
      365,
      708.617544,
      0.393790,
      4.281961,
      297,
      NULL,
      1.840526,
      3.062084,
      NULL,
      3578.550443,
      2,
      3.194398,
      651.644892,
      2325.977620,
      NULL,
      5,
      151,
      1736,
      NULL,
      3.580811,
      NULL,
      1,
      1.427470,
      1.346497,
      728,
      463,
      NULL,
      3,
      753.366347,
      NULL,
      NULL,
      2.820409,
      4,
      5,
      NULL,
      NULL,
      NULL,
      7,
      0.710206,
      0,
      NULL,
      NULL,
      3,
      2.450286,
      80.662718,
      NULL,
      2.884912,
      NULL,
      6,
      19,
      0.656526,
      5,
      61.555178,
      48,
      NULL,
      NULL,
      221,
      NULL,
      0.187657,
      3.856138,
      136,
      80.658901,
      2,
      5,
      203.595251,
      NULL,
      0,
      4.686124,
      NULL,
      78,
      1,
      1,
      25.170720,
      216,
      1.654884,
      NULL,
      111,
      592.754714,
      NULL,
      NULL,
      21,
      9.533739,
      1,
      1.969310,
      NULL,
      2,
      3.490160,
      7.560698,
      46,
      23.863411,
      2,
      NULL,
      NULL,
      6.036083,
      1.790320,
      NULL,
      NULL,
      24.317110,
      3.316055,
      2.032610,
      188.920947,
      NULL,
      1.724895,
      3,
      NULL,
      2,
      0.219536,
      2,
      NULL,
      26.978477,
      1.022805,
      0,
      143.796240,
      47,
      3.382682,
      0.170100,
      58,
      40,
      NULL,
      3.584572,
      391,
      30.346576,
      2.729902,
      1,
      365,
      0,
      3,
      3,
      560,
      6,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.371869,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      2,
      NULL,
      113,
      0.529316,
      857.849301,
      4,
      13.601496,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.140057,
      NULL,
      0.506106,
      NULL,
      0.206205,
      NULL,
      0.914366,
      NULL,
      ' 9-11-1980',
      8,
      11.355031,
      NULL,
      6.376466,
      13.503737,
      1.600844,
      NULL,
      13,
      9,
      5.285054,
      5.893768,
      17.573945,
      NULL,
      1.813970,
      18.278260,
      12,
      12,
      0,
      NULL,
      23.141419,
      NULL,
      NULL,
      6,
      4,
      7.763849,
      7,
      0.728771,
      NULL,
      2.550605,
      NULL,
      NULL,
      22,
      17,
      7,
      11.911636,
      2.154037,
      7.535730,
      11,
      14.609787,
      12.868871,
      1.742602,
      5.104497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      20.891527,
      12,
      1,
      NULL,
      30,
      17,
      23,
      14,
      13.509961,
      2.958945,
      0,
      NULL,
      16,
      5.355805,
      44,
      NULL,
      12,
      22.085886,
      28.882031,
      2.683393,
      20,
      14,
      17.855556,
      3.738600,
      53,
      35.362760,
      38.326755,
      5.655869,
      0,
      32.194107,
      NULL,
      29.762878,
      NULL,
      20,
      12.411249,
      22,
      13.107594,
      15.731711,
      9,
      28,
      41,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      103,
      18.956142,
      3,
      NULL,
      7,
      68.680586,
      42,
      NULL,
      115,
      NULL,
      125.081641,
      7,
      161,
      85,
      135.656898,
      NULL,
      94.315694,
      NULL,
      146.033267,
      127.298296,
      105.237166,
      138,
      36.296830,
      137.455246,
      NULL,
      NULL,
      106.199044,
      37.741982,
      80.907035,
      149.174451,
      163,
      NULL,
      NULL,
      32.963523,
      66.128571,
      144.104766,
      19,
      46.880765,
      162.613926,
      90,
      90,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.378510,
      3.099216,
      3,
      6.707028,
      1.690524,
      9.546045,
      2,
      2.538001,
      10.291837,
      7.267805,
      3.689912,
      2,
      4,
      0.062459,
      6.621284,
      11.766435,
      1.646936,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      3,
      0.453148,
      9.541022,
      1,
      8,
      NULL,
      7.557473,
      6,
      2,
      1.525484,
      3.073144,
      1.842462,
      7.818746,
      3.657879,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      6.543146,
      5,
      3,
      4,
      NULL,
      5.014152,
      3.530653,
      7,
      4,
      9,
      4.577470,
      8.623169,
      1,
      0.391706,
      NULL,
      2.968084,
      NULL,
      6.946480,
      1.482625,
      1.430152,
      0.986851,
      NULL,
      0,
      2,
      0.452265,
      0,
      9.983102,
      7,
      4.375214,
      NULL,
      NULL,
      0,
      0.329456,
      5,
      3.622032,
      4,
      4.482606,
      NULL,
      2.059361,
      1.561939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709077,
      2.791864,
      1.686916,
      4,
      5,
      6.043953,
      0,
      NULL,
      0,
      8,
      3.578660,
      1,
      NULL,
      1.912153,
      7.534068,
      4,
      7.709542,
      NULL,
      NULL,
      2.676578,
      NULL,
      1.276232,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.114513,
      3.327655,
      1.993811,
      0,
      4,
      5,
      1,
      5,
      5.413739,
      5.074079,
      3,
      3.355580,
      4,
      3,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378521,
      2.877285,
      3.699453,
      1.867220,
      3.153553,
      2,
      3,
      1.937259,
      9,
      0,
      1,
      3,
      2,
      1.864597,
      5,
      1,
      3,
      4,
      2,
      3,
      2,
      4.127598,
      7,
      7,
      6,
      6.485175,
      5.363691,
      9.610944,
      1.394530,
      5,
      1,
      4,
      5,
      4,
      1.865934,
      NULL,
      NULL,
      NULL,
      2.990818,
      2.353456,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728970,
      NULL,
      2.750458,
      1.409663,
      NULL,
      3,
      3,
      0,
      2,
      0,
      2.408194,
      2,
      2,
      NULL,
      5,
      1,
      3,
      1.006100,
      NULL,
      3,
      NULL,
      NULL,
      0.400238,
      2.576024,
      0,
      3.958907,
      NULL,
      NULL,
      3.186527,
      4,
      NULL,
      5.213380,
      1,
      0,
      1.399628,
      0.596504,
      1,
      NULL,
      0,
      1,
      1.776097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      4,
      2.298862,
      3,
      1.678021,
      2.022979,
      5,
      NULL,
      5.862757,
      4,
      1.324465,
      4.921407,
      4,
      4,
      5,
      4.808192,
      NULL,
      1.709886,
      2,
      3.668288,
      5,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      7,
      4.986794,
      NULL,
      0,
      0,
      2.295860,
      0.103786,
      0.687721,
      4.813398,
      5,
      6,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.887277,
      1.896417,
      2,
      NULL,
      4,
      5.235536,
      1.362965,
      3.216883,
      1.366924,
      NULL,
      NULL,
      5,
      2,
      2,
      NULL,
      0,
      5.156939,
      2,
      NULL,
      1.512772,
      2.679563,
      2.865840,
      2.006138,
      2.658776,
      0.076334,
      1.178300,
      2.886484,
      2,
      5.174423,
      NULL,
      4.297870,
      6,
      3,
      0,
      5,
      3.354267,
      1,
      0,
      4,
      NULL,
      3,
      7,
      1.862661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.838782,
      3,
      1,
      2,
      1.322804,
      NULL,
      2.714355,
      5,
      3,
      NULL,
      3,
      2,
      3.045861,
      1,
      0,
      NULL,
      3.944737,
      1.212407,
      4.611223,
      3,
      NULL,
      NULL,
      0.353281,
      1.423292,
      2,
      1,
      5,
      1.295155,
      0,
      0.107887,
      3.389150,
      NULL,
      0.640814,
      1,
      0.733886,
      0.059505,
      1,
      NULL,
      0,
      3,
      1.071834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0.806432,
      2.560905,
      3,
      3,
      3.436204,
      0.010319,
      0,
      NULL,
      NULL,
      3,
      0.876401,
      0,
      1.732883,
      3,
      0.738806,
      0,
      2.930386,
      2.490008,
      0.060814,
      NULL,
      1.468390,
      0.574614,
      0,
      3,
      3,
      1.069537,
      2,
      NULL,
      0.942253,
      2,
      NULL,
      0,
      2.954398,
      NULL,
      NULL,
      2,
      1,
      2.326697,
      0.728100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.228775,
      2.268155,
      0.418401,
      0.574444,
      1.740782,
      NULL,
      NULL,
      3.107270,
      2.349106,
      4,
      1,
      3.362890,
      0,
      2,
      0.334566,
      3.046965,
      0.683525,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      3,
      3.772244,
      0,
      0,
      3,
      0.439786,
      2.396669,
      0,
      4.879346,
      1.658242,
      NULL,
      NULL,
      4.537812,
      NULL,
      2,
      3,
      0,
      1.588890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.245149,
      1,
      0,
      1,
      0,
      0.241526,
      1.194590,
      0.204303,
      1.472114,
      4.744730,
      3.163347,
      4.660829,
      3,
      3.990318,
      3,
      5,
      0,
      5.982149,
      1.263435,
      2,
      0.265658,
      1,
      1.850468,
      1.100236,
      0,
      0,
      0,
      5,
      NULL,
      3,
      4,
      6,
      2,
      2.840889,
      0,
      0.897237,
      0.918688,
      0,
      NULL,
      1,
      1,
      1.606035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382066,
      NULL,
      0.851646,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      2.138105,
      1.488116,
      NULL,
      0,
      0,
      1.332474,
      0,
      1.125152,
      1.283832,
      3,
      2,
      4,
      2,
      1.397150,
      NULL,
      NULL,
      0.545823,
      1.799797,
      1.549097,
      0.506092,
      0,
      NULL,
      5.382777,
      2.111665,
      7.541722,
      3,
      1.552768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1.884350,
      1,
      1,
      NULL,
      0,
      1.923612,
      0,
      1.720447,
      0.880355,
      1.637983,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0.161827,
      1.014783,
      NULL,
      1.039327,
      0.699273,
      0.710913,
      NULL,
      NULL,
      NULL,
      0.381693,
      0.907723,
      0.863750,
      1,
      NULL,
      NULL,
      1.753521,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.543234,
      11,
      5,
      11,
      6.754119,
      1.909713,
      3,
      4,
      11,
      6,
      7,
      9.077997,
      2,
      2.385396,
      NULL,
      0.678373,
      3,
      7,
      4.483625,
      2.032698,
      NULL,
      10,
      NULL,
      8,
      4.866924,
      2,
      NULL,
      NULL,
      9.293287,
      9,
      2.619051,
      NULL,
      7.820619,
      NULL,
      1.533708,
      0.600103,
      6.471657,
      3,
      NULL,
      6.456904,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.030818,
      6,
      3.435519,
      NULL,
      1,
      0,
      4.849515,
      1.370439,
      3,
      NULL,
      0.403901,
      NULL,
      2,
      3,
      NULL,
      0,
      5.377008,
      3,
      2.190723,
      NULL,
      2,
      4,
      0.936261,
      1.094038,
      5.675934,
      5,
      NULL,
      6.447276,
      6,
      9,
      NULL,
      5,
      2.296637,
      7,
      4.065025,
      1.098217,
      3.927294,
      6.175166,
      NULL,
      NULL,
      5.265023,
      8.461456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253293,
      1,
      0,
      0.909496,
      1,
      1,
      NULL,
      NULL,
      3.841227,
      1,
      NULL,
      0,
      NULL,
      1.534428,
      5,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      1.515525,
      0.651072,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      6,
      6.775550,
      0,
      NULL,
      1,
      1.487025,
      NULL,
      0.735352,
      1,
      0,
      1,
      1.485050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248045,
      0.914951,
      1.441183,
      NULL,
      1,
      1.971273,
      1.736557,
      NULL,
      0.727277,
      1,
      0.312590,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      0.784496,
      1,
      3.039816,
      4,
      0,
      1,
      NULL,
      1.443463,
      0,
      1.781970,
      0,
      0.122976,
      0,
      NULL,
      1.539181,
      1,
      0,
      NULL,
      3.586220,
      1.339131,
      5.145411,
      0,
      0.723664,
      1.145811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      2,
      5,
      2,
      2,
      3,
      2,
      NULL,
      2,
      2,
      NULL,
      2,
      1,
      0,
      1,
      3,
      5,
      1,
      NULL,
      0,
      2,
      2,
      NULL,
      0,
      3,
      1,
      2,
      2,
      NULL,
      NULL,
      4,
      0,
      3,
      2,
      0,
      4,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-1978',
      ' 5-21-1987',
      NULL,
      ' 1-16-1986',
      ' 0-12-1984',
      ' 9- 5-1982',
      ' 2- 2-1984',
      ' 9-11-2003',
      ' 8-23-1985',
      '10-13-1979',
      ' 7-25-2002',
      '11-21-1979',
      ' 2- 8-1999',
      ' 0- 5-1996',
      ' 0-14-1977',
      ' 5-11-1978',
      ' 5- 0-1986',
      ' 7- 0-1990',
      ' 6- 0-1977',
      ' 3-10-2000',
      NULL,
      ' 6- 0-1977',
      NULL,
      '10-26-1983',
      NULL,
      ' 1- 0-1997',
      '10-28-1986',
      ' 4-13-1978',
      ' 1-17-1977',
      ' 1-28-1979',
      ' 9- 9-1995',
      ' 7-23-1977',
      '11- 1-1989',
      NULL,
      ' 0-22-1993',
      ' 6-23-2002',
      ' 6-26-1992',
      ' 2- 2-2001',
      ' 5-13-1981',
      ' 0-13-1985',
      ' 9- 6-1986',
      ' 2- 1-1994',
      '10-22-1999',
      NULL,
      ' 6-27-1985',
      NULL,
      ' 2- 4-1980',
      ' 9-24-1985',
      ' 7- 0-1991',
      ' 2-12-1994',
      ' 3-15-1986',
      ' 8-18-1981',
      ' 1- 7-1988',
      '11-26-1974',
      ' 6-19-1986',
      ' 8-22-2000',
      ' 6- 2-1995',
      ' 3-27-1997',
      ' 0-16-1988',
      NULL,
      ' 0-19-2002',
      ' 7-16-1997',
      '10- 1-1996',
      NULL,
      ' 9-11-1979',
      ' 4- 6-1985',
      ' 4-14-2001',
      ' 2-25-1981',
      ' 6-18-1993',
      ' 0-17-1999',
      ' 9-27-1988',
      ' 9- 5-1979',
      '10-11-1993',
      ' 8-14-1993',
      ' 4- 6-1981',
      ' 9- 0-1993',
      '11-22-1996',
      ' 6- 9-1988',
      '10-20-1977',
      NULL,
      ' 2- 1-1996',
      NULL,
      ' 0- 3-1998',
      ' 9-16-1978',
      ' 4- 7-1981',
      NULL,
      ' 6-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-15-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


