set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6703672';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      2,
      2.605189,
      0,
      '00304',
      2.979086,
      NULL,
      122,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.328349,
      0,
      0,
      1.720342,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.831764,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      4,
      4,
      0,
      0.797643,
      NULL,
      0.373669,
      NULL,
      1.526236,
      1.293754,
      1,
      4,
      1.452204,
      0.811672,
      0.701759,
      NULL,
      NULL,
      7,
      5.777417,
      0,
      0,
      NULL,
      2.677693,
      1.958866,
      '11-24-1978',
      12,
      1,
      NULL,
      1,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      8.889405,
      0,
      1.201696,
      82.730692,
      NULL,
      1,
      1.897822,
      176,
      8.375119,
      2,
      NULL,
      69,
      NULL,
      2,
      1,
      201,
      NULL,
      NULL,
      2,
      279.264044,
      661.700510,
      1.587176,
      7.799243,
      NULL,
      NULL,
      2,
      NULL,
      278.653425,
      1.405312,
      NULL,
      6.289535,
      248.159350,
      NULL,
      2,
      NULL,
      196,
      67,
      3.797263,
      4.254614,
      110,
      75.238037,
      2.501921,
      0.497731,
      122,
      413,
      1.981845,
      2,
      576.078259,
      NULL,
      2,
      1.851177,
      NULL,
      2,
      3,
      0.605397,
      129.164895,
      3,
      0,
      0,
      1338.884846,
      0,
      0.451271,
      1,
      1262.141895,
      325,
      NULL,
      1,
      66,
      NULL,
      NULL,
      2.203052,
      146,
      22.927470,
      0.671196,
      0.411959,
      60.511162,
      7,
      2,
      2,
      32,
      20,
      3.414588,
      NULL,
      189,
      15,
      NULL,
      2.510826,
      953,
      179,
      0,
      5.363088,
      394,
      NULL,
      0.257175,
      5.140118,
      125,
      17.361446,
      NULL,
      NULL,
      172,
      4.796048,
      0,
      7,
      320,
      724.052815,
      0,
      NULL,
      142.918468,
      NULL,
      3.406314,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '34312',
      '',
      '',
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      3,
      9.797153,
      1883,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.808696,
      NULL,
      0,
      NULL,
      0.188194,
      NULL,
      1.957344,
      NULL,
      1,
      NULL,
      0,
      NULL,
      ' 5- 0-1995',
      2,
      3.443992,
      9.375097,
      3.597688,
      4.093323,
      NULL,
      17.650329,
      0.102516,
      NULL,
      NULL,
      1.204542,
      12,
      0,
      4.137853,
      4,
      NULL,
      2,
      0.637840,
      16.242533,
      11.881126,
      0.321839,
      5.504910,
      2.754446,
      2,
      8,
      8,
      NULL,
      8,
      3,
      5.026907,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      42.168653,
      0.893078,
      NULL,
      8,
      20,
      0,
      37,
      7.497770,
      1.241956,
      NULL,
      NULL,
      4.041880,
      2,
      47,
      18,
      30,
      2,
      NULL,
      12.859650,
      0.102759,
      37,
      0.595342,
      NULL,
      0.743467,
      21,
      16.552244,
      20,
      3.693537,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      38.425176,
      80.330807,
      12,
      NULL,
      70.272395,
      64,
      20.246825,
      NULL,
      87.037422,
      50,
      60,
      NULL,
      73,
      56,
      138,
      NULL,
      NULL,
      22,
      NULL,
      4.592841,
      NULL,
      94,
      72,
      13.715160,
      144.213677,
      NULL,
      171,
      157,
      61,
      183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.468919,
      6,
      0.657610,
      7,
      1,
      3.666065,
      1.687011,
      9.604958,
      NULL,
      NULL,
      0.124421,
      11,
      8.797531,
      8,
      1,
      6.823983,
      5,
      NULL,
      3.921369,
      NULL,
      NULL,
      8,
      7,
      NULL,
      NULL,
      NULL,
      8,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.565044,
      NULL,
      3,
      2.222808,
      4.071718,
      3,
      0.675103,
      NULL,
      0.854528,
      1,
      4.050409,
      NULL,
      6.392235,
      NULL,
      1,
      0.146992,
      6.158591,
      4,
      NULL,
      0.860090,
      0,
      1,
      NULL,
      8.359203,
      5,
      2.515087,
      4,
      NULL,
      2.453173,
      2,
      0.969958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465171,
      0,
      1,
      1.864543,
      0,
      NULL,
      1,
      NULL,
      7,
      0.915897,
      1,
      0,
      3.176698,
      1.529107,
      NULL,
      0.160732,
      1.279619,
      0,
      2,
      5.851580,
      NULL,
      0,
      1.533507,
      3,
      1,
      0.682063,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      7,
      4,
      1.437901,
      1.101675,
      5.658176,
      1.528306,
      NULL,
      NULL,
      3.208259,
      1,
      0,
      1.420420,
      1.780093,
      0,
      7,
      1.132125,
      5,
      NULL,
      1.547856,
      1,
      NULL,
      NULL,
      3,
      4,
      4.115909,
      1.696601,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780856,
      1,
      1.313308,
      0,
      5,
      0.239213,
      0,
      2,
      1,
      NULL,
      0.192890,
      1,
      2.280055,
      2,
      1.173837,
      1,
      1,
      1.062397,
      1.660252,
      0.001134,
      NULL,
      0.212428,
      1,
      0.292121,
      NULL,
      1,
      0,
      1.511179,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.287872,
      0,
      3.551631,
      0.738389,
      2,
      4,
      1,
      6,
      3,
      1.135321,
      5,
      3.517561,
      0,
      2.378859,
      6.775205,
      5,
      0.921086,
      8,
      NULL,
      3.054402,
      1.143934,
      5,
      2.647287,
      2.089818,
      2.318921,
      2,
      NULL,
      4.247422,
      4,
      1.563287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      7.230790,
      3.013161,
      5.188165,
      6.343548,
      NULL,
      3,
      NULL,
      3.189059,
      5,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      7,
      4.112749,
      3.032194,
      7.416321,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.190832,
      NULL,
      0.570344,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861343,
      4.701210,
      2,
      7,
      0,
      2,
      1,
      8,
      1.045576,
      1,
      5,
      9.757301,
      5,
      2.680368,
      2.318200,
      7,
      7,
      3.631492,
      4.211293,
      2,
      5.073353,
      1,
      7,
      NULL,
      NULL,
      0,
      4,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602484,
      1,
      1,
      1.852823,
      3,
      1.204900,
      1.533815,
      0.756240,
      3,
      NULL,
      1,
      0,
      0,
      0.128683,
      1,
      0,
      1,
      1.309071,
      NULL,
      NULL,
      0,
      0.188711,
      0.382562,
      0.625128,
      0.881563,
      1.165197,
      NULL,
      0,
      0,
      1.957112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.365733,
      1,
      NULL,
      1.746960,
      1.211721,
      1,
      0.332382,
      1.240491,
      0.736767,
      0.372553,
      1.366718,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1.567098,
      0.981025,
      1,
      1.111586,
      NULL,
      1,
      1,
      0,
      0,
      0.529929,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.822908,
      1.768322,
      1.660146,
      0.081254,
      NULL,
      NULL,
      0,
      0.229091,
      1,
      0,
      0.591921,
      1.753335,
      0.657959,
      0.762186,
      0,
      0.363316,
      0,
      1,
      5.252036,
      1.817042,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.857119,
      0.575776,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.005281,
      NULL,
      1.408872,
      1.589849,
      NULL,
      NULL,
      1.750356,
      0.658035,
      NULL,
      1,
      1,
      1,
      1.610058,
      1,
      0,
      0,
      NULL,
      0.061318,
      0,
      0.552176,
      0.203278,
      0.295449,
      1.036843,
      1,
      1,
      NULL,
      0.116474,
      1,
      0.884151,
      0.617326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333051,
      1,
      1.376354,
      1.784906,
      NULL,
      NULL,
      1.811936,
      1.530064,
      NULL,
      0,
      1,
      1.475006,
      0.189144,
      1.865108,
      0.194035,
      0,
      NULL,
      NULL,
      0,
      0,
      1.083657,
      0.500233,
      1.240653,
      1.411736,
      0.900075,
      NULL,
      1,
      0.990446,
      1,
      1.309844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.163217,
      NULL,
      2,
      2.306256,
      7.316127,
      NULL,
      5,
      5,
      9.639648,
      NULL,
      5,
      NULL,
      6,
      0,
      5,
      6,
      4.848090,
      NULL,
      7,
      0.240576,
      5.516822,
      2,
      6.809816,
      4.894726,
      2,
      1.995520,
      7.035465,
      NULL,
      0,
      0.703061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      6.476013,
      3,
      7.564059,
      5,
      0.049419,
      7.356486,
      5.165778,
      3.034169,
      2,
      NULL,
      6.579881,
      0,
      5.994283,
      6,
      7.670402,
      NULL,
      5,
      7.609159,
      0,
      1,
      NULL,
      6.399975,
      NULL,
      3.109841,
      7.347942,
      1.333568,
      3.113378,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158326,
      0,
      0.296768,
      0.071431,
      1.692791,
      1.481957,
      NULL,
      0.743341,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1.239897,
      NULL,
      1.219967,
      NULL,
      0,
      1.841029,
      0.268902,
      0,
      0,
      1.389702,
      0,
      1,
      1,
      NULL,
      0,
      1.221883,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.379115,
      1.041250,
      1.507130,
      NULL,
      NULL,
      0.938660,
      1,
      NULL,
      0,
      1,
      0.267212,
      0.758412,
      0.246827,
      0.581764,
      NULL,
      0.490058,
      0,
      1,
      1.106071,
      NULL,
      1,
      0.783925,
      0,
      0,
      1.478651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1,
      0,
      2,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      1,
      3,
      3,
      1,
      2,
      2,
      3,
      1,
      NULL,
      1,
      3,
      0,
      5,
      NULL,
      0,
      3,
      3,
      NULL,
      0,
      3,
      3,
      3,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-2002',
      '11- 0-1998',
      ' 1- 9-1990',
      '11-10-2002',
      NULL,
      NULL,
      ' 9- 0-2001',
      ' 7-16-1984',
      '11- 9-2000',
      ' 4- 9-1978',
      ' 7- 1-1996',
      ' 1- 9-1986',
      ' 9-21-2002',
      ' 8- 2-1981',
      NULL,
      NULL,
      '10-16-2001',
      NULL,
      ' 6- 1-1976',
      ' 5-28-1990',
      ' 4-26-2000',
      ' 1-20-2003',
      NULL,
      ' 8- 2-1991',
      ' 6-27-1981',
      ' 5-17-1993',
      ' 8-29-2002',
      NULL,
      ' 6-29-1995',
      ' 6- 5-1999',
      ' 2- 1-1995',
      ' 8-12-1997',
      ' 0-28-1983',
      ' 5-17-1979',
      ' 5-24-1997',
      ' 7-22-1985',
      ' 0-21-1975',
      ' 5-29-1979',
      '11- 4-1980',
      ' 6- 1-2002',
      ' 7-26-1983',
      ' 1- 5-1984',
      ' 6-28-1986',
      ' 9-18-2000',
      ' 6-25-1977',
      NULL,
      ' 8- 7-1997',
      ' 2-16-2000',
      ' 6- 6-1977',
      ' 6-12-1980',
      '11-16-1979',
      '10-27-1982',
      ' 1-25-2001',
      NULL,
      '10- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


