set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7825293';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '3424002',
      2,
      NULL,
      1,
      NULL,
      NULL,
      ' 3- 3-1974',
      50,
      NULL,
      0.723491,
      NULL,
      NULL,
      0.783619,
      1,
      0.738784,
      0.063937,
      NULL,
      1,
      3.111898,
      0.352244,
      6,
      NULL,
      NULL,
      0,
      1.247506,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7,
      6.172917,
      1,
      2.095927,
      NULL,
      NULL,
      NULL,
      6,
      7,
      3,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      5,
      4,
      NULL,
      NULL,
      2,
      0,
      0.605002,
      0,
      0,
      NULL,
      4,
      4.398456,
      1,
      1.378479,
      1,
      1.992555,
      2,
      4,
      6,
      7.209293,
      NULL,
      4,
      17.914598,
      ' 1-25-1990',
      15,
      2,
      2.979751,
      NULL,
      4,
      0,
      3.178920,
      3,
      NULL,
      30,
      NULL,
      2,
      2,
      NULL,
      55,
      1,
      2.662393,
      NULL,
      217.634062,
      NULL,
      1,
      121,
      13.423928,
      1,
      2,
      105.487557,
      0.081740,
      2.197989,
      NULL,
      234.087200,
      4,
      NULL,
      2.473736,
      162,
      461,
      2,
      NULL,
      412.776891,
      1041.918115,
      0.900919,
      9.244448,
      414,
      1199,
      NULL,
      NULL,
      421,
      58.922803,
      1,
      0.684261,
      520,
      39.359291,
      NULL,
      0.032020,
      87,
      NULL,
      NULL,
      1.391557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '02240',
      NULL,
      '',
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      1.904124,
      '',
      '',
      '',
      3,
      7,
      NULL,
      0,
      NULL,
      4.967705,
      54,
      1,
      NULL,
      NULL,
      NULL,
      1.891837,
      NULL,
      1,
      85,
      1.171269,
      NULL,
      1,
      NULL,
      0.431236,
      NULL,
      ' 7- 7-1978',
      7.291699,
      3.694399,
      14.062345,
      4.487680,
      10.873408,
      3,
      NULL,
      3,
      0,
      9.381713,
      NULL,
      19,
      2.835115,
      1,
      NULL,
      7.490202,
      6.208874,
      11,
      6,
      NULL,
      4,
      1,
      13,
      NULL,
      2,
      NULL,
      7,
      4.468456,
      NULL,
      21,
      NULL,
      0,
      NULL,
      10.982910,
      0,
      1.068762,
      5,
      0.395554,
      0.262067,
      0,
      NULL,
      0.007417,
      21,
      0.529493,
      10,
      0.140584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.269792,
      NULL,
      9,
      39,
      17.109303,
      3.620937,
      16.420239,
      0.638940,
      NULL,
      17.887742,
      9,
      NULL,
      7,
      16,
      45,
      5,
      12.200632,
      36,
      0.132271,
      37,
      1,
      18.445500,
      9.147676,
      NULL,
      NULL,
      16,
      11,
      15,
      13,
      NULL,
      0,
      9,
      18,
      7.412184,
      4,
      20.260923,
      21,
      15.148964,
      13.417872,
      22,
      NULL,
      2,
      27.808913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      121.113355,
      56,
      NULL,
      118,
      3.491504,
      12.652845,
      33,
      65,
      15.520787,
      NULL,
      NULL,
      120.205376,
      NULL,
      121.303794,
      103,
      153,
      70,
      112.251399,
      59,
      92.102877,
      74.416734,
      133.495173,
      103,
      NULL,
      133.527864,
      87,
      128.707067,
      117,
      135.766776,
      126,
      69.748728,
      80,
      6.995977,
      NULL,
      19.689193,
      16,
      0,
      NULL,
      153.564922,
      101,
      25.642881,
      3,
      20,
      33,
      156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917706,
      1,
      3.206360,
      2,
      4.728802,
      NULL,
      4.271985,
      1.118084,
      0,
      1,
      0,
      0.593820,
      0.134049,
      2,
      1,
      1.179682,
      2,
      2,
      4,
      0.045624,
      8,
      0.327798,
      3,
      1,
      0.354712,
      1,
      0.416461,
      3.997093,
      4.199227,
      1.304572,
      NULL,
      5,
      NULL,
      4.807953,
      3.889028,
      3.051711,
      4,
      1.115657,
      0,
      0.477411,
      NULL,
      4,
      4,
      2,
      1,
      0.041721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.684915,
      NULL,
      3.235723,
      3.806103,
      1,
      2,
      1.183705,
      0,
      1.450680,
      1.954348,
      1,
      0,
      1.731803,
      1,
      NULL,
      1.089155,
      3.146885,
      1,
      6,
      8,
      1.021312,
      NULL,
      NULL,
      1.838071,
      NULL,
      0,
      5.735434,
      6.072380,
      0.919968,
      1,
      3.945476,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0.189031,
      1.417363,
      0.553007,
      NULL,
      2.141679,
      NULL,
      0.363960,
      1.808850,
      1.977493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372792,
      1.021918,
      2.495034,
      5,
      NULL,
      2,
      2.431072,
      1.080387,
      2,
      NULL,
      NULL,
      0.970444,
      NULL,
      1,
      0.038016,
      2.502893,
      NULL,
      7.338605,
      4,
      4,
      NULL,
      2.279857,
      4,
      2,
      NULL,
      2,
      0.786774,
      2.608269,
      7.441469,
      0.295068,
      NULL,
      3.713949,
      3,
      0,
      1,
      NULL,
      1.309256,
      1.648132,
      NULL,
      5,
      3.402904,
      5,
      8.538561,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032036,
      5,
      5,
      0.027353,
      4,
      1.820776,
      3,
      1.397077,
      0,
      0,
      0.549955,
      1.635373,
      0,
      1,
      0,
      3.254036,
      0.710011,
      0,
      0.302807,
      1,
      NULL,
      1,
      1,
      2,
      3.316324,
      NULL,
      3.864751,
      1.838305,
      NULL,
      1.076079,
      7.349116,
      9.872152,
      5,
      3.814789,
      NULL,
      NULL,
      NULL,
      1.923129,
      1,
      0,
      NULL,
      3.040088,
      NULL,
      2,
      NULL,
      1.590981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752402,
      NULL,
      2,
      4.792677,
      NULL,
      3,
      0,
      4,
      NULL,
      1,
      0.734823,
      1,
      7.470945,
      4,
      3,
      2,
      3,
      1.695882,
      2.911396,
      4.325704,
      3,
      0,
      3,
      3.979475,
      NULL,
      NULL,
      7,
      3.855223,
      3,
      2,
      1.511262,
      NULL,
      1,
      0,
      3,
      1,
      0.819960,
      1,
      0.731002,
      NULL,
      2.895681,
      0,
      1.555892,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      8,
      NULL,
      NULL,
      1.652920,
      4.979464,
      NULL,
      3.376877,
      2.328834,
      2,
      5.979269,
      NULL,
      9.847218,
      1.725020,
      NULL,
      7,
      1.164608,
      4,
      7,
      NULL,
      3.548458,
      NULL,
      7.934092,
      NULL,
      5,
      1,
      5,
      0.916353,
      0,
      1.898328,
      1,
      7,
      5,
      NULL,
      NULL,
      4,
      4,
      1.574547,
      2.442272,
      5.962536,
      0,
      NULL,
      4,
      6.726800,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.558831,
      0.204114,
      0.821331,
      NULL,
      6,
      0.404205,
      3,
      NULL,
      NULL,
      5,
      6,
      4.390619,
      6.897620,
      NULL,
      2.933260,
      NULL,
      5.680068,
      0,
      0.917729,
      6.254623,
      3.123605,
      7.800407,
      NULL,
      0.151510,
      3.923540,
      NULL,
      7,
      5,
      7,
      3.874695,
      7,
      5,
      NULL,
      1,
      NULL,
      8,
      0,
      1.151701,
      2.342147,
      4,
      3.740312,
      0.347487,
      3,
      5.175942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      2.302310,
      2.956434,
      0,
      NULL,
      4.239828,
      1.303653,
      0,
      3.544285,
      1.277255,
      NULL,
      NULL,
      2,
      2,
      1.596584,
      2,
      NULL,
      0.996109,
      1.967002,
      3,
      1.422400,
      6.339112,
      3.124138,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      1.934767,
      0,
      5,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.398286,
      7.539669,
      NULL,
      7,
      1.855940,
      NULL,
      5.320691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.507002,
      NULL,
      0,
      NULL,
      1,
      2.953235,
      0.823894,
      0.578860,
      0.480597,
      NULL,
      2.924673,
      0.755698,
      1.565546,
      NULL,
      0,
      NULL,
      5,
      0.179718,
      3.147638,
      5.569923,
      1.318539,
      NULL,
      9.948060,
      2,
      NULL,
      1,
      4,
      NULL,
      4,
      3,
      5.203961,
      3,
      1,
      NULL,
      2.660059,
      NULL,
      1.605360,
      NULL,
      1.706982,
      0,
      2,
      0.009315,
      1,
      0.130403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.381689,
      NULL,
      1.298575,
      0,
      0.844447,
      NULL,
      6.727798,
      NULL,
      0.510500,
      0,
      NULL,
      NULL,
      1.240268,
      4,
      0,
      3.234018,
      2,
      0.101324,
      NULL,
      2,
      NULL,
      0.193593,
      0.939607,
      6.101905,
      0.946784,
      0.289824,
      6.832756,
      NULL,
      1,
      2,
      1,
      NULL,
      3,
      NULL,
      1,
      0.988794,
      NULL,
      4,
      1.082111,
      0.668762,
      1.654676,
      0.941726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762747,
      0,
      0,
      1.135534,
      NULL,
      0,
      1,
      0,
      0,
      0.206655,
      4,
      NULL,
      1.615429,
      1,
      0.522724,
      1,
      NULL,
      5.413868,
      1.745172,
      1.260980,
      3,
      1,
      1,
      1.924424,
      1,
      NULL,
      0,
      8.890926,
      NULL,
      NULL,
      3,
      2.987718,
      5,
      5.995380,
      NULL,
      0.190646,
      0,
      0.258751,
      1,
      1,
      1,
      1.459820,
      5.190594,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.253285,
      3.859226,
      3.556034,
      NULL,
      1.160869,
      1.186090,
      6,
      0.052908,
      1,
      0.373387,
      1.709523,
      0.112168,
      NULL,
      0.471307,
      1,
      7,
      7,
      3.668241,
      NULL,
      1.184974,
      0,
      0,
      NULL,
      NULL,
      1.145088,
      0.865675,
      1,
      1,
      1.433231,
      0.716510,
      NULL,
      NULL,
      0,
      1.342417,
      0.856266,
      3.193096,
      5,
      NULL,
      5.525002,
      0,
      NULL,
      NULL,
      0,
      1.843753,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760784,
      0.069661,
      0.329380,
      NULL,
      0.716056,
      NULL,
      1,
      NULL,
      1.839883,
      1.323995,
      1.114884,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.849552,
      0.074061,
      0.624319,
      1.824983,
      0.537838,
      1.690135,
      0.625370,
      1,
      0,
      0,
      1.898754,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1.813169,
      1.272171,
      1.352742,
      NULL,
      1,
      1.467937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      3.827405,
      7.362082,
      NULL,
      5.734119,
      0,
      NULL,
      3.975025,
      3,
      0,
      1.671571,
      1.828010,
      1,
      2.764414,
      2,
      0,
      4,
      7.244443,
      0.505267,
      0,
      1,
      7.000370,
      1,
      NULL,
      3.119979,
      6.950927,
      6,
      0,
      0,
      NULL,
      NULL,
      3,
      1,
      6,
      NULL,
      1.673881,
      3,
      NULL,
      5,
      4.210303,
      11,
      5.241894,
      0.748292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.289971,
      1,
      2,
      2.353113,
      3,
      8,
      NULL,
      0.256488,
      2.986226,
      3,
      NULL,
      NULL,
      NULL,
      6.701531,
      9.127972,
      8,
      NULL,
      2.387613,
      9,
      8.728568,
      5,
      1.670906,
      0,
      5,
      NULL,
      3,
      3,
      NULL,
      NULL,
      3,
      1,
      1.369091,
      3,
      1.617830,
      0,
      5,
      NULL,
      7.707070,
      5,
      0,
      5.111413,
      3,
      5.648245,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428317,
      0,
      0.078196,
      8,
      4.571706,
      1.979201,
      0,
      0.274052,
      1,
      NULL,
      NULL,
      1.270786,
      1.330365,
      1.357401,
      0,
      1,
      4.296900,
      0.565141,
      7.831847,
      1,
      NULL,
      NULL,
      0.887820,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      3.338261,
      6,
      4,
      4,
      2,
      1.996080,
      1,
      1,
      1,
      1,
      0,
      0.010918,
      NULL,
      0.609840,
      1.894348,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.347529,
      7.467996,
      NULL,
      1,
      1.434197,
      NULL,
      1.861211,
      NULL,
      NULL,
      NULL,
      1,
      7,
      2,
      0,
      6.296584,
      NULL,
      NULL,
      NULL,
      1.175845,
      0,
      0.660470,
      7.867019,
      1,
      NULL,
      3.502834,
      0.773605,
      0.089563,
      1.408686,
      1.251686,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1.056637,
      1.278742,
      0.302085,
      NULL,
      0,
      2,
      NULL,
      0.401081,
      0.414661,
      0.371947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      1,
      0,
      0,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      1,
      5,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      3,
      1,
      1,
      2,
      2,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      4,
      0,
      2,
      1,
      NULL,
      0,
      4,
      1,
      4,
      1,
      NULL,
      3,
      2,
      2,
      0,
      1,
      4,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      3,
      1,
      0,
      3,
      NULL,
      0,
      2,
      2,
      2,
      2,
      0,
      3,
      0,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1996',
      ' 2-16-1978',
      ' 0- 0-1975',
      ' 8- 7-1990',
      ' 8- 2-1992',
      ' 5-11-1994',
      ' 5-19-1974',
      ' 3- 2-1997',
      ' 3-11-1977',
      ' 1-29-1989',
      '11- 9-1982',
      NULL,
      ' 0-11-1988',
      ' 3-22-1982',
      ' 8-10-1997',
      ' 9-16-1998',
      ' 7-16-1992',
      NULL,
      '11-23-2002',
      ' 9- 9-1989',
      ' 6-16-1995',
      ' 0- 4-1993',
      ' 3-27-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 0-1996',
      NULL,
      ' 8-15-1982',
      ' 5-25-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


