set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      NULL,
      76.537355,
      19,
      '4130201',
      1,
      0.775238,
      NULL,
      '43233',
      2.919145,
      ' 6-29-1976',
      153,
      NULL,
      1.259254,
      2,
      0.922629,
      1.153349,
      1,
      3.235089,
      1.594044,
      0.217430,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.777961,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.026689,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5,
      3,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0.352368,
      NULL,
      9.874692,
      NULL,
      0.510498,
      1,
      1.169422,
      NULL,
      3,
      NULL,
      1.211211,
      0,
      3.672200,
      1,
      NULL,
      7,
      4.129700,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      9,
      345,
      28.041952,
      NULL,
      1,
      79,
      4.154120,
      0.999335,
      5,
      NULL,
      3.878434,
      NULL,
      3.886049,
      184.011838,
      0.223267,
      1.596496,
      NULL,
      30,
      16,
      NULL,
      0.057610,
      471,
      21.301999,
      0.354320,
      6.227214,
      191.991986,
      15.364769,
      2,
      1,
      143.317982,
      3.391850,
      1.160938,
      NULL,
      23,
      6,
      0.424979,
      0.164115,
      167.253854,
      7,
      1,
      6,
      NULL,
      13.962674,
      2.942362,
      6.607007,
      233,
      22,
      NULL,
      2,
      150,
      30,
      3.223610,
      5,
      NULL,
      69,
      NULL,
      0,
      318,
      32.172477,
      NULL,
      2,
      943,
      7,
      NULL,
      7,
      NULL,
      5.286686,
      3.672783,
      6,
      691,
      3,
      0.378092,
      5.528409,
      710,
      NULL,
      NULL,
      NULL,
      NULL,
      97,
      2.728082,
      1,
      NULL,
      115.517055,
      3.385249,
      3.846057,
      149,
      0,
      1,
      3.057941,
      NULL,
      1,
      1,
      NULL,
      323,
      190.712502,
      2,
      3,
      44,
      NULL,
      NULL,
      0,
      188.850288,
      8.054591,
      3,
      5,
      328.140230,
      5.302738,
      0.904336,
      NULL,
      484,
      12,
      1.931330,
      2.828356,
      537.919053,
      NULL,
      NULL,
      0.891417,
      NULL,
      8.199521,
      2.830670,
      NULL,
      416.192174,
      NULL,
      1,
      NULL,
      345,
      46,
      NULL,
      7,
      151.684182,
      150,
      1.705814,
      NULL,
      534.086617,
      133.098281,
      NULL,
      2.103693,
      277,
      321.146373,
      0.722993,
      2,
      139,
      238,
      NULL,
      0,
      NULL,
      179.646628,
      2.494298,
      2,
      23,
      2,
      NULL,
      5.324366,
      210.052233,
      1,
      3.724666,
      0.839578,
      NULL,
      7.019960,
      NULL,
      6,
      211,
      5,
      NULL,
      4.141288,
      NULL,
      1.645456,
      2,
      NULL,
      219,
      2.214299,
      0,
      6,
      121,
      NULL,
      0,
      3.924985,
      629.434603,
      82.728607,
      2,
      0,
      155,
      4,
      1,
      3.493653,
      16,
      NULL,
      3.660990,
      1,
      201.714840,
      NULL,
      NULL,
      4.708119,
      NULL,
      15,
      1.613010,
      3.288747,
      195,
      14,
      2,
      0,
      392.276663,
      NULL,
      0,
      0.963048,
      975,
      102.436429,
      0.786331,
      NULL,
      108.969559,
      652,
      0,
      6,
      444,
      1238,
      3.511685,
      NULL,
      1007,
      986,
      3.476641,
      NULL,
      208.421608,
      80,
      2,
      2,
      NULL,
      86.394391,
      0.739926,
      1.667373,
      NULL,
      12,
      NULL,
      2.142257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.319523,
      '00424',
      '22410',
      '',
      '',
      '',
      '',
      0.035971,
      NULL,
      '',
      '',
      1,
      '2402',
      '',
      '',
      NULL,
      1,
      186.194814,
      1.860590,
      NULL,
      1.190417,
      NULL,
      0.225683,
      NULL,
      0.275931,
      9,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.259604,
      182.803857,
      0.972624,
      NULL,
      ' 1- 4-2000',
      2.096691,
      NULL,
      2,
      NULL,
      6.926695,
      8,
      1,
      NULL,
      13,
      NULL,
      9,
      NULL,
      7,
      3,
      19.381548,
      21,
      8.123107,
      3.072914,
      11.161409,
      13.028040,
      0,
      6.860167,
      9.061800,
      NULL,
      2.124145,
      4.430913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      19,
      NULL,
      0,
      0,
      45.838385,
      NULL,
      NULL,
      9,
      NULL,
      42.324179,
      7,
      22,
      16.146776,
      5,
      25,
      29,
      NULL,
      NULL,
      0,
      NULL,
      33.715397,
      12.530059,
      19,
      9.353821,
      1.283138,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.686345,
      185.870323,
      25,
      160,
      NULL,
      67.277727,
      20,
      152.277587,
      72.576145,
      NULL,
      143.875769,
      NULL,
      32.809086,
      151,
      176,
      109,
      NULL,
      131,
      NULL,
      171.130917,
      1,
      NULL,
      NULL,
      1.094380,
      1,
      1.145992,
      2.716622,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.494507,
      0.613133,
      NULL,
      7.255939,
      4,
      1,
      6.368804,
      4.983176,
      3,
      NULL,
      0,
      4.203008,
      0,
      0.215943,
      0.078887,
      7.016491,
      7.570421,
      6,
      3,
      6.074161,
      5.294484,
      2.090728,
      NULL,
      6.234082,
      0,
      3,
      1.613106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398345,
      1,
      3.371861,
      4.771555,
      3.548202,
      6,
      1,
      0,
      7.364291,
      3.270411,
      5.988515,
      5,
      3.210096,
      NULL,
      NULL,
      2,
      0,
      0.113265,
      2.257225,
      NULL,
      NULL,
      NULL,
      5.917139,
      NULL,
      4,
      8.311300,
      1.253050,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.527134,
      1,
      NULL,
      NULL,
      0.844262,
      0,
      2.533135,
      1.971875,
      1,
      0.169704,
      NULL,
      0,
      5.503912,
      4.562162,
      0.392501,
      1.635045,
      4.210842,
      NULL,
      0.680590,
      4,
      1,
      NULL,
      2,
      3,
      1.467934,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429254,
      1,
      1.882061,
      1,
      0,
      NULL,
      0.376332,
      0.418903,
      NULL,
      0,
      1.463053,
      0,
      0,
      1.809423,
      0.058389,
      0,
      NULL,
      0.951525,
      1,
      NULL,
      1.099625,
      1.633178,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189778,
      1,
      5.345425,
      0,
      NULL,
      NULL,
      5.876183,
      NULL,
      1,
      5.988722,
      4,
      3,
      1,
      0.344546,
      1.256919,
      2,
      NULL,
      2,
      0,
      1,
      1,
      0.063179,
      1.912676,
      1,
      NULL,
      1,
      1.692036,
      0.882656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.938354,
      NULL,
      5,
      8,
      9.266799,
      NULL,
      2,
      NULL,
      8,
      0,
      NULL,
      9.688580,
      5,
      7.018348,
      6,
      9.310298,
      9.903864,
      1.368332,
      NULL,
      0.688539,
      5.677917,
      0.156887,
      1.673360,
      5.547755,
      10.154730,
      7,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235863,
      NULL,
      NULL,
      4,
      2.245453,
      7.784463,
      11,
      10,
      7,
      3,
      9.991943,
      7.841547,
      2,
      0.553904,
      8.916330,
      5.207129,
      1,
      7.363753,
      5,
      4.988617,
      3,
      7.776067,
      1.200979,
      3,
      NULL,
      8,
      4.174331,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      7,
      0.857845,
      NULL,
      4,
      2,
      4.383515,
      2.504883,
      5,
      4.153909,
      0.608888,
      2,
      0,
      7,
      2,
      2.559541,
      5,
      4,
      NULL,
      2.263573,
      6.075652,
      9,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.947697,
      1,
      5,
      7.293969,
      6.937943,
      5.295394,
      1.933267,
      0,
      NULL,
      2,
      NULL,
      6.248561,
      2.283573,
      1.978816,
      NULL,
      7,
      2,
      NULL,
      1,
      1.908224,
      1.459926,
      NULL,
      5.489655,
      4.080619,
      5,
      1,
      3,
      0.324643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.755822,
      0,
      3,
      0.079444,
      0.495599,
      NULL,
      1.347086,
      4.649752,
      3,
      3,
      3,
      NULL,
      3.991204,
      1.027888,
      NULL,
      1.648019,
      3,
      5,
      0.272708,
      5.999396,
      5.514177,
      2.635746,
      1,
      3,
      NULL,
      5,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.191588,
      1,
      1,
      1.465831,
      0.012367,
      NULL,
      0,
      1,
      NULL,
      0.531824,
      NULL,
      1,
      0,
      NULL,
      0.403774,
      0,
      1,
      0.843090,
      NULL,
      1.630416,
      1.863684,
      0,
      NULL,
      1.646869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.408923,
      1.971351,
      2,
      NULL,
      0,
      2.485249,
      3.522460,
      3.841261,
      5,
      1,
      NULL,
      7,
      8,
      1,
      11,
      9,
      NULL,
      0,
      1,
      2.465006,
      6,
      5.288319,
      4,
      NULL,
      1.012405,
      0.832494,
      4.616374,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.715798,
      0,
      3,
      5,
      2.498898,
      1,
      4.940444,
      5,
      0.852779,
      3.005712,
      0,
      4,
      3,
      NULL,
      NULL,
      3,
      6.196835,
      3,
      NULL,
      0.030915,
      NULL,
      5,
      3,
      4,
      9,
      2,
      4.640990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576390,
      1.021352,
      1,
      3.393556,
      NULL,
      1,
      NULL,
      4.653234,
      3,
      NULL,
      2,
      1.283211,
      NULL,
      7,
      1,
      6.389578,
      7.330770,
      3,
      6,
      7.429177,
      1.578106,
      0.173841,
      4,
      4,
      3,
      7.465812,
      NULL,
      3.973145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4.728526,
      4.648382,
      4,
      0,
      4.757945,
      5,
      NULL,
      NULL,
      7.587729,
      NULL,
      6.642382,
      5,
      3,
      6,
      4.080041,
      8,
      NULL,
      2.106376,
      9.841615,
      3.301104,
      3,
      8.290618,
      9,
      4.054927,
      8.260686,
      9.590589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.642154,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.652926,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.833585,
      1,
      1.468857,
      0.388821,
      0,
      1,
      1.985798,
      0,
      0,
      0.284908,
      0,
      0.116266,
      1,
      1,
      1.819897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052632,
      NULL,
      1.167186,
      1.265600,
      3.040152,
      2,
      3.305930,
      5,
      1,
      1.321802,
      0,
      8,
      4.421698,
      2,
      4,
      5.386375,
      1,
      4.784470,
      1.127241,
      4,
      NULL,
      0,
      4.000572,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      0,
      5,
      4,
      1,
      2,
      4,
      NULL,
      5,
      3,
      5,
      NULL,
      NULL,
      0,
      3,
      2,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-10-1992',
      NULL,
      NULL,
      ' 6- 3-2001',
      NULL,
      '10-16-1996',
      ' 4-13-1981',
      NULL,
      ' 1- 7-1984',
      ' 6-21-1986',
      ' 3-19-1999',
      NULL,
      ' 0-19-1996',
      ' 6-18-1988',
      '11-13-1984',
      '11-15-1986',
      ' 1-11-1975',
      ' 9-29-1988',
      ' 3-17-1982',
      ' 8-28-1978',
      NULL,
      ' 6- 3-1982',
      ' 5- 5-1977',
      NULL,
      ' 3-24-1993',
      ' 1-15-1990',
      ' 3-11-1998',
      NULL,
      ' 5-26-1997',
      ' 1- 5-1988',
      '11-12-1989',
      '10-25-1997',
      ' 7- 5-1989',
      ' 8-10-1982',
      ' 8- 9-2000',
      ' 2- 2-1991',
      NULL,
      NULL,
      '11-24-1986',
      ' 8- 1-1983',
      ' 2-29-1993',
      ' 8-19-1984',
      ' 1-15-1977',
      NULL,
      NULL,
      '10-28-1979',
      ' 0- 0-1975',
      ' 4- 8-1975',
      ' 2-17-1982',
      ' 5-26-1974',
      NULL,
      '11-16-1995',
      ' 9-22-1999',
      '10-18-1976',
      ' 8-19-1987',
      ' 8-21-1984',
      NULL,
      ' 0-29-1979',
      NULL,
      '10-29-1985',
      ' 8- 5-1991',
      NULL,
      NULL,
      '11- 6-1984',
      ' 5-14-1975',
      ' 9-26-1995',
      ' 1-14-2000',
      ' 5- 7-1985',
      ' 1- 8-1985',
      ' 4-15-1991',
      ' 3-22-1997',
      NULL,
      NULL,
      NULL,
      ' 6-19-1980',
      ' 6-12-1978',
      ' 7- 4-1979',
      NULL,
      ' 2-13-1998',
      ' 7- 2-2001',
      NULL,
      ' 1- 6-1994',
      ' 5- 2-1998',
      NULL,
      NULL,
      '10-21-2003',
      ' 4-11-1978',
      NULL,
      ' 7-23-1978',
      ' 8-29-1990',
      NULL,
      NULL,
      ' 0-26-1976',
      ' 8-22-1983',
      ' 0- 7-1999',
      NULL,
      NULL,
      '10-26-1986',
      ' 5-14-1990',
      ' 5-11-1977',
      NULL,
      NULL,
      ' 4-22-1979',
      ' 2- 0-2002',
      ' 9- 3-1980',
      '11- 6-1976',
      ' 5-20-1991',
      ' 1- 1-2000',
      ' 8- 6-2000',
      '10- 5-1978',
      NULL,
      ' 1- 0-2003',
      '10- 4-1980',
      '10- 2-1995',
      ' 4-13-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773075);
commit;
end;
/


