set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7633982';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.936388,
      NULL,
      NULL,
      0,
      ' 8-16-1994',
      35.667607,
      NULL,
      0.131440,
      1,
      3,
      0.416849,
      0,
      1,
      1.397350,
      2.019674,
      2,
      1,
      1.830606,
      9,
      NULL,
      NULL,
      0.838652,
      2.132561,
      NULL,
      NULL,
      NULL,
      NULL,
      3.907471,
      NULL,
      4,
      5,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      4,
      0,
      9,
      NULL,
      2,
      1.720525,
      0.882038,
      1,
      1,
      2,
      3,
      NULL,
      5,
      6.031617,
      6,
      7,
      3,
      NULL,
      4,
      6.428048,
      0.674211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      14.162361,
      3,
      NULL,
      235,
      4.494935,
      2,
      1.955811,
      NULL,
      858,
      1.394930,
      1.814268,
      NULL,
      89.700569,
      3.217429,
      4.353040,
      220,
      28.220848,
      2.142589,
      3.729663,
      114.074492,
      NULL,
      3.971735,
      2,
      682.061654,
      3790.174420,
      1,
      0.925241,
      NULL,
      NULL,
      0,
      NULL,
      53,
      2213,
      2.754745,
      1.922768,
      139.352039,
      7153,
      4.415330,
      0,
      NULL,
      7557,
      2.752939,
      2.052587,
      NULL,
      35,
      0.720495,
      1,
      420,
      15038,
      NULL,
      2.885415,
      NULL,
      3908,
      0,
      3.984040,
      177,
      NULL,
      8,
      1,
      179,
      NULL,
      2.633742,
      NULL,
      453,
      34.882851,
      3,
      0,
      120.352713,
      604,
      NULL,
      4.850533,
      42,
      1876,
      0,
      3.519412,
      205,
      30.601489,
      0,
      6,
      5,
      583,
      3.821337,
      0,
      47.075320,
      NULL,
      NULL,
      0.114175,
      420,
      11605,
      3,
      1,
      815.792656,
      19472,
      NULL,
      4.567864,
      558,
      8939.395853,
      NULL,
      0,
      199,
      3480,
      2.864586,
      4.755452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '40443',
      '',
      '',
      '',
      '',
      '',
      1.917330,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      5,
      1.060245,
      NULL,
      3,
      1122.279345,
      1,
      NULL,
      1.594523,
      NULL,
      7,
      NULL,
      0,
      NULL,
      1.746284,
      NULL,
      0.705657,
      NULL,
      0.133081,
      NULL,
      NULL,
      NULL,
      ' 1-23-1995',
      NULL,
      NULL,
      4.363771,
      NULL,
      8,
      NULL,
      0,
      4.614112,
      7.302080,
      NULL,
      NULL,
      12,
      5,
      NULL,
      4.011302,
      NULL,
      NULL,
      20,
      0,
      3.859509,
      2.140351,
      NULL,
      17.978462,
      7.212901,
      1.915037,
      9.334963,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.415315,
      51,
      50,
      NULL,
      19,
      3.370505,
      22,
      19.093400,
      NULL,
      0,
      1,
      15.442925,
      26,
      10,
      NULL,
      2,
      29,
      0.584380,
      1,
      18.304981,
      6.264639,
      19,
      18,
      18.644207,
      24,
      0.870152,
      26.701630,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.470447,
      123,
      NULL,
      141.607604,
      138,
      NULL,
      94,
      32,
      NULL,
      94.717203,
      16.786975,
      8,
      NULL,
      150,
      113.023814,
      NULL,
      NULL,
      NULL,
      128,
      68.430478,
      98,
      140.893078,
      98,
      122.368229,
      115.959071,
      67,
      17.121809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      8.932445,
      5.824569,
      9,
      NULL,
      2,
      0.922524,
      NULL,
      4,
      6,
      NULL,
      9,
      2.032984,
      3.371674,
      1.481961,
      NULL,
      5,
      8.669445,
      2.000840,
      2,
      NULL,
      2.065530,
      5.852974,
      0.229576,
      3.119378,
      5.631767,
      2.370724,
      3.179183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.579177,
      2.565570,
      2.029895,
      NULL,
      0,
      1,
      4.937142,
      0.339750,
      9.296859,
      1.731872,
      5.763329,
      0,
      9,
      1.781408,
      0,
      2.748510,
      6.787932,
      NULL,
      NULL,
      6.904270,
      4,
      0,
      3,
      6.539470,
      6.394312,
      7,
      1.236533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.081101,
      2.484022,
      0.195836,
      NULL,
      6.734679,
      3,
      3.369891,
      0,
      NULL,
      3,
      1,
      0,
      4.172479,
      NULL,
      3,
      3.243503,
      NULL,
      4.844195,
      4,
      5.135720,
      NULL,
      3.893924,
      NULL,
      1,
      NULL,
      5.579715,
      5.697112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.969497,
      5.879138,
      0,
      3.049167,
      2,
      5,
      2,
      0.987877,
      NULL,
      0,
      0,
      NULL,
      3.373499,
      4,
      NULL,
      2,
      2.808148,
      0.584873,
      NULL,
      NULL,
      1.668448,
      0.623655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083860,
      0.799570,
      0,
      0,
      5,
      2,
      2,
      7.572770,
      2,
      NULL,
      5,
      2.804764,
      NULL,
      4,
      4.752289,
      2.800608,
      NULL,
      1.565061,
      0.309948,
      NULL,
      0.875466,
      3,
      1,
      NULL,
      4,
      4.052148,
      1.644967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908116,
      1,
      1.339558,
      1.033337,
      1,
      4.171956,
      1.277909,
      4.154702,
      4.537604,
      10.332597,
      8.656707,
      4.359519,
      4.256423,
      5,
      6.310064,
      1.671911,
      NULL,
      0,
      3,
      2,
      NULL,
      3,
      3.282452,
      NULL,
      0.894323,
      NULL,
      3.831698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430689,
      0.728456,
      NULL,
      3,
      6.195568,
      4.770139,
      5,
      5.833801,
      8.211401,
      NULL,
      0,
      5.322948,
      8,
      2.292119,
      7,
      0,
      4,
      NULL,
      11.820240,
      NULL,
      NULL,
      NULL,
      5.130535,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      3.182163,
      2,
      0.724286,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0,
      NULL,
      3.557755,
      4,
      NULL,
      3,
      0.051899,
      NULL,
      1.312241,
      7.521132,
      5.304195,
      0,
      0,
      6.342102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      2,
      0.035590,
      NULL,
      8.855056,
      3,
      3,
      0,
      5,
      3.139011,
      7.905965,
      NULL,
      1.794279,
      4,
      0.903262,
      5,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.304192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343867,
      0.964250,
      1.845325,
      NULL,
      0,
      0,
      3,
      2,
      1,
      0.976976,
      1,
      NULL,
      1.278935,
      0,
      0.501224,
      0.814866,
      2.645228,
      1,
      3,
      3,
      NULL,
      2.316616,
      NULL,
      NULL,
      1.153532,
      1.512386,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580592,
      1.487960,
      1,
      1.804600,
      NULL,
      1.356203,
      1.439744,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1.558280,
      1.233099,
      NULL,
      1.847437,
      1.597377,
      1.022610,
      NULL,
      1.193345,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.329234,
      0,
      NULL,
      0,
      4.945560,
      2,
      1,
      NULL,
      1.598510,
      5.430692,
      0.641526,
      1.722351,
      3.538965,
      1.051499,
      3,
      1.344524,
      2.740828,
      4,
      1,
      7,
      3,
      3,
      1.687587,
      NULL,
      1.697582,
      1.374444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312780,
      NULL,
      0,
      1,
      NULL,
      0,
      0.342511,
      1.320066,
      0.626367,
      0.030372,
      1,
      1.879801,
      NULL,
      1.547208,
      NULL,
      1.000941,
      0.226723,
      0.245961,
      1,
      0.962023,
      0.333085,
      1,
      1,
      0.139599,
      0,
      1.077279,
      0.907419,
      0.946185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.607138,
      1,
      5.356347,
      0,
      0.299268,
      5.351596,
      3.509136,
      3,
      4,
      NULL,
      5,
      2.252700,
      NULL,
      5.616329,
      3,
      6.265462,
      9,
      4,
      3.341365,
      0.183142,
      4.787089,
      NULL,
      3.771984,
      2.028980,
      7.173728,
      6,
      0.067864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925276,
      NULL,
      0.281670,
      0,
      0,
      0.946718,
      3.200880,
      8.093977,
      5,
      NULL,
      1,
      6.959817,
      7,
      8.418030,
      NULL,
      8.545401,
      6.475374,
      NULL,
      7.725642,
      10.978732,
      2.293406,
      NULL,
      2.641826,
      6.728182,
      7,
      3,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.881956,
      0.642209,
      1.004077,
      0,
      0,
      1.937656,
      0,
      0.913719,
      1,
      0.110824,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0.244268,
      0.882248,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.233255,
      1,
      0,
      1.517134,
      2.159312,
      NULL,
      0,
      5.841058,
      2,
      2.811047,
      NULL,
      5.700663,
      0.939309,
      1,
      0.390114,
      NULL,
      2,
      5,
      4,
      4.733715,
      2.996840,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      2,
      2,
      1,
      3,
      NULL,
      3,
      2,
      1,
      1,
      4,
      NULL,
      5,
      0,
      NULL,
      3,
      0,
      0,
      1,
      1,
      1,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1989',
      NULL,
      NULL,
      NULL,
      ' 8-24-1982',
      NULL,
      ' 3-14-1974',
      NULL,
      ' 2- 1-1976',
      '10-15-1982',
      NULL,
      NULL,
      ' 9- 9-1978',
      NULL,
      ' 5-15-1993',
      NULL,
      ' 6- 9-1991',
      NULL,
      '10-22-1986',
      NULL,
      ' 7-26-1992',
      NULL,
      ' 5- 5-1978',
      NULL,
      ' 7- 5-1990',
      NULL,
      ' 0- 1-1981',
      ' 7- 4-1976',
      ' 8-25-1993',
      '11-22-1999',
      '10-28-2001',
      ' 3-28-2000',
      ' 8-15-1989',
      NULL,
      ' 8- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-23-1985',
      '10- 6-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-22-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


