set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '101',
      '2',
      67.984565,
      77.602274,
      NULL,
      3,
      4.749495,
      0,
      '12432',
      0,
      '11-19-2001',
      142,
      NULL,
      1.638306,
      NULL,
      1.222385,
      NULL,
      0.059236,
      1,
      1,
      NULL,
      0.734075,
      0.504438,
      1.432533,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      23.719969,
      5.370478,
      1,
      3.433834,
      NULL,
      1.183084,
      3.876303,
      0,
      5.093136,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      4,
      2,
      1,
      3.045870,
      0,
      0,
      1,
      0.343698,
      0.412708,
      NULL,
      NULL,
      4,
      5.050120,
      7,
      0,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0.138671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.258973,
      3,
      1,
      1,
      NULL,
      NULL,
      17.528037,
      174,
      NULL,
      NULL,
      NULL,
      450.128774,
      NULL,
      NULL,
      3.106477,
      392,
      3,
      2.589039,
      2.456640,
      NULL,
      7.676951,
      0,
      2,
      913,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.478296,
      1317.753334,
      NULL,
      0,
      3,
      58.565544,
      3.864257,
      NULL,
      3.587778,
      76.241870,
      17.239710,
      0.069789,
      1,
      44,
      9,
      NULL,
      0,
      43,
      2.994865,
      3,
      3.080639,
      177,
      NULL,
      0.462580,
      3.524873,
      NULL,
      0.692978,
      2.082971,
      2,
      925.885084,
      2.679811,
      2.596362,
      2.436855,
      19,
      2,
      3.050292,
      3.883004,
      132,
      11,
      2.443805,
      0.822619,
      NULL,
      NULL,
      NULL,
      NULL,
      174.784595,
      44,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.095961,
      NULL,
      '32041',
      '',
      '',
      '',
      '',
      1.479585,
      '',
      '',
      '',
      0.388348,
      '4341',
      '',
      '',
      2,
      2.536833,
      NULL,
      1.154966,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      8.523675,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 0-12-1984',
      13.858286,
      2.882311,
      2.042140,
      12,
      12.209310,
      0.593216,
      2.844958,
      2.621041,
      NULL,
      12,
      1,
      14.326044,
      NULL,
      0.049608,
      16,
      12,
      1,
      6.130062,
      2,
      19.612074,
      NULL,
      10,
      17,
      NULL,
      23.983245,
      17.904787,
      15,
      4,
      NULL,
      3.043767,
      3.453902,
      5.069534,
      3.831010,
      6,
      4,
      11,
      7,
      3.273161,
      5.453837,
      4,
      13,
      12.138807,
      6,
      11.740454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      11.188399,
      3,
      NULL,
      0,
      23.285099,
      6,
      31,
      5,
      13,
      NULL,
      16.243755,
      18,
      2,
      12,
      19.926619,
      NULL,
      NULL,
      26,
      10.026577,
      7.296203,
      10,
      NULL,
      57.961126,
      0.086013,
      13,
      41.196120,
      31.062043,
      2,
      6,
      10.367630,
      38.460705,
      25,
      5,
      17.706180,
      19.577142,
      1,
      3,
      2,
      0,
      NULL,
      1.639248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.712391,
      118.337535,
      63,
      35.984876,
      123.492041,
      NULL,
      36,
      103,
      NULL,
      195.633880,
      165,
      119.904340,
      126,
      NULL,
      117.263540,
      117,
      3.654135,
      173.339922,
      183,
      85.495039,
      0.208591,
      1.332061,
      NULL,
      NULL,
      0,
      0.651289,
      1,
      3,
      2.122433,
      2.396311,
      2,
      4.084873,
      NULL,
      3.255255,
      0.956618,
      0.428858,
      5.549022,
      2,
      0,
      5.813967,
      NULL,
      7,
      5.710725,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.731321,
      0.393420,
      NULL,
      1.481036,
      1,
      0.712094,
      0,
      1.309895,
      NULL,
      0,
      2,
      2,
      NULL,
      1.311730,
      3,
      1.536531,
      0,
      3.267619,
      1,
      3.831912,
      2.889643,
      2.707382,
      3.352063,
      NULL,
      1,
      1,
      1,
      1.689065,
      0,
      1,
      2,
      3,
      1.341572,
      0,
      1.160301,
      1,
      1.693644,
      0.192642,
      0.556325,
      0.496872,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.806231,
      0,
      1,
      0.595762,
      1.445289,
      1,
      0.504247,
      0.624555,
      NULL,
      3.597788,
      1.946890,
      3.633255,
      4,
      3.100181,
      0,
      3,
      NULL,
      NULL,
      6.747435,
      9,
      0.819318,
      NULL,
      NULL,
      0.521211,
      0.024269,
      0.347688,
      1.844816,
      1.608978,
      1.794241,
      6,
      0,
      2,
      4,
      3.579727,
      NULL,
      NULL,
      0.317332,
      1.110603,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0.365007,
      3.107012,
      3,
      1.347375,
      1.918590,
      5.973461,
      2,
      5.986099,
      3,
      3.152157,
      2,
      NULL,
      NULL,
      4.013424,
      2.744692,
      2.132832,
      3,
      0,
      0,
      0,
      4,
      2.515724,
      1,
      1.429947,
      2,
      4.513533,
      3,
      NULL,
      2.603124,
      0,
      4.184820,
      5.648543,
      1,
      NULL,
      1,
      1.102808,
      5.680976,
      1,
      NULL,
      0,
      0.257234,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555887,
      1.057326,
      1.289805,
      0,
      0,
      1,
      1.064702,
      NULL,
      0.675216,
      0,
      1.575351,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      5,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1.820450,
      1.476380,
      0.983678,
      NULL,
      0,
      1,
      1.345917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.067817,
      0,
      5,
      3.367711,
      NULL,
      2.746221,
      5,
      0,
      6.517921,
      0.410769,
      NULL,
      NULL,
      7.463852,
      5.665841,
      8,
      2.222759,
      4.938864,
      4,
      5,
      9,
      1,
      8.486286,
      3,
      2,
      1.782900,
      NULL,
      9.176406,
      NULL,
      NULL,
      2,
      1,
      2.547384,
      8,
      3,
      NULL,
      5.142381,
      4.796066,
      2,
      1.756207,
      5,
      0.235981,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441547,
      7,
      0.627013,
      4.826737,
      1.030361,
      0.102093,
      3.961349,
      7,
      NULL,
      4,
      NULL,
      4.912883,
      2,
      NULL,
      0.297538,
      2,
      9.408962,
      8,
      8,
      3,
      6,
      NULL,
      NULL,
      3,
      5,
      4.430861,
      1,
      7.261283,
      NULL,
      3,
      NULL,
      NULL,
      7,
      0,
      6.973308,
      1.814780,
      4.519427,
      0.140736,
      1,
      NULL,
      5,
      6,
      4,
      2.962919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475410,
      NULL,
      1.212723,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      1.071817,
      NULL,
      7.716982,
      7.588465,
      5.376413,
      9.514930,
      NULL,
      6,
      8,
      5,
      5.755973,
      0,
      7.538889,
      1.456688,
      8.743788,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9.495884,
      9.728511,
      NULL,
      7.352129,
      9.215752,
      3,
      NULL,
      4,
      2,
      4,
      NULL,
      2,
      1.654420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833598,
      6,
      5,
      NULL,
      7,
      5,
      3.186175,
      2,
      6.955122,
      7.803786,
      2,
      7,
      NULL,
      NULL,
      3,
      NULL,
      3,
      4,
      NULL,
      1.588995,
      5.677269,
      0.589124,
      4.539576,
      5,
      1.782244,
      1.331746,
      NULL,
      0,
      NULL,
      2,
      6.294117,
      3,
      2.711387,
      2,
      NULL,
      4,
      5.842878,
      3.462307,
      5,
      1,
      2.110165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.440075,
      7.179504,
      7,
      NULL,
      5.847867,
      7.614302,
      4.861033,
      5,
      0,
      NULL,
      NULL,
      5,
      3,
      NULL,
      5,
      5.782131,
      7,
      2.367019,
      NULL,
      6.485716,
      1.778509,
      NULL,
      5.902867,
      7.066815,
      7.571953,
      7.757751,
      5.338126,
      1.449561,
      NULL,
      NULL,
      4.127287,
      7.373293,
      6.062677,
      NULL,
      3.633797,
      4.223280,
      0,
      0.030277,
      NULL,
      5.613758,
      2,
      1,
      1.880011,
      1.004488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.005406,
      0.035518,
      5.050891,
      1.303684,
      4.430166,
      0.756941,
      1,
      3.424636,
      NULL,
      1.401507,
      4,
      NULL,
      3.560943,
      4.973850,
      1.213969,
      1,
      1.843108,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0.364640,
      0,
      NULL,
      NULL,
      NULL,
      1.220392,
      0,
      NULL,
      0.044110,
      0,
      1,
      1,
      0.143153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.558937,
      1,
      0.106870,
      0.397309,
      1.700020,
      0,
      1.508768,
      NULL,
      0,
      1.376689,
      1,
      0.549816,
      0.267883,
      1.989256,
      0.281089,
      0.437031,
      NULL,
      NULL,
      NULL,
      0,
      1.613444,
      NULL,
      NULL,
      1.212518,
      NULL,
      0.760534,
      0.250828,
      NULL,
      0,
      NULL,
      0,
      1.827536,
      NULL,
      0.696030,
      NULL,
      1,
      0,
      1.061943,
      0.520066,
      NULL,
      0,
      0,
      0.566595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.277746,
      6,
      3.708538,
      1.599791,
      0.607143,
      1.352632,
      0,
      0.171771,
      0.362477,
      1.006994,
      NULL,
      0.015462,
      0,
      1.996883,
      0.424164,
      NULL,
      1.399121,
      1.469534,
      1.862491,
      0,
      1,
      3.119126,
      NULL,
      0.521845,
      3.003632,
      2,
      5.581228,
      NULL,
      1.742367,
      0.223778,
      NULL,
      0.691867,
      2,
      NULL,
      0,
      0.654999,
      0,
      1.027763,
      0.315634,
      1,
      NULL,
      0.714295,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.770587,
      1.250986,
      5,
      3.797605,
      0,
      1,
      5.065034,
      NULL,
      4.881700,
      1.455188,
      1.468918,
      NULL,
      1.386311,
      0,
      3.636485,
      0,
      1.207916,
      0,
      0.134034,
      2,
      4,
      NULL,
      0.333151,
      5.412965,
      5.447684,
      NULL,
      6.293659,
      4,
      0,
      NULL,
      NULL,
      7,
      NULL,
      4,
      0.588673,
      4,
      0.466568,
      2.931489,
      4.633844,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.209054,
      2,
      2,
      NULL,
      NULL,
      3.241487,
      4.578900,
      2,
      5.144522,
      NULL,
      0,
      1.222470,
      2,
      0,
      1.666705,
      1.715668,
      5.937719,
      3.068748,
      0.471069,
      3.143439,
      7,
      5,
      3,
      NULL,
      NULL,
      3.278797,
      0.446614,
      1,
      NULL,
      NULL,
      0,
      2.795359,
      5.921574,
      6.133533,
      9.381499,
      NULL,
      0.701229,
      5,
      NULL,
      1,
      1,
      0,
      NULL,
      1.116821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      2.946926,
      NULL,
      7.096460,
      5.373872,
      NULL,
      1,
      6,
      7.479299,
      8.318418,
      9.507503,
      2.076850,
      2,
      NULL,
      NULL,
      NULL,
      2,
      9,
      1,
      9,
      NULL,
      0.287974,
      6.527301,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285832,
      NULL,
      6,
      7.238523,
      1.396297,
      1.594880,
      4,
      4,
      2,
      1,
      5.727809,
      2.737211,
      NULL,
      5.360865,
      4,
      1.776458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0.951548,
      1,
      0,
      1,
      1,
      1,
      1,
      0.129468,
      1.366710,
      0.103831,
      0.488820,
      1,
      0.523791,
      NULL,
      NULL,
      0.174173,
      NULL,
      1,
      1.590796,
      1.242848,
      0.547013,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.220978,
      0,
      NULL,
      0.959827,
      NULL,
      NULL,
      1.005914,
      1,
      0,
      NULL,
      1,
      0.645949,
      1.733250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      4.165501,
      NULL,
      1.002149,
      1,
      1.010217,
      NULL,
      1.190293,
      1.629075,
      1,
      0.461858,
      1.277034,
      NULL,
      1,
      1,
      1.063634,
      0.932545,
      2.307757,
      1.125357,
      NULL,
      4,
      4,
      1,
      0.753839,
      4,
      3.830109,
      2,
      NULL,
      2.839067,
      1.611431,
      1,
      NULL,
      5,
      NULL,
      1.735218,
      NULL,
      0.417186,
      NULL,
      0.522372,
      NULL,
      1.279091,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      2,
      1,
      3,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      3,
      1,
      NULL,
      3,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      2,
      2,
      1,
      3,
      1,
      2,
      3,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      2,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4,
      1,
      1,
      2,
      5,
      5,
      2,
      5,
      3,
      NULL,
      5,
      5,
      3,
      1,
      0,
      2,
      4,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      5,
      1,
      5,
      2,
      2,
      1,
      4,
      0,
      1,
      2,
      1,
      4,
      4,
      4,
      1,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-29-1982',
      NULL,
      ' 9- 6-1984',
      ' 5-28-1981',
      ' 1- 0-1976',
      ' 1-14-1991',
      ' 1-29-2002',
      ' 2-24-1991',
      NULL,
      ' 5-23-1999',
      ' 1-27-1979',
      ' 6- 1-1992',
      ' 2-15-1993',
      ' 6-11-2001',
      ' 6-25-1993',
      ' 7-16-1982',
      ' 5-26-1977',
      ' 8-24-1992',
      '10-11-1989',
      ' 3-27-1975',
      ' 6-14-2001',
      ' 2-29-1977',
      '11-21-1990',
      ' 3- 2-1979',
      ' 4-22-2003',
      NULL,
      NULL,
      ' 2- 9-1997',
      ' 2-21-1975',
      NULL,
      ' 9-10-1978',
      '11-23-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1988',
      ' 5-16-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


