set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '21101033',
      35,
      21,
      NULL,
      NULL,
      NULL,
      0,
      '32002',
      NULL,
      ' 7-14-1988',
      5.696725,
      NULL,
      NULL,
      0,
      3.065836,
      NULL,
      1.797826,
      1,
      NULL,
      2.296159,
      2,
      2,
      0.553542,
      8,
      NULL,
      NULL,
      0.133958,
      NULL,
      38,
      0.974389,
      1.354377,
      1,
      2.048281,
      NULL,
      2,
      2.517608,
      3.691502,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      4,
      1,
      7,
      5,
      0,
      NULL,
      1.570497,
      0.597330,
      1.900474,
      0,
      0,
      2.190618,
      0.520204,
      0,
      0,
      5,
      2,
      1.677362,
      NULL,
      6,
      0.963152,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      1,
      0,
      NULL,
      NULL,
      0,
      51.951086,
      213.350458,
      0.489278,
      6.859073,
      96,
      61.700167,
      1.257647,
      2,
      1209,
      0.788559,
      3.448970,
      3,
      444.597388,
      4.051620,
      0,
      0,
      406,
      NULL,
      1.901998,
      7,
      NULL,
      10,
      0.779984,
      NULL,
      1398,
      6,
      NULL,
      NULL,
      1284,
      29,
      3.684324,
      3.511209,
      695,
      NULL,
      3.302354,
      3,
      205.468923,
      8.331517,
      2.093733,
      1,
      41,
      NULL,
      3.593815,
      2,
      NULL,
      NULL,
      1.358417,
      3.411395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '31133',
      '20324',
      '',
      '',
      NULL,
      0.243975,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      NULL,
      NULL,
      0.597283,
      NULL,
      1,
      NULL,
      1.712734,
      NULL,
      0.067896,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '10-10-2002',
      11.361440,
      6.629534,
      2,
      20.557634,
      1,
      1,
      1,
      NULL,
      3.436663,
      13.595908,
      NULL,
      9.928126,
      NULL,
      NULL,
      20.711480,
      6,
      NULL,
      NULL,
      3,
      23,
      19.611356,
      22.569925,
      16,
      16.180958,
      4,
      11.444027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.940999,
      0,
      7,
      1.307569,
      19,
      54.279409,
      2.330694,
      7.242541,
      NULL,
      7.680714,
      6.125890,
      28,
      NULL,
      2,
      2.673917,
      2,
      0.316422,
      15.131645,
      42.732324,
      13,
      6,
      NULL,
      NULL,
      2.402798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      124.323037,
      NULL,
      NULL,
      134.960643,
      129,
      163.564262,
      80.195997,
      NULL,
      29.853067,
      20.418403,
      5.619610,
      100.719631,
      100.834320,
      23,
      NULL,
      167,
      31.380352,
      154.532125,
      53,
      35,
      0,
      1,
      1,
      NULL,
      1.992406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900783,
      NULL,
      0.977115,
      1,
      NULL,
      1,
      0.626771,
      0,
      0.284757,
      NULL,
      NULL,
      2,
      1,
      2,
      0.283341,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.067438,
      2.565084,
      1,
      2,
      1.861400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595275,
      0.941064,
      0,
      1,
      0.875186,
      0.567336,
      0.909102,
      0.953118,
      0.441753,
      1.124414,
      NULL,
      0,
      0.412152,
      1.438452,
      4,
      6,
      6.803029,
      2,
      5,
      2.227580,
      1.552593,
      8,
      1.630231,
      2.729028,
      1.192018,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350072,
      0,
      0.305839,
      5.784274,
      1,
      3,
      2,
      0,
      5,
      1.996345,
      5.868168,
      4.110355,
      NULL,
      5.064406,
      NULL,
      3,
      3.240435,
      2.175542,
      5,
      1.412762,
      3,
      1.535120,
      NULL,
      4.616028,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685365,
      0.974922,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.175700,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.482301,
      1.657124,
      NULL,
      NULL,
      NULL,
      1.298174,
      0.783875,
      1,
      1.174858,
      4,
      1,
      1.293661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9.883786,
      NULL,
      NULL,
      4.399836,
      NULL,
      NULL,
      NULL,
      6.705461,
      7.618453,
      3,
      9,
      NULL,
      8,
      6,
      5.279830,
      7.042880,
      5,
      7.822372,
      3.588378,
      8,
      NULL,
      8.613033,
      9.920591,
      2,
      7.486350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.065056,
      0.215997,
      0,
      1,
      5.489766,
      7.203266,
      4,
      NULL,
      3,
      3.712368,
      NULL,
      7,
      0.870365,
      7.461082,
      1.065557,
      NULL,
      6.142515,
      3.244655,
      0,
      1.234496,
      1,
      2.812418,
      1.971466,
      5.290716,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4.072015,
      5,
      0.490871,
      NULL,
      1,
      NULL,
      0.143590,
      9,
      NULL,
      NULL,
      3,
      2,
      8,
      0,
      3.699870,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.015144,
      NULL,
      9,
      6,
      NULL,
      3.370264,
      3.458397,
      2.695425,
      2.225091,
      4,
      2.653518,
      7.336827,
      1,
      2.288190,
      7.379576,
      NULL,
      0.313824,
      4.241278,
      NULL,
      4,
      1,
      2,
      3.476938,
      1.053685,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543844,
      6,
      7,
      0.043845,
      5,
      2,
      4.097504,
      NULL,
      1,
      2.086787,
      0,
      NULL,
      3.477431,
      NULL,
      NULL,
      7.822186,
      4,
      5,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635114,
      1.470002,
      1.427334,
      1,
      0.104745,
      1,
      0.238720,
      5,
      5,
      3.429124,
      0.010460,
      NULL,
      0.424935,
      NULL,
      1.496000,
      3,
      5,
      6.694451,
      NULL,
      1.798121,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856054,
      NULL,
      1.312822,
      1.543788,
      0.384605,
      NULL,
      1.714445,
      1,
      1.077128,
      NULL,
      0.898429,
      1.230927,
      1.579919,
      0.143541,
      1,
      NULL,
      1.858272,
      0.078060,
      NULL,
      0.046126,
      0.820764,
      NULL,
      0.514300,
      1,
      0.967399,
      0.460197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2.879142,
      1,
      1,
      0.554942,
      1,
      0,
      0,
      0,
      0.250706,
      0.866369,
      1.936977,
      NULL,
      0.607883,
      1,
      NULL,
      1,
      3,
      3.791617,
      2,
      4.317905,
      5.614462,
      1.915542,
      3.730153,
      0.570284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      4.889225,
      NULL,
      5.720627,
      NULL,
      2,
      2.519218,
      NULL,
      3,
      NULL,
      NULL,
      0.128364,
      3.876356,
      NULL,
      0.259760,
      1,
      NULL,
      5,
      3,
      5.493635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      5.583602,
      2,
      1.972498,
      4.356502,
      0,
      1,
      4,
      4.878077,
      2.150813,
      5,
      4,
      1.403562,
      1.267584,
      NULL,
      0,
      1,
      6,
      3.036721,
      1.659508,
      5,
      6.488664,
      NULL,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      9.974282,
      5.160348,
      4,
      0,
      NULL,
      6.694698,
      4,
      NULL,
      2.758020,
      4,
      4,
      6,
      4.403372,
      NULL,
      5.642826,
      8,
      4,
      7,
      0.713149,
      NULL,
      NULL,
      NULL,
      7.390981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952363,
      0,
      NULL,
      1,
      NULL,
      1,
      0.524493,
      0,
      NULL,
      1.975543,
      0,
      0.179351,
      0.758016,
      NULL,
      1.546191,
      1.437582,
      1,
      0.296681,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1.534717,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7,
      0,
      0,
      0.131533,
      NULL,
      1,
      0,
      1.365884,
      1,
      1,
      0.445500,
      0.370606,
      1.084471,
      NULL,
      1,
      0,
      1,
      3.648019,
      NULL,
      0.235043,
      3,
      2.990219,
      0.009192,
      3,
      0.021256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      1,
      2,
      3,
      2,
      1,
      3,
      0,
      3,
      0,
      1,
      1,
      3,
      0,
      2,
      0,
      0,
      3,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2,
      5,
      2,
      NULL,
      4,
      2,
      NULL,
      5,
      NULL,
      5,
      NULL,
      NULL,
      4,
      NULL,
      5,
      5,
      5,
      1,
      0,
      0,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-1988',
      ' 7- 1-1974',
      '11- 5-1978',
      NULL,
      ' 0- 9-1983',
      ' 1-15-2002',
      NULL,
      ' 4-29-1977',
      ' 1- 3-1974',
      ' 8-25-1986',
      ' 8- 1-1985',
      ' 8-14-1980',
      '11- 3-1987',
      ' 5-27-1998',
      NULL,
      '10- 3-1991',
      ' 5-29-1981',
      ' 8-24-1979',
      ' 6-15-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1981',
      ' 0-22-1989',
      ' 6-20-1994',
      NULL,
      ' 3-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


