set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929504';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '3200134',
      1,
      NULL,
      2,
      '13213',
      0,
      '10-18-1996',
      36,
      NULL,
      1,
      NULL,
      2.521642,
      1.491565,
      NULL,
      0,
      0,
      NULL,
      1,
      0.740433,
      0.451713,
      9,
      NULL,
      NULL,
      1.937130,
      NULL,
      NULL,
      47,
      9,
      8,
      NULL,
      NULL,
      1,
      NULL,
      1.069374,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      2,
      7,
      5,
      5,
      5,
      NULL,
      9,
      NULL,
      4,
      NULL,
      1,
      1.147264,
      0,
      2,
      0,
      7,
      1.978861,
      4,
      7,
      4,
      0,
      6,
      3,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      5,
      1.239004,
      NULL,
      90.754141,
      34,
      15821,
      12,
      0.574225,
      80,
      7190.986137,
      3.951177,
      0.918102,
      99,
      19867,
      3,
      3,
      NULL,
      10132,
      1,
      0.783457,
      203,
      3978.601530,
      0,
      NULL,
      40.888773,
      77.594714,
      1,
      2.696814,
      NULL,
      3.983687,
      3,
      4.580830,
      328,
      NULL,
      1.717225,
      7,
      328.499710,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.759536,
      4,
      142.131804,
      24.550505,
      1,
      6,
      119.519303,
      NULL,
      1,
      2,
      74.706702,
      NULL,
      1.226587,
      3.070555,
      204.719741,
      7,
      NULL,
      3,
      48,
      8,
      0,
      7,
      294.143210,
      NULL,
      3,
      0,
      NULL,
      13603.030219,
      0.048385,
      2,
      49.297320,
      NULL,
      3,
      1,
      32,
      123.954944,
      2,
      9.170017,
      56.276015,
      80.184323,
      3,
      7,
      208,
      230.678033,
      NULL,
      3,
      44,
      271,
      4.712911,
      2,
      185.476849,
      103.832267,
      0,
      1.049597,
      11.470426,
      5728,
      1,
      3,
      87.224894,
      11.201617,
      1.099170,
      NULL,
      145.753881,
      15,
      0.598806,
      5,
      NULL,
      NULL,
      2.440801,
      1.379383,
      104,
      1,
      0,
      2,
      1391.726155,
      98,
      NULL,
      5,
      1401.818001,
      NULL,
      3,
      5.419574,
      1039,
      76.259223,
      2,
      3.044277,
      1157.725026,
      945.394832,
      3.839349,
      0,
      139.717091,
      5.859596,
      NULL,
      NULL,
      15.069256,
      5.841720,
      2,
      NULL,
      181,
      55,
      3,
      8,
      9,
      25,
      3.879761,
      NULL,
      636,
      2647.204205,
      NULL,
      3.554925,
      157,
      NULL,
      3.374789,
      7,
      740,
      8,
      3,
      9.317965,
      21,
      3,
      3,
      2,
      515,
      1,
      3,
      3,
      NULL,
      1,
      NULL,
      3,
      80,
      5.063520,
      1.194742,
      NULL,
      65,
      3.345251,
      2,
      0,
      216.759863,
      52,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '03320',
      NULL,
      '',
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '10300',
      '',
      '',
      1,
      3,
      NULL,
      2,
      268.843391,
      0.606705,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.095448,
      NULL,
      1,
      NULL,
      ' 6- 6-1977',
      NULL,
      0.575919,
      3,
      3.810489,
      NULL,
      7.256284,
      12,
      NULL,
      3,
      1.905578,
      2,
      19.465456,
      NULL,
      20.013593,
      23.199614,
      3.937742,
      1,
      5,
      1,
      19,
      11.960604,
      NULL,
      NULL,
      6,
      3,
      NULL,
      1.811584,
      2,
      2,
      1,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.417759,
      NULL,
      29,
      30,
      3.493709,
      NULL,
      9.940992,
      36,
      1.091314,
      48,
      NULL,
      31,
      26.101310,
      19.169917,
      5,
      31,
      NULL,
      NULL,
      11.095415,
      0.080815,
      11,
      28,
      24,
      4,
      20.261929,
      NULL,
      NULL,
      40.973043,
      32,
      0,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      NULL,
      NULL,
      20.578210,
      78.046776,
      76,
      166.923932,
      78.791307,
      124,
      97.375248,
      150.303615,
      56,
      69,
      42,
      72.394982,
      20,
      140.211571,
      45.044459,
      85,
      NULL,
      101.122196,
      51.715401,
      42.782420,
      150,
      79,
      173.770979,
      143,
      145,
      NULL,
      144.623180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030900,
      3.877286,
      2.130087,
      2.960588,
      0,
      8,
      1.853646,
      5,
      NULL,
      2,
      0.021607,
      9,
      0.655044,
      7.750385,
      2.943144,
      2.996852,
      5.630035,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      9,
      NULL,
      3,
      6.148586,
      8,
      5.664706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.815037,
      5,
      1.997904,
      7,
      NULL,
      4,
      0,
      8.674874,
      5,
      3.127262,
      2.411060,
      NULL,
      0.788499,
      6.414426,
      4.117173,
      3,
      1.443365,
      11.507018,
      8.008713,
      3.342797,
      2,
      8.804766,
      7,
      5.961669,
      8.141012,
      NULL,
      4,
      9.834172,
      NULL,
      7.013091,
      8.034036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.849126,
      5,
      3,
      7.319377,
      0.069508,
      3.236987,
      0,
      0.765994,
      1.554619,
      2,
      3,
      1,
      3,
      5,
      3,
      NULL,
      0,
      6.035075,
      NULL,
      2.591123,
      4,
      4,
      3.033359,
      6,
      4,
      4,
      6.239544,
      0.073439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832294,
      1,
      1,
      NULL,
      0.331061,
      2.783988,
      0.647949,
      0,
      1.033324,
      1.177248,
      0,
      4.259228,
      0,
      5.995032,
      0.779726,
      NULL,
      3.061298,
      4,
      NULL,
      3.645140,
      4.148101,
      4,
      NULL,
      5,
      4.762710,
      2,
      5,
      4.441914,
      7.989765,
      6,
      0.596770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235427,
      1,
      2,
      0.731566,
      2.488621,
      1.457786,
      3.390791,
      0,
      NULL,
      1,
      0,
      0.072306,
      NULL,
      2.727463,
      0.073183,
      2.685023,
      NULL,
      3,
      4,
      1,
      2.385346,
      0.066677,
      0,
      0.339274,
      2,
      1.647443,
      3.310253,
      5,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      9.648182,
      2.388413,
      8.663831,
      3,
      0.092424,
      2,
      7.750217,
      0.632044,
      NULL,
      5.595969,
      1,
      2,
      2,
      5,
      NULL,
      3.184669,
      11,
      1.480031,
      0,
      0.541957,
      0.789273,
      3,
      9,
      1.372813,
      2,
      3.809146,
      5,
      4.055994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.527111,
      NULL,
      0,
      6.720145,
      NULL,
      2,
      4.637056,
      2,
      2.597572,
      2.256615,
      NULL,
      2,
      3,
      2.492149,
      5.694568,
      1.778964,
      7.705692,
      NULL,
      4.103199,
      0,
      2.719805,
      5,
      NULL,
      NULL,
      5,
      4,
      4.181157,
      4,
      5.079385,
      5.608162,
      1.974895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035620,
      0.598838,
      0.810431,
      1,
      0,
      NULL,
      0.397333,
      5,
      1,
      7,
      NULL,
      4,
      NULL,
      NULL,
      4,
      7.981681,
      3.602096,
      7.944442,
      4.434389,
      0.648868,
      2.582222,
      0.474062,
      4,
      NULL,
      5.852846,
      NULL,
      5,
      0,
      6.662636,
      1.817564,
      1.042668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.833901,
      11.597149,
      0,
      NULL,
      3,
      NULL,
      1.455524,
      4,
      3,
      2.335615,
      2.848533,
      10.870649,
      NULL,
      0,
      5,
      NULL,
      5,
      10,
      5.258578,
      10.480206,
      4,
      10,
      5,
      6.589073,
      3,
      NULL,
      7,
      NULL,
      10,
      7.873472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916914,
      10,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.231016,
      11,
      0.391522,
      4.787798,
      NULL,
      8.489792,
      0,
      NULL,
      0.079091,
      6.059730,
      NULL,
      8,
      4,
      11.972790,
      1,
      NULL,
      2,
      10.032135,
      2.273385,
      2,
      5.128062,
      7,
      2.113542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448096,
      1.828958,
      1,
      1.870708,
      0.854388,
      1,
      1,
      1,
      NULL,
      0,
      0.395779,
      1.366203,
      1,
      1.505183,
      1.189651,
      1.942720,
      1,
      0,
      1,
      0.957190,
      1.523017,
      0.386192,
      NULL,
      1.089545,
      0.238553,
      0.747257,
      1,
      1,
      NULL,
      0,
      0.341063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.700590,
      1.392311,
      1,
      0,
      1.873628,
      1,
      1,
      0,
      0.754611,
      0,
      0.702947,
      0,
      1,
      NULL,
      1.410681,
      1.909646,
      0.500046,
      1,
      0,
      NULL,
      1,
      1.712720,
      NULL,
      0.896442,
      0.343292,
      1.610438,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455317,
      0,
      1.459787,
      NULL,
      0.246803,
      1.419440,
      1.303445,
      1.327376,
      1,
      0.100616,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1.249915,
      1,
      1.202674,
      NULL,
      0,
      0,
      1.469475,
      0.369833,
      1,
      NULL,
      1,
      2,
      1,
      0.192961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.534673,
      6,
      1.446356,
      9,
      2,
      NULL,
      2,
      6,
      1.879060,
      NULL,
      1.091278,
      2.539007,
      1.853678,
      2.664289,
      0,
      6.511350,
      NULL,
      11,
      1,
      9.966875,
      8.953111,
      8,
      4,
      4.085155,
      1,
      0.033101,
      NULL,
      4.959410,
      5,
      NULL,
      0.184619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685377,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2,
      1.582598,
      NULL,
      2,
      4.070018,
      4.937214,
      0,
      1,
      3,
      4,
      1,
      6,
      4,
      1.001008,
      11,
      0.752764,
      10.482543,
      7,
      1,
      2,
      1.439936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273438,
      1.930449,
      NULL,
      1.596536,
      0,
      1,
      NULL,
      1.326419,
      NULL,
      1,
      1,
      1,
      1.656774,
      1,
      1.209741,
      0,
      NULL,
      1,
      0,
      1.993147,
      NULL,
      1.002021,
      1.486254,
      NULL,
      NULL,
      0.437130,
      0.641840,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.018941,
      1.852416,
      0,
      1.034513,
      0,
      0.879370,
      0.975441,
      1,
      0,
      NULL,
      0.993836,
      0.441927,
      0,
      0,
      1,
      1.898529,
      0.477464,
      1,
      NULL,
      0,
      0.963841,
      NULL,
      0.142371,
      0.039278,
      0.457496,
      1,
      0,
      NULL,
      0.676780,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      3,
      0,
      2,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      2,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4,
      NULL,
      2,
      3,
      NULL,
      2,
      4,
      0,
      NULL,
      2,
      5,
      2,
      NULL,
      0,
      5,
      1,
      NULL,
      3,
      1,
      3,
      NULL,
      2,
      5,
      2,
      5,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-1985',
      NULL,
      NULL,
      NULL,
      ' 1-22-1997',
      ' 8-21-2001',
      ' 8-26-2003',
      NULL,
      ' 7- 7-1976',
      ' 7- 6-1977',
      ' 1-10-1999',
      ' 9- 0-1978',
      ' 4- 5-2002',
      ' 4-10-1987',
      ' 1- 6-1990',
      NULL,
      ' 5-29-1976',
      ' 1-16-1991',
      ' 4-11-1984',
      ' 2-29-2002',
      ' 9-23-1974',
      ' 1- 1-1989',
      '10-17-1995',
      '11-17-1980',
      NULL,
      ' 7-15-2000',
      ' 6-13-1977',
      NULL,
      ' 8-29-1983',
      '11-16-1981',
      ' 4- 3-1975',
      '10-23-1981',
      ' 0-20-1987',
      ' 2- 6-1981',
      NULL,
      NULL,
      NULL,
      ' 5-14-1980',
      NULL,
      ' 1-22-1974',
      '10- 2-1996',
      NULL,
      ' 3- 9-1992',
      ' 6-11-1986',
      NULL,
      ' 9- 4-1990',
      ' 9-15-1976',
      ' 8-28-1979',
      NULL,
      ' 5- 2-1998',
      ' 6- 8-1995',
      ' 0-12-1982',
      ' 9-14-1976',
      ' 3-18-1978',
      ' 7-22-1983',
      ' 8-18-1994',
      ' 4-19-1984',
      ' 5- 5-1994',
      '10- 9-2002',
      '11- 6-1977',
      NULL,
      ' 0- 8-1976',
      ' 1-12-1996',
      ' 0-26-1990',
      ' 5-28-1976',
      ' 7- 0-1978',
      ' 1-17-1986',
      ' 7-28-1992',
      ' 8- 5-2000',
      ' 4-29-2002',
      ' 5-24-1991',
      '10- 7-1991',
      ' 0-17-1984',
      NULL,
      ' 0-20-1990',
      ' 8- 8-1984',
      NULL,
      ' 0- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-15-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165554);
commit;
end;
/


