set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8008059';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '2400311',
      2,
      2,
      NULL,
      '03422',
      2,
      ' 3-13-1981',
      15,
      NULL,
      0.639601,
      0,
      0.378991,
      NULL,
      0,
      0,
      NULL,
      3.931383,
      1,
      2.962873,
      0,
      6,
      NULL,
      NULL,
      0.356958,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113167,
      NULL,
      3,
      6.259530,
      0.594033,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      9,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      8,
      0.984888,
      1,
      0.195696,
      NULL,
      0.424773,
      0.007272,
      0,
      1.166056,
      3,
      1,
      NULL,
      1,
      2,
      4,
      7.174734,
      2,
      7,
      4,
      0.904866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      0.494202,
      3,
      NULL,
      3,
      4854,
      12,
      9,
      187.104114,
      77.114726,
      1.489219,
      0,
      189,
      12,
      0,
      0,
      143.311453,
      NULL,
      0,
      NULL,
      125.671833,
      63,
      0,
      1.496388,
      122.787966,
      NULL,
      2.786988,
      3,
      178,
      28.684088,
      2.088251,
      NULL,
      147,
      15,
      0.909401,
      0.243039,
      92.879681,
      3.950265,
      1,
      7.281020,
      121,
      31,
      NULL,
      NULL,
      NULL,
      0.487328,
      0,
      0.604666,
      NULL,
      54.077007,
      1,
      0.269004,
      102,
      82,
      NULL,
      2,
      24.020634,
      27.720279,
      NULL,
      1.265504,
      404,
      26.129480,
      3,
      4,
      146.635289,
      103.430889,
      0,
      NULL,
      920.509232,
      5,
      2.787884,
      1,
      36,
      21.372102,
      3.895284,
      5.173100,
      97.171408,
      NULL,
      1,
      2,
      187,
      3.587978,
      3.803789,
      0,
      181,
      24.697468,
      0.801707,
      2.821922,
      NULL,
      NULL,
      0.260580,
      2,
      89.183348,
      126,
      3,
      NULL,
      213.881218,
      2099.715379,
      2,
      1,
      191,
      NULL,
      1.346031,
      NULL,
      140.916169,
      NULL,
      0.508592,
      1,
      385,
      8,
      NULL,
      2.843327,
      40.958467,
      NULL,
      0.272932,
      3.698905,
      330.411701,
      NULL,
      NULL,
      1.704026,
      224,
      4.219053,
      3,
      2,
      84,
      4.658248,
      2.900267,
      2.210837,
      169.024136,
      10,
      3.492152,
      0,
      130.864792,
      484,
      3.915118,
      0,
      208.106438,
      NULL,
      NULL,
      NULL,
      33.070123,
      111.124538,
      1,
      3.492915,
      911.648826,
      1213,
      NULL,
      1,
      73.769011,
      681.590454,
      0,
      1.737411,
      153.762512,
      131,
      1,
      0.159711,
      278,
      11,
      1,
      2,
      48.990472,
      NULL,
      3,
      5,
      117.981213,
      254,
      NULL,
      2,
      177,
      88,
      0.045519,
      NULL,
      37,
      491.189948,
      3,
      4.434938,
      NULL,
      530.670733,
      0,
      2,
      43,
      983,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '10324',
      '33320',
      '24210',
      '',
      '',
      '',
      1.083212,
      NULL,
      '',
      NULL,
      3,
      '00311',
      NULL,
      NULL,
      2,
      1.816062,
      NULL,
      2,
      590,
      NULL,
      NULL,
      1.522652,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.663709,
      NULL,
      1.697532,
      NULL,
      NULL,
      NULL,
      NULL,
      3.831185,
      8.772253,
      6.974543,
      11,
      2.156377,
      15,
      2,
      10.453889,
      4,
      4,
      NULL,
      17,
      1,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.124186,
      NULL,
      7,
      NULL,
      17.237719,
      24.435243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.167131,
      12,
      30,
      18.776453,
      4.535134,
      2.599137,
      2.300636,
      5.436163,
      28,
      1.050446,
      15.974902,
      1.561668,
      3,
      3.451881,
      NULL,
      NULL,
      21,
      45.553030,
      5,
      35,
      9,
      33.709956,
      16.186747,
      14,
      6.475127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      127,
      63,
      74,
      92.991992,
      NULL,
      106.679847,
      NULL,
      62,
      22.840711,
      147,
      105,
      84,
      129,
      NULL,
      113.526798,
      72.869336,
      113.890795,
      NULL,
      10.609120,
      19.498655,
      4,
      NULL,
      173.601430,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.017409,
      4.528007,
      5,
      NULL,
      8,
      0.972090,
      NULL,
      9,
      2,
      NULL,
      9.135052,
      NULL,
      7.842265,
      1,
      6,
      NULL,
      6.917727,
      3.900681,
      5,
      3.816795,
      3.959944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.542691,
      4.213708,
      1.667476,
      2.679258,
      5,
      6,
      1.877416,
      5.566459,
      NULL,
      1.409645,
      NULL,
      7,
      5,
      0,
      5.519016,
      1,
      4,
      5.405317,
      1,
      3.800562,
      4.373073,
      8.965584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1,
      5,
      3,
      7.182618,
      7,
      NULL,
      1,
      5.765279,
      3,
      NULL,
      3,
      NULL,
      3.709114,
      7.508252,
      6.639215,
      NULL,
      3.726568,
      7.433187,
      3,
      5.906773,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      2,
      0,
      3,
      1,
      2.689212,
      3,
      4.892712,
      3.850103,
      0.701148,
      2,
      NULL,
      3,
      1,
      3.618870,
      2,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.375586,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.997218,
      0.619582,
      3.782604,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      0.322066,
      2.901239,
      NULL,
      4.272469,
      2,
      0.320818,
      2.134097,
      1,
      1.682925,
      2.885886,
      2,
      0.904740,
      2.039429,
      7.092522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.331231,
      5.512131,
      1,
      6,
      0,
      5.721913,
      NULL,
      4,
      1.757534,
      7.014613,
      0.716836,
      NULL,
      5.254059,
      0.130001,
      10.033072,
      6,
      1,
      NULL,
      6,
      NULL,
      6,
      5,
      9.968783,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      4.391199,
      NULL,
      7,
      6.124405,
      5.327185,
      6,
      0.783971,
      0.206660,
      4,
      5,
      3.242029,
      1.351778,
      4,
      2.297176,
      0,
      7,
      4,
      NULL,
      NULL,
      NULL,
      3.908143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.217903,
      2,
      5.260688,
      NULL,
      NULL,
      2.147057,
      4,
      0,
      3.605270,
      NULL,
      1,
      3.512422,
      1.317035,
      1,
      3,
      5.136151,
      6,
      3.416773,
      5,
      3.850725,
      NULL,
      5,
      3,
      4.083213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      5,
      5,
      0,
      5.255155,
      5,
      NULL,
      5,
      NULL,
      0,
      3,
      0.773147,
      4.006971,
      4,
      3.768468,
      0,
      2.455737,
      3.178207,
      1.825161,
      2,
      NULL,
      0.873195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.524278,
      NULL,
      1,
      4.112618,
      0.247385,
      4.931138,
      4,
      3.101455,
      3.242728,
      0,
      2,
      5,
      NULL,
      4.397266,
      4.093351,
      6.502651,
      1,
      5.185652,
      3,
      1.628977,
      1,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982922,
      1,
      0.357929,
      0,
      0.113268,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.587600,
      1.466909,
      0.973869,
      0.590150,
      1.606246,
      NULL,
      NULL,
      1.738392,
      1,
      NULL,
      NULL,
      NULL,
      0.954000,
      0.609662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.391860,
      0.937090,
      5,
      1,
      4,
      1.127880,
      1,
      3.168271,
      2.038054,
      NULL,
      3.733354,
      2,
      2.362950,
      5.605537,
      NULL,
      5.786477,
      0.907496,
      4.607231,
      4,
      5.325721,
      5,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      3.952875,
      3,
      2,
      3.831816,
      NULL,
      1.278242,
      3.340781,
      3,
      0,
      4.592617,
      5,
      3.484038,
      4,
      NULL,
      3.343305,
      1,
      NULL,
      1.650060,
      3,
      3.817237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.071139,
      3,
      3,
      0.503245,
      1,
      4.132402,
      7,
      3.216478,
      6.874453,
      0.121473,
      0.808753,
      4.359992,
      9.279273,
      NULL,
      6.050027,
      NULL,
      2.226926,
      0.676649,
      7,
      6,
      0,
      6,
      4,
      7.560757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3.117555,
      6.634694,
      2.528520,
      7,
      NULL,
      6,
      2.482545,
      0,
      3.183579,
      7.528143,
      2,
      4,
      3.311923,
      NULL,
      5.550973,
      NULL,
      4.052537,
      1.445226,
      3,
      3.260481,
      6,
      6,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468333,
      0.650484,
      NULL,
      NULL,
      1.808147,
      NULL,
      1,
      1,
      NULL,
      1,
      0.958970,
      NULL,
      0.087028,
      1.889030,
      1.853028,
      NULL,
      1.856890,
      1,
      1.775074,
      0.521742,
      0.084535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.457069,
      2.040298,
      3.824504,
      2,
      5.442383,
      3,
      1.652577,
      NULL,
      0.758381,
      2,
      NULL,
      5.714288,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.636486,
      3.952366,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      1,
      0,
      3,
      3,
      NULL,
      1,
      2,
      NULL,
      1,
      2,
      1,
      1,
      1,
      2,
      0,
      0,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      3,
      1,
      2,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      5,
      3,
      3,
      1,
      0,
      1,
      NULL,
      3,
      NULL,
      0,
      5,
      0,
      NULL,
      3,
      0,
      1,
      3,
      0,
      2,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1978',
      NULL,
      '10- 0-1985',
      ' 9- 3-2001',
      '10-18-2001',
      ' 2- 1-1991',
      ' 0-26-1998',
      ' 3-18-1997',
      ' 5- 6-1986',
      ' 2-29-1987',
      ' 2-14-1989',
      NULL,
      NULL,
      ' 7-21-1989',
      ' 5-27-1981',
      ' 9-10-1980',
      '10-28-1996',
      NULL,
      '11-29-1992',
      NULL,
      ' 3-23-1993',
      NULL,
      NULL,
      ' 7-15-1997',
      NULL,
      ' 6-26-1992',
      NULL,
      ' 0- 2-1976',
      NULL,
      '10-10-1981',
      NULL,
      ' 0- 5-1999',
      ' 1-14-1985',
      '10-15-1994',
      '11- 7-1986',
      ' 4-16-1997',
      ' 0-22-1999',
      '11-26-1976',
      ' 5-24-1992',
      ' 3- 3-1983',
      ' 4- 2-2002',
      NULL,
      ' 5-25-1989',
      ' 9-25-2002',
      ' 8- 7-1994',
      ' 6-27-1996',
      ' 9- 6-2003',
      ' 2-14-2002',
      ' 7-13-1992',
      ' 0-16-1982',
      '11-11-2003',
      ' 1-27-1982',
      ' 9- 4-1996',
      ' 0-19-1991',
      ' 2- 5-1993',
      '11-23-2001',
      '11- 6-1979',
      NULL,
      ' 3-19-1999',
      '11-23-1997',
      ' 3-26-1987',
      ' 0- 2-1976',
      '10-25-2002',
      '11-26-1994',
      NULL,
      ' 7-15-1999',
      ' 8- 4-1996',
      ' 7-20-1994',
      ' 8- 4-2003',
      NULL,
      ' 5- 7-1982',
      NULL,
      ' 8- 2-1978',
      ' 0- 5-1975',
      ' 8- 2-1994',
      ' 3-22-1993',
      '11-26-2000',
      '11- 3-1990',
      NULL,
      ' 9-19-1985',
      ' 7-16-1993',
      NULL,
      ' 4-21-1996',
      ' 9-28-1985',
      ' 9-23-1992',
      ' 8-20-1992',
      ' 5-16-1986',
      ' 7-15-1987',
      ' 4-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-2002',
      ' 0- 1-1994',
      ' 6- 2-1989',
      ' 4-20-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265322);
commit;
end;
/


