set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016189';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '3040233',
      NULL,
      0.233052,
      NULL,
      '04030',
      0,
      ' 6- 3-1997',
      NULL,
      NULL,
      1.755839,
      3,
      1,
      1.566304,
      0.474700,
      0.138893,
      NULL,
      2,
      3.123520,
      NULL,
      1.144243,
      NULL,
      NULL,
      NULL,
      1.763105,
      2.730070,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858033,
      NULL,
      5,
      7.294861,
      NULL,
      3.127543,
      NULL,
      NULL,
      6,
      0,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      4,
      1,
      NULL,
      9.539247,
      NULL,
      NULL,
      0,
      0.040383,
      NULL,
      NULL,
      3,
      0.344719,
      1.029062,
      14.402770,
      3,
      4,
      2,
      NULL,
      4,
      10,
      3.684602,
      1,
      62.482148,
      '11- 6-2002',
      168.585550,
      3.197317,
      2,
      2,
      0,
      NULL,
      3.304135,
      1,
      1,
      81,
      42.938017,
      NULL,
      NULL,
      163,
      2,
      1.073528,
      0,
      220.676932,
      3.677463,
      2.297644,
      3,
      189.249504,
      NULL,
      3.377123,
      3,
      117.990539,
      126,
      3,
      7.494890,
      161.189726,
      184,
      3,
      4.724539,
      158.367924,
      13.371934,
      0,
      3,
      184.063837,
      153,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      40.203553,
      93.444999,
      NULL,
      1,
      237,
      NULL,
      NULL,
      2,
      107.655238,
      9,
      3.528023,
      5,
      24,
      143.771701,
      1.533397,
      1.726016,
      275.797282,
      1.425208,
      2.001675,
      2.227052,
      452.574473,
      395,
      0,
      2.717936,
      135.205915,
      85,
      2.838346,
      2.766879,
      97,
      318,
      3.754003,
      1.956106,
      NULL,
      35,
      NULL,
      4,
      NULL,
      48,
      0.850141,
      6,
      NULL,
      49.924456,
      1,
      3.405245,
      110.766941,
      131,
      1,
      NULL,
      128.236439,
      NULL,
      1,
      0,
      182,
      44.182809,
      NULL,
      1,
      NULL,
      149,
      2.009748,
      2.762639,
      51.401222,
      76,
      NULL,
      1.544820,
      34,
      NULL,
      NULL,
      1,
      NULL,
      192.243614,
      NULL,
      0.482637,
      157.146756,
      NULL,
      1,
      6,
      NULL,
      26,
      0.521753,
      6.448598,
      3.457288,
      699.572366,
      NULL,
      7.942974,
      NULL,
      462.092172,
      1,
      2,
      86,
      551,
      3.435786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '41441',
      '43434',
      '43003',
      '43024',
      '13220',
      '',
      0.536744,
      '',
      '',
      NULL,
      0.468097,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      201.331018,
      NULL,
      NULL,
      0.558358,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.835956,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.996867,
      14.223472,
      NULL,
      5,
      8,
      NULL,
      NULL,
      0,
      4.644203,
      4.849386,
      NULL,
      10,
      NULL,
      8,
      10.065552,
      4,
      1,
      9,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      19,
      NULL,
      13,
      21.790841,
      NULL,
      7,
      4.303199,
      0.048023,
      18.068082,
      26,
      38,
      7.172927,
      NULL,
      NULL,
      NULL,
      5,
      21.727944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.317973,
      7.251227,
      NULL,
      22,
      0,
      135,
      89.023075,
      81.077898,
      NULL,
      102,
      27.145036,
      25,
      NULL,
      8.420551,
      124,
      11.439236,
      NULL,
      16.825601,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344768,
      2,
      NULL,
      7.188608,
      NULL,
      7.633774,
      3.271468,
      4,
      9.562629,
      7.809506,
      2,
      2,
      NULL,
      9,
      5,
      5.231831,
      5.484451,
      7,
      8.300357,
      0.869012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6,
      NULL,
      3.588698,
      7.197894,
      NULL,
      7,
      2,
      0,
      9,
      0,
      NULL,
      7,
      8.877841,
      NULL,
      0.180219,
      2.274058,
      4.631365,
      3.614324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.936895,
      7,
      1.313194,
      NULL,
      2,
      1,
      5,
      0.013065,
      NULL,
      3.812242,
      NULL,
      5.093162,
      0,
      4,
      2.845946,
      1.410008,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.967466,
      5,
      6,
      2,
      0,
      1,
      NULL,
      1.328526,
      NULL,
      3,
      4.750742,
      1.405301,
      0,
      7.184937,
      NULL,
      4.910256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445241,
      4.991782,
      1.921346,
      0,
      2.513068,
      0,
      NULL,
      0.092094,
      1,
      4.752381,
      4.551747,
      4.345001,
      2.667573,
      4,
      1.950451,
      2.925058,
      4.064919,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.863922,
      7,
      NULL,
      NULL,
      NULL,
      2,
      7,
      3.501222,
      NULL,
      7.404331,
      NULL,
      0,
      NULL,
      2.132642,
      1,
      4,
      5.292341,
      10,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.160420,
      3,
      1,
      5.249327,
      7.934317,
      2.641299,
      7,
      7,
      0,
      5.744273,
      4,
      8.378166,
      2.956950,
      1.995968,
      NULL,
      6,
      7,
      NULL,
      6.778886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.374459,
      5,
      1,
      1.363716,
      3,
      4,
      3.056770,
      NULL,
      7,
      NULL,
      7,
      5,
      NULL,
      1.644497,
      NULL,
      6,
      2,
      5,
      6,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.090284,
      NULL,
      1,
      1.707691,
      1,
      3,
      1.463528,
      1.812236,
      3.048731,
      1,
      2,
      NULL,
      NULL,
      4,
      NULL,
      5.807817,
      4.260133,
      5.153529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.461344,
      1.602954,
      0.081609,
      0,
      0,
      1,
      0.693942,
      1,
      1.003570,
      0,
      4,
      1,
      NULL,
      1,
      3.769096,
      NULL,
      2.482322,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.371749,
      0,
      1,
      0,
      0,
      1.142565,
      0,
      NULL,
      0.144827,
      1.134359,
      0.314625,
      0.575572,
      0.073832,
      1.920717,
      0,
      1,
      NULL,
      0,
      1.054905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.734313,
      3,
      1.451062,
      0.943813,
      2.607470,
      0,
      0.908891,
      0,
      NULL,
      0,
      3,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666095,
      0.341572,
      2.128807,
      1,
      NULL,
      2,
      0,
      NULL,
      0.719727,
      1,
      0.914572,
      0,
      0,
      0.769363,
      0,
      1.901901,
      1.994804,
      0.374626,
      0.459977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.355527,
      5,
      5.472620,
      NULL,
      8,
      7.517512,
      5,
      NULL,
      2.199425,
      2,
      1.885380,
      0.303462,
      8,
      NULL,
      NULL,
      5.165840,
      6.359431,
      NULL,
      8.343496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.530257,
      4.918549,
      1,
      6.834974,
      2.093466,
      1.870653,
      1.077555,
      NULL,
      4.888587,
      6.097713,
      8,
      NULL,
      5,
      5.223077,
      2,
      NULL,
      6.617434,
      3.362871,
      NULL,
      0.504794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.966465,
      1,
      NULL,
      0.130291,
      NULL,
      1,
      1.067049,
      1,
      0,
      1,
      NULL,
      0.570747,
      NULL,
      1.700607,
      NULL,
      1.765122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802824,
      1,
      5.481071,
      2,
      3.878862,
      0.307258,
      3,
      0.592010,
      2.460791,
      5.745341,
      0,
      1.315819,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3.913227,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      5,
      2,
      2,
      2,
      NULL,
      3,
      3,
      5,
      1,
      4,
      0,
      3,
      1,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1979',
      NULL,
      ' 0-16-2000',
      NULL,
      ' 0-13-1980',
      NULL,
      NULL,
      ' 9- 6-1981',
      NULL,
      NULL,
      ' 7-13-1998',
      NULL,
      ' 5-23-1985',
      ' 8-11-1978',
      ' 5- 0-1974',
      NULL,
      ' 2-21-2003',
      ' 9-27-1987',
      ' 5-16-1993',
      NULL,
      '10-22-1993',
      NULL,
      NULL,
      '10-17-2000',
      ' 3-11-1989',
      '10-20-1985',
      ' 9-26-1975',
      ' 4- 0-1981',
      ' 3- 4-2002',
      ' 4- 6-1977',
      ' 6-20-1975',
      ' 1-11-1980',
      ' 5- 9-1986',
      ' 2-11-1992',
      '10- 9-1974',
      ' 3-23-1984',
      ' 2-17-1988',
      '11-21-1996',
      NULL,
      NULL,
      '10- 4-1992',
      ' 5- 8-1996',
      NULL,
      ' 1- 0-1977',
      ' 0-17-1991',
      ' 6-21-1995',
      '10-22-1983',
      ' 6-13-1991',
      ' 1-22-2002',
      ' 0- 3-1989',
      ' 4- 7-1999',
      ' 7- 0-1994',
      ' 2-23-1982',
      ' 8- 8-1999',
      ' 1-29-1980',
      ' 7-23-1993',
      NULL,
      ' 1-15-1994',
      ' 5- 7-2000',
      ' 5-22-1974',
      ' 3-13-1986',
      ' 0- 4-1976',
      '10-16-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-1995',
      ' 8-26-1978',
      '11-15-1996',
      '10- 3-1992',
      ' 7- 1-1991',
      '10- 8-1985',
      ' 4-28-2003',
      ' 6-21-1995',
      ' 1- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320182);
commit;
end;
/


