set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9706710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '4010222',
      2,
      3.718448,
      NULL,
      '04110',
      0,
      '10- 7-1993',
      36.844340,
      NULL,
      0.561951,
      3,
      0,
      1.409512,
      0,
      NULL,
      0.151676,
      0,
      1.282120,
      3.488657,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      67.166534,
      117.227413,
      6,
      4,
      NULL,
      NULL,
      0,
      6,
      1.353408,
      4,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      5.656880,
      8,
      NULL,
      1,
      1.345740,
      1.221779,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.108993,
      NULL,
      7,
      NULL,
      4,
      NULL,
      2,
      NULL,
      0.929271,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.598459,
      3,
      1,
      2,
      5,
      5,
      63,
      79.920606,
      67.006100,
      1,
      8,
      121,
      16.231499,
      0,
      2.668770,
      13.202039,
      48.733163,
      2.652100,
      1,
      113,
      32,
      1,
      7.321779,
      187.110929,
      20.523408,
      3,
      3.000423,
      NULL,
      0,
      0.308346,
      1.033439,
      NULL,
      5,
      1,
      0.284637,
      117.937895,
      51.195876,
      NULL,
      1.924623,
      34.606299,
      2,
      1.502498,
      3,
      118.172690,
      3.272051,
      0,
      1.326843,
      91,
      27.568386,
      0.830096,
      2.255837,
      NULL,
      11,
      3.834140,
      NULL,
      111.105902,
      1,
      0.631342,
      0,
      105,
      24.494834,
      NULL,
      3.282650,
      462.725179,
      40,
      NULL,
      1,
      24,
      16,
      2.462801,
      3.545386,
      366.478378,
      1,
      2,
      NULL,
      73.372752,
      20,
      0,
      8,
      169,
      NULL,
      0.779232,
      3.055271,
      215,
      16.910687,
      1.911793,
      NULL,
      71,
      4.909862,
      3,
      6,
      125.751003,
      3,
      2,
      NULL,
      23,
      5.362754,
      2,
      NULL,
      43.587666,
      2.593394,
      3.098120,
      0,
      56.580276,
      NULL,
      NULL,
      0.455524,
      132.091326,
      NULL,
      0.620207,
      5,
      159.296320,
      NULL,
      2.062055,
      3.405618,
      7,
      1,
      NULL,
      4,
      7,
      0.419549,
      NULL,
      2,
      891,
      NULL,
      0.957152,
      0.120561,
      212.628532,
      6.219008,
      2.569253,
      NULL,
      372,
      1,
      1,
      3.442113,
      150,
      14.225455,
      3.665866,
      7,
      587.718197,
      41,
      2,
      0.381384,
      117.553519,
      2.695644,
      0.945664,
      0.203968,
      211,
      0.273995,
      0,
      3,
      223.272163,
      3.914623,
      1.428066,
      3,
      197.571889,
      5,
      2,
      3,
      NULL,
      10,
      3,
      2.032311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.754340,
      '20040',
      NULL,
      '',
      '',
      '',
      '',
      1.233376,
      '',
      '',
      '',
      1.269477,
      '',
      NULL,
      NULL,
      NULL,
      3.958354,
      155,
      1,
      NULL,
      0.556550,
      NULL,
      0.011912,
      NULL,
      0.592901,
      NULL,
      1,
      NULL,
      0,
      20.027116,
      1.930199,
      NULL,
      1.807716,
      NULL,
      0.496711,
      NULL,
      ' 9-26-1990',
      8,
      9.028992,
      15,
      2.143779,
      2,
      0.316986,
      7,
      NULL,
      0,
      2,
      4.224768,
      1.765938,
      9,
      13,
      9.076147,
      15.846096,
      NULL,
      4.048776,
      16.354147,
      2.897271,
      9,
      2,
      4,
      4,
      NULL,
      13,
      NULL,
      12,
      5,
      8,
      9,
      8,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      6,
      7.484374,
      25,
      NULL,
      44.489371,
      12.299644,
      7.616200,
      NULL,
      45.740816,
      2.886003,
      7.333733,
      18.199642,
      26.728358,
      32.870544,
      13,
      13,
      1,
      NULL,
      NULL,
      4,
      18,
      NULL,
      8,
      NULL,
      2.023782,
      12,
      NULL,
      NULL,
      11,
      7.665077,
      9,
      43.718033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      119.080767,
      89.742991,
      72.097371,
      180,
      33.721557,
      38.175218,
      82.605361,
      175.769897,
      157,
      65.012348,
      NULL,
      146.410241,
      137.494056,
      120,
      NULL,
      149.094818,
      91,
      151,
      163.660737,
      NULL,
      173,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      180,
      185.516377,
      74,
      NULL,
      181.109444,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4.595213,
      NULL,
      8.193097,
      1.897985,
      NULL,
      NULL,
      2,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      3.137562,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0.265275,
      0,
      1,
      2,
      NULL,
      5,
      NULL,
      0.166077,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.471619,
      0.759171,
      1.525400,
      6,
      4,
      2,
      3,
      0.479395,
      0.747765,
      7,
      2.446905,
      0,
      1,
      2,
      0,
      NULL,
      3,
      7,
      0,
      0.017167,
      1.952318,
      NULL,
      NULL,
      NULL,
      2,
      0.324318,
      0,
      5,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.197080,
      2,
      2,
      NULL,
      NULL,
      1.138929,
      2.096946,
      3,
      1.867179,
      0.982359,
      1,
      1.912838,
      NULL,
      NULL,
      3,
      0.535204,
      3.825501,
      1,
      3,
      NULL,
      NULL,
      3.462798,
      0.323959,
      0,
      3.701940,
      0,
      NULL,
      NULL,
      1.316374,
      0,
      4.996240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.469809,
      3.573314,
      5.503965,
      4.631429,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.524400,
      5.553202,
      4.414604,
      2.099772,
      2.817047,
      NULL,
      0.791421,
      1,
      2,
      NULL,
      4,
      NULL,
      0.545323,
      3,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      4.988519,
      0.206256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      0.241091,
      5,
      5,
      2.243062,
      0.625013,
      2.379500,
      NULL,
      5.876926,
      NULL,
      0.402643,
      1,
      2,
      0.711422,
      NULL,
      0,
      NULL,
      2,
      0.766950,
      NULL,
      0.124407,
      0,
      3,
      0,
      1.306743,
      1,
      0,
      2.352022,
      0,
      1,
      2.605591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196996,
      NULL,
      5,
      0.011318,
      2,
      1.056696,
      NULL,
      1,
      NULL,
      0.267125,
      6,
      3,
      3,
      2,
      NULL,
      NULL,
      2,
      4,
      4,
      5.625576,
      0,
      NULL,
      3,
      6.620411,
      NULL,
      NULL,
      0,
      4,
      6.578662,
      4.549075,
      4,
      2.938776,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.479426,
      5,
      2,
      0,
      1.440699,
      3.700275,
      7.604265,
      3.795115,
      1,
      7.209872,
      0,
      NULL,
      3.584069,
      1.905418,
      1,
      3,
      NULL,
      2.131822,
      4,
      6,
      5,
      0.616002,
      9,
      6.892665,
      5.737242,
      6.383867,
      NULL,
      3.244294,
      0.545866,
      2,
      NULL,
      2.814964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.830877,
      0.666885,
      1.778614,
      NULL,
      0,
      1,
      1,
      3.123883,
      1.198116,
      0,
      1,
      0.551567,
      1.785911,
      1.322098,
      1,
      NULL,
      1.209748,
      2.874184,
      1.366605,
      0.786744,
      NULL,
      NULL,
      2.802109,
      2,
      2,
      0,
      NULL,
      2,
      0.824080,
      1.543760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.001708,
      0.406547,
      0.709192,
      2.272448,
      1,
      3.217250,
      4,
      1.780524,
      NULL,
      1.204023,
      1.458399,
      1.668784,
      NULL,
      2.941512,
      1.926402,
      5.653047,
      1,
      2.376933,
      0,
      NULL,
      NULL,
      2.612287,
      3,
      2.414315,
      2,
      0.814326,
      1,
      NULL,
      NULL,
      5,
      0.115572,
      4.892061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.456239,
      7,
      NULL,
      NULL,
      1,
      0,
      0.248846,
      1.253132,
      0.745304,
      0.214820,
      4,
      2,
      0.697504,
      0.248177,
      NULL,
      0,
      2,
      1,
      0.341918,
      0.639151,
      NULL,
      0,
      3,
      2,
      0.905996,
      3.132163,
      0.300524,
      0.063580,
      3,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.464601,
      1.153010,
      1.455143,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0.783335,
      NULL,
      0.254370,
      0.119492,
      NULL,
      0,
      1.522746,
      0.274120,
      NULL,
      1.312689,
      1.593283,
      0.272338,
      0.433048,
      0,
      NULL,
      NULL,
      2.875083,
      0.565458,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.319054,
      0.116259,
      0,
      1,
      1.087584,
      1.542002,
      1,
      NULL,
      NULL,
      5.696599,
      3.835930,
      1.809504,
      0.097781,
      1.037545,
      0.414677,
      2,
      0.550834,
      0.721392,
      NULL,
      1.936231,
      2.804014,
      0,
      NULL,
      4,
      2,
      NULL,
      1,
      0.781092,
      2.553458,
      1.439816,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.164418,
      0.585803,
      1.332300,
      0.478637,
      0,
      NULL,
      1.353151,
      NULL,
      0.873746,
      0,
      0,
      0,
      1.941895,
      1,
      1,
      1,
      0.901255,
      1,
      4.373931,
      2.009488,
      NULL,
      2.272871,
      4,
      3.691054,
      3,
      2.601252,
      2.780935,
      3,
      3.530398,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366198,
      NULL,
      4.854522,
      0.329790,
      1.986441,
      0.274001,
      0,
      7.952448,
      4.794257,
      2.946219,
      NULL,
      NULL,
      2,
      NULL,
      2.926102,
      2,
      1.902305,
      0,
      NULL,
      2.269501,
      1,
      7.246711,
      6.878418,
      5.790929,
      0,
      2.126485,
      3,
      2,
      4.095674,
      2.047292,
      1.868213,
      1.628774,
      2.531472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1,
      5.222237,
      5.241874,
      3,
      4.896148,
      1,
      5,
      6,
      NULL,
      3,
      1,
      1,
      NULL,
      6.875659,
      4.601781,
      1.291692,
      2.965233,
      6,
      0,
      2,
      8.761015,
      6.138281,
      NULL,
      7.339129,
      7,
      4,
      1,
      6,
      7.303044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538575,
      1.661319,
      0.167354,
      NULL,
      0.348157,
      NULL,
      1.415773,
      1.230969,
      1.191367,
      0,
      1,
      0.114615,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.407909,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0.790724,
      NULL,
      3.940668,
      1.127811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510687,
      1,
      1,
      NULL,
      0.060642,
      0,
      0,
      NULL,
      1,
      3.402707,
      2,
      2,
      NULL,
      0,
      0.918140,
      NULL,
      3,
      1,
      0,
      NULL,
      2.001226,
      2,
      3.138197,
      NULL,
      3.568928,
      0.397612,
      0.233063,
      NULL,
      NULL,
      0.821453,
      NULL,
      0.543706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      5,
      1,
      1,
      0,
      NULL,
      1,
      2,
      4,
      0,
      NULL,
      6,
      4,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      0,
      2,
      5,
      0,
      4,
      1,
      NULL,
      5,
      NULL,
      2,
      NULL,
      4,
      2,
      5,
      5,
      4,
      NULL,
      4,
      NULL,
      5,
      5,
      1,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1984',
      ' 4-13-1993',
      NULL,
      ' 2- 8-1996',
      ' 1-29-1998',
      NULL,
      ' 5- 2-1993',
      NULL,
      ' 4-23-1990',
      '10-22-1992',
      NULL,
      ' 9-25-1979',
      ' 7-24-1981',
      ' 5-26-1996',
      ' 6-14-1974',
      ' 7-22-1987',
      '10-20-2001',
      NULL,
      '11- 6-1998',
      NULL,
      ' 1-22-1991',
      ' 4- 3-1987',
      ' 7-13-1979',
      ' 6-14-2002',
      ' 9-14-1990',
      NULL,
      NULL,
      NULL,
      ' 6-15-1980',
      ' 2-27-1987',
      ' 4- 7-1974',
      NULL,
      ' 3-14-1994',
      ' 1- 3-2000',
      ' 9- 0-1983',
      ' 9-23-1999',
      ' 1-26-1996',
      ' 1-15-1997',
      ' 1-28-1991',
      ' 6-22-1994',
      '11-21-1998',
      ' 5-13-2003',
      NULL,
      '10- 5-1997',
      ' 8-17-1993',
      NULL,
      ' 0-17-1981',
      ' 1-14-2003',
      ' 2-12-1988',
      NULL,
      ' 5-16-1984',
      ' 9- 3-1999',
      ' 8- 4-2001',
      ' 4- 6-1974',
      NULL,
      ' 3- 9-1996',
      ' 6-29-1996',
      ' 9-21-1974',
      '11- 6-1998',
      '10- 0-1990',
      NULL,
      NULL,
      ' 3- 1-1990',
      NULL,
      ' 5-12-1999',
      ' 2-21-1976',
      ' 7-13-1984',
      ' 1-16-1978',
      ' 5- 9-1975',
      ' 0- 2-1991',
      ' 6-22-1995',
      '10-29-1986',
      ' 3-26-1974',
      ' 9-16-1994',
      ' 5-26-1979',
      ' 1-28-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-1992',
      ' 7-15-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640437);
commit;
end;
/


