set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '3004334',
      4,
      NULL,
      2,
      '23203',
      2,
      '10-26-1978',
      32.670181,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.086489,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.432684,
      3,
      7,
      NULL,
      NULL,
      NULL,
      3.216438,
      1.093965,
      NULL,
      NULL,
      1,
      2.102489,
      2,
      NULL,
      0,
      5,
      0,
      1,
      1,
      0,
      3,
      0,
      2,
      1,
      NULL,
      0.750625,
      6,
      3.033437,
      0,
      2,
      0.047177,
      1,
      NULL,
      3,
      7,
      7,
      NULL,
      2.561857,
      7,
      5,
      1,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.288079,
      5,
      NULL,
      1,
      3,
      4,
      NULL,
      3.708075,
      194,
      19,
      NULL,
      1,
      362,
      NULL,
      0.674252,
      3,
      360.015088,
      38,
      5,
      2.516641,
      105.654261,
      NULL,
      3,
      4.404193,
      31,
      NULL,
      1,
      2,
      49,
      30,
      1,
      7,
      182,
      102.967817,
      NULL,
      5.224736,
      120.080770,
      422.877109,
      2,
      3.531759,
      NULL,
      37.957275,
      2,
      2,
      179,
      428,
      2,
      NULL,
      123,
      26,
      NULL,
      2,
      NULL,
      198,
      NULL,
      2.706993,
      NULL,
      427,
      0,
      0.875349,
      194.853328,
      NULL,
      3.151675,
      NULL,
      110.838608,
      87.108426,
      2,
      NULL,
      1,
      568,
      2,
      6,
      35,
      745.906460,
      1.970813,
      NULL,
      52,
      NULL,
      0.557780,
      7.476201,
      NULL,
      1816.468725,
      0,
      2.628318,
      69.895610,
      11.375815,
      1.461771,
      4.994102,
      NULL,
      30.057779,
      NULL,
      4,
      5,
      887.181237,
      2,
      7,
      47.541623,
      572,
      1,
      5,
      122,
      136.442241,
      2,
      1,
      164,
      369,
      0.412150,
      2.818540,
      99,
      1317.031998,
      0.372757,
      0.705232,
      202,
      NULL,
      2.722475,
      8,
      134,
      396.664668,
      2.229131,
      6,
      NULL,
      32,
      3,
      2.274196,
      64,
      2,
      1,
      6.135220,
      1298,
      5.480098,
      0.572030,
      1,
      1397,
      NULL,
      2.689759,
      6.889344,
      1311.175370,
      132.686372,
      1.602757,
      NULL,
      454,
      311,
      3,
      NULL,
      216,
      NULL,
      3,
      5.898637,
      604,
      13.343839,
      2,
      NULL,
      125.561767,
      NULL,
      1.838495,
      3.385184,
      111,
      123.652036,
      NULL,
      5.926678,
      NULL,
      124.649622,
      0.566760,
      7,
      160,
      NULL,
      2.619755,
      0.639245,
      44,
      35.824317,
      NULL,
      NULL,
      195.125010,
      1,
      2.834820,
      0.371660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '22033',
      '',
      '',
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      5,
      1,
      NULL,
      2,
      87.944453,
      NULL,
      NULL,
      0.488273,
      NULL,
      NULL,
      NULL,
      0.749398,
      NULL,
      0.455654,
      NULL,
      1.168966,
      NULL,
      1,
      NULL,
      0.485634,
      NULL,
      ' 6-18-2000',
      2.008651,
      17,
      0,
      NULL,
      17,
      8.263363,
      2,
      1,
      NULL,
      16,
      4,
      9,
      NULL,
      8,
      5.046072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.453219,
      6,
      NULL,
      NULL,
      18,
      3.859694,
      43,
      11,
      25,
      10.115094,
      43.377657,
      NULL,
      25.029026,
      3.790814,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      113,
      NULL,
      95.583847,
      9,
      149,
      69.466820,
      65,
      50.322573,
      148,
      114.732358,
      116,
      122,
      13.526061,
      122.823351,
      5.343118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      4.736383,
      NULL,
      4.366000,
      2,
      8,
      4,
      7.042796,
      7,
      4.337113,
      3.206993,
      7.845270,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      4,
      10.538687,
      3.122286,
      8.597650,
      NULL,
      NULL,
      2,
      0,
      0.527210,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.034422,
      2,
      1.956113,
      0.274199,
      1.772557,
      0.454802,
      0.202584,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0.175521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.566666,
      0.365098,
      1.539862,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.973244,
      4,
      5.636101,
      2.386585,
      NULL,
      1.383343,
      0,
      NULL,
      0.736476,
      3.481361,
      3,
      5.633678,
      0,
      3.011198,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      6,
      8.557231,
      7.689003,
      7.145882,
      NULL,
      NULL,
      3.687562,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032680,
      4,
      0,
      9,
      NULL,
      NULL,
      5.461455,
      2.815680,
      7.813849,
      6.515549,
      1.416660,
      4,
      0.619152,
      NULL,
      4.433468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201471,
      3.134683,
      0.523651,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      6,
      5,
      0,
      3.495472,
      3,
      0.586011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.229615,
      0,
      0,
      NULL,
      4,
      1.614768,
      4.475384,
      3,
      NULL,
      NULL,
      5.563203,
      3.252132,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713978,
      1,
      0.744069,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.872607,
      1.249708,
      0.986841,
      0.530625,
      1.512852,
      0.928248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.397521,
      NULL,
      0,
      0,
      1.397557,
      NULL,
      1.959589,
      0.569691,
      0,
      NULL,
      0,
      NULL,
      0.150227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.192445,
      1.110843,
      5.098183,
      7,
      4,
      5,
      NULL,
      NULL,
      1.458844,
      3,
      3,
      2.723657,
      4.113155,
      7.470714,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.229850,
      6.181070,
      0.537288,
      3.980695,
      5.739777,
      NULL,
      NULL,
      0.335238,
      1,
      0,
      1.081542,
      1.364117,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      8,
      NULL,
      2.703505,
      3,
      NULL,
      0.252577,
      5.586140,
      6,
      4.426157,
      5,
      2,
      0.855619,
      3.078696,
      6.879775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.538221,
      7.986554,
      7.260966,
      8,
      NULL,
      9.065595,
      7.081068,
      4,
      4,
      4.133177,
      2.378229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.262092,
      1.145222,
      NULL,
      1,
      0.253321,
      1,
      1.907577,
      NULL,
      0,
      0.808524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.896866,
      0.110640,
      2,
      2,
      2,
      5.213645,
      NULL,
      NULL,
      3,
      1.537186,
      3,
      5.485994,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      5,
      2,
      NULL,
      1,
      4,
      NULL,
      NULL,
      3,
      3,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449920,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      0,
      3,
      0,
      1,
      1,
      3,
      1,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-19-1994',
      '11-12-2002',
      ' 7-12-2001',
      ' 2- 2-1981',
      NULL,
      ' 4-11-1984',
      ' 4-26-1990',
      ' 7-15-1998',
      ' 1-10-1975',
      NULL,
      ' 5-17-1985',
      ' 7-24-2003',
      '10-19-1979',
      NULL,
      ' 6- 6-2000',
      ' 2-13-1985',
      NULL,
      '10- 1-1994',
      '11-13-1997',
      NULL,
      ' 3- 6-1975',
      NULL,
      ' 4- 6-1977',
      ' 9- 1-2000',
      ' 1-18-2002',
      ' 4-23-1975',
      ' 0- 1-2003',
      ' 4- 8-1977',
      NULL,
      '10- 7-2002',
      ' 2- 4-1992',
      ' 9-18-1999',
      ' 9-21-1991',
      '11-29-1986',
      ' 5-19-1991',
      ' 2-10-1994',
      '11-20-1994',
      ' 4- 3-1984',
      ' 6-13-1980',
      '10-19-2001',
      ' 7- 8-1982',
      ' 9-27-1981',
      ' 2-27-2000',
      ' 7-16-2000',
      '10- 0-1977',
      ' 4-17-1994',
      '10-26-1990',
      ' 7-22-1974',
      ' 8-29-1986',
      NULL,
      ' 8-27-1981',
      ' 8-12-1991',
      ' 6- 6-1989',
      ' 1-20-2002',
      NULL,
      ' 6-11-1997',
      ' 6-10-2003',
      ' 1-14-1975',
      '10-10-1978',
      ' 8- 7-2003',
      ' 2-23-1998',
      NULL,
      ' 4-18-1998',
      ' 8-10-1987',
      ' 6- 7-1975',
      ' 1- 6-1986',
      NULL,
      ' 6-24-1978',
      NULL,
      ' 8-27-1984',
      ' 2- 1-1978',
      ' 7-20-1998',
      ' 5-11-1987',
      ' 4-27-1985',
      ' 3-11-1979',
      NULL,
      ' 7-12-1996',
      ' 8- 7-1997',
      ' 7-27-2001',
      ' 9-20-1992',
      ' 6- 3-1995',
      ' 8-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


