set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '24200043',
      50.243255,
      75.609221,
      '3342334',
      NULL,
      0.448401,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      NULL,
      0.508864,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      6.808267,
      2.425621,
      2,
      NULL,
      7,
      6.700736,
      0,
      1.651918,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      7,
      3.338641,
      7,
      5.490238,
      1,
      NULL,
      0,
      0.325520,
      0,
      1,
      2,
      NULL,
      1,
      2.357097,
      0,
      NULL,
      NULL,
      4.035144,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      3,
      NULL,
      3,
      94.214369,
      158,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.480569,
      2.237017,
      NULL,
      15.586248,
      1,
      1,
      154.029438,
      NULL,
      3.628048,
      1.962272,
      294.729731,
      1571,
      1,
      3,
      109.763024,
      18.724459,
      1.175820,
      NULL,
      191.552542,
      NULL,
      NULL,
      3.964870,
      167.258813,
      NULL,
      1.442093,
      NULL,
      NULL,
      5.161053,
      2,
      0.000720,
      191.675610,
      36,
      NULL,
      NULL,
      22.748874,
      0,
      NULL,
      2.517729,
      222.704944,
      3,
      2.961925,
      0,
      188,
      18,
      2.941974,
      NULL,
      169.025253,
      7,
      3.529921,
      0,
      204.328433,
      18,
      1.022336,
      NULL,
      152.383091,
      71,
      0,
      4,
      137,
      5,
      NULL,
      8,
      NULL,
      24.822495,
      0.195125,
      5.707943,
      167,
      15.003628,
      0.892232,
      NULL,
      154,
      207.381297,
      NULL,
      NULL,
      194,
      315,
      8,
      7.318277,
      287,
      4.886383,
      3,
      2,
      76.531947,
      61.479700,
      6.776010,
      NULL,
      294.109693,
      3.987891,
      3,
      4.493136,
      218,
      0.532664,
      0.597042,
      NULL,
      227.787455,
      3,
      NULL,
      0.984899,
      71.713446,
      7,
      0,
      NULL,
      13,
      32.366983,
      3.589671,
      3,
      301.196665,
      3,
      3.302495,
      NULL,
      153,
      1.601030,
      2,
      4.727530,
      NULL,
      5.389794,
      2,
      NULL,
      154.468766,
      12,
      NULL,
      2.367606,
      83,
      4,
      2.455045,
      2,
      381.833188,
      26,
      0,
      2,
      182,
      NULL,
      NULL,
      0,
      48,
      3.808465,
      2.240276,
      6.327032,
      148.585097,
      5.549867,
      0.197074,
      7.654182,
      19,
      9.737900,
      0.199992,
      2.917594,
      329.538895,
      NULL,
      1.629428,
      2.974788,
      204,
      1,
      3,
      0,
      115,
      17.900394,
      0,
      NULL,
      55.529743,
      NULL,
      1,
      3.184162,
      94,
      NULL,
      0,
      5,
      72,
      35,
      2,
      9.336379,
      121.062704,
      NULL,
      3.584624,
      2,
      NULL,
      162,
      NULL,
      1.360993,
      215,
      9.816163,
      NULL,
      0.293172,
      372,
      9.273497,
      1,
      0.258815,
      127.956652,
      2,
      1.452594,
      1,
      45.370117,
      7.250781,
      NULL,
      1,
      117,
      5.682418,
      2.345234,
      4.290235,
      434,
      NULL,
      NULL,
      NULL,
      936,
      0,
      1,
      0.142799,
      225.679002,
      65.636190,
      2.063786,
      NULL,
      NULL,
      411.241797,
      2.811256,
      0,
      163,
      3,
      1.546350,
      NULL,
      47,
      15.411202,
      3.981713,
      2.443192,
      243,
      6,
      NULL,
      2.485529,
      426.747088,
      931,
      0.935571,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '02012',
      '',
      '',
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      0.173065,
      NULL,
      2.315083,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.192085,
      NULL,
      1.754787,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 6-15-1993',
      NULL,
      NULL,
      20,
      6,
      2.804832,
      9,
      0.613608,
      NULL,
      NULL,
      7.648264,
      9.033915,
      NULL,
      8,
      7,
      3.455506,
      NULL,
      5,
      9.774924,
      NULL,
      7.652722,
      4.513307,
      8.847312,
      NULL,
      9,
      12,
      3,
      4,
      3.015997,
      8,
      1,
      NULL,
      NULL,
      NULL,
      5.536618,
      NULL,
      2,
      5.334967,
      15,
      NULL,
      5,
      4.558345,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999254,
      3.131243,
      12.015344,
      2,
      15.217273,
      3,
      1.506316,
      1.556301,
      13,
      NULL,
      2.442347,
      2,
      18,
      NULL,
      4,
      NULL,
      NULL,
      5.641401,
      2.385086,
      NULL,
      NULL,
      6,
      31,
      26.721958,
      4.515976,
      NULL,
      31,
      NULL,
      NULL,
      38.039434,
      5.235094,
      19,
      4.976247,
      NULL,
      0.541376,
      NULL,
      24,
      11,
      43,
      13.029955,
      32,
      1,
      13.495708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.595916,
      68,
      NULL,
      47,
      148,
      NULL,
      90,
      NULL,
      49.694236,
      157.078775,
      32.828525,
      104.673141,
      58.050558,
      NULL,
      8.188278,
      NULL,
      98,
      NULL,
      88.712166,
      79,
      46,
      94.896473,
      NULL,
      NULL,
      138.876861,
      162,
      63,
      136,
      119,
      187.503097,
      157.726754,
      66.812823,
      193,
      190.781416,
      1,
      0,
      5.990701,
      1.722818,
      4,
      2,
      7.577246,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      7,
      1.669859,
      0,
      6,
      4,
      7.588323,
      4.548507,
      NULL,
      2.151127,
      0,
      8.449050,
      11.812851,
      1,
      11,
      NULL,
      8.431988,
      5,
      6,
      0,
      9,
      4.956442,
      2,
      2.911514,
      3.119691,
      1.391238,
      2.087881,
      8.301875,
      0.733006,
      8,
      8.653331,
      5,
      8,
      NULL,
      9,
      3,
      3,
      6.937772,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.094473,
      0,
      NULL,
      3.679550,
      6,
      6.982647,
      5.710484,
      2.490408,
      2,
      9.128663,
      3.348307,
      3.109879,
      4,
      5,
      NULL,
      9,
      NULL,
      3,
      NULL,
      4,
      3,
      NULL,
      7.006749,
      5,
      0.558965,
      5,
      6.692277,
      4.965715,
      9.364507,
      2,
      5.492939,
      5.777839,
      NULL,
      0.697040,
      7,
      NULL,
      4,
      0,
      4.064742,
      2,
      6.027892,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.181294,
      7.422962,
      6.541197,
      NULL,
      NULL,
      7,
      NULL,
      3,
      9,
      7.323178,
      3.610405,
      NULL,
      7,
      2,
      NULL,
      NULL,
      11,
      4.044300,
      1.785126,
      7.794709,
      0.124045,
      0.691930,
      NULL,
      NULL,
      6.245340,
      NULL,
      8,
      4,
      NULL,
      1,
      1,
      7,
      6,
      7,
      2.212509,
      3.456811,
      5,
      5.609489,
      2.218570,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.525602,
      2,
      3,
      0,
      5,
      1,
      0,
      2.198118,
      NULL,
      NULL,
      4,
      2,
      NULL,
      3.755553,
      1.918064,
      5.393203,
      3,
      NULL,
      4.349728,
      3.346948,
      2.747857,
      2.216607,
      5.865901,
      1,
      2.436955,
      0.384566,
      5,
      4.936648,
      0.302068,
      2,
      0.963717,
      3.920066,
      4.331348,
      1,
      3,
      NULL,
      0.562137,
      7.544003,
      7.702367,
      3,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      NULL,
      NULL,
      0,
      2.405498,
      4,
      3.718378,
      5,
      NULL,
      1.804103,
      2,
      4.934203,
      2.708665,
      NULL,
      5.884750,
      5,
      0,
      4.302549,
      4,
      1.430372,
      1.724423,
      0,
      NULL,
      2.667149,
      NULL,
      0,
      0.523476,
      5,
      0,
      2,
      NULL,
      4.622797,
      NULL,
      NULL,
      2.088956,
      5,
      NULL,
      1.965677,
      3.053608,
      5.600872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.428950,
      6,
      1.118874,
      NULL,
      2,
      2.015429,
      2,
      4.308285,
      NULL,
      NULL,
      7.858783,
      1.421817,
      7.174116,
      5.013898,
      8.966670,
      NULL,
      8,
      7.684355,
      NULL,
      2,
      1,
      9.375260,
      8.790907,
      5.542106,
      1,
      5.102355,
      1,
      NULL,
      8,
      NULL,
      0,
      9,
      8.348482,
      3,
      1.728861,
      11,
      4.108180,
      0,
      NULL,
      5,
      7,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      0.766190,
      0.346368,
      NULL,
      5,
      4.016835,
      2.587607,
      6.335212,
      6,
      0,
      6,
      NULL,
      1,
      5,
      7.788421,
      8,
      NULL,
      7,
      7,
      4.720599,
      6.194071,
      9,
      4.879259,
      NULL,
      7,
      NULL,
      8,
      3,
      8,
      9.755730,
      2,
      0.027991,
      5.282439,
      6.889407,
      3,
      5.451959,
      6.474356,
      2.760548,
      3.414511,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176371,
      NULL,
      3,
      1,
      1.550891,
      NULL,
      1.989279,
      0.285282,
      4.987061,
      0.432618,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      6.904783,
      3,
      6.383899,
      8.503734,
      3,
      NULL,
      0,
      8.602460,
      1.532515,
      5,
      NULL,
      5.264512,
      1,
      NULL,
      1.568075,
      2.509254,
      9,
      2,
      8.544230,
      1,
      NULL,
      NULL,
      1,
      7.429504,
      1.087698,
      3.962274,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.744887,
      0,
      1,
      1.035402,
      0.146946,
      0.735185,
      1.064638,
      0,
      0.033962,
      0,
      0,
      0.540780,
      1.830553,
      NULL,
      0.803743,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1.743974,
      1,
      NULL,
      1,
      1.526431,
      1,
      0,
      1.341974,
      1.276147,
      0.212217,
      1.865394,
      1.782159,
      0.150754,
      1,
      1,
      1,
      0,
      0.225036,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322648,
      0.226838,
      1.853082,
      0,
      1,
      0,
      NULL,
      1.294051,
      1.900186,
      0.201273,
      0,
      1.545796,
      1.288978,
      1.363927,
      1,
      NULL,
      NULL,
      1.728666,
      1.568212,
      NULL,
      1.256984,
      0.678012,
      NULL,
      1,
      NULL,
      NULL,
      1.407662,
      0.937103,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1.758166,
      0,
      1,
      0,
      0.140658,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.576740,
      NULL,
      1.964159,
      1,
      1,
      0.663119,
      0,
      1.335313,
      NULL,
      1.552161,
      1.862684,
      NULL,
      1.890151,
      0,
      0.919765,
      0,
      0,
      1,
      NULL,
      1.990660,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.631154,
      0.067164,
      0,
      0.504375,
      0,
      1.517854,
      0,
      1,
      1,
      0.933787,
      1.447108,
      0.113837,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.601981,
      0.453568,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1.629711,
      NULL,
      NULL,
      0.811253,
      NULL,
      1,
      NULL,
      0.562977,
      2,
      NULL,
      NULL,
      1,
      1.677097,
      0,
      3.472553,
      0,
      0.776444,
      1,
      0.297316,
      NULL,
      0.173363,
      NULL,
      0.130853,
      NULL,
      1,
      0,
      0,
      3.019785,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.628216,
      1.295990,
      1,
      NULL,
      0.594271,
      4,
      NULL,
      0.764348,
      3,
      0,
      1,
      0.040397,
      3,
      NULL,
      3.581287,
      4.007958,
      2,
      3,
      1,
      1.307903,
      1.776746,
      1.222283,
      1,
      1,
      4,
      0.690179,
      0,
      NULL,
      0.882906,
      1,
      0.050663,
      0,
      0.935301,
      NULL,
      3,
      1,
      1.205480,
      0,
      1.860967,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      3.679516,
      NULL,
      2.183393,
      6,
      6,
      7,
      10,
      9.049588,
      7,
      1.695262,
      2,
      3.960574,
      7,
      8,
      NULL,
      NULL,
      4,
      9,
      NULL,
      NULL,
      6.366138,
      5.099371,
      9.142295,
      6,
      6.505788,
      4,
      5,
      9.932988,
      2,
      NULL,
      NULL,
      NULL,
      2.981089,
      0,
      3,
      1,
      1,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.810461,
      2.072372,
      6.077339,
      4.104557,
      7,
      4.931798,
      3,
      0.020354,
      NULL,
      2.255162,
      7,
      1.873431,
      NULL,
      4.982274,
      8,
      2.732881,
      5.107617,
      4,
      NULL,
      NULL,
      0,
      2,
      7.841953,
      3.666287,
      9.281784,
      7.444787,
      0.858129,
      1.499556,
      5.473022,
      1,
      6,
      NULL,
      2.281411,
      4.794413,
      NULL,
      9.809696,
      2,
      8.013153,
      0.493945,
      NULL,
      NULL,
      3.905684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.949005,
      0,
      NULL,
      0.179294,
      1.999673,
      1,
      0.051951,
      1.480935,
      1,
      1.682015,
      1,
      NULL,
      NULL,
      0,
      0.056624,
      1,
      NULL,
      0.926157,
      NULL,
      NULL,
      1.523195,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.191501,
      1.957253,
      1.975490,
      0,
      0,
      NULL,
      1,
      1,
      1.712173,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.247473,
      NULL,
      1,
      0,
      1,
      1.269289,
      NULL,
      0.217004,
      1,
      0.719046,
      1.689531,
      0,
      1.964106,
      0.508796,
      0.729771,
      NULL,
      1,
      1,
      1,
      4,
      0,
      1,
      1.793311,
      1,
      1.070299,
      4.150865,
      NULL,
      0.550644,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.908241,
      1.011504,
      NULL,
      0.636441,
      3.183552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      1,
      4,
      2,
      1,
      2,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      5,
      NULL,
      2,
      NULL,
      NULL,
      0,
      4,
      3,
      2,
      3,
      3,
      NULL,
      0,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      1,
      3,
      1,
      1,
      0,
      2,
      3,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      2,
      3,
      NULL,
      2,
      0,
      NULL,
      2,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-1996',
      NULL,
      '11-26-1982',
      NULL,
      ' 5- 7-1988',
      ' 6-26-1988',
      ' 0-19-1993',
      ' 9-23-1975',
      ' 8-13-1993',
      ' 6-28-1997',
      ' 7-11-1996',
      NULL,
      ' 9- 7-1987',
      ' 1- 7-1984',
      ' 8-23-1997',
      ' 0-27-1980',
      '11-27-1994',
      ' 2-18-1991',
      ' 5-17-1977',
      ' 5- 0-1980',
      ' 3-17-2000',
      ' 4-17-1986',
      '10- 2-1985',
      ' 1-17-1974',
      NULL,
      '11- 3-2000',
      ' 7- 4-1975',
      ' 5-20-1993',
      ' 3-13-1999',
      '10-14-1987',
      ' 7-23-1974',
      ' 0-17-2003',
      ' 6-21-1985',
      ' 3-21-1991',
      '10-16-1988',
      NULL,
      ' 5-16-1998',
      ' 2-10-1999',
      ' 4-14-1992',
      ' 1-14-1997',
      ' 0- 2-1978',
      ' 0- 1-1996',
      ' 7-15-1996',
      ' 9- 9-1974',
      ' 8-29-1975',
      '10-17-1996',
      ' 6- 1-1987',
      NULL,
      '11-17-1996',
      NULL,
      '11-16-2001',
      ' 1- 4-1990',
      ' 0-19-1980',
      NULL,
      ' 1- 6-1986',
      '11-13-1983',
      ' 3-16-1978',
      ' 8-27-1990',
      ' 3-16-1976',
      ' 9- 4-1980',
      NULL,
      ' 3-13-1997',
      NULL,
      ' 2- 2-1984',
      ' 0-19-1980',
      '10- 8-1998',
      ' 2-25-1993',
      ' 3-29-1988',
      ' 4-26-1997',
      ' 1-23-1991',
      ' 3-22-1987',
      ' 2- 3-1992',
      ' 9- 0-1990',
      ' 9- 4-1993',
      NULL,
      ' 1- 9-1985',
      '10-26-1980',
      NULL,
      ' 8-20-1992',
      ' 1- 8-1987',
      ' 2-19-1979',
      ' 6-25-1992',
      NULL,
      ' 1- 6-1975',
      NULL,
      ' 0- 2-1996',
      ' 5- 8-1994',
      NULL,
      ' 1- 8-1989',
      ' 3-12-1991',
      '11-20-1989',
      ' 7-18-2002',
      ' 7-23-2000',
      ' 7-19-1993',
      NULL,
      ' 9- 3-1978',
      ' 1-19-1990',
      ' 4-29-1979',
      '10-18-1998',
      ' 1-21-1983',
      NULL,
      NULL,
      '11- 0-1986',
      ' 3-11-2001',
      NULL,
      ' 6- 1-1979',
      ' 4-15-1983',
      NULL,
      ' 6-17-1986',
      '11-22-1991',
      ' 5-13-1995',
      ' 5-25-1977',
      ' 6-19-1990',
      ' 8-14-1985',
      ' 2-28-1986',
      NULL,
      ' 2-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


