set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '1222113',
      2,
      1,
      3,
      NULL,
      2,
      ' 0- 2-1998',
      35.824038,
      NULL,
      1,
      3,
      2.968010,
      0.866789,
      NULL,
      1,
      0,
      1,
      1.531676,
      0,
      1.311867,
      NULL,
      NULL,
      NULL,
      1.791270,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.717939,
      NULL,
      3.426214,
      NULL,
      0,
      4.924876,
      5,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      6,
      5,
      8,
      3.373068,
      0,
      NULL,
      NULL,
      1.659442,
      NULL,
      2,
      3,
      3,
      NULL,
      7,
      NULL,
      NULL,
      8,
      3.361900,
      9,
      4,
      3.984906,
      0,
      8,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      3.396377,
      2,
      73.898722,
      740.254848,
      4129.371205,
      1.300436,
      4.966994,
      105,
      9.595553,
      1.037548,
      2.409073,
      376.937232,
      1971.130101,
      2.611371,
      2.946178,
      182,
      21,
      2.940136,
      7.659936,
      211,
      10,
      2,
      6,
      NULL,
      1,
      0,
      2.962406,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      20.568017,
      1.824123,
      9,
      742,
      414.394117,
      0,
      1,
      NULL,
      9.694489,
      3.107279,
      NULL,
      NULL,
      45,
      0.334648,
      9.642585,
      183.387629,
      34,
      3.111317,
      3.943579,
      730.224691,
      1.601030,
      2,
      1,
      753,
      2554,
      1.488401,
      6,
      207.781475,
      12,
      NULL,
      3,
      742.047933,
      NULL,
      3.524596,
      2.299801,
      111.753605,
      35,
      NULL,
      4,
      96,
      12.078722,
      NULL,
      1.607859,
      101,
      73.755369,
      1,
      5.071015,
      215,
      109.252160,
      3,
      1,
      162,
      NULL,
      1.300723,
      NULL,
      NULL,
      63,
      0,
      0,
      154.140507,
      77,
      NULL,
      6.315246,
      204,
      76,
      1,
      5,
      131.778727,
      NULL,
      3,
      0,
      436,
      5.283221,
      2.105732,
      0.606002,
      94,
      38,
      1.103092,
      3.096488,
      NULL,
      1.841846,
      NULL,
      2.656031,
      NULL,
      NULL,
      1.405847,
      6.576618,
      NULL,
      124.317485,
      0,
      4.606330,
      82.007301,
      119,
      0,
      3.718631,
      NULL,
      129,
      2.551564,
      3.011877,
      979,
      NULL,
      2,
      1.035213,
      177,
      389,
      3.757584,
      7,
      137,
      444,
      3.117657,
      3.315993,
      NULL,
      NULL,
      2,
      2.115124,
      51.178521,
      259.925553,
      1.442707,
      NULL,
      171.877597,
      22,
      0.659804,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '42210',
      '',
      '',
      '',
      '',
      '',
      2,
      '33210',
      '',
      '',
      0.566333,
      '',
      '',
      '',
      3,
      0,
      NULL,
      1.892621,
      78.135425,
      1,
      NULL,
      0.874406,
      NULL,
      0.100677,
      NULL,
      0.815251,
      NULL,
      0.685467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1996',
      2,
      4.170815,
      2.340993,
      7,
      13.371665,
      3.677811,
      0.045061,
      3,
      9,
      14,
      18.832638,
      10,
      3,
      2,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      6,
      NULL,
      5,
      3.650014,
      NULL,
      3,
      NULL,
      11.842494,
      34,
      20.298374,
      NULL,
      10.823394,
      12.510991,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      157.866577,
      62,
      46,
      162.314656,
      17,
      54,
      NULL,
      136.096357,
      80,
      62,
      102,
      69,
      NULL,
      111.917483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.090329,
      2,
      5,
      4.959653,
      NULL,
      4,
      2,
      7,
      1.001842,
      4.979029,
      3.290430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9,
      2,
      8,
      2,
      1,
      NULL,
      4,
      2,
      4.037156,
      7,
      4.272743,
      NULL,
      7.764712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.410002,
      5,
      1.743478,
      1,
      NULL,
      6,
      1.540066,
      2,
      6,
      5.318533,
      NULL,
      1,
      0.912271,
      1.342965,
      3.946080,
      0.852588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.655106,
      3.517181,
      2.721169,
      NULL,
      1.880725,
      1,
      0.994874,
      0,
      1.156986,
      NULL,
      1,
      0,
      3.814176,
      2.028337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.302700,
      5,
      NULL,
      4.623786,
      NULL,
      NULL,
      6.471682,
      1.639172,
      4.971802,
      1,
      NULL,
      2,
      NULL,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      7,
      2,
      2,
      9.103132,
      9,
      2.155162,
      7,
      2,
      NULL,
      1.480941,
      2.886383,
      NULL,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.507420,
      0.075557,
      6.628492,
      5.017755,
      6,
      NULL,
      2,
      2,
      3.520436,
      9.391021,
      NULL,
      7.460433,
      9,
      7.112029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476178,
      2.653429,
      0.327392,
      3.642886,
      4.671593,
      1,
      2.221612,
      5.864711,
      5.923251,
      4.313318,
      1.979571,
      3.813248,
      7.825703,
      0,
      1.912384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.479735,
      NULL,
      6,
      NULL,
      5.949230,
      NULL,
      NULL,
      3.662331,
      5.399522,
      NULL,
      3,
      3.510912,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.262770,
      1.470080,
      NULL,
      NULL,
      4,
      2.706200,
      NULL,
      NULL,
      0,
      NULL,
      0.824307,
      1,
      7,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      0.428325,
      4.006097,
      NULL,
      0.356897,
      3.983297,
      0.353886,
      NULL,
      1,
      2,
      2,
      NULL,
      1.716952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418935,
      1.486141,
      1,
      NULL,
      1.072936,
      0.737914,
      0,
      1.639866,
      0,
      0,
      0.410656,
      1.172173,
      0.182037,
      1.110796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.634156,
      1.761387,
      1,
      0,
      0,
      0.343130,
      0.141086,
      0.807875,
      0.957085,
      1.456098,
      1.470188,
      0.767726,
      0.076934,
      0.126344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6.406168,
      5.989260,
      0.840673,
      1,
      NULL,
      6.503535,
      NULL,
      6.580084,
      6.331150,
      NULL,
      0,
      6,
      2,
      8,
      5.556506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      8,
      1.620840,
      8.196650,
      7.448626,
      5,
      1,
      5,
      0.136247,
      1.351385,
      9.566542,
      1,
      4,
      9.277329,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.320363,
      NULL,
      1.882130,
      NULL,
      1.854939,
      1,
      0.017262,
      0,
      2.462447,
      1.653692,
      0,
      NULL,
      2.777446,
      2,
      2.968775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.814297,
      0,
      NULL,
      1,
      0.546968,
      1,
      NULL,
      0,
      0.527989,
      0.346319,
      0.099349,
      0,
      1.349519,
      0.111059,
      0.111230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      2,
      3,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      4,
      1,
      1,
      5,
      2,
      3,
      NULL,
      0,
      0,
      1,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      5,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      4,
      NULL,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-26-1983',
      NULL,
      NULL,
      ' 5-11-1990',
      ' 0-10-1992',
      NULL,
      ' 5-20-1988',
      ' 0- 3-1986',
      ' 1- 4-1977',
      NULL,
      ' 9- 9-1990',
      NULL,
      NULL,
      ' 9- 0-1997',
      ' 6- 6-1983',
      ' 2-14-1976',
      ' 1-13-2000',
      ' 4-10-1993',
      ' 9-10-1978',
      ' 7- 1-1977',
      ' 4-20-1977',
      ' 5-27-1977',
      NULL,
      ' 9- 8-1987',
      ' 5-21-2003',
      ' 0- 6-1976',
      ' 2-26-1991',
      ' 1-10-1975',
      ' 0-27-1987',
      NULL,
      '10- 9-1998',
      NULL,
      NULL,
      ' 3-10-2000',
      '10-16-1974',
      '11- 5-1985',
      '10- 4-1997',
      ' 4-17-1995',
      ' 2- 3-1998',
      '11- 7-1977',
      ' 1- 7-1988',
      ' 3- 1-1994',
      ' 7-25-1974',
      NULL,
      ' 6-21-1980',
      ' 8- 5-1974',
      NULL,
      ' 4-26-2001',
      ' 7-21-1976',
      ' 5-29-1995',
      ' 6-25-1981',
      ' 2-14-1994',
      NULL,
      NULL,
      ' 5-10-1982',
      ' 4- 8-1992',
      ' 2-12-1980',
      ' 0-14-1981',
      NULL,
      ' 0- 0-1988',
      ' 9-25-1988',
      ' 0- 4-1980',
      ' 4-15-1980',
      NULL,
      ' 2-14-1981',
      ' 6-13-1976',
      NULL,
      ' 2- 1-1984',
      ' 0- 0-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-27-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


