set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '0141101',
      1,
      NULL,
      2,
      '00021',
      2,
      ' 0-27-2000',
      13,
      NULL,
      3.172227,
      3,
      3.606082,
      1.129428,
      NULL,
      3.311385,
      NULL,
      3,
      2.853849,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      1.292098,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.481358,
      NULL,
      7,
      4,
      2,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      3,
      NULL,
      3,
      NULL,
      0,
      1.433124,
      NULL,
      0.884546,
      NULL,
      0,
      8,
      0.263085,
      13,
      NULL,
      5,
      2,
      1,
      1.636222,
      NULL,
      4,
      0,
      3,
      NULL,
      ' 1- 1-1999',
      NULL,
      0.403340,
      NULL,
      3,
      4,
      NULL,
      1.350244,
      NULL,
      NULL,
      73,
      3718.446067,
      1,
      9.085883,
      149,
      NULL,
      1.588075,
      NULL,
      NULL,
      2160,
      NULL,
      NULL,
      145,
      26,
      1,
      4,
      153,
      21,
      0.035861,
      5.255718,
      313,
      5,
      0,
      6.654737,
      196,
      0.397711,
      NULL,
      5,
      282,
      1.000337,
      3,
      NULL,
      137,
      8,
      3,
      5.535046,
      39,
      NULL,
      2,
      6.515388,
      79.716112,
      14.780836,
      2.700278,
      2,
      1341.103659,
      606,
      1,
      1.353213,
      112.092462,
      2.640625,
      NULL,
      1,
      102,
      97,
      2.636360,
      5.567145,
      NULL,
      NULL,
      3.742698,
      6.298417,
      1232,
      NULL,
      3,
      NULL,
      162.345486,
      3919,
      2.268621,
      2.597344,
      155,
      33.889692,
      3.457305,
      5,
      733,
      700,
      3,
      1,
      84,
      86,
      3,
      9,
      11.332779,
      NULL,
      0,
      NULL,
      NULL,
      54,
      NULL,
      1.245685,
      NULL,
      140,
      NULL,
      3.910289,
      160,
      NULL,
      3,
      NULL,
      1,
      78,
      3.804291,
      4.521223,
      92.356924,
      63,
      NULL,
      5.063989,
      161.910337,
      70.783949,
      NULL,
      8,
      46.481470,
      7.162414,
      1.821514,
      NULL,
      NULL,
      0,
      NULL,
      0,
      37,
      30.382552,
      3,
      1.473583,
      NULL,
      4,
      2,
      3.999035,
      53.452005,
      17,
      NULL,
      NULL,
      134.036057,
      60.315526,
      0,
      5.232204,
      63,
      26.001466,
      3,
      7,
      NULL,
      4,
      3.716438,
      1.506940,
      105.449811,
      NULL,
      1.451282,
      0.533260,
      NULL,
      82,
      0,
      0,
      5.167115,
      343.800964,
      1.254587,
      0.940940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '00444',
      '',
      '',
      '',
      '',
      '',
      NULL,
      '21033',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      1.952046,
      NULL,
      NULL,
      32.984226,
      0,
      2.283014,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.466901,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-18-1986',
      NULL,
      7.629497,
      0.849147,
      0.256586,
      4.838276,
      13.111760,
      0.594874,
      3,
      6.887280,
      4.309418,
      12.080047,
      NULL,
      15,
      21.484680,
      0,
      3,
      2.070533,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      0,
      3.648375,
      2,
      7,
      19.020438,
      1.724702,
      4,
      NULL,
      NULL,
      2.398772,
      4.350275,
      17,
      26,
      7.327538,
      1.537135,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      48.439860,
      54.947856,
      118,
      116.150939,
      105,
      59.294733,
      2.237581,
      63.804277,
      1.382159,
      NULL,
      NULL,
      110.697438,
      38,
      137.336607,
      16.459542,
      113.965281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.259970,
      9,
      NULL,
      1,
      2.140404,
      6,
      0.374467,
      0,
      6,
      1.376712,
      1,
      2.494585,
      5.429659,
      5.258442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.878376,
      NULL,
      1,
      NULL,
      1,
      5.736087,
      6.130656,
      4.517201,
      3,
      NULL,
      NULL,
      6,
      NULL,
      0,
      8,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226279,
      NULL,
      NULL,
      5.944922,
      2.664873,
      6,
      6.241301,
      5.478001,
      NULL,
      2,
      NULL,
      2.218692,
      NULL,
      1,
      6.151240,
      5,
      3.801506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      2.415491,
      2.976055,
      2,
      3.874372,
      2,
      4,
      NULL,
      0.574681,
      4,
      0,
      2.463255,
      3,
      4,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      0.285788,
      6.425918,
      NULL,
      0.396174,
      6.112584,
      2,
      7.026404,
      2,
      4,
      NULL,
      7.709099,
      0,
      4,
      7,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      9,
      NULL,
      NULL,
      2,
      4.530264,
      5.260232,
      4.114552,
      5.680235,
      8.578533,
      NULL,
      1,
      5,
      3.747001,
      0.524090,
      2,
      4.367546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.978932,
      1,
      8,
      NULL,
      8.597802,
      7.862092,
      0,
      9.925110,
      7,
      5,
      4.657311,
      6.313328,
      6.476706,
      7.992692,
      2.474891,
      NULL,
      4.533737,
      1.192602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.087835,
      3,
      4.619710,
      3,
      0.582559,
      NULL,
      3.618174,
      0,
      5.600894,
      0,
      1,
      5,
      4,
      1.639438,
      5.532333,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792784,
      2.695220,
      1.458028,
      2.278756,
      NULL,
      3,
      4,
      6,
      1,
      5.600160,
      7,
      5,
      2,
      2.848718,
      5.161432,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.552953,
      NULL,
      1,
      2.576349,
      3.573169,
      2.913105,
      6,
      1.472044,
      5.245774,
      NULL,
      NULL,
      3,
      4.323540,
      9.028200,
      4.508321,
      4,
      2.716074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.233641,
      5,
      1,
      2,
      1,
      3.799786,
      NULL,
      3.380169,
      1,
      0.392730,
      3.580237,
      2.699612,
      0,
      1,
      1.522158,
      1,
      0.827820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519986,
      0.077020,
      1,
      0.205113,
      1,
      NULL,
      0.767921,
      1.646231,
      0,
      1.954196,
      0.551091,
      1,
      0,
      0,
      1.160958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007994,
      1,
      0,
      0.749393,
      NULL,
      0.269552,
      1,
      NULL,
      1,
      0.282108,
      0.805648,
      NULL,
      0.016255,
      0.510943,
      1,
      1,
      0,
      0.846337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596661,
      7.867910,
      6,
      6.787233,
      5,
      NULL,
      NULL,
      4.652847,
      5,
      7,
      3,
      5.915963,
      1.525241,
      1,
      9,
      4,
      1.512465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      5.199248,
      0.570798,
      NULL,
      4.525005,
      6,
      4.481533,
      1.151270,
      NULL,
      0,
      4,
      9.538541,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.192605,
      0.845176,
      0,
      1.379426,
      1,
      4.020461,
      1,
      2,
      2.792710,
      NULL,
      3.056326,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737168,
      1.564474,
      NULL,
      1,
      1,
      1,
      0.386404,
      NULL,
      0.573884,
      1,
      1.671869,
      1.987743,
      1,
      1.377770,
      0,
      1.138848,
      NULL,
      0.211399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      4,
      1,
      NULL,
      4,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1999',
      '10-29-1986',
      ' 9- 1-1983',
      NULL,
      ' 8-12-1986',
      ' 3-24-1979',
      ' 3-12-1998',
      ' 9- 7-1994',
      '10-10-1983',
      ' 7-27-1985',
      ' 5- 2-1985',
      ' 3-22-1986',
      ' 9-28-2001',
      ' 7-19-1975',
      ' 6-20-1999',
      NULL,
      ' 4- 4-1978',
      ' 7-26-1985',
      ' 1- 7-1981',
      '10-20-1982',
      '10-26-1981',
      ' 3-10-1992',
      ' 4-13-1982',
      ' 6-21-1993',
      ' 1-23-1991',
      ' 4- 0-1984',
      '11- 0-1999',
      '11-21-1980',
      '11- 3-1976',
      ' 9-14-2001',
      ' 6-28-1990',
      ' 6-12-1987',
      ' 2- 3-1988',
      ' 0-20-1998',
      ' 9- 9-1997',
      ' 4-28-1983',
      ' 2-12-1996',
      ' 1-29-1991',
      ' 8-16-1984',
      NULL,
      '11-23-1999',
      NULL,
      ' 9-22-2003',
      ' 5-22-1974',
      ' 1- 3-1984',
      ' 6- 9-2003',
      ' 1- 0-1981',
      NULL,
      ' 6-28-2001',
      NULL,
      ' 8-22-1990',
      ' 5-12-1997',
      ' 0- 1-1988',
      ' 6-13-1979',
      NULL,
      ' 3-22-1992',
      ' 7- 5-1989',
      ' 4-10-1987',
      '11- 1-2001',
      ' 7-11-1982',
      ' 3- 3-1992',
      NULL,
      NULL,
      ' 9-19-1981',
      '11- 2-2002',
      '10-25-1974',
      ' 8-14-2001',
      ' 0- 3-1977',
      ' 8-16-2000',
      ' 1-11-2001',
      ' 6-12-1974',
      NULL,
      ' 3- 7-1981',
      NULL,
      ' 2-11-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


