set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      '11-16-2002',
      38,
      NULL,
      NULL,
      2,
      2.677572,
      0,
      1,
      0,
      NULL,
      2.584085,
      NULL,
      0,
      0.547535,
      NULL,
      NULL,
      NULL,
      1.247182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.575624,
      NULL,
      NULL,
      6.027982,
      1,
      3.893496,
      NULL,
      NULL,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      11.588829,
      9,
      0,
      1,
      0,
      1,
      1.712807,
      0.592038,
      2,
      0,
      2,
      NULL,
      0,
      2,
      NULL,
      4,
      4.836979,
      NULL,
      3.452164,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      3,
      40,
      690,
      1404,
      2,
      0.684798,
      NULL,
      NULL,
      0,
      2.119249,
      599,
      842,
      3.288108,
      2.285791,
      13.094251,
      4,
      NULL,
      1.571025,
      347.589958,
      NULL,
      0.593487,
      7,
      693.785339,
      NULL,
      0,
      3,
      273,
      NULL,
      0.955007,
      0.822051,
      NULL,
      14.404858,
      NULL,
      0,
      38,
      7.919858,
      0.830580,
      9.854769,
      146,
      5.096038,
      1,
      1.787211,
      174,
      NULL,
      2.958338,
      0.512411,
      169.437515,
      NULL,
      3,
      NULL,
      NULL,
      21.283344,
      1,
      2.955806,
      194.918739,
      42.864428,
      1.029046,
      4,
      79.427212,
      82,
      0.225924,
      2,
      66.686627,
      80,
      NULL,
      4,
      9,
      7,
      0.096088,
      NULL,
      74,
      NULL,
      NULL,
      1.525406,
      184,
      47,
      NULL,
      0,
      29.170106,
      29,
      NULL,
      5.906945,
      142,
      41.752342,
      9,
      NULL,
      197.143143,
      NULL,
      4,
      8.293122,
      6,
      5.625190,
      1.112237,
      2,
      40,
      NULL,
      1,
      4.724715,
      245.201761,
      NULL,
      3.701347,
      5.771039,
      101.600524,
      7,
      2.866336,
      3.468728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.375421,
      '42401',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      1.371387,
      '21044',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      100.176167,
      3,
      13.726225,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.948553,
      249.165748,
      1,
      NULL,
      0.934070,
      NULL,
      NULL,
      1179,
      NULL,
      4.941966,
      7.004455,
      NULL,
      3.681001,
      3.440446,
      3.186258,
      1,
      NULL,
      6,
      5,
      9.986053,
      2.571852,
      NULL,
      NULL,
      5,
      0,
      7,
      NULL,
      9,
      8,
      3.730972,
      6,
      NULL,
      1,
      14,
      9.758751,
      12,
      13,
      0.666460,
      11.966313,
      3.586043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.242135,
      32.859642,
      NULL,
      NULL,
      11,
      41,
      43,
      7.557963,
      0.232131,
      21.199806,
      0.174440,
      42,
      21.386228,
      5.006896,
      15.260210,
      50,
      19.411257,
      14,
      NULL,
      NULL,
      36.036922,
      17.910888,
      NULL,
      19.339159,
      4.752225,
      1.288066,
      12,
      28,
      7.403542,
      13,
      23.222947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9,
      69.060416,
      NULL,
      9,
      NULL,
      122.186801,
      30,
      48,
      126.894811,
      76,
      64,
      NULL,
      NULL,
      84,
      104,
      NULL,
      56,
      88,
      NULL,
      0.741503,
      8.047712,
      150.220803,
      0,
      124.379327,
      NULL,
      NULL,
      121.697740,
      15,
      185.132332,
      136.425093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.832954,
      5,
      2.689547,
      4.210281,
      5,
      NULL,
      4,
      NULL,
      1.326619,
      9.353340,
      NULL,
      NULL,
      5.900140,
      3,
      11.332919,
      7,
      1,
      6.543978,
      9.657516,
      7,
      5,
      NULL,
      3,
      2,
      NULL,
      NULL,
      11,
      6.333132,
      5.672452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      2,
      3,
      NULL,
      6.025923,
      1,
      0,
      5,
      1.213331,
      2,
      3.197692,
      3.876943,
      9.280223,
      0,
      NULL,
      7,
      NULL,
      4,
      3.704011,
      6.746312,
      NULL,
      4.222961,
      4,
      NULL,
      4,
      10,
      2.443423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.447823,
      0.320756,
      NULL,
      NULL,
      3,
      4,
      NULL,
      6.230857,
      2,
      1,
      1,
      NULL,
      NULL,
      3.824050,
      0,
      5.934204,
      9,
      2.090337,
      1,
      1.065881,
      2,
      1,
      NULL,
      3.020014,
      4,
      0.049337,
      3.945836,
      0.976948,
      4.238874,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3.934966,
      3,
      5,
      6,
      4,
      2.034937,
      4.932645,
      2,
      1,
      2.125894,
      NULL,
      2,
      1,
      NULL,
      1,
      2,
      1.854445,
      1.556669,
      3.809344,
      2,
      NULL,
      3,
      0,
      2.953967,
      6.979856,
      5.105275,
      1.709410,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      3,
      NULL,
      2,
      3.048733,
      NULL,
      3.017765,
      2.510073,
      1.127236,
      4.823807,
      NULL,
      0,
      4.980974,
      0,
      3.602851,
      0,
      1.631941,
      1,
      5.082281,
      0,
      3,
      NULL,
      1.563909,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.691444,
      2,
      NULL,
      5,
      2,
      2.773182,
      1,
      7.475335,
      7,
      5,
      5,
      3.895247,
      7,
      NULL,
      7.142793,
      3.257729,
      3.745291,
      8,
      1,
      1,
      3.755147,
      NULL,
      2,
      5,
      7,
      5.321002,
      NULL,
      0,
      0,
      3,
      4.404326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1,
      6,
      0.653990,
      3,
      5.357085,
      8,
      7.937825,
      7.064929,
      NULL,
      3,
      0.563750,
      NULL,
      7,
      4,
      5.636351,
      7,
      3.218970,
      NULL,
      1.151636,
      0,
      1,
      7,
      4,
      4.244600,
      2,
      2,
      4,
      3.121330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.331813,
      5,
      0.374194,
      7.402643,
      5,
      3.614798,
      2,
      1.031787,
      1.475840,
      0,
      2,
      5.190365,
      2.091932,
      2,
      NULL,
      0,
      NULL,
      1.390628,
      3.327158,
      3.980449,
      1,
      4,
      NULL,
      1.872788,
      0,
      1.807790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712849,
      1,
      1,
      1.998697,
      1.650024,
      0.479872,
      2,
      0,
      NULL,
      2,
      1.556191,
      1,
      NULL,
      2.946359,
      3,
      0,
      5,
      0.838132,
      NULL,
      0.939929,
      1.903225,
      0.008863,
      1,
      3,
      3,
      0,
      1,
      2.705689,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.395593,
      NULL,
      1,
      2,
      2.678919,
      NULL,
      3,
      4.334612,
      NULL,
      NULL,
      2.162576,
      0.704209,
      0,
      1,
      NULL,
      3.323974,
      0,
      NULL,
      NULL,
      0,
      2.600955,
      5,
      1,
      1.740446,
      1,
      NULL,
      2.730184,
      0.723017,
      0.788434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825330,
      3.158653,
      3.325794,
      NULL,
      6.656663,
      0,
      0.295878,
      0.617908,
      NULL,
      NULL,
      4,
      0,
      1.435364,
      1.092094,
      1.848409,
      1.831910,
      8.206204,
      0,
      1,
      0.699784,
      NULL,
      1.843886,
      5,
      1,
      0,
      0,
      1.654542,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374844,
      0.005448,
      1.232385,
      0,
      1,
      0.103806,
      1,
      4,
      1.432672,
      0.413956,
      1.276568,
      0.952540,
      NULL,
      NULL,
      1.315414,
      0.664521,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.121223,
      0,
      0.706023,
      0.663849,
      0,
      1,
      NULL,
      0.617260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.658142,
      0.845220,
      0.028461,
      1.332587,
      1.196557,
      1,
      1.080257,
      0.108439,
      0,
      1,
      1,
      1,
      0.960134,
      1,
      NULL,
      1.641045,
      4,
      2.988104,
      NULL,
      NULL,
      0,
      0.657131,
      0.965971,
      NULL,
      1,
      0,
      3.468415,
      0,
      1.486070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082797,
      1,
      1,
      NULL,
      7,
      8.425406,
      NULL,
      9.683129,
      2.857361,
      8.669636,
      NULL,
      3,
      4,
      NULL,
      5.652585,
      5,
      3.618295,
      4,
      4,
      5,
      5.186250,
      7.979350,
      8,
      4.391447,
      3,
      7,
      1,
      5,
      5,
      5,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160752,
      1,
      NULL,
      4,
      0,
      4,
      6,
      2.209778,
      3.867429,
      2.183926,
      9.364109,
      7.567059,
      NULL,
      9.377226,
      6,
      2.821992,
      1.028338,
      0.041022,
      4.795543,
      2.709778,
      2.697269,
      1,
      NULL,
      7.329011,
      4,
      4.206788,
      6.269757,
      4.581001,
      2.995509,
      5.752815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.808309,
      NULL,
      1,
      4.926201,
      NULL,
      3,
      1.330509,
      4.764415,
      0,
      0.116683,
      8,
      4,
      3.885028,
      0.248889,
      3.308039,
      5.368364,
      4,
      1.761189,
      1,
      1,
      0,
      3.336720,
      0,
      1,
      1.311279,
      1.328047,
      1,
      0,
      0.605583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.717725,
      NULL,
      NULL,
      1.636887,
      0,
      1.392901,
      1.328526,
      1.674875,
      0,
      NULL,
      0,
      NULL,
      1.965219,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.899960,
      0,
      0.358188,
      1,
      1.900516,
      0.649915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      5,
      1,
      1,
      NULL,
      5,
      0,
      2,
      3,
      1,
      NULL,
      4,
      0,
      5,
      1,
      7,
      2,
      2,
      4,
      NULL,
      4,
      5,
      1,
      0,
      4,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      2,
      NULL,
      6,
      5,
      1,
      NULL,
      2,
      6,
      NULL,
      5,
      NULL,
      3,
      6,
      1,
      5,
      3,
      1,
      5,
      3,
      5,
      NULL,
      2,
      NULL,
      0,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4,
      4,
      0,
      0,
      3,
      4,
      2,
      5,
      2,
      NULL,
      5,
      1,
      3,
      5,
      3,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 9-1984',
      ' 7- 3-1988',
      NULL,
      ' 1-25-2000',
      ' 8- 1-1997',
      '10-22-1993',
      ' 3-14-2000',
      ' 7- 7-1994',
      ' 5-21-1983',
      '10-17-1979',
      '10-24-1990',
      ' 2-19-1999',
      NULL,
      ' 7- 7-1998',
      NULL,
      ' 0-13-1974',
      ' 0-28-2001',
      NULL,
      ' 8-24-1976',
      ' 5-16-1996',
      ' 4-17-1988',
      ' 5-13-1975',
      ' 4-28-1981',
      ' 6- 7-1982',
      '11-29-1981',
      ' 8- 6-1999',
      ' 6- 3-1978',
      ' 7- 1-1999',
      '11- 9-2002',
      ' 8- 9-1997',
      ' 2- 7-1991',
      '10- 7-1980',
      ' 4-27-1985',
      NULL,
      ' 6-22-1978',
      NULL,
      NULL,
      ' 5- 4-1998',
      ' 2-16-1978',
      NULL,
      NULL,
      ' 3-13-1981',
      ' 1-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-1991',
      ' 9- 9-1977',
      '10-24-1978',
      '10- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 1-1989',
      NULL,
      ' 7- 0-1997',
      NULL,
      ' 9-25-2003',
      NULL,
      ' 5- 0-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-13-1981',
      ' 3-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


