set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8203083';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '2234403',
      3,
      0.590593,
      0,
      NULL,
      3,
      ' 8-15-1982',
      51.484705,
      NULL,
      NULL,
      3,
      2,
      0,
      0.381325,
      1.518115,
      0.262717,
      NULL,
      2.029982,
      1,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105005,
      NULL,
      10.117823,
      2,
      1,
      NULL,
      NULL,
      NULL,
      7,
      0,
      7,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      5,
      1,
      0,
      0,
      8,
      4.352756,
      0,
      1.809532,
      NULL,
      NULL,
      0.700849,
      3,
      4,
      7.055307,
      1,
      NULL,
      2,
      9,
      5,
      0,
      NULL,
      NULL,
      NULL,
      22.071528,
      4,
      ' 9-15-1984',
      7.885378,
      1.178240,
      1,
      NULL,
      4,
      NULL,
      2,
      3,
      1.025649,
      411.782089,
      96,
      1.697479,
      2.530781,
      385,
      14447.797850,
      3.520959,
      0.348267,
      NULL,
      20,
      2,
      3,
      139.864232,
      NULL,
      0,
      4.949626,
      83,
      11.665481,
      2.580304,
      1.402648,
      257.070069,
      NULL,
      1.567632,
      3,
      493,
      256.915042,
      0.273271,
      NULL,
      258,
      3,
      2.172149,
      2.310474,
      NULL,
      9.944102,
      0.261414,
      NULL,
      NULL,
      NULL,
      2,
      2.635373,
      12.727324,
      NULL,
      NULL,
      0.127667,
      818,
      6953.007170,
      1,
      2,
      123,
      10199,
      0,
      3.245902,
      51.152019,
      NULL,
      2,
      0,
      30.440596,
      15060,
      3.294828,
      1,
      83,
      14250.259607,
      2,
      0.702350,
      58.643341,
      6253,
      3,
      2,
      1,
      1123,
      3,
      1,
      518.522563,
      15816,
      3.648211,
      3.151413,
      528,
      NULL,
      0,
      NULL,
      42.159287,
      15046.968249,
      2,
      1.936986,
      83.439029,
      3.926831,
      2.375478,
      NULL,
      904,
      0.507772,
      NULL,
      2,
      581,
      12,
      3,
      2.382327,
      360.774818,
      75.053130,
      3.730358,
      1.345432,
      251,
      NULL,
      2.774245,
      NULL,
      345,
      16,
      1,
      0.826124,
      71.227395,
      NULL,
      3,
      7.958567,
      48.609615,
      NULL,
      3.655843,
      6,
      331,
      3.971451,
      0,
      3,
      116,
      NULL,
      1.923518,
      0,
      NULL,
      124.366499,
      1.162783,
      1,
      522.215533,
      54,
      3,
      3,
      216,
      5.831021,
      0,
      NULL,
      NULL,
      2.729621,
      2,
      3,
      NULL,
      17.698040,
      1.385210,
      NULL,
      96,
      76,
      0,
      NULL,
      687,
      4.787931,
      2,
      1,
      NULL,
      276,
      NULL,
      1.258795,
      140.450005,
      13,
      1.714708,
      NULL,
      NULL,
      NULL,
      0,
      0.330624,
      NULL,
      NULL,
      1,
      7.124407,
      427.139177,
      660,
      3.835554,
      1.892187,
      184,
      NULL,
      3,
      1.638589,
      NULL,
      NULL,
      2,
      7.107658,
      329,
      3.307653,
      NULL,
      NULL,
      7,
      21.457294,
      3.377749,
      4,
      118.427510,
      19,
      NULL,
      7,
      136.119423,
      19,
      NULL,
      0.942280,
      213,
      NULL,
      3,
      5.560357,
      34.466351,
      NULL,
      3,
      NULL,
      97.194274,
      69.663281,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      '34143',
      NULL,
      '',
      '',
      '',
      0,
      '43114',
      '',
      '',
      0.152716,
      '',
      NULL,
      NULL,
      3,
      0.725685,
      NULL,
      0.758162,
      38,
      1,
      NULL,
      0.025418,
      NULL,
      10.741952,
      246.316379,
      0.395413,
      NULL,
      0.439136,
      NULL,
      0.707354,
      NULL,
      0.362847,
      NULL,
      0,
      NULL,
      ' 6-27-1987',
      6.928063,
      4.462995,
      1.473114,
      NULL,
      0,
      2,
      0,
      4.360728,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      5,
      14.663221,
      10.014858,
      2.081736,
      13.211570,
      NULL,
      6,
      2,
      11,
      1.801730,
      1.540089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.464583,
      38.253867,
      NULL,
      1.180727,
      24,
      37.006432,
      37.665927,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701680,
      23.089704,
      0.196660,
      9,
      34.753724,
      7.468829,
      1.510947,
      45,
      26.474099,
      28.211735,
      29.214944,
      23,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      100.998607,
      0,
      37,
      115.699505,
      136,
      94,
      20,
      5,
      NULL,
      35.881035,
      NULL,
      59,
      126,
      50.292699,
      50.479289,
      NULL,
      57.185720,
      NULL,
      63.750490,
      104,
      NULL,
      NULL,
      34,
      19,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      2,
      0.022518,
      2,
      2,
      NULL,
      3,
      1,
      NULL,
      4,
      0,
      5,
      0,
      3.457092,
      5.130522,
      1.924733,
      4.954154,
      NULL,
      1.656795,
      NULL,
      0.845876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858984,
      3,
      1,
      1.355645,
      2,
      NULL,
      NULL,
      1.235785,
      2.791036,
      NULL,
      NULL,
      0.869198,
      3,
      NULL,
      NULL,
      0,
      0.738387,
      1,
      3,
      0.046859,
      2,
      2.380747,
      NULL,
      NULL,
      3.904288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316780,
      1,
      0,
      0,
      0.425841,
      0,
      NULL,
      NULL,
      0,
      1.974973,
      1.875894,
      NULL,
      0.552455,
      NULL,
      NULL,
      NULL,
      1.543218,
      NULL,
      1.407732,
      1,
      1.763998,
      0,
      0,
      0.167371,
      1.257609,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586727,
      0,
      5,
      1,
      5,
      NULL,
      3.438995,
      3,
      0,
      4,
      1,
      5.491987,
      0.694089,
      3,
      3.913191,
      4,
      4.849101,
      2,
      NULL,
      5.352254,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.196582,
      4.119923,
      2,
      0,
      0,
      10.591798,
      7.243036,
      7.046827,
      NULL,
      11,
      NULL,
      1.412088,
      1.910609,
      4,
      8.743393,
      NULL,
      4,
      8,
      9.064693,
      NULL,
      NULL,
      1,
      9.325785,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.621069,
      4,
      2,
      3,
      7.636439,
      NULL,
      5.366596,
      7,
      8,
      6,
      10,
      1,
      9.125121,
      5.855630,
      0,
      6,
      7.091134,
      5,
      5.220237,
      7,
      NULL,
      4,
      9,
      0,
      3.914210,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      9.980934,
      8.022131,
      9.109701,
      5.237260,
      NULL,
      NULL,
      2,
      9.311703,
      9,
      6,
      2,
      6.426845,
      6,
      0.839817,
      0,
      6.779629,
      5,
      3.850848,
      3,
      8,
      NULL,
      9.890067,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915533,
      NULL,
      NULL,
      1,
      10.531050,
      6,
      5,
      4,
      NULL,
      NULL,
      4,
      8,
      8.426728,
      6,
      8.688229,
      2.061324,
      3,
      0.487846,
      11.382614,
      4.853843,
      2.083968,
      8.830259,
      3,
      4.715869,
      NULL,
      1.820609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.072293,
      0,
      0.911634,
      3,
      NULL,
      0.271519,
      4,
      4.444063,
      6,
      4.153857,
      4.374896,
      0,
      1.694698,
      0.715976,
      1.444250,
      6,
      NULL,
      1.953232,
      2.226106,
      NULL,
      NULL,
      2,
      7.967961,
      1,
      3.999210,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.634624,
      0,
      1.780712,
      1,
      0,
      0,
      0.447965,
      0.453156,
      0,
      NULL,
      0.807122,
      NULL,
      NULL,
      0.427546,
      1.595651,
      0,
      0,
      1,
      NULL,
      0,
      0.585284,
      NULL,
      1.526651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.898297,
      1.919376,
      NULL,
      NULL,
      0.254576,
      1,
      NULL,
      NULL,
      1.311486,
      0,
      0.100183,
      1,
      0.407945,
      0,
      NULL,
      1.909292,
      1.520275,
      NULL,
      0.222755,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899835,
      6,
      NULL,
      0,
      6,
      NULL,
      2.814249,
      4.504329,
      11,
      3.838204,
      4,
      NULL,
      5.384281,
      3.190396,
      2.571699,
      2.756705,
      6,
      2.402139,
      3,
      5.581225,
      0,
      4,
      8,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257056,
      NULL,
      1.382079,
      1,
      1.475541,
      0,
      3,
      0,
      1.773792,
      1,
      1,
      0.833531,
      NULL,
      2,
      1.005897,
      3,
      1.587090,
      6,
      1,
      1,
      0,
      3.431327,
      2,
      0.032907,
      0.813167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.407291,
      3,
      1.486776,
      5,
      0.517031,
      4.807061,
      4,
      3.786197,
      1,
      NULL,
      NULL,
      5,
      5.991432,
      3,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      3.796188,
      NULL,
      NULL,
      9.202337,
      6,
      4.754063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      NULL,
      9.665989,
      NULL,
      4.627513,
      0.873055,
      7,
      9.733937,
      2,
      1.571749,
      9.752958,
      10.410829,
      1,
      10,
      NULL,
      6.767344,
      NULL,
      NULL,
      2.269468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.595097,
      0,
      1.445448,
      NULL,
      1,
      0,
      0,
      0.533622,
      1.769758,
      0.808980,
      NULL,
      NULL,
      1,
      1.192869,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1.166152,
      1,
      0,
      0.741064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.743765,
      6.794068,
      NULL,
      5.351590,
      8.399422,
      NULL,
      1.427857,
      2,
      8.545281,
      1,
      4,
      3,
      3,
      0,
      6,
      1,
      6,
      0,
      8.337794,
      4,
      NULL,
      2.698935,
      5,
      8.683464,
      0.968831,
      4.070920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      5,
      1,
      NULL,
      3,
      5,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      2,
      0,
      NULL,
      5,
      0,
      1,
      3,
      2,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1993',
      ' 2-10-1978',
      ' 8-18-1988',
      '10- 0-1975',
      '11- 2-1998',
      ' 4-15-1977',
      NULL,
      ' 3- 1-1988',
      NULL,
      '11-29-1979',
      ' 0-22-1996',
      ' 7-25-1990',
      ' 3- 3-2003',
      '10-18-1976',
      NULL,
      NULL,
      ' 8- 4-1996',
      ' 5-15-1984',
      ' 6- 6-2003',
      NULL,
      ' 8- 8-1998',
      NULL,
      ' 6- 0-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1987',
      NULL,
      NULL,
      NULL,
      ' 2-11-1976',
      NULL,
      ' 4-26-1984',
      NULL,
      ' 4-18-1993',
      NULL,
      '11- 2-2000',
      NULL,
      NULL,
      ' 5-15-1996',
      NULL,
      ' 1-13-1982',
      '10-16-1980',
      ' 6-25-1979',
      NULL,
      ' 9-27-1979',
      ' 1- 1-1982',
      ' 2-17-1979',
      ' 9-18-1997',
      ' 5-23-1991',
      ' 7-29-2003',
      ' 7- 6-1992',
      ' 1-11-1997',
      NULL,
      ' 3- 6-1975',
      ' 0-24-1984',
      ' 7-23-1987',
      ' 6- 3-1996',
      NULL,
      ' 1-17-1997',
      NULL,
      NULL,
      ' 7- 9-1999',
      NULL,
      NULL,
      ' 1-24-2003',
      ' 4-15-1988',
      NULL,
      ' 3- 4-1974',
      ' 8-16-1989',
      '11- 8-1980',
      ' 5-13-1983',
      '10-17-1982',
      ' 9- 8-2003',
      ' 3-13-1988',
      NULL,
      NULL,
      '11-12-1997',
      '10-18-1976',
      ' 6- 8-2001',
      ' 2-18-1997',
      NULL,
      NULL,
      '10- 0-2003',
      ' 6-12-1988',
      ' 0- 5-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-16-1998',
      NULL,
      NULL,
      ' 6-25-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      0.300206);
commit;
end;
/


